/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.DiagramViewBuilder;
import biouml.model.SemanticController;
import biouml.model.util.DiagramXmlReader;
import biouml.model.xml.XmlDiagramSemanticController;
import biouml.model.xml.XmlDiagramType;
import biouml.model.xml.XmlDiagramTypeSupport;
import biouml.model.xml.XmlDiagramViewBuilder;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.exception.LoggedClassCastException;
import ru.biosoft.exception.LoggedClassNotFoundException;
import ru.biosoft.graph.Layouter;
import ru.biosoft.util.XmlStream;
import ru.biosoft.util.XmlUtil;

public class XmlDiagramTypeReader
extends XmlDiagramTypeSupport {
    protected static final Logger log = Logger.getLogger(XmlDiagramTypeReader.class.getName());
    String version = "0.8.0";
    protected InputStream stream;
    protected String name;
    private final Map<String, String> iconName2Type = new HashMap<String, String>();

    public XmlDiagramTypeReader(String name, InputStream stream) {
        this.name = name;
        this.stream = stream;
    }

    public XmlDiagramType read(DataCollection<?> origin) throws Exception {
        this.diagramType = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = null;
        StringBuffer buffer = new StringBuffer();
        byte[] b = new byte[65536];
        int length = this.stream.read(b);
        while (length > 0) {
            buffer.append(new String(b, 0, length, StandardCharsets.UTF_8));
            length = this.stream.read(b);
        }
        String xml = buffer.toString();
        xml = xml.replaceAll("[\\x01\\x02\\x03\\x04\\x05\\x06\\x0b\\x0c\\x0f\\x12\\x14\\x16\\x92\\x1a\\x1c\\x1e\\xff]", "?");
        this.stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            doc = builder.parse(this.stream);
        }
        catch (SAXException e) {
            log.log(Level.SEVERE, "Parse diagram type \"" + this.name + "\" error: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            int finish;
            log.log(Level.SEVERE, "Read diagram type \"" + this.name + "\" error: " + e.getMessage());
            int start = xml.indexOf("<![CDATA[");
            String newXml = xml;
            if (start >= 0 && (finish = xml.indexOf("]]>")) > start + 9) {
                newXml = xml.substring(0, start + 9) + "Invalid diagram" + xml.substring(finish, xml.length());
            }
            this.stream = new ByteArrayInputStream(newXml.getBytes(StandardCharsets.UTF_8));
            try {
                doc = builder.parse(this.stream);
            }
            catch (IOException | SAXException e2) {
                return null;
            }
            return this.read(origin, doc);
        }
        return this.read(origin, doc);
    }

    protected XmlDiagramType read(DataCollection origin, Document doc) throws Exception {
        String description;
        String title;
        Element e;
        Element root = doc.getDocumentElement();
        if (root.hasAttribute("version")) {
            this.version = root.getAttribute("version");
        }
        this.diagramType = new XmlDiagramType(origin, this.name);
        if (root.hasAttribute("requiredPlugins")) {
            this.diagramType.setRequiredPlugins(root.getAttribute("requiredPlugins"));
        }
        if ((e = XmlUtil.getChildElement((Element)root, (String)"pathLayouter")) != null) {
            try {
                Class layouterClass = ClassLoading.loadSubClass((String)e.getAttribute("class"), Layouter.class);
                this.diagramType.setPathLayouter(layouterClass);
            }
            catch (LoggedClassCastException | LoggedClassNotFoundException ex) {
                XmlDiagramTypeReader.error("ERROR_PATH_LAYOUTER", new String[]{this.name, ex.getMessage()}, ex);
            }
        }
        if ((title = root.getAttribute("title")) != null && title.trim().length() > 0) {
            this.diagramType.setTitle(title);
        }
        if ((description = root.getAttribute("short-description")) != null && description.trim().length() > 0) {
            this.diagramType.setDescription(description);
        }
        this.readProperties(root);
        this.readExamples(root);
        this.readNodeTypes(root);
        this.readEdgeTypes(root);
        this.readReactionTypes(root);
        this.readViewBuilder(root);
        this.readViewOptions(root);
        this.readSemanticController(root);
        this.readIcons(root);
        return this.diagramType;
    }

    public void readProperties(Element root) {
        Element propertiesElement = XmlDiagramTypeReader.getElement(root, "properties");
        if (propertiesElement == null) {
            XmlDiagramTypeReader.error("ERROR_PROPERTIES_ABSENT", new String[]{this.name});
            return;
        }
        DynamicPropertySet propertiesMap = this.diagramType.getProperties();
        DiagramXmlReader.fillProperties(propertiesElement, propertiesMap, null);
    }

    public void readNodeTypes(Element root) {
        Element nodeTypesElement = XmlDiagramTypeReader.getElement(root, "nodes");
        if (nodeTypesElement == null) {
            XmlDiagramTypeReader.error("ERROR_NODE_TYPES_ABSENT", new String[]{this.name});
            return;
        }
        NodeList list = nodeTypesElement.getChildNodes();
        DynamicPropertySet propertiesMap = this.diagramType.getProperties();
        ArrayList<String> types = new ArrayList<String>();
        for (Element child : XmlUtil.elements((NodeList)list)) {
            try {
                types.add(this.readNodeType(child, propertiesMap));
            }
            catch (Throwable t) {
                XmlDiagramTypeReader.error("ERROR_NODE_TYPES", new String[]{this.name, t.getMessage()}, t);
            }
        }
        this.diagramType.setNodeTypes(types.toArray(new String[types.size()]));
    }

    public String readNodeType(Element nodeElement, DynamicPropertySet propertySet) throws Exception {
        String idFormat;
        if (!nodeElement.getNodeName().equals("node")) {
            XmlDiagramTypeReader.error("ERROR_UNEXPECTED_ELEMENT", new String[]{this.name, nodeElement.getNodeName(), "nodes", "node"});
            return null;
        }
        if (!nodeElement.hasAttribute("type")) {
            XmlDiagramTypeReader.error("ERROR_NODE_TYPE_NOT_SPECIFIED", new String[]{this.name, nodeElement.toString()});
            return null;
        }
        String type = nodeElement.getAttribute("type");
        if (nodeElement.hasAttribute("propertiesBean")) {
            try {
                this.diagramType.addPropertiesBeanClass(type, ClassLoading.loadClass((String)nodeElement.getAttribute("propertiesBean")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Class kernelType = null;
        if (nodeElement.hasAttribute("kernelType")) {
            String className = nodeElement.getAttribute("kernelType");
            try {
                kernelType = ClassLoading.loadClass((String)className, null);
            }
            catch (LoggedClassNotFoundException e) {
                kernelType = null;
            }
        }
        if (nodeElement.hasAttribute("icon")) {
            String icon = nodeElement.getAttribute("icon");
            this.iconName2Type.put(icon, type);
        }
        DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
        DiagramXmlReader.fillProperties(nodeElement, (DynamicPropertySet)dps, propertySet);
        if (nodeElement.hasAttribute("isCompartment") && Boolean.parseBoolean(nodeElement.getAttribute("isCompartment"))) {
            this.diagramType.addCompartment(type);
        }
        if (nodeElement.hasAttribute("id-format") && (idFormat = nodeElement.getAttribute("id-format")).length() > 0) {
            this.diagramType.setIdFormat(type, idFormat);
        }
        this.diagramType.addType(type, (DynamicPropertySet)dps, kernelType);
        if (nodeElement.hasAttribute("isDefault") && Boolean.parseBoolean(nodeElement.getAttribute("isDefault"))) {
            this.diagramType.setDefaultTypeName(type);
        }
        if (nodeElement.hasAttribute("needLayout") && Boolean.parseBoolean(nodeElement.getAttribute("needLayout"))) {
            this.diagramType.addNeedLayout(type);
        }
        if (nodeElement.hasAttribute("createByPrototype") && Boolean.parseBoolean(nodeElement.getAttribute("createByPrototype"))) {
            this.diagramType.addCreateByPrototype(type);
        }
        return type;
    }

    public void readEdgeTypes(Element root) {
        Element edgeTypesElement = XmlDiagramTypeReader.getElement(root, "edges");
        if (edgeTypesElement == null) {
            XmlDiagramTypeReader.error("ERROR_EDGE_TYPES_ABSENT", new String[]{this.name});
            return;
        }
        NodeList list = edgeTypesElement.getChildNodes();
        DynamicPropertySet propertiesMap = this.diagramType.getProperties();
        ArrayList<String> types = new ArrayList<String>();
        for (Element child : XmlUtil.elements((NodeList)list)) {
            try {
                types.add(this.readEdgeType(child, propertiesMap));
            }
            catch (Throwable t) {
                XmlDiagramTypeReader.error("ERROR_EDGE_TYPES", new String[]{this.name, t.getMessage()}, t);
            }
        }
        this.diagramType.setEdgeTypes(types.toArray(new String[types.size()]));
    }

    public String readEdgeType(Element edgeElement, DynamicPropertySet propertySet) throws Exception {
        if (!edgeElement.getNodeName().equals("edge")) {
            XmlDiagramTypeReader.error("ERROR_UNEXPECTED_ELEMENT", new String[]{this.name, edgeElement.getNodeName(), "edges", "edge"});
            return null;
        }
        if (!edgeElement.hasAttribute("type")) {
            XmlDiagramTypeReader.error("ERROR_EDGE_TYPE_NOT_SPECIFIED", new String[]{this.name, edgeElement.toString()});
            return null;
        }
        String type = edgeElement.getAttribute("type");
        Class kernelType = null;
        if (edgeElement.hasAttribute("kernelType")) {
            String className = edgeElement.getAttribute("kernelType");
            try {
                kernelType = ClassLoading.loadClass((String)className, null);
            }
            catch (LoggedClassNotFoundException e) {
                kernelType = null;
            }
        }
        if (edgeElement.hasAttribute("icon")) {
            String icon = edgeElement.getAttribute("icon");
            this.iconName2Type.put(icon, type);
        }
        DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
        DiagramXmlReader.fillProperties(edgeElement, (DynamicPropertySet)dps, propertySet);
        this.diagramType.addType(type, (DynamicPropertySet)dps, kernelType);
        return type;
    }

    public void readReactionTypes(Element root) {
        Element reactionTypesElement = XmlDiagramTypeReader.getElement(root, "reactions");
        if (reactionTypesElement == null) {
            XmlDiagramTypeReader.error("ERROR_REACTION_TYPES_ABSENT", new String[]{this.name});
            return;
        }
        NodeList list = reactionTypesElement.getChildNodes();
        DynamicPropertySet propertiesMap = this.diagramType.getProperties();
        ArrayList<String> types = new ArrayList<String>();
        for (Element child : XmlUtil.elements((NodeList)list)) {
            try {
                types.add(this.readReactionType(child, propertiesMap));
            }
            catch (Throwable t) {
                XmlDiagramTypeReader.error("ERROR_REACTION_TYPES", new String[]{this.name, t.getMessage()}, t);
            }
        }
        this.diagramType.setReactionTypes(types.toArray(new String[types.size()]));
    }

    public String readReactionType(Element nodeElement, DynamicPropertySet propertySet) throws Exception {
        if (!nodeElement.getNodeName().equals("reaction")) {
            XmlDiagramTypeReader.error("ERROR_UNEXPECTED_ELEMENT", new String[]{this.name, nodeElement.getNodeName(), "reactions", "reaction"});
            return null;
        }
        if (!nodeElement.hasAttribute("type")) {
            XmlDiagramTypeReader.error("ERROR_NODE_TYPE_NOT_SPECIFIED", new String[]{this.name, nodeElement.toString()});
            return null;
        }
        String type = nodeElement.getAttribute("type");
        Class kernelType = null;
        if (nodeElement.hasAttribute("kernelType")) {
            String className = nodeElement.getAttribute("kernelType");
            try {
                kernelType = ClassLoading.loadClass((String)className, null);
            }
            catch (LoggedClassNotFoundException e) {
                kernelType = null;
            }
        }
        if (nodeElement.hasAttribute("icon")) {
            String icon = nodeElement.getAttribute("icon");
            this.iconName2Type.put(icon, type);
        }
        DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
        DiagramXmlReader.fillProperties(nodeElement, (DynamicPropertySet)dps, propertySet);
        this.diagramType.addType(type, (DynamicPropertySet)dps, kernelType);
        return type;
    }

    public void readViewOptions(Element root) {
        Element optionsElement = XmlDiagramTypeReader.getElement(root, "viewOptions");
        if (optionsElement == null) {
            XmlDiagramTypeReader.error("ERROR_VIEW_OPTIONS_ABSENT", new String[]{this.name});
            return;
        }
        DiagramXmlReader.fillProperties(optionsElement, this.diagramType.getXmlDiagramViewBuilder().getViewOptions(), null);
    }

    public void readIcons(Element root) {
        Element iconsElement = XmlDiagramTypeReader.getElement(root, "icons");
        if (iconsElement != null) {
            NodeList list = iconsElement.getElementsByTagName("icon");
            for (Element icon : XmlUtil.elements((NodeList)list)) {
                try {
                    String name = icon.getAttribute("name");
                    if (!name.isEmpty()) {
                        String elementType = this.getElementType(name);
                        String base64 = icon.getFirstChild().getNodeValue();
                        Object kernelType = this.diagramType.getKernelType(elementType);
                        Icon imageIcon = XmlDiagramTypeReader.getIconFromBase64(base64);
                        this.diagramType.getXmlDiagramViewBuilder().setIcon(elementType, imageIcon);
                        this.diagramType.getXmlDiagramViewBuilder().setIcon(kernelType, imageIcon);
                        continue;
                    }
                    XmlDiagramTypeReader.error("ERROR_NO_ICON_NAME", new String[0]);
                }
                catch (Throwable t) {
                    XmlDiagramTypeReader.error("ERROR_EDGE_TYPES", new String[]{this.name, t.getMessage()}, t);
                }
            }
        }
    }

    public void readExamples(Element root) {
        Element examplesElement = XmlDiagramTypeReader.getElement(root, "examples");
        if (examplesElement == null) {
            XmlDiagramTypeReader.error("ERROR_EXAMPLES_ABSENT", new String[]{this.name});
            return;
        }
        NodeList list = examplesElement.getElementsByTagName("example");
        for (Element example : XmlUtil.elements((NodeList)list)) {
            try {
                String name = example.getAttribute("name");
                if (!name.isEmpty()) {
                    this.readExample(name, XmlDiagramTypeReader.getElement(example, "diagram"));
                    continue;
                }
                XmlDiagramTypeReader.error("ERROR_NO_EXAMPLE_NAME", new String[]{name});
            }
            catch (Throwable t) {
                XmlDiagramTypeReader.error("ERROR_READ_EXAMPLE", new String[]{this.name, t.getMessage()}, t);
            }
        }
    }

    protected void readExample(String name, Element element) {
        this.diagramType.addExampleElement(name, element);
    }

    private String getElementType(String name) {
        return this.iconName2Type.get(name);
    }

    public static Icon getIconFromBase64(String base64) {
        return new ImageIcon(Base64.getDecoder().decode(base64));
    }

    public void readViewBuilder(Element root) {
        XmlDiagramViewBuilder dvb;
        this.diagramType.xmlDiagramViewBuilder = dvb = new XmlDiagramViewBuilder(this.diagramType);
        Element builderElement = XmlDiagramTypeReader.getElement(root, "viewBuilder");
        if (builderElement == null) {
            XmlDiagramTypeReader.error("ERROR_VIEW_BUILDER_ABSENT", new String[]{this.name});
            return;
        }
        if (builderElement.hasAttribute("prototype")) {
            String prototype = builderElement.getAttribute("prototype");
            try {
                dvb.setBaseViewBuilder((DiagramViewBuilder)ClassLoading.loadSubClass((String)prototype, (String)this.diagramType.getRequiredPlugins(), DiagramViewBuilder.class).newInstance());
            }
            catch (Throwable t) {
                XmlDiagramTypeReader.error("ERROR_VIEW_BUILDER_PROTOTYPE", new String[]{this.name, t.getMessage()}, t);
            }
        }
        NodeList list = builderElement.getChildNodes();
        for (Element child : XmlUtil.elements((NodeList)list)) {
            try {
                this.readViewFunction(child, dvb);
            }
            catch (Throwable t) {
                XmlDiagramTypeReader.error("ERROR_VIEW_BUILDER_FUNCTION", new String[]{this.name, t.getMessage()}, t);
            }
        }
    }

    protected void readViewFunction(Element viewElement, XmlDiagramViewBuilder dvb) throws Exception {
        if (!viewElement.getNodeName().equals("nodeView") && !viewElement.getNodeName().equals("edgeView")) {
            XmlDiagramTypeReader.error("ERROR_UNEXPECTED_ELEMENT", new String[]{this.name, viewElement.getNodeName(), "viewBuilder", "nodeView, edgeView"});
            return;
        }
        if (!viewElement.hasAttribute("type")) {
            XmlDiagramTypeReader.error("ERROR_VIEW_TYPE_NOT_SPECIFIED", new String[]{this.name, viewElement.toString()});
            return;
        }
        String type = viewElement.getAttribute("type");
        String script = this.getCDATA(viewElement);
        if (script == null || script.length() == 0) {
            XmlDiagramTypeReader.error("ERROR_VIEW_SCRIPT_NOT_SPECIFIED", new String[]{this.name, type});
            return;
        }
        dvb.addFunction(type, script);
    }

    public void readSemanticController(Element root) {
        XmlDiagramSemanticController sc = new XmlDiagramSemanticController(this.diagramType);
        this.diagramType.setSemanticController(sc);
        Element controllerElement = XmlDiagramTypeReader.getElement(root, "semanticController");
        if (controllerElement == null) {
            XmlDiagramTypeReader.error("ERROR_SEMANTIC_CONTROLLER_ABSENT", new String[]{this.name});
            return;
        }
        if (controllerElement.hasAttribute("prototype")) {
            String prototype = controllerElement.getAttribute("prototype");
            try {
                sc.setPrototype((SemanticController)ClassLoading.loadSubClass((String)prototype, (String)this.diagramType.getRequiredPlugins(), SemanticController.class).newInstance());
            }
            catch (Throwable t) {
                XmlDiagramTypeReader.error("ERROR_SEMANTIC_CONTROLLER_PROTOTYPE", new String[]{this.name, t.getMessage()}, t);
            }
        }
        NodeList list = controllerElement.getChildNodes();
        for (Element child : XmlUtil.elements((NodeList)list)) {
            try {
                this.readSemanticControllerFunction(child, sc);
            }
            catch (Throwable t) {
                XmlDiagramTypeReader.error("ERROR_SEMANTIC_CONTROLLER_FUNCTION", new String[]{this.name, t.getMessage()}, t);
            }
        }
    }

    protected void readSemanticControllerFunction(Element viewElement, XmlDiagramSemanticController sc) throws Exception {
        if (!(viewElement.getNodeName().equals("canAccept") || viewElement.getNodeName().equals("isResizable") || viewElement.getNodeName().equals("move") || viewElement.getNodeName().equals("remove"))) {
            XmlDiagramTypeReader.error("ERROR_UNEXPECTED_ELEMENT", new String[]{this.name, viewElement.getNodeName(), "viewBuilder", "nodeView, edgeView"});
            return;
        }
        String script = this.getCDATA(viewElement);
        if (script == null || script.length() == 0) {
            XmlDiagramTypeReader.error("ERROR_CONTROLLER_SCRIPT_NOT_SPECIFIED", new String[]{this.name, ""});
            return;
        }
        if (viewElement.getNodeName().equals("canAccept")) {
            sc.setCanAcceptFunction(script);
        } else if (viewElement.getNodeName().equals("isResizable")) {
            sc.setIsResizableFunction(script);
        } else if (viewElement.getNodeName().equals("move")) {
            sc.setMoveFunction(script);
        } else if (viewElement.getNodeName().equals("remove")) {
            sc.setRemoveFunction(script);
        }
    }

    protected String getCDATA(Element element) {
        return XmlStream.nodes((Element)element).findFirst(child -> child.getNodeName().equals("#cdata-section")).map(child -> child.getNodeValue().trim()).orElse(null);
    }
}

