/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.Diagram;
import biouml.model.DiagramTypeSupport;
import biouml.model.DiagramViewBuilder;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.util.DiagramXmlReader;
import biouml.model.xml.XmlDiagramSemanticController;
import biouml.model.xml.XmlDiagramViewBuilder;
import biouml.standard.diagram.PathwaySimulationDiagramType;
import biouml.standard.type.Base;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.editors.StringTagEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import org.w3c.dom.Element;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.graph.Layouter;

public class XmlDiagramType
extends DiagramTypeSupport
implements Base {
    public static final String DEFAULT_NOTATION_PATH = "databases/Utils/Diagrams/graphic notations";
    public static final String NOTATION_PATH_PROPERTY = "NotationPath";
    static final String[] IMPORT_PACKAGES = new String[]{"ru.biosoft.graphics", "ru.biosoft.graphics.font", "ru.biosoft.graph", "java.awt", "java.util", "java.lang", "java.awt.geom", "biouml.model.xml", "biouml.standard.type", "biouml.model", "biouml.model.dynamics"};
    protected String name;
    protected String title;
    protected String requiredPlugins;
    protected String description = null;
    private Class<? extends Layouter> pathLayouter = null;
    private DataCollection<?> origin;
    protected Map<String, DynamicPropertySet> typeMap = new HashMap<String, DynamicPropertySet>();
    protected Map<String, Class<?>> kernelTypeMap = new HashMap();
    protected Map<String, String> idFormatMap = new HashMap<String, String>();
    protected Map<String, Class<?>> beanMap = new HashMap();
    protected String[] nodeTypes = new String[0];
    protected String defaultTypeName = null;
    protected String[] edgeTypes = new String[0];
    protected String[] reactionTypes = new String[0];
    protected XmlDiagramViewBuilder xmlDiagramViewBuilder;
    private Map<String, Element> exampleElements;
    private Map<String, Diagram> examples;
    private final List<String> compartmentList = new ArrayList<String>();
    private final List<String> needLayoutList = new ArrayList<String>();
    private final List<String> createByPrototype = new ArrayList<String>();

    public XmlDiagramType() {
    }

    public XmlDiagramType(DataCollection<?> origin, String name) {
        this.origin = origin;
        this.name = name;
    }

    @Override
    @Nonnull
    public Diagram createDiagram(DataCollection<?> origin, String diagramName, Base kernel) throws Exception {
        Diagram diagram = super.createDiagram(origin, diagramName, kernel);
        PathwaySimulationDiagramType.DiagramPropertyChangeListener listener = new PathwaySimulationDiagramType.DiagramPropertyChangeListener(diagram);
        diagram.getViewOptions().addPropertyChangeListener(listener);
        SemanticController semanticController = this.getSemanticController();
        if (this.getPathLayouter() != null) {
            diagram.setPathLayouter(this.getPathLayouter().getConstructor(new Class[0]).newInstance(new Object[0]));
            diagram.getViewOptions().setAutoLayout(true);
        }
        if (semanticController instanceof XmlDiagramSemanticController) {
            return (Diagram)((XmlDiagramSemanticController)semanticController).getPrototype().validate(null, diagram);
        }
        return diagram;
    }

    @Override
    public String getType() {
        return "xml notation";
    }

    @Override
    public DynamicPropertySet getAttributes() {
        return null;
    }

    public Class<? extends Layouter> getPathLayouter() {
        return this.pathLayouter;
    }

    public void setPathLayouter(Class<? extends Layouter> pathLayouter) {
        this.pathLayouter = pathLayouter;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            return this.name;
        }
        return this.title;
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return "XML Diagram (" + this.getTitle() + ")";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public DataCollection<?> getOrigin() {
        return this.origin;
    }

    public void addType(String type, DynamicPropertySet dps, Class<?> kernelType) {
        this.typeMap.put(type, dps);
        this.putKernelType(type, kernelType);
    }

    public void putKernelType(String type, Class<?> kernelType) {
        if (kernelType != null) {
            this.kernelTypeMap.put(type, kernelType);
        }
    }

    public void addPropertiesBeanClass(String type, Class<?> beanClass) {
        this.beanMap.put(type, beanClass);
    }

    public Object getPropertiesBean(String type) {
        try {
            Class<?> clazz = this.beanMap.get(type);
            return clazz == null ? null : clazz.newInstance();
        }
        catch (Exception e) {
            throw ExceptionRegistry.translateException((Throwable)e);
        }
    }

    public DynamicPropertySet getType(String type) {
        return this.typeMap.get(type);
    }

    public void removeType(String type) {
        this.typeMap.remove(type);
    }

    @Override
    @Nonnull
    public Object[] getNodeTypes() {
        return StreamEx.of((Object[])this.nodeTypes).append((Object[])this.reactionTypes).map(this::getKernelType).toArray();
    }

    public void setNodeTypes(String[] nodeTypes) {
        this.nodeTypes = nodeTypes;
    }

    public Object getKernelType(String typeName) {
        if (this.kernelTypeMap.containsKey(typeName)) {
            return this.kernelTypeMap.get(typeName);
        }
        return typeName;
    }

    public String getKernelTypeName(Object type) {
        if (type instanceof String) {
            return (String)type;
        }
        return StreamEx.ofKeys(this.kernelTypeMap, cls -> cls.getName().equals(((Class)type).getName())).findAny().orElse(null);
    }

    public String getDefaultTypeName() {
        return this.defaultTypeName;
    }

    protected void setDefaultTypeName(String typeName) {
        this.defaultTypeName = typeName;
    }

    public String getIdFormat(String typeName) {
        return this.idFormatMap.get(typeName);
    }

    public void setIdFormat(String typeName, String idFormat) {
        if (idFormat == null) {
            this.idFormatMap.remove(typeName);
        } else {
            this.idFormatMap.put(typeName, idFormat);
        }
    }

    public String[] getNodes() {
        return this.nodeTypes;
    }

    @Override
    @Nonnull
    public Object[] getEdgeTypes() {
        return StreamEx.of((Object[])this.edgeTypes).map(this::getKernelType).toArray();
    }

    public String[] getEdges() {
        return this.edgeTypes;
    }

    public void setEdgeTypes(String[] edgeTypes) {
        this.edgeTypes = edgeTypes;
    }

    public String[] getReactionTypes() {
        return this.reactionTypes;
    }

    public void setReactionTypes(String[] reactionTypes) {
        this.reactionTypes = reactionTypes;
    }

    public XmlDiagramViewBuilder getXmlDiagramViewBuilder() {
        if (this.xmlDiagramViewBuilder == null) {
            this.xmlDiagramViewBuilder = new XmlDiagramViewBuilder(this);
        }
        return this.xmlDiagramViewBuilder;
    }

    public void setXmlDiagramViewBuilder(XmlDiagramViewBuilder diagramViewBuilder) {
        this.xmlDiagramViewBuilder = diagramViewBuilder;
        this.setDiagramViewBuilder(diagramViewBuilder);
    }

    @Override
    public DiagramViewBuilder getDiagramViewBuilder() {
        if (this.diagramViewBuilder == null) {
            this.diagramViewBuilder = this.getXmlDiagramViewBuilder();
        }
        return this.diagramViewBuilder;
    }

    @Override
    public void setDiagramViewBuilder(DiagramViewBuilder viewBuilder) {
        super.setDiagramViewBuilder(viewBuilder);
        if (viewBuilder instanceof XmlDiagramViewBuilder) {
            this.xmlDiagramViewBuilder = (XmlDiagramViewBuilder)viewBuilder;
        }
    }

    @Override
    public SemanticController getSemanticController() {
        if (this.semanticController == null) {
            this.semanticController = new XmlDiagramSemanticController(this);
        }
        return this.semanticController;
    }

    public void setSemanticController(SemanticController sc) {
        this.semanticController = sc;
    }

    public void addExampleElement(String name, Element element) {
        if (this.exampleElements == null) {
            this.exampleElements = new HashMap<String, Element>();
        }
        this.exampleElements.put(name, element);
    }

    public void addExample(Diagram example) {
        if (this.examples == null) {
            this.examples = new HashMap<String, Diagram>();
        }
        this.examples.put(example.getName(), example);
    }

    public Set<String> getExampleNameList() {
        if (this.examples == null) {
            this.examples = new HashMap<String, Diagram>();
        }
        HashSet<String> nameList = new HashSet<String>();
        nameList.addAll(this.examples.keySet());
        if (this.exampleElements != null) {
            nameList.addAll(this.exampleElements.keySet());
        }
        return nameList;
    }

    public Diagram getExample(String name) {
        if (this.examples == null) {
            this.examples = new HashMap<String, Diagram>();
        }
        if (this.examples.containsKey(name)) {
            return this.examples.get(name);
        }
        if (this.exampleElements != null && this.exampleElements.containsKey(name)) {
            Element element = this.exampleElements.get(name);
            Diagram diagram = DiagramXmlReader.parseDiagram(name, element, null, this);
            this.examples.put(diagram.getName(), diagram);
            this.exampleElements.remove(name);
            return diagram;
        }
        return null;
    }

    public void removeExample(String name) {
        if (this.examples == null) {
            this.examples = new HashMap<String, Diagram>();
        }
        if (this.examples.containsKey(name)) {
            this.examples.remove(name);
        } else if (this.exampleElements.containsKey(name)) {
            this.exampleElements.remove(name);
        }
    }

    public boolean checkCompartment(String type) {
        return this.compartmentList.contains(type);
    }

    public void addCompartment(String type) {
        this.compartmentList.add(type);
    }

    public void removeCompartment(String type) {
        this.compartmentList.remove(type);
    }

    public void addNeedLayout(String type) {
        this.needLayoutList.add(type);
    }

    public boolean checkNeedLayout(String type) {
        return this.needLayoutList.contains(type);
    }

    public void removeNeedLayout(String type) {
        this.needLayoutList.remove(type);
    }

    public void addCreateByPrototype(String type) {
        this.createByPrototype.add(type);
    }

    public boolean isCreateByPrototype(String type) {
        return this.createByPrototype.contains(type);
    }

    public void fillPropertyEditorParameters(DynamicPropertySet dps) {
        Iterator iter = dps.nameIterator();
        while (iter.hasNext()) {
            Object tags;
            String pName = (String)iter.next();
            DynamicProperty templateProperty = this.properties.getProperty(pName);
            if (templateProperty == null || !((tags = templateProperty.getDescriptor().getValue("TAGS")) instanceof String[])) continue;
            DynamicProperty property = dps.getProperty(pName);
            property.getDescriptor().setValue("TAGS", tags);
            property.getDescriptor().setPropertyEditorClass(TestTagEditor.class);
        }
    }

    public String getRequiredPlugins() {
        return this.requiredPlugins;
    }

    public void setRequiredPlugins(String requiredPlugins) {
        this.requiredPlugins = requiredPlugins;
    }

    @Override
    public boolean needLayout(Node node) {
        DynamicPropertySet dps = node.getAttributes();
        String type = dps != null && dps.getValue("xmlElementType") != null ? dps.getValue("xmlElementType").toString() : node.getKernel().getType();
        return this.checkNeedLayout(type);
    }

    @Override
    public boolean needAutoLayout(Edge edge) {
        return true;
    }

    public static XmlDiagramType getTypeObject(String xml) {
        try {
            return (XmlDiagramType)XmlDiagramType.getTypesCollection().get(xml);
        }
        catch (Exception e) {
            throw ExceptionRegistry.translateException((Throwable)e);
        }
    }

    @Nonnull
    public static DataCollection<XmlDiagramType> getTypesCollection() {
        try {
            return DataElementPath.create((String)Application.getGlobalValue((String)NOTATION_PATH_PROPERTY, (String)DEFAULT_NOTATION_PATH)).getDataCollection(XmlDiagramType.class);
        }
        catch (Exception ex) {
            return new VectorDataCollection("");
        }
    }

    public static class TestTagEditor
    extends StringTagEditor {
    }
}

