/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.model.util.DiagramDependentProperty;
import biouml.model.xml.DiagramElementJScriptWrapper;
import biouml.model.xml.XmlCreateDiagramElementDialog;
import biouml.model.xml.XmlDiagramType;
import biouml.model.xml.XmlDiagramTypeConstants;
import biouml.model.xml.XmlReactionPane;
import biouml.standard.diagram.CreateDiagramElementDialog;
import biouml.standard.diagram.CreateEdgeDialog;
import biouml.standard.diagram.CreateReactionDialog;
import biouml.standard.diagram.MessageBundle;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationFrame;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import com.developmentontheedge.beans.editors.StringTagEditor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.graphics.editor.ViewEditorPane;

public class XmlDiagramSemanticController
extends DefaultSemanticController {
    protected static final Logger log = Logger.getLogger(XmlDiagramSemanticController.class.getName());
    protected SemanticController prototype = new DefaultSemanticController();
    protected MessageBundle messageBundle = new MessageBundle();
    protected XmlDiagramType xmlDiagramType;
    private final Map<String, Context> contextMap = new HashMap<String, Context>();
    private final Map<String, ImporterTopLevel> scopeMap = new HashMap<String, ImporterTopLevel>();
    protected Function canAcceptFunction = null;
    protected String canAcceptCode = null;
    protected Function isResizableFunction = null;
    protected String isResizableCode = null;
    protected Function moveFunction = null;
    protected String moveCode = null;
    private boolean moveFunctionEnabled = true;
    protected Function removeFunction = null;
    protected String removeCode = null;

    public SemanticController getPrototype() {
        return this.prototype;
    }

    public void setPrototype(SemanticController prototype) {
        this.prototype = prototype;
    }

    public XmlDiagramSemanticController(XmlDiagramType diagramType) {
        this.xmlDiagramType = diagramType;
    }

    public Context getContext() {
        Context context;
        String threadKey = Thread.currentThread().getName();
        if (this.contextMap.containsKey(threadKey)) {
            context = this.contextMap.get(threadKey);
        } else {
            context = Context.enter();
            context.initStandardObjects((ScriptableObject)this.getScope());
            this.contextMap.put(threadKey, context);
            try {
                ImporterTopLevel scope = this.getScope();
                scope.put("prototype", (Scriptable)scope, (Object)Context.toObject((Object)this.prototype, (Scriptable)scope));
                for (String packageName : XmlDiagramType.IMPORT_PACKAGES) {
                    NativeJavaPackage pack = new NativeJavaPackage(packageName, this.getClass().getClassLoader());
                    ScriptRuntime.setObjectProtoAndParent((ScriptableObject)pack, (Scriptable)scope);
                    scope.importPackage(null, null, new Object[]{pack}, null);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not initialise JavaScript context for Xml Diagram Semantic Controller");
            }
        }
        return context;
    }

    public ImporterTopLevel getScope() {
        ImporterTopLevel scope;
        String threadKey = Thread.currentThread().getName();
        if (this.scopeMap.containsKey(threadKey)) {
            scope = this.scopeMap.get(threadKey);
        } else {
            scope = new ImporterTopLevel();
            this.scopeMap.put(threadKey, scope);
        }
        return scope;
    }

    public void setCanAcceptFunction(String script) {
        this.canAcceptFunction = this.getContext().compileFunction((Scriptable)this.getScope(), script, "canAccept function", 0, null);
        this.canAcceptCode = script;
    }

    public String getCanAcceptCode() {
        return this.canAcceptCode;
    }

    @Override
    public boolean canAccept(Compartment compartment, DiagramElement de) {
        if (this.canAcceptFunction != null) {
            try {
                Object[] functionArgs = new Object[]{new DiagramElementJScriptWrapper(compartment), new DiagramElementJScriptWrapper(de)};
                Boolean result = (Boolean)this.canAcceptFunction.call(this.getContext(), (Scriptable)this.getScope(), (Scriptable)this.getScope(), functionArgs);
                return result;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not accept element " + de.getName() + " to compartment " + compartment.getName() + ": " + t);
            }
        }
        return this.prototype.canAccept(compartment, de);
    }

    public void setIsResizableFunction(String script) {
        this.isResizableFunction = this.getContext().compileFunction((Scriptable)this.getScope(), script, "isResizable function", 0, null);
        this.isResizableCode = script;
    }

    public String getIsResizableCode() {
        return this.isResizableCode;
    }

    @Override
    public boolean isResizable(DiagramElement diagramElement) {
        if (diagramElement instanceof SubDiagram) {
            return true;
        }
        if (diagramElement instanceof Diagram) {
            return false;
        }
        if (this.isResizableFunction != null) {
            try {
                Object[] functionArgs = new Object[]{new DiagramElementJScriptWrapper(diagramElement)};
                return (Boolean)this.isResizableFunction.call(this.getContext(), (Scriptable)this.getScope(), (Scriptable)this.getScope(), functionArgs);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not execute isResizable, JavaScript function=" + this.isResizableFunction + ", error=" + t, t);
            }
        }
        return this.prototype.isResizable(diagramElement);
    }

    public void setMoveFunction(String script) {
        this.moveFunction = this.getContext().compileFunction((Scriptable)this.getScope(), script, "move function", 0, null);
        this.moveCode = script;
    }

    public String getMoveCode() {
        return this.moveCode;
    }

    public boolean isMoveFunctionEnabled() {
        return this.moveFunctionEnabled;
    }

    public void enableMoveFunction() {
        this.moveFunctionEnabled = true;
    }

    public void disableMoveFunction() {
        this.moveFunctionEnabled = false;
    }

    @Override
    public Dimension move(DiagramElement de, Compartment newParent, Dimension offset, Rectangle oldBounds) throws Exception {
        if (this.isMoveFunctionEnabled() && this.moveFunction != null && de instanceof Node) {
            Node oldNode = (Node)de;
            try {
                Node newNode = (Node)this.prototype.validate(newParent, oldNode);
                Point location = oldNode.getLocation();
                Compartment parent = (Compartment)oldNode.getOrigin();
                if (oldNode == newParent) {
                    newParent = (Compartment)oldNode.getOrigin();
                }
                location.translate(offset.width, offset.height);
                if (newParent != parent) {
                    if (newParent.get(oldNode.getName()) != null) {
                        throw new Exception(ERROR_NODE_IS_DUPLICATED);
                    }
                    if (this.canAccept(newParent, newNode)) {
                        newNode = this.changeNodeParent(newNode, newParent);
                    } else {
                        return new Dimension(0, 0);
                    }
                }
                Object[] functionArgs = new Object[]{location, new DiagramElementJScriptWrapper(newNode), new DiagramElementJScriptWrapper(newParent)};
                this.moveFunction.call(this.getContext(), (Scriptable)this.getScope(), (Scriptable)this.getScope(), functionArgs);
                newNode.setLocation(location);
                if (newNode instanceof Compartment) {
                    for (Node element : ((Compartment)newNode).stream(Node.class)) {
                        this.move(element, element.getCompartment(), offset, null);
                    }
                }
                newNode.edges().forEach(this::recalculateEdgePath);
                return offset;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not move element: " + t);
            }
        }
        return this.prototype.move(de, newParent, offset, oldBounds);
    }

    public void setRemoveFunction(String script) {
        this.removeFunction = this.getContext().compileFunction((Scriptable)this.getScope(), script, "remove function", 0, null);
        this.removeCode = script;
    }

    public String getRemoveCode() {
        return this.removeCode;
    }

    @Override
    public boolean remove(DiagramElement de) throws Exception {
        if (this.removeFunction != null) {
            try {
                Object[] functionArgs = new Object[]{new DiagramElementJScriptWrapper(de)};
                return (Boolean)this.removeFunction.call(this.getContext(), (Scriptable)this.getScope(), (Scriptable)this.getScope(), functionArgs);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not remove element: " + t);
            }
        }
        boolean result = super.remove(de);
        this.prototype.validate((Compartment)de.getOrigin(), de);
        return result;
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment parent, Object type, Point point, ViewEditorPane viewEditor) {
        String typeStr = this.xmlDiagramType.getKernelTypeName(type);
        Diagram diagram = Diagram.getDiagram(parent);
        if (typeStr != null) {
            Object obj;
            boolean isCompartment = false;
            if (this.xmlDiagramType.isCreateByPrototype(typeStr) && (obj = this.xmlDiagramType.getKernelType(typeStr)) instanceof Class) {
                try {
                    Class clazz = (Class)obj;
                    DiagramElement de = this.prototype.createInstance(parent, (Object)clazz, point, viewEditor).get(0);
                    return de == null ? null : new DiagramElementGroup(this.prototype.validate(parent, de));
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Error during element creation by prototype: type = " + type + " error: " + ExceptionRegistry.translateException((Throwable)ex));
                }
            }
            if (this.xmlDiagramType.checkCompartment(typeStr)) {
                isCompartment = true;
            }
            boolean isNode = Arrays.asList(this.xmlDiagramType.getNodes()).contains(typeStr);
            boolean isReaction = Arrays.asList(this.xmlDiagramType.getReactionTypes()).contains(typeStr);
            if (isNode) {
                block18: {
                    try {
                        Module module;
                        boolean standardDialog = false;
                        if (type instanceof Class && (module = Module.optModule((DataElement)parent)) != null && module.getCategory(((Class)type).asSubclass(DataElement.class)) != null) {
                            standardDialog = true;
                        }
                        if (standardDialog) {
                            CreateDiagramElementDialog dialog = new CreateDiagramElementDialog(parent, ((Class)type).asSubclass(DataElement.class));
                            if (dialog.doModal()) {
                                Node diagramElement = dialog.getNode();
                                DynamicPropertySet attributes = this.createAttributes(typeStr, diagram);
                                for (DynamicProperty attribute : attributes) {
                                    diagramElement.getAttributes().add(attribute);
                                }
                                if (isNode) {
                                    diagramElement.setLocation(point);
                                }
                                DiagramElement validatedNode = this.prototype.validate(parent, diagramElement, true);
                                return new DiagramElementGroup(validatedNode);
                            }
                            break block18;
                        }
                        DynamicPropertySet attributes = this.createAttributes(typeStr, diagram);
                        XmlCreateDiagramElementDialog dialog = new XmlCreateDiagramElementDialog("New element", parent, typeStr, isCompartment, attributes);
                        if (!dialog.doModal()) {
                            return null;
                        }
                        DiagramElement diagramElement = dialog.getNewDiagramElement();
                        if (isNode) {
                            ((Node)diagramElement).setLocation(point);
                        }
                        DiagramElement validatedNode = this.prototype.validate(parent, diagramElement, true);
                        return new DiagramElementGroup(validatedNode);
                    }
                    catch (Throwable t) {
                        log.log(Level.SEVERE, "Can not create new node element: " + t);
                    }
                }
                return null;
            }
            if (isReaction) {
                XmlReactionPane reactionPane = new XmlReactionPane(diagram, parent, point, viewEditor, typeStr, ((Class)type).getName(), this.createAttributes(typeStr, diagram));
                ApplicationFrame frame = Application.getApplicationFrame();
                CreateReactionDialog dialog = new CreateReactionDialog((JFrame)frame, reactionPane);
                dialog.pack();
                dialog.setVisible(true);
                return null;
            }
            try {
                String name = XmlDiagramSemanticController.generateUniqueNodeName(parent, typeStr);
                CreateEdgeDialog dialog = CreateEdgeDialog.getSimpleEdgeDialog(Module.optModule((DataElement)parent), point, viewEditor, name, typeStr, this.createAttributes(typeStr, diagram));
                dialog.setVisible(true);
                return null;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Can not create new diagram element, error: " + t, t);
                return null;
            }
        }
        return null;
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment parent, Object type, Point point, Object properties) {
        DiagramElement de = this.prototype.createInstance(parent, type, point, properties).getElement();
        DynamicProperty property = de.getAttributes().getProperty("xmlElementType");
        if (property != null) {
            String typeStr = (String)property.getValue();
            for (DynamicProperty attribute : this.createAttributes(typeStr, Diagram.getDiagram(parent))) {
                de.getAttributes().add(attribute);
            }
        }
        return new DiagramElementGroup(de);
    }

    @Override
    public Object getPropertiesByType(Compartment compartment, Object type, Point point) {
        Object bean = this.xmlDiagramType.getPropertiesBean(type.toString());
        if (bean != null) {
            return bean;
        }
        return this.prototype.getPropertiesByType(compartment, type, point);
    }

    @Nonnull
    public DynamicPropertySet createAttributes(String typeStr) {
        return this.createAttributes(typeStr, null);
    }

    @Nonnull
    public DynamicPropertySet createAttributes(String typeStr, Diagram diagram) {
        DynamicPropertySetAsMap result = new DynamicPropertySetAsMap();
        DynamicPropertySet properties = this.xmlDiagramType.getType(typeStr);
        if (properties != null) {
            for (DynamicProperty property : properties) {
                String dpName = property.getName();
                DynamicProperty dp = this.xmlDiagramType.getProperties().getProperty(dpName);
                try {
                    Class pType = dp.getType();
                    if (pType.isArray()) {
                        DynamicProperty[] items = (DynamicProperty[])dp.getValue();
                        if (items.length <= 0) continue;
                        DynamicProperty dpItem = items[0];
                        Object[] values = (Object[])Array.newInstance(dpItem.getType(), 0);
                        result.add(new DynamicProperty(dp.getName(), values.getClass(), (Object)values));
                        continue;
                    }
                    Object dpValue = dp.getValue();
                    if (dpValue instanceof DiagramDependentProperty) {
                        ((DiagramDependentProperty)dpValue).setDiagram(diagram);
                    }
                    DynamicProperty newProperty = new DynamicProperty(dp.getName(), pType, dpValue);
                    Object tagValues = dp.getDescriptor().getValue("TAGS");
                    if (tagValues instanceof String[]) {
                        newProperty.getDescriptor().setValue("TAGS", tagValues);
                        newProperty.getDescriptor().setPropertyEditorClass(TestTagEditor.class);
                        newProperty.setValue((Object)((String[])tagValues)[0]);
                        if (dp.getValue() != null && !dp.getValue().equals("")) {
                            String value = dp.getValue().toString();
                            if (Arrays.asList((String[])tagValues).contains(value)) {
                                newProperty.setValue((Object)value);
                            }
                        }
                    }
                    result.add(newProperty);
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    @Override
    public DiagramElementGroup createInstanceFromElement(Compartment compartment, DataElement element, Point point, ViewEditorPane viewEditor) throws Exception {
        DiagramElementGroup result = super.createInstanceFromElement(compartment, element, point, viewEditor);
        DiagramElementGroup validated = new DiagramElementGroup();
        for (DiagramElement de : result.getElements()) {
            validated.add(this.getPrototype().validate(compartment, de));
        }
        return validated;
    }

    @Override
    protected Node changeNodeParent(Node oldNode, Compartment newParent) throws Exception {
        Node node = super.changeNodeParent(oldNode, newParent);
        if (node.getKernel() instanceof Reaction) {
            return node;
        }
        for (Edge edge : node.getEdges()) {
            if (!(edge.getKernel() instanceof SpecieReference)) continue;
            SpecieReference ref = (SpecieReference)edge.getKernel();
            ref.setSpecie(node.getCompleteNameInDiagram());
        }
        return node;
    }

    @Override
    public DiagramElement validate(Compartment compartment, @Nonnull DiagramElement de, boolean newElement) throws Exception {
        return this.prototype.validate(compartment, de, newElement);
    }

    @Override
    public Edge createEdge(Node fromNode, Node toNode, String edgeType, Compartment compartment) {
        Edge edge = super.createEdge(fromNode, toNode, edgeType, compartment);
        if (edge != null) {
            String xmlKernelType = "logic arc";
            if ("semantic".equals(edgeType)) {
                xmlKernelType = "logic arc";
            } else if ("reactant".equals(edgeType)) {
                xmlKernelType = "consumption";
            } else if ("product".equals(edgeType)) {
                xmlKernelType = "production";
            } else if ("modifier".equals(edgeType)) {
                xmlKernelType = "regulation";
            } else if ("noteLink".equals(edgeType)) {
                xmlKernelType = "logic arc";
            }
            DynamicProperty dp = new DynamicProperty(XmlDiagramTypeConstants.XML_TYPE_PD, String.class, (Object)xmlKernelType);
            edge.getAttributes().add(dp);
            try {
                edge = (Edge)this.getPrototype().validate(compartment, edge);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return edge;
    }

    public static class TestTagEditor
    extends StringTagEditor {
    }
}

