/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.Compartment;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.standard.type.Base;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.dialog.OkCancelDialog;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.swing.PropertyInspector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class XmlCreateDiagramElementDialog
extends OkCancelDialog {
    protected static final Logger log = Logger.getLogger(XmlCreateDiagramElementDialog.class.getName());
    protected Compartment parent;
    protected DiagramElement de;
    protected JTextField id;
    protected PropertyInspector propertyInspector;
    protected String typeStr;
    protected boolean isCompartment;
    protected DynamicPropertySet attributes;

    public XmlCreateDiagramElementDialog(String title, Compartment parent, String typeStr, boolean isCompartment, DynamicPropertySet attributes) {
        super((JFrame)Application.getApplicationFrame(), title);
        this.parent = parent;
        this.typeStr = typeStr;
        this.isCompartment = isCompartment;
        this.attributes = attributes;
        this.init();
    }

    public DiagramElement getNewDiagramElement() {
        return this.de;
    }

    private void init() {
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContent(content);
        String idName = "Name";
        content.add((Component)new JLabel(idName), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.id = new JTextField(15);
        content.add((Component)this.id, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.id.addActionListener(e -> {
            String name = this.id.getText();
            if (this.parent.contains(name)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Data element \"" + name + "\" already exists.", "", 2);
            } else {
                this.createDiagramElement(name);
                this.propertyInspector.explore((Object)this.de);
                this.id.setEnabled(false);
                this.okButton.setEnabled(true);
            }
        });
        this.okButton.setEnabled(false);
        this.propertyInspector = new PropertyInspector();
        this.propertyInspector.setPreferredSize(new Dimension(350, 250));
        this.propertyInspector.explore((Object)this.de);
        content.add((Component)this.propertyInspector, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
    }

    protected void createDiagramElement(String name) {
        Stub stub = null;
        try {
            stub = new Stub(null, name, this.typeStr);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Can not create new diagram element, error: " + t, t);
        }
        if (!this.isCompartment) {
            this.de = new Node(this.parent, (Base)stub);
        } else {
            this.de = new Compartment(this.parent, (Base)stub);
            ((Compartment)this.de).setShapeSize(new Dimension(0, 0));
        }
        Iterator iter = this.attributes.nameIterator();
        while (iter.hasNext()) {
            this.de.getAttributes().add(this.attributes.getProperty((String)iter.next()));
        }
    }
}

