/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.xml.DiagramElementJScriptWrapper;
import biouml.standard.diagram.CompositeSemanticController;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import one.util.streamex.StreamEx;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.SimplePath;
import ru.biosoft.graphics.View;
import ru.biosoft.graphics.font.ColorFont;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.parser.ParseException;
import ru.biosoft.math.parser.Parser;
import ru.biosoft.math.view.FormulaViewBuilder;

public class JSUtility {
    protected Pen connectionPen = new Pen(1.0f, Color.black);
    protected Pen connectionPortPen = new Pen(1.0f, Color.black);
    protected Brush outputConnectionPortBrush = new Brush((Paint)Color.red);

    public static int moveToEdge(Point location, Rectangle bounds) {
        int[] dist = new int[]{(int)Math.abs((double)location.x - bounds.getMinX()), (int)Math.abs((double)location.y - bounds.getMinY()), (int)Math.abs((double)location.x - bounds.getMaxX()), (int)Math.abs((double)location.y - bounds.getMaxY())};
        int minDist = dist[0];
        int maxDir = 0;
        for (int i = 1; i < 4; ++i) {
            if (minDist <= dist[i]) continue;
            minDist = dist[i];
            maxDir = i;
        }
        switch (maxDir) {
            case 0: {
                location.y = (int)Math.min(Math.max((double)location.y, bounds.getMinY()), bounds.getMaxY());
                location.x = (int)bounds.getMinX();
                break;
            }
            case 1: {
                location.y = (int)bounds.getMinY();
                location.x = (int)Math.min(Math.max((double)location.x, bounds.getMinX()), bounds.getMaxX());
                break;
            }
            case 2: {
                location.y = (int)Math.min(Math.max((double)location.y, bounds.getMinY()), bounds.getMaxY());
                location.x = (int)bounds.getMaxX();
                break;
            }
            case 3: {
                location.y = (int)bounds.getMaxY();
                location.x = (int)Math.min(Math.max((double)location.x, bounds.getMinX()), bounds.getMaxX());
            }
        }
        return maxDir;
    }

    public static int moveToEdge(Point location, DiagramElementJScriptWrapper node, DiagramElementJScriptWrapper parent) {
        return JSUtility.moveToEdge(location, node, parent, false);
    }

    public static int moveToEdge(Point location, DiagramElementJScriptWrapper node, DiagramElementJScriptWrapper parent, boolean isInside) {
        Dimension nodeSize;
        Point parentLocation = (Point)parent.getValue("location", null);
        Dimension parentDimension = (Dimension)parent.getValue("shapeSize", null);
        View nodeView = (View)node.getValue("view", null);
        if (nodeView != null) {
            Rectangle nodeBounds = nodeView.getBounds();
            nodeSize = new Dimension(nodeBounds.width, nodeBounds.height);
        } else {
            nodeSize = new Dimension(40, 20);
        }
        location.translate(nodeSize.width / 2, nodeSize.height / 2);
        Rectangle rect = new Rectangle(parentLocation, parentDimension);
        if (isInside) {
            rect.grow(-nodeSize.width / 2, -nodeSize.height / 2);
        }
        int result = JSUtility.moveToEdge(location, rect);
        location.translate(-nodeSize.width / 2, -nodeSize.height / 2);
        return result;
    }

    public static int fillLocationByAngle(Point location, Dimension parentDimension, Dimension nodeSize, double angle, boolean isInside) {
        int type = 0;
        double dWidth = parentDimension.width;
        double dHeight = parentDimension.height;
        double angleLimit = Math.atan(dHeight / dWidth);
        Point pos = new Point(0, parentDimension.height / 2);
        if (angle >= -angleLimit && angle <= angleLimit) {
            pos.y = (int)((dHeight - dWidth * Math.tan(angle)) / 2.0);
        } else if (angle >= angleLimit && angle <= Math.PI - angleLimit) {
            pos.y = 0;
            pos.x = (int)((dWidth - dHeight / Math.tan(angle)) / 2.0);
            type = 1;
        } else if (angle <= -angleLimit && angle >= -Math.PI + angleLimit) {
            pos.y = parentDimension.height;
            pos.x = (int)((dWidth + dHeight / Math.tan(angle)) / 2.0);
            type = 3;
        } else if (angle >= Math.PI - angleLimit && angle <= Math.PI || angle <= -Math.PI + angleLimit && angle >= -Math.PI) {
            pos.y = (int)((dHeight - dWidth * Math.tan(Math.PI - angle)) / 2.0);
            pos.x = parentDimension.width;
            type = 2;
        }
        if (isInside) {
            if (type == 0) {
                location.x = pos.x;
                location.y = pos.y - nodeSize.height / 2;
            } else if (type == 1) {
                location.x = pos.x - nodeSize.width / 2;
                location.y = pos.y;
            } else if (type == 2) {
                location.x = pos.x - nodeSize.width;
                location.y = pos.y - nodeSize.height / 2;
            } else {
                location.x = pos.x - nodeSize.width / 2;
                location.y = pos.y - nodeSize.height;
            }
        } else {
            location.x = pos.x - nodeSize.width / 2;
            location.y = pos.y - nodeSize.height / 2;
        }
        return type;
    }

    public static double getTitleAngle(View nodeView, DiagramElementJScriptWrapper node) {
        Node n = (Node)node.getDiagramElement();
        Rectangle nBounds = nodeView.getBounds();
        Point nodeCenter = new Point(n.getLocation().x + nBounds.width / 2, n.getLocation().y + nBounds.height / 2);
        Compartment c = n.getCompartment();
        Point baseCenter = new Point(c.getLocation().x + c.getShapeSize().width / 2, c.getLocation().y + c.getShapeSize().height / 2);
        if (baseCenter.x > nodeCenter.x) {
            return Math.atan((double)(baseCenter.y - nodeCenter.y) / (double)(baseCenter.x - nodeCenter.x)) + Math.PI;
        }
        if (baseCenter.x < nodeCenter.x) {
            return Math.atan((double)(baseCenter.y - nodeCenter.y) / (double)(baseCenter.x - nodeCenter.x));
        }
        if (baseCenter.y >= nodeCenter.y) {
            return 4.71238898038469;
        }
        return 1.5707963267948966;
    }

    public static SimplePath getPath(DiagramElementJScriptWrapper de) {
        SimplePath path;
        if (!(de.getDiagramElement() instanceof Edge)) {
            return null;
        }
        Edge edge = (Edge)de.getDiagramElement();
        if (edge.getPath() == null) {
            Diagram.getDiagram(edge).getType().getSemanticController().recalculateEdgePath(edge);
        }
        if ((path = edge.getSimplePath()) == null) {
            path = new SimplePath(new int[]{edge.getInPort().x, edge.getOutPort().x}, new int[]{edge.getInPort().y, edge.getOutPort().y}, 2);
        }
        return path;
    }

    public static SimplePath getArcPath(DiagramElementJScriptWrapper de) {
        if (!(de.getDiagramElement() instanceof Edge)) {
            return null;
        }
        Edge edge = (Edge)de.getDiagramElement();
        Path path = new Path();
        Point in = new Point();
        Point out = new Point();
        Diagram.getDiagram(edge).getType().getDiagramViewBuilder().calculateInOut(edge, in, out);
        Point middlePoint = null;
        if (edge.getInput().getKernel() instanceof Reaction) {
            Node reactionNode = edge.getInput();
            Node elementNode = edge.getOutput();
            for (Edge e : reactionNode.getEdges()) {
                SpecieReference sr;
                if (!(e.getKernel() instanceof SpecieReference) || !(sr = (SpecieReference)e.getKernel()).getRole().equals("product") || e.getOutput() == elementNode) continue;
                Node specie = e.getOutput();
                Rectangle rect = specie.getView().getBounds();
                int x = rect.x + rect.width / 2;
                int y = rect.y + rect.height / 2;
                middlePoint = JSUtility.getProjection(out, in, new Point(x, y));
                break;
            }
        } else if (edge.getOutput().getKernel() instanceof Reaction) {
            Node reactionNode = edge.getOutput();
            Node elementNode = edge.getInput();
            for (Edge e : reactionNode.getEdges()) {
                SpecieReference sr;
                if (!(e.getKernel() instanceof SpecieReference) || !(sr = (SpecieReference)e.getKernel()).getRole().equals("reactant") || e.getInput() == elementNode) continue;
                Node specie = e.getInput();
                Rectangle rect = specie.getView().getBounds();
                int x = rect.x + rect.width / 2;
                int y = rect.y + rect.height / 2;
                middlePoint = JSUtility.getProjection(in, out, new Point(x, y));
                break;
            }
        }
        path.addPoint(in.x, in.y, 0);
        if (middlePoint != null) {
            path.addPoint(middlePoint.x, middlePoint.y, 1);
        }
        path.addPoint(out.x, out.y, 0);
        edge.setPath(path);
        return edge.getSimplePath();
    }

    protected static Point getProjection(Point p, Point p1, Point p2) {
        double fDenominator = (p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y);
        if (fDenominator == 0.0) {
            return new Point(p1.x, p1.y);
        }
        double t = (double)(p.x * (p2.x - p1.x) - (p2.x - p1.x) * p1.x + p.y * (p2.y - p1.y) - (p2.y - p1.y) * p1.y) / fDenominator;
        return new Point((int)((double)p1.x + (double)(p2.x - p1.x) * t), (int)((double)p1.y + (double)(p2.y - p1.y) * t));
    }

    public static DiagramElementJScriptWrapper[] getNodesByRole(Diagram diagram, Reaction reaction, String role) {
        return (DiagramElementJScriptWrapper[])((StreamEx)((StreamEx)StreamEx.of((Object[])reaction.getSpecieReferences()).filter(sr -> sr.getRole().equals(role))).map(sr -> Module.getModule(reaction).getKernel(sr.getSpecie())).select(Base.class).flatMap(de -> diagram.getKernelNodes((Base)de)).distinct()).map(DiagramElementJScriptWrapper::new).toArray(DiagramElementJScriptWrapper[]::new);
    }

    public static boolean isPartOfReaction(DiagramElementJScriptWrapper dew) {
        return true;
    }

    public static CompositeView createFormulaView(String formula, Graphics g) {
        try {
            Parser parser = new Parser((Reader)new StringReader(formula));
            AstStart start = parser.Start();
            return new FormulaViewBuilder().createView(start, g);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static ColorFont getDefaultFont() {
        return new FormulaViewBuilder().getDefaultFont();
    }

    public static void addEdgeTitle(View edgeView, Edge edge, String title, ColorFont font, Map<String, ColorFont> fontRegistry, Graphics g) {
        View parentView;
        if (edge.getOrigin() != null && (parentView = ((DiagramElement)edge.getOrigin()).getView()) instanceof CompositeView) {
            Node node = null;
            Point point = null;
            if (edge.getInput().getKernel() instanceof Reaction) {
                node = edge.getOutput();
                point = edge.getOutPort();
            } else if (edge.getOutput().getKernel() instanceof Reaction) {
                node = edge.getInput();
                point = edge.getInPort();
            }
            if (node != null && point != null && point.x != 0 && point.y != 0) {
                ComplexTextView textView = new ComplexTextView(title, font, fontRegistry, 12, 15, g);
                Dimension size = new Dimension(textView.getBounds().width, textView.getBounds().height);
                Point titleLocation = new Point();
                int minPenalty = Integer.MAX_VALUE;
                minPenalty = JSUtility.checkPosition(edgeView, node, size, new Point(point.x + 5, point.y), minPenalty, titleLocation);
                minPenalty = JSUtility.checkPosition(edgeView, node, size, new Point(point.x - size.width / 2, point.y + 3), minPenalty, titleLocation);
                minPenalty = JSUtility.checkPosition(edgeView, node, size, new Point(point.x - size.width - 5, point.y), minPenalty, titleLocation);
                minPenalty = JSUtility.checkPosition(edgeView, node, size, new Point(point.x - size.width - 5, point.y - size.height), minPenalty, titleLocation);
                minPenalty = JSUtility.checkPosition(edgeView, node, size, new Point(point.x - size.width / 2, point.y - size.height - 3), minPenalty, titleLocation);
                JSUtility.checkPosition(edgeView, node, size, new Point(point.x + 5, point.y - size.height), minPenalty, titleLocation);
                ((CompositeView)parentView).add((View)textView, 8, titleLocation);
            }
        }
    }

    protected static int checkPosition(View edgeView, Node node, Dimension size, Point location, int minPenalty, Point currentLocation) {
        int penalty = JSUtility.calculatePenalty(edgeView, node, size, location, 2);
        if (penalty < minPenalty) {
            currentLocation.x = location.x;
            currentLocation.y = location.y;
            return penalty;
        }
        return minPenalty;
    }

    protected static int calculatePenalty(View edgeView, Node node, Dimension size, Point location, int deep) {
        Rectangle bounds;
        int result = 0;
        Rectangle titleRect = new Rectangle(location.x, location.y, size.width, size.height);
        if (node.getView() != null && (bounds = node.getView().getBounds()).intersects(titleRect)) {
            result += 20;
        }
        if (edgeView != null && edgeView.intersects(titleRect)) {
            result += 10;
        }
        if (deep > 0) {
            for (Edge edge : node.edges()) {
                result += JSUtility.calculatePenalty(null, edge.getOtherEnd(node), size, location, deep - 1);
            }
        }
        return result;
    }

    public static void movePortToEdge(DiagramElement nodeDE, DiagramElement compartmentDE, Point newLocation) {
        CompositeSemanticController.movePortToEdge((Node)nodeDE, (Compartment)compartmentDE, newLocation, false);
    }

    public static boolean isSubDiagramPort(String type, String deType) {
        return deType.equals("port") && type.equals("subDiagram");
    }
}

