/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.xml;

import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.standard.type.Base;
import com.developmentontheedge.beans.DynamicProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import one.util.streamex.StreamEx;

public class DiagramElementJScriptWrapper {
    protected DiagramElement diagramElement;
    private static Map<Class<?>, Map<String, Method>> methods = new ConcurrentHashMap();

    public DiagramElementJScriptWrapper(DiagramElement diagramElement) {
        this.diagramElement = diagramElement;
    }

    public DiagramElement getDiagramElement() {
        return this.diagramElement;
    }

    public void setDiagramElement(DiagramElement diagramElement) {
        this.diagramElement = diagramElement;
    }

    public boolean isNode() {
        return this.diagramElement instanceof Node;
    }

    public boolean isEdge() {
        return this.diagramElement instanceof Edge;
    }

    public Object getValue(String name, Object defaultValue) {
        Object obj = this.getCoreValue(name, defaultValue);
        if (obj instanceof DiagramElement) {
            return new DiagramElementJScriptWrapper((DiagramElement)((Object)obj));
        }
        return obj;
    }

    private static Object fetchValue(Object bean, String property) {
        Method m = (Method)methods.computeIfAbsent(bean.getClass(), clazz -> ((StreamEx)StreamEx.of((Object[])clazz.getMethods()).filter(method -> method.getParameterTypes().length == 0)).mapToEntry(Method::getName, Function.identity()).filterKeys(name -> name.startsWith("get")).mapKeys(name -> name.substring("get".length()).toLowerCase()).toMap()).get(property.toLowerCase());
        if (m == null) {
            return null;
        }
        try {
            return m.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    private Object getCoreValue(String name, Object defaultValue) {
        Object result = DiagramElementJScriptWrapper.fetchValue((Object)this.diagramElement, name);
        if (result != null) {
            return result;
        }
        if (this.diagramElement.getAttributes() != null && (result = this.diagramElement.getAttributes().getValue(name)) != null) {
            return result;
        }
        Base kernel = this.diagramElement.getKernel();
        if (kernel != null) {
            result = DiagramElementJScriptWrapper.fetchValue(kernel, name);
            if (result != null) {
                return result;
            }
            if (kernel.getAttributes() != null && (result = kernel.getAttributes().getValue(name)) != null) {
                return result;
            }
        }
        return defaultValue;
    }

    public void setValue(String name, Object value) {
        DynamicProperty dp;
        Method[] methods;
        for (Method method : methods = ((Object)((Object)this.diagramElement)).getClass().getMethods()) {
            if (!method.getName().toLowerCase().equals(("set" + name).toLowerCase())) continue;
            try {
                method.invoke((Object)this.diagramElement, value);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.diagramElement.getAttributes() != null && (dp = this.diagramElement.getAttributes().getProperty(name)) != null) {
            dp.setValue(value);
            return;
        }
        Base kernel = this.diagramElement.getKernel();
        if (kernel != null) {
            DynamicProperty kernelDp;
            Method[] kernelMethods;
            for (Method kernelMethod : kernelMethods = kernel.getClass().getMethods()) {
                if (!kernelMethod.getName().toLowerCase().equals(("set" + name).toLowerCase())) continue;
                try {
                    kernelMethod.invoke((Object)kernel, value);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (kernel.getAttributes() != null && (kernelDp = kernel.getAttributes().getProperty(name)) != null && kernelDp.getValue() != null) {
                kernelDp.setValue(value);
                return;
            }
        }
    }

    public boolean hasValue(String name) {
        DynamicProperty dp;
        Method[] methods;
        for (Method method : methods = ((Object)((Object)this.diagramElement)).getClass().getMethods()) {
            if (!method.getName().toLowerCase().equals(("get" + name).toLowerCase())) continue;
            return true;
        }
        if (this.diagramElement.getAttributes() != null && (dp = this.diagramElement.getAttributes().getProperty(name)) != null) {
            return true;
        }
        Base kernel = this.diagramElement.getKernel();
        if (kernel != null) {
            DynamicProperty kernelDp;
            Method[] kernelMethods;
            for (Method kernelMethod : kernelMethods = kernel.getClass().getMethods()) {
                if (!kernelMethod.getName().toLowerCase().equals(("get" + name).toLowerCase())) continue;
                return true;
            }
            if (kernel.getAttributes() != null && (kernelDp = kernel.getAttributes().getProperty(name)) != null) {
                return true;
            }
        }
        return false;
    }

    public void addAttribute(String name, Class<?> type, Object value) {
        try {
            this.diagramElement.getAttributes().add(new DynamicProperty(name, type, value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

