/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.web;

import biouml.model.Diagram;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.EquationBeanInfo;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.util.FormulaEditor;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.Util;
import biouml.standard.type.Reaction;
import biouml.standard.type.Unit;
import biouml.workbench.diagram.viewpart.ConnectionSimple;
import biouml.workbench.diagram.viewpart.ModelViewPart;
import biouml.workbench.diagram.viewpart.PortSimple;
import biouml.workbench.diagram.viewpart.ReactionSimple;
import biouml.workbench.diagram.viewpart.SubDiagramSimple;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.VectorDataCollection;
import ru.biosoft.server.servlets.webservices.BiosoftWebRequest;
import ru.biosoft.server.servlets.webservices.WebException;
import ru.biosoft.table.access.TableResolver;
import ru.biosoft.util.bean.BeanInfoEx2;

public class DiagramModelTableResolver
extends TableResolver {
    public static final String TABLE_TYPE_PARAMETER = "tabletype";
    protected String type;
    protected String subDiagram;

    public DiagramModelTableResolver(BiosoftWebRequest arguments) throws WebException {
        this.type = arguments.getString(TABLE_TYPE_PARAMETER);
        this.subDiagram = arguments.get("subDiagram");
    }

    public DataCollection<?> getTable(DataElement de) throws Exception {
        SubDiagram sub;
        Diagram diagram = (Diagram)de.cast(Diagram.class);
        Role modelObj = diagram.getRole();
        if (this.subDiagram != null && (sub = Util.getSubDiagram(diagram, this.subDiagram)) != null) {
            modelObj = sub.getDiagram().getRole();
        }
        if (modelObj instanceof EModel) {
            EModel emodel = (EModel)modelObj;
            if ("variables".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Parameters", Variable.class, null);
                for (Variable parameter : ((EModel)modelObj).getParameters()) {
                    result.put((DataElement)parameter);
                }
                return result;
            }
            if ("variableroles".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Parameters", VariableRole.class, null);
                for (VariableRole parameter : ((EModel)modelObj).getVariableRoles()) {
                    result.put((DataElement)parameter);
                }
                return result;
            }
            if ("entities".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Variables", VariableRole.class, null);
                for (VariableRole variable : ((EModel)modelObj).getEntityRoles()) {
                    result.put((DataElement)variable);
                }
                return result;
            }
            if ("units".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Units", UnitWrapper.class, null);
                for (Unit unit : ((EModel)modelObj).getUnits().values()) {
                    result.put((DataElement)new UnitWrapper(unit));
                }
                return result;
            }
            if ("compartments".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Compartments", VariableRole.class, null);
                for (VariableRole variable : ((EModel)modelObj).getCompartmentRoles()) {
                    result.put((DataElement)variable);
                }
                return result;
            }
            if ("equations".equals(this.type)) {
                ModelViewPart.RuleFilter filter = new ModelViewPart.RuleFilter();
                VectorDataCollection result = new VectorDataCollection("Equations", EquationWrapper.class, null);
                emodel.getChildrenRoles(emodel.getParent(), Equation.class, filter).map(e -> new EquationWrapper((Equation)e)).forEach(ew -> {
                    EquationWrapper cfr_ignored_0 = (EquationWrapper)result.put((DataElement)ew);
                });
                return result;
            }
            if ("functions".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Functions", FunctionWrapper.class, null);
                emodel.getChildrenRoles(emodel.getParent(), Function.class).map(e -> new FunctionWrapper((Function)e)).forEach(fw -> {
                    FunctionWrapper cfr_ignored_0 = (FunctionWrapper)result.put((DataElement)fw);
                });
                return result;
            }
            if ("events".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Events", EventWrapper.class, null);
                emodel.getChildrenRoles(emodel.getParent(), Event.class).map(e -> new EventWrapper((Event)e)).forEach(ev -> {
                    EventWrapper cfr_ignored_0 = (EventWrapper)result.put((DataElement)ev);
                });
                return result;
            }
            if ("constraints".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Constraints", ConstraintWrapper.class, null);
                emodel.getChildrenRoles(emodel.getParent(), Constraint.class).map(e -> new ConstraintWrapper((Constraint)e)).forEach(cw -> {
                    ConstraintWrapper cfr_ignored_0 = (ConstraintWrapper)result.put((DataElement)cw);
                });
                return result;
            }
            if ("reactions".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Reactions", ReactionSimple.class, null);
                StreamEx.of(DiagramUtility.getReactions(diagram)).map(r -> new ReactionSimple((Reaction)r)).forEach(r -> {
                    ReactionSimple cfr_ignored_0 = (ReactionSimple)result.put((DataElement)r);
                });
                return result;
            }
            if ("ports".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Ports", PortSimple.class, null);
                DiagramUtility.getTopLevelPorts(diagram).map(r -> new PortSimple((Node)((Object)r))).forEach(port -> {
                    PortSimple cfr_ignored_0 = (PortSimple)result.put((DataElement)port);
                });
                return result;
            }
            if ("connections".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Connections", ConnectionSimple.class, null);
                DiagramUtility.getConnections(diagram).map(n -> new ConnectionSimple((Edge)((Object)n))).forEach(c -> {
                    ConnectionSimple cfr_ignored_0 = (ConnectionSimple)result.put((DataElement)c);
                });
                return result;
            }
            if ("subdiagrams".equals(this.type)) {
                VectorDataCollection result = new VectorDataCollection("Subdiagrams", SubDiagramSimple.class, null);
                DiagramUtility.getSubDiagrams(diagram).map(n -> new SubDiagramSimple((SubDiagram)((Object)n))).forEach(c -> {
                    SubDiagramSimple cfr_ignored_0 = (SubDiagramSimple)result.put((DataElement)c);
                });
                return result;
            }
        }
        return null;
    }

    public static class ConstraintWrapperBeanInfo
    extends BeanInfoEx2<ConstraintWrapper> {
        public ConstraintWrapperBeanInfo() {
            super(ConstraintWrapper.class);
        }

        public void initProperties() throws Exception {
            this.add("formula", FormulaEditor.class);
            this.add("message");
            this.add("comment");
        }
    }

    public static class ConstraintWrapper
    implements DataElement {
        private Constraint constraint;

        public ConstraintWrapper() {
            this.constraint = new Constraint(null);
        }

        public ConstraintWrapper(Constraint constraint) {
            this.constraint = constraint;
        }

        @PropertyName(value="Name")
        public String getName() {
            return this.constraint.getParent().getName();
        }

        public DataCollection<?> getOrigin() {
            return null;
        }

        @PropertyName(value="Formula")
        public String getFormula() {
            return this.constraint.getFormula();
        }

        public void setFormula(String formula) {
            this.constraint.setFormula(formula);
        }

        @PropertyName(value="Message")
        public String getMessage() {
            return this.constraint.getMessage();
        }

        public void setMessage(String message) {
            this.constraint.setMessage(message);
        }

        @PropertyName(value="Comment")
        public String getComment() {
            return this.constraint.getComment();
        }

        public void setComment(String comment) {
            this.constraint.setComment(comment);
        }
    }

    public static class EventWrapperBeanInfo
    extends BeanInfoEx2<EventWrapper> {
        public EventWrapperBeanInfo() {
            super(EventWrapper.class);
        }

        public void initProperties() throws Exception {
            this.add("trigger", FormulaEditor.class);
            this.add("priority", FormulaEditor.class);
            this.add("useValuesFromTriggerTime");
            this.add("triggerPersistent");
            this.add("triggerInitialValue");
            this.add("delay");
            this.add("timeUnits");
            this.add("triggerMessage");
            this.add("eventAssignment");
            this.add("comment");
        }
    }

    public static class EventWrapper
    implements DataElement {
        Event event;

        public EventWrapper() {
            this.event = new Event(null);
        }

        public EventWrapper(Event equation) {
            this.event = equation;
        }

        @PropertyName(value="Name")
        public String getName() {
            return this.event.getParent().getName();
        }

        public DataCollection<?> getOrigin() {
            return null;
        }

        @PropertyName(value="Trigger")
        public String getTrigger() {
            return this.event.getTrigger();
        }

        public void setTrigger(String trigger) {
            this.event.setTrigger(trigger);
        }

        @PropertyName(value="Trigger message")
        public String getTriggerMessage() {
            return this.event.getTriggerMessage();
        }

        public void setTriggerMessage(String message) {
            this.event.setTriggerMessage(message);
        }

        @PropertyName(value="Delay")
        public String getDelay() {
            return this.event.getDelay();
        }

        public void setDelay(String delay) {
            this.event.setDelay(delay);
        }

        @PropertyName(value="Delay time units")
        public String getTimeUnits() {
            return this.event.getTimeUnits();
        }

        public void setTimeUnits(String units) {
            this.event.setTimeUnits(units);
        }

        @PropertyName(value="Use trigger time values")
        public boolean isUseValuesFromTriggerTime() {
            return this.event.isUseValuesFromTriggerTime();
        }

        public void setUseValuesFromTriggerTime(boolean useValuesFromTriggerTime) {
            this.event.setUseValuesFromTriggerTime(useValuesFromTriggerTime);
        }

        @PropertyName(value="Priority")
        public String getPriority() {
            return this.event.getPriority();
        }

        public void setPriority(String priority) {
            this.event.setPriority(priority);
        }

        @PropertyName(value="Comment")
        public String getComment() {
            return this.event.getComment();
        }

        public void setComment(String comment) {
            this.event.setComment(comment);
        }

        @PropertyName(value="Trigger initial value")
        public boolean isTriggerInitialValue() {
            return this.event.isTriggerInitialValue();
        }

        public void setTriggerInitialValue(boolean triggerInitialValue) {
            this.event.setTriggerInitialValue(triggerInitialValue);
        }

        @PropertyName(value="Persistent trigger")
        public boolean isTriggerPersistent() {
            return this.event.isTriggerPersistent();
        }

        public void setTriggerPersistent(boolean triggerPersistent) {
            this.event.setTriggerPersistent(triggerPersistent);
        }

        @PropertyName(value="Assignments")
        public Assignment[] getEventAssignment() {
            return this.event.getEventAssignment();
        }

        public void setEventAssignment(Assignment[] eventAssignment) {
            this.event.setEventAssignment(eventAssignment);
        }
    }

    public static class FunctionWrapperBeanInfo
    extends BeanInfoEx2<FunctionWrapper> {
        public FunctionWrapperBeanInfo() {
            super(FunctionWrapper.class);
        }

        public void initProperties() throws Exception {
            this.add("name");
            this.add("rightHandSide", FormulaEditor.class);
            this.addReadOnly("formula");
            this.add("comment");
        }
    }

    public static class FunctionWrapper
    implements DataElement {
        Function function;

        public FunctionWrapper() {
            this.function = new Function(null, "function f() = 0");
        }

        public FunctionWrapper(Function equation) {
            this.function = equation;
        }

        @PropertyName(value="Formula")
        public String getFormula() {
            return this.function.getFormula();
        }

        public void setFormula(String formula) {
            this.function.setFormula(formula);
        }

        @PropertyName(value="Name")
        public String getName() {
            return this.function.getName();
        }

        public void setName(String name) {
            this.function.setName(name);
        }

        public DataCollection<?> getOrigin() {
            return null;
        }

        @PropertyName(value="Right Hand Side")
        public String getRightHandSide() {
            return this.function.getRightHandSide();
        }

        public void setRightHandSide(String rhs) {
            this.function.setRightHandSide(rhs);
        }

        @PropertyName(value="Comment")
        public String getComment() {
            return this.function.getComment();
        }

        public void setComment(String comment) {
            this.function.setComment(comment);
        }
    }

    public static class EquationWrapperBeanInfo
    extends BeanInfoEx2<EquationWrapper> {
        public EquationWrapperBeanInfo() {
            super(EquationWrapper.class);
        }

        public void initProperties() throws Exception {
            this.addHidden("variable", "isAlgebraic");
            this.add("formula", FormulaEditor.class);
            this.add("type", EquationBeanInfo.EquationTypeEditor.class);
            this.add("comment");
        }
    }

    public static class EquationWrapper
    implements DataElement {
        Equation equation;

        public EquationWrapper() {
            this.equation = new Equation(null, "x", "0");
        }

        public EquationWrapper(Equation equation) {
            this.equation = equation;
        }

        @PropertyName(value="Equation")
        public String getFormula() {
            return this.equation.getFormula();
        }

        public void setFormula(String formula) {
            this.equation.setFormula(formula);
        }

        public String getName() {
            return this.equation.getParent().getName();
        }

        public DataCollection<?> getOrigin() {
            return null;
        }

        @PropertyName(value="Variable")
        public String getVariable() {
            return this.equation.getVariable();
        }

        public void setVariable(String variable) {
            this.equation.setVariable(variable);
        }

        public boolean isAlgebraic() {
            return this.equation.isAlgebraic();
        }

        @PropertyName(value="Type")
        public String getType() {
            return this.equation.getType();
        }

        public void setType(String type) {
            this.equation.setType(type);
        }

        @PropertyName(value="Comment")
        public String getComment() {
            return this.equation.getComment();
        }

        public void setComment(String comment) {
            this.equation.setComment(comment);
        }
    }

    public static class UnitWrapperBeanInfo
    extends BeanInfoEx2<UnitWrapper> {
        public UnitWrapperBeanInfo() {
            super(UnitWrapper.class);
        }

        public void initProperties() throws Exception {
            this.property("name").htmlDisplayName("ID").add();
            this.property("title").htmlDisplayName("TI").add();
            this.property("comment").htmlDisplayName("CC").add();
            this.addReadOnly("formula");
        }
    }

    public static class UnitWrapper
    implements DataElement {
        Unit unit;

        public UnitWrapper() {
            this.unit = new Unit();
        }

        public UnitWrapper(Unit unit) {
            this.unit = unit;
        }

        public String getName() {
            return this.unit.getName();
        }

        public void setName(String name) {
            this.unit.setName(name);
        }

        @PropertyName(value="Title")
        @PropertyDescription(value="The object title (generally it is object brief name).")
        public String getTitle() {
            return this.unit.getTitle();
        }

        public void setTitle(String title) {
            this.unit.setTitle(title);
        }

        @PropertyName(value="Comment")
        public String getComment() {
            return this.unit.getComment();
        }

        public void setComment(String comment) {
            this.unit.setComment(comment);
        }

        @PropertyName(value="Formula")
        public String getFormula() {
            return this.unit.getFormula();
        }

        public void setFormula(String formula) {
        }

        public DataCollection<?> getOrigin() {
            return null;
        }
    }
}

