/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.util.DiagramXmlConstants;
import biouml.model.util.DiagramXmlSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.exception.LoggedClassNotFoundException;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;
import ru.biosoft.util.ColorUtils;
import ru.biosoft.util.TextUtil;
import ru.biosoft.util.XmlStream;
import ru.biosoft.util.XmlUtil;

public class XmlSerializationUtils
extends DiagramXmlConstants {
    protected static final Logger log = Logger.getLogger(XmlSerializationUtils.class.getName());
    private static Set<Class<?>> wrappers = new HashSet<Class>(Arrays.asList(Integer.class, Float.class, Double.class, Long.class, Short.class, Boolean.class, Byte.class, Character.class));
    @Deprecated
    private static final String NAME_ATTRIBUTE = "n";
    @Deprecated
    public static final String OBJECT_ELEMENT = "o";
    @Deprecated
    public static final String ARRAY_ELEMENT = "a";
    @Deprecated
    private static final String TYPE_ATTRIBUTE = "t";
    @Deprecated
    private static final String VALUE_ATTRIBUTE = "v";
    @Deprecated
    private static final Map<Class<?>, String> primitiveWrapperXmlElements = new HashMap();
    @Deprecated
    private static final String INTEGER_WRAPPER_PRIMITIVE_ELEMENT = "wi";
    @Deprecated
    private static final String FLOAT_WRAPPER_PRIMITIVE_ELEMENT = "wf";
    @Deprecated
    private static final String DOUBLE_WRAPPER_PRIMITIVE_ELEMENT = "wd";
    @Deprecated
    private static final String LONG_WRAPPER_PRIMITIVE_ELEMENT = "wl";
    @Deprecated
    private static final String SHORT_WRAPPER_PRIMITIVE_ELEMENT = "ws";
    @Deprecated
    private static final String BOOLEAN_WRAPPER_PRIMITIVE_ELEMENT = "wb";
    @Deprecated
    private static final String BYTE_WRAPPER_PRIMITIVE_ELEMENT = "wy";
    @Deprecated
    private static final String CHARACTER_WRAPPER_PRIMITIVE_ELEMENT = "wc";

    public static Object getPrimitiveValue(Class<?> type, String s) {
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return "".equals(s) ? 0 : Integer.parseInt(s);
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return "".equals(s) ? 0.0 : Double.parseDouble(s);
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return Float.valueOf("".equals(s) ? 0.0f : Float.parseFloat(s));
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return "".equals(s) ? 0L : Long.parseLong(s);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return "".equals(s) ? false : Boolean.parseBoolean(s);
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return "".equals(s) ? (short)0 : Short.parseShort(s);
        }
        if (Character.class.equals(type) || Character.TYPE.equals(type)) {
            return Character.valueOf("".equals(s) ? (char)'-' : s.charAt(0));
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return "".equals(s) ? null : Byte.valueOf(Byte.parseByte(s));
        }
        return null;
    }

    public static boolean isPrimitiveWrapperElement(Class<?> type) {
        return wrappers.contains(type);
    }

    @Deprecated
    public static Object deserialize(Element element) {
        if (!element.getNodeName().equals(OBJECT_ELEMENT) && !element.getNodeName().equals(ARRAY_ELEMENT)) {
            return null;
        }
        return XmlSerializationUtils.readObject(element);
    }

    @Deprecated
    private static Object readObject(Element element) {
        Field[] fields;
        String typeName = element.getAttribute(TYPE_ATTRIBUTE);
        Class clazz = null;
        try {
            clazz = Class.forName(typeName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            try {
                clazz = ClassLoading.loadClass((String)typeName);
            }
            catch (LoggedClassNotFoundException e1) {
                e1.log();
                return null;
            }
        }
        if (element.getNodeName().equals(ARRAY_ELEMENT)) {
            return XmlSerializationUtils.readArray(element, clazz);
        }
        Object result = XmlSerializationUtils.instantiate(clazz);
        if (result == null) {
            return null;
        }
        Element valueElement = DiagramXmlSupport.getElement(element, VALUE_ATTRIBUTE);
        for (Field field : fields = XmlSerializationUtils.getFields(clazz)) {
            String fieldValue;
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !field.getType().isPrimitive() && !field.getType().equals(String.class) && !field.getType().equals(DataElementPath.class) && !field.getType().equals(Color.class) || (fieldValue = valueElement.getAttribute(field.getName())) == null || fieldValue.length() <= 0) continue;
            XmlSerializationUtils.setFieldValue(result, field, fieldValue);
        }
        NodeList complexFieldsNodes = valueElement.getChildNodes();
        for (Element fieldElement : XmlUtil.elements((NodeList)complexFieldsNodes)) {
            Object fieldValue;
            if (fieldElement.getNodeName().equals(OBJECT_ELEMENT) || fieldElement.getNodeName().equals(ARRAY_ELEMENT)) {
                fieldValue = XmlSerializationUtils.readObject(fieldElement);
            } else {
                Class<?> fieldType = XmlSerializationUtils.getPrimitiveWrapperType(fieldElement.getNodeName());
                fieldValue = XmlSerializationUtils.getPrimitiveWrapperValue(fieldType, fieldElement.getAttribute(VALUE_ATTRIBUTE));
            }
            String fieldName = fieldElement.getAttribute(NAME_ATTRIBUTE);
            Field field = XmlSerializationUtils.getField(clazz, fieldName);
            if (field == null) {
                log.log(Level.SEVERE, "Could not find field named :" + fieldName + " for class :" + clazz.getCanonicalName());
                continue;
            }
            try {
                field.setAccessible(true);
                field.set(result, fieldValue);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Could not set field", t);
            }
        }
        return result;
    }

    @Deprecated
    private static Object readArray(Element element, Class<?> clazz) {
        ArrayList result = new ArrayList();
        Element valueElement = DiagramXmlSupport.getElement(element, VALUE_ATTRIBUTE);
        for (String value : XmlStream.attributes((Element)valueElement).filterKeys(name -> name.startsWith("val")).values()) {
            try {
                result.add(clazz.getComponentType().getConstructor(String.class).newInstance(value));
            }
            catch (Exception exception) {}
        }
        ((StreamEx)XmlStream.elements((Element)valueElement).map(XmlSerializationUtils::readObject).nonNull()).forEach(result::add);
        if (result.size() == 0) {
            return null;
        }
        return result.toArray((Object[])Array.newInstance(clazz.getComponentType(), result.size()));
    }

    @Deprecated
    private static void setFieldValue(Object o, Field field, String fieldValue) {
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        Class<?> fieldType = field.getType();
        try {
            if (fieldType.equals(String.class)) {
                field.set(o, fieldValue);
            } else if (fieldValue == null) {
                field.set(o, null);
            } else if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                field.set(o, Integer.valueOf(fieldValue));
            } else if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                field.set(o, Double.valueOf(fieldValue));
            } else if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                field.set(o, Boolean.valueOf(fieldValue));
            } else if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                field.set(o, Long.valueOf(fieldValue));
            } else if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
                field.set(o, Short.valueOf(fieldValue));
            } else if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
                field.set(o, Float.valueOf(fieldValue));
            } else if (fieldType.equals(DataElementPath.class)) {
                field.set(o, DataElementPath.create((String)fieldValue));
            } else if (fieldType.equals(Color.class)) {
                field.set(o, new Color(Integer.parseInt(fieldValue), true));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Could not set field", t);
        }
    }

    @Deprecated
    private static Object instantiate(Class<?> clazz) {
        Object result = null;
        try {
            result = clazz.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    @Deprecated
    private static Field getField(Class<?> clazz, String name) {
        List<Field> fields = XmlSerializationUtils.getClassFields(clazz);
        for (Field field : fields) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    @Deprecated
    private static Field[] getFields(Class<?> clazz) {
        List<Field> fields = XmlSerializationUtils.getClassFields(clazz);
        return fields.toArray(new Field[fields.size()]);
    }

    @Deprecated
    private static List<Field> getClassFields(Class<?> clazz) {
        if (!clazz.isArray() && !clazz.isPrimitive()) {
            List fieldsList = StreamEx.of((Object[])clazz.getDeclaredFields()).toList();
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                fieldsList.addAll(XmlSerializationUtils.getClassFields(superClass));
            }
            return fieldsList;
        }
        return new ArrayList<Field>();
    }

    @Deprecated
    private static Class<?> getPrimitiveWrapperType(String name) {
        return StreamEx.ofKeys(primitiveWrapperXmlElements, name::equals).findAny().orElse(null);
    }

    @Deprecated
    private static Object getPrimitiveWrapperValue(Class<?> type, String s) {
        if (Integer.class.equals(type)) {
            return Integer.valueOf(s);
        }
        if (Double.class.equals(type)) {
            return Double.valueOf(s);
        }
        if (Float.class.equals(type)) {
            return Float.valueOf(s);
        }
        if (Long.class.equals(type)) {
            return Long.valueOf(s);
        }
        if (Boolean.class.equals(type)) {
            return Boolean.valueOf(s);
        }
        if (Short.class.equals(type)) {
            return Short.valueOf(s);
        }
        if (Character.class.equals(type)) {
            return Character.valueOf(s.charAt(0));
        }
        if (Byte.class.equals(type)) {
            return Byte.valueOf(s);
        }
        return null;
    }

    public static String getBrushString(Brush brush) {
        if (brush == null) {
            return null;
        }
        return ColorUtils.paintToString((Paint)brush.getPaint());
    }

    public static Brush readBrush(String value) {
        String[] tokens = TextUtil.split((String)value, (char)';');
        if (tokens.length == 1) {
            return new Brush(ColorUtils.parsePaint((String)value));
        }
        if (tokens.length == 3) {
            return new Brush((Paint)new Color(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2])));
        }
        if (tokens.length == 6) {
            return new Brush(new Color(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2])), new Color(Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4]), Integer.parseInt(tokens[5])));
        }
        return null;
    }

    protected static void serializeBrush(Element element, Brush brush, boolean isRef) {
        String brushStr;
        if (!isRef) {
            element.setAttribute("type", "brush");
        }
        if ((brushStr = XmlSerializationUtils.getBrushString(brush)) != null) {
            element.setAttribute("value", brushStr);
        }
    }

    public static String getFontString(ColorFont font) {
        Font f = font.getFont();
        Color color = font.getColor();
        String string = f.getName() + ";" + f.getStyle() + ";" + f.getSize() + ";" + ColorUtils.colorToString((Color)color);
        return string;
    }

    @CheckForNull
    public static ColorFont readFont(String value) {
        StringTokenizer st = new StringTokenizer(value, ";");
        if (st.countTokens() == 6) {
            return new ColorFont(new Font(st.nextToken(), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())), new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())));
        }
        if (st.countTokens() == 4) {
            return new ColorFont(new Font(st.nextToken(), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())), ColorUtils.parseColor((String)st.nextToken()));
        }
        return null;
    }

    protected static void serializeFont(Element element, ColorFont font, boolean isRef) {
        if (!isRef) {
            element.setAttribute("type", "font");
        }
        if (font != null) {
            element.setAttribute("value", XmlSerializationUtils.getFontString(font));
        }
    }

    public static String getDimensionString(Dimension dimension) {
        return dimension.width + ";" + dimension.height;
    }

    public static Dimension readDimension(String value) {
        StringTokenizer st = new StringTokenizer(value, ";");
        return st.countTokens() == 2 ? new Dimension(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())) : null;
    }

    protected static void serializeDimension(Element element, Dimension dimension, boolean isRef) {
        if (!isRef) {
            element.setAttribute("type", "dimension");
        }
        if (dimension != null) {
            element.setAttribute("value", XmlSerializationUtils.getDimensionString(dimension));
        }
    }

    public static String getPenString(Pen pen) {
        Color color = pen.getColor();
        if (color == null) {
            return String.valueOf(pen.getWidth());
        }
        return pen.getWidth() + ";" + ColorUtils.colorToString((Color)color) + ";" + pen.getStrokeAsString();
    }

    @Nonnull
    public static Pen readPen(String value) {
        if (value.isEmpty()) {
            return new Pen();
        }
        String[] tokens = TextUtil.split((String)value, (char)';');
        Pen pen = new Pen(Float.parseFloat(tokens[0]));
        if (tokens.length > 1) {
            if (tokens.length >= 4) {
                if (tokens.length >= 5) {
                    pen.setColor(new Color(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4])));
                } else {
                    pen.setColor(new Color(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3])));
                }
            } else {
                pen.setColor(ColorUtils.parseColor((String)tokens[1]));
            }
        }
        if (tokens.length == 3) {
            pen.setStrokeAsString(tokens[2]);
        }
        return pen;
    }

    protected static void serializePen(Element element, Pen pen, boolean isRef) {
        if (!isRef) {
            element.setAttribute("type", "pen");
        }
        if (pen != null) {
            element.setAttribute("value", XmlSerializationUtils.getPenString(pen));
        }
    }

    public static String getPointString(Point point) {
        return point.x + ";" + point.y;
    }

    public static Point readPoint(String str) {
        Point point = new Point();
        if (str != null && str.length() > 0) {
            try {
                StringTokenizer tz = new StringTokenizer(str, "[] ,=xy;");
                if (!str.contains(";")) {
                    tz.nextToken();
                }
                int x = Integer.parseInt(tz.nextToken());
                int y = Integer.parseInt(tz.nextToken());
                point = new Point(x, y);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return point;
    }

    protected static void serializePoint(Element element, Point point, boolean isRef) {
        if (!isRef) {
            element.setAttribute("type", "point");
        }
        if (point != null) {
            element.setAttribute("value", XmlSerializationUtils.getPointString(point));
        }
    }

    static {
        primitiveWrapperXmlElements.put(Integer.class, INTEGER_WRAPPER_PRIMITIVE_ELEMENT);
        primitiveWrapperXmlElements.put(Float.class, FLOAT_WRAPPER_PRIMITIVE_ELEMENT);
        primitiveWrapperXmlElements.put(Double.class, DOUBLE_WRAPPER_PRIMITIVE_ELEMENT);
        primitiveWrapperXmlElements.put(Long.class, LONG_WRAPPER_PRIMITIVE_ELEMENT);
        primitiveWrapperXmlElements.put(Short.class, SHORT_WRAPPER_PRIMITIVE_ELEMENT);
        primitiveWrapperXmlElements.put(Boolean.class, BOOLEAN_WRAPPER_PRIMITIVE_ELEMENT);
        primitiveWrapperXmlElements.put(Character.class, CHARACTER_WRAPPER_PRIMITIVE_ELEMENT);
        primitiveWrapperXmlElements.put(Byte.class, BYTE_WRAPPER_PRIMITIVE_ELEMENT);
    }
}

