/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.util.BaseSupportWrapper;
import biouml.standard.type.BaseSupport;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.Entry;
import ru.biosoft.access.core.AbstractTransformer;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementReadException;
import ru.biosoft.access.core.MutableDataElementSupport;
import ru.biosoft.exception.LoggedClassNotFoundException;

public class UniversalXmlTransformer
extends AbstractTransformer<Entry, BaseSupport> {
    protected static final Logger log = Logger.getLogger(UniversalXmlTransformer.class.getName());
    protected String errorMessage;
    protected Class<? extends BaseSupport> outputType;

    public Class<Entry> getInputType() {
        return Entry.class;
    }

    public Class<? extends BaseSupport> getOutputType() {
        if (this.outputType == null) {
            Properties properties = this.getTransformedCollection().getInfo().getProperties();
            String name = properties.getProperty("data-element-class");
            if (name != null) {
                try {
                    String plugins = properties.getProperty("plugins");
                    this.outputType = ClassLoading.loadSubClass((String)name, (String)plugins, BaseSupport.class);
                }
                catch (LoggedClassNotFoundException e) {
                    throw new DataElementReadException((Throwable)e, (DataElement)this.getTransformedCollection(), (Object)"data-element-class");
                }
            } else {
                throw new DataElementReadException((DataElement)this.getTransformedCollection(), (Object)"data-element-class");
            }
        }
        return this.outputType;
    }

    public boolean isOutputType(Class<?> type) {
        return this.getOutputType().isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseSupport transformInput(Entry entry) throws Exception {
        BaseSupport de = null;
        ClassLoader oldClassLoader = null;
        try {
            try (ByteArrayInputStream is = new ByteArrayInputStream(entry.getData().getBytes(StandardCharsets.UTF_8));
                 XMLDecoder decoder = new XMLDecoder(is);){
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                String pluginNames = this.getTransformedCollection().getInfo().getProperties().getProperty("plugins");
                Thread.currentThread().setContextClassLoader(ClassLoading.getClassLoader((String)this.getOutputType().getName(), (String)pluginNames));
                decoder.setExceptionListener(e -> {
                    this.errorMessage = this.errorMessage + "\n" + e.getMessage();
                    e.printStackTrace();
                });
                BaseSupportWrapper bsw = (BaseSupportWrapper)decoder.readObject();
                bsw.restoreWrapped();
                de = bsw.getWrapped();
                de.setOrigin(this.getTransformedCollection());
            }
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        catch (Throwable throwable) {
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            throw throwable;
        }
        return de;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry transformOutput(BaseSupport de) throws Exception {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        ClassLoader oldClassLoader = null;
        try {
            try (BufferedOutputStream os = new BufferedOutputStream(bas);
                 XMLEncoder xmlEncoder = new XMLEncoder(os);){
                PropertyDescriptor[] props;
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                String pluginNames = this.getTransformedCollection().getInfo().getProperties().getProperty("plugins");
                Thread.currentThread().setContextClassLoader(ClassLoading.getClassLoader((String)this.getOutputType().getName(), (String)pluginNames));
                xmlEncoder.setOwner(this.getTransformedCollection());
                xmlEncoder.setPersistenceDelegate(de.getClass(), new PersistenceDelegate());
                BeanInfo beanInfo = Introspector.getBeanInfo(de.getClass());
                for (PropertyDescriptor pd : props = beanInfo.getPropertyDescriptors()) {
                    Class<?> propertyType = pd.getPropertyType();
                    if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
                    if (propertyType.isArray()) {
                        propertyType = propertyType.getComponentType();
                    }
                    if (propertyType.equals(DynamicPropertySet.class) || propertyType.equals(String.class) || propertyType.isPrimitive() || !xmlEncoder.getPersistenceDelegate(propertyType).getClass().equals(DefaultPersistenceDelegate.class)) continue;
                    xmlEncoder.setPersistenceDelegate(propertyType, new PersistenceDelegate());
                }
                this.errorMessage = "";
                xmlEncoder.setExceptionListener(e -> {
                    this.errorMessage = this.errorMessage + "\n" + e.getMessage();
                    e.printStackTrace();
                });
                BaseSupportWrapper bsw = new BaseSupportWrapper(de);
                xmlEncoder.writeObject(bsw);
                if (this.errorMessage.length() > 0) {
                    log.log(Level.SEVERE, this.errorMessage);
                }
            }
            if (oldClassLoader != null) {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
        catch (Throwable t) {
            try {
                log.log(Level.SEVERE, "transform to XML error", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (oldClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
        }
        return new Entry(this.getPrimaryCollection(), de.getName(), bas.toString("UTF-8"));
    }

    private static class PersistenceDelegate
    extends DefaultPersistenceDelegate {
        private PersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            if (oldInstance instanceof MutableDataElementSupport) {
                String name = "";
                try {
                    name = ((MutableDataElementSupport)oldInstance).getName();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{null, name});
            }
            return super.instantiate(oldInstance, out);
        }
    }
}

