/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Module;
import biouml.standard.type.DatabaseInfo;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Referrer;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.biohub.BioHub;
import ru.biosoft.access.biohub.Element;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;

public class ReferencesHandler {
    public static Stream<String> idsForDataElement(DataElement kernel, Map<String, DatabaseInfo> databaseInfoMap, BioHub bioHub) {
        Stream.Builder<String> builder = Stream.builder();
        if (kernel instanceof Referrer) {
            Element[] resultReferences;
            Element[] references = ReferencesHandler.convertToElements(((Referrer)kernel).getDatabaseReferences());
            Map results = null;
            if (null != bioHub) {
                results = bioHub.getReferences(references, null, null, 1, -1);
            }
            for (Element reference : references) {
                if (null != results && results.containsKey(reference)) {
                    resultReferences = (Element[])results.get(reference);
                    for (DatabaseReference resultReference : ReferencesHandler.convertToDatabaseReferences(resultReferences)) {
                        builder.add(resultReference.getAc());
                    }
                }
                builder.add(ReferencesHandler.convertToDatabaseReference(reference).getId());
            }
            if (null != databaseInfoMap && 0 < databaseInfoMap.size()) {
                if (null != bioHub) {
                    results = bioHub.getReferences(references, null, null, 1, -1);
                }
                if (null != results) {
                    for (Element reference : references) {
                        if (!results.containsKey(reference)) continue;
                        resultReferences = (Element[])results.get(reference);
                        for (DatabaseReference resultReference : ReferencesHandler.convertToDatabaseReferences(resultReferences)) {
                            builder.add(resultReference.getAc());
                        }
                    }
                }
            }
        }
        builder.add(kernel.getName());
        return builder.build();
    }

    public static void initDatabaseInfoMap(Module module, Map<String, DatabaseInfo> databaseInfoMap) throws Exception {
        DataCollection databaseInfo;
        databaseInfoMap.clear();
        DataCollection metadata = (DataCollection)module.get("Dictionaries");
        if (metadata != null && (databaseInfo = (DataCollection)metadata.get("database info")) != null) {
            for (DatabaseInfo dbInfo : databaseInfo) {
                databaseInfoMap.put(dbInfo.getTitle(), dbInfo);
            }
        }
    }

    @Nonnull
    public static Element[] convertToElements(DatabaseReference[] reference) {
        if (reference == null) {
            return new Element[0];
        }
        return (Element[])StreamEx.of((Object[])reference).map(DatabaseReference::convertToElement).toArray(Element[]::new);
    }

    public static DatabaseReference[] convertToDatabaseReferences(Element[] elements) {
        return (DatabaseReference[])((StreamEx)StreamEx.of((Object[])elements).map(ReferencesHandler::convertToDatabaseReference).nonNull()).toArray(DatabaseReference[]::new);
    }

    public static DatabaseReference convertToDatabaseReference(Element element) {
        try {
            return new DatabaseReference(element);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

