/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Node;
import biouml.standard.diagram.CreateReactionDialog;
import biouml.standard.diagram.ReactionPane;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.workbench.diagram.DiagramDocument;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.editors.CustomEditorSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.graphics.editor.ViewPane;
import ru.biosoft.gui.Document;

public class ReactionEditor
extends CustomEditorSupport {
    protected JPanel panel = new JPanel(new BorderLayout(3, 0));
    protected JButton editButton;
    protected ReactionPane editorPane = null;
    protected ViewEditorPane viewEditor;
    private static final String HEADER = "Edit Reaction";

    public ReactionEditor() {
        this.panel.setOpaque(false);
        this.editButton = new JButton(HEADER);
        this.panel.add((Component)this.editButton, "East");
        this.editButton.addActionListener(e -> this.editButtonAction());
    }

    public void editButtonAction() {
        try {
            this.init();
            new CreateReactionDialog((JFrame)Application.getApplicationFrame(), this.editorPane, HEADER);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected Node findNode(Compartment comp, Base kernel) {
        return comp.recursiveStream().select(Compartment.class).flatMap(c -> c.getKernelNodes(kernel)).findAny().orElse(null);
    }

    public Component getCustomRenderer(Component parent, boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    public Component getCustomEditor(Component parent, boolean isSelected) {
        return this.getCustomRenderer(parent, isSelected, true);
    }

    private void init() {
        Object bean;
        Document document = Document.getCurrentDocument();
        Diagram diagram = null;
        if (document instanceof DiagramDocument) {
            diagram = ((DiagramDocument)document).getDiagram();
            ViewPane vp = ((DiagramDocument)document).getDiagramViewPane();
            if (vp instanceof ViewEditorPane) {
                this.viewEditor = (ViewEditorPane)vp;
            }
        }
        if (!((bean = this.getBean()) instanceof Node) || !(((Node)((Object)bean)).getKernel() instanceof Reaction)) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Unsupported object type", "Editor unavailable", 0);
            return;
        }
        if (diagram == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Opened diagran document is necessary for reaction editor", "Editor unavailable", 0);
            return;
        }
        Node reactionNode = (Node)((Object)bean);
        Reaction reaction = (Reaction)reactionNode.getKernel();
        this.editorPane = new ReactionPane(reaction, diagram, reactionNode.getCompartment(), reactionNode.getLocation(), this.viewEditor);
    }
}

