/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Module;
import biouml.model.ProtectedModule;
import biouml.model.util.MessageBundle;
import biouml.model.util.ModuleActivator;
import com.developmentontheedge.application.ApplicationUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JDialog;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.CreateDataCollectionController;
import ru.biosoft.access.LocalRepository;
import ru.biosoft.access.Repository;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.jobcontrol.FunctionJobControl;
import ru.biosoft.util.ExProperties;

public class ModulePackager {
    public static final String MF_DATABASE_NAME = "Module-Name";
    public static final String MF_DATABASE_VERSION = "Module-Version";
    public static final String MF_DATABASE_DESCRIPTION = "Module-Description";
    public static final String MF_DATABASE_ACTIVATOR_CLASS = "Module-Activator-Class";
    public static final String MF_DATABASE_TYPE_CLASS = "Module-Type-Class";
    public static final String MF_DATABASE_PARENT = "Module-Parent-Name";
    public static final String BMD_FILE_EXTENTION = ".bmd";
    public static final String INFO_FILENAME = "info";
    public static final String LICENSE_FILENAME = "license";
    private static final String MANIFEST_DIR = "META-INF/";
    private static final String MANIFEST_FILE = "META-INF/manifest.mf";
    protected static final Logger log = Logger.getLogger(ModulePackager.class.getName());
    protected static final MessageBundle messageBundle = new MessageBundle();
    static Module module = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void exportModule(DataCollection module, String moduleName, String moduleVersion, String moduleDescription, String filename, FunctionJobControl jobControl, Set<String> excludedNames) {
        block33: {
            String nextConfig;
            File moduleDir;
            ZipOutputStream jarOutputStream;
            block32: {
                File outputFile;
                if (excludedNames == null) {
                    excludedNames = new HashSet<String>();
                }
                excludedNames.add("CVS");
                excludedNames.add(INFO_FILENAME);
                String exportModuleMessage = MessageFormat.format(messageBundle.getResourceString("EXPORT_DATABASE_MESSAGE"), module.getName(), filename);
                log.info(exportModuleMessage);
                if (jobControl != null) {
                    jobControl.functionStarted();
                }
                jarOutputStream = null;
                DataElementPath oldPath = DataElementPath.create((DataElement)module);
                moduleDir = ModulePackager.getModuleDir(module.getCompletePath());
                nextConfig = null;
                Manifest manifest = ModulePackager.getModuleManifest(module.getCompletePath());
                Attributes attr = null;
                if (manifest != null) {
                    attr = manifest.getMainAttributes();
                    attr.remove(MF_DATABASE_ACTIVATOR_CLASS);
                } else {
                    manifest = new Manifest();
                    attr = manifest.getMainAttributes();
                    attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                }
                attr.putValue(MF_DATABASE_NAME, moduleName);
                attr.putValue(MF_DATABASE_VERSION, moduleVersion);
                attr.putValue(MF_DATABASE_DESCRIPTION, moduleDescription);
                attr.putValue(MF_DATABASE_PARENT, oldPath.getParentPath().toString());
                if (module instanceof Module) {
                    attr.putValue(MF_DATABASE_TYPE_CLASS, ((Module)module).getType().getClass().getName());
                }
                if (!(outputFile = new File(filename)).getName().toLowerCase().endsWith(BMD_FILE_EXTENTION)) {
                    outputFile = new File(outputFile.getPath() + BMD_FILE_EXTENTION);
                }
                FileOutputStream out = new FileOutputStream(outputFile);
                jarOutputStream = new JarOutputStream((OutputStream)out, manifest);
                jarOutputStream.setMethod(8);
                File configFile = new File(moduleDir, "default.config");
                ExProperties properties = new ExProperties(configFile);
                nextConfig = properties.getProperty("nextConfig");
                if (nextConfig != null && !module.getName().equals(moduleName)) {
                    ModulePackager.setProperty(moduleDir, nextConfig, "name", moduleName);
                }
                if (!module.getName().equals(moduleName)) {
                    ModulePackager.setProperty(moduleDir, "default.config", "name", moduleName);
                    File defaultRepository = new File(moduleDir, "default.repository");
                    if (defaultRepository.exists()) {
                        ModulePackager.setProperty(moduleDir, "default.repository", "name", moduleName);
                    }
                }
                int excludedPrefixPathSize = moduleDir.getPath().length() + 1;
                List<File> files = ModulePackager.getFiles(moduleDir, excludedNames);
                int count = 0;
                for (File file : files) {
                    String fileStr = MessageFormat.format(messageBundle.getResourceString("ADDING_FILE"), file.getName());
                    log.info(fileStr);
                    ModulePackager.addToJar((JarOutputStream)jarOutputStream, excludedPrefixPathSize, file);
                    ++count;
                    if (jobControl == null) continue;
                    jobControl.setPreparedness(100 * count / files.size());
                }
                String message = messageBundle.getResourceString("DATABASE_EXPORTED_SUCCESSFULLY");
                log.info(message);
                if (jobControl == null) break block32;
                jobControl.functionFinished(message);
            }
            try {
                if (jarOutputStream != null) {
                    jarOutputStream.close();
                }
                if (!module.getName().equals(moduleName)) {
                    ModulePackager.setProperty(moduleDir, "default.config", "name", module.getName());
                    File defaultRepository = new File(moduleDir, "default.repository");
                    if (defaultRepository.exists()) {
                        ModulePackager.setProperty(moduleDir, "default.repository", "name", module.getName());
                    }
                    if (nextConfig != null) {
                        ModulePackager.setProperty(moduleDir, nextConfig, "name", module.getName());
                    }
                }
                break block33;
            }
            catch (IOException e) {
                String message = MessageFormat.format(messageBundle.getResourceString("DATABASE_EXPORT_ERROR"), e.getMessage(), module.getName());
                log.log(Level.SEVERE, message, e);
            }
            break block33;
            catch (Throwable t) {
                String message;
                block34: {
                    try {
                        message = MessageFormat.format(messageBundle.getResourceString("DATABASE_EXPORT_ERROR"), t.getMessage(), module.getName());
                        log.log(Level.SEVERE, message, t);
                        if (jobControl == null) break block34;
                        jobControl.functionTerminatedByError(t);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (jarOutputStream != null) {
                                jarOutputStream.close();
                            }
                            if (!module.getName().equals(moduleName)) {
                                ModulePackager.setProperty(moduleDir, "default.config", "name", module.getName());
                                File defaultRepository = new File(moduleDir, "default.repository");
                                if (defaultRepository.exists()) {
                                    ModulePackager.setProperty(moduleDir, "default.repository", "name", module.getName());
                                }
                                if (nextConfig != null) {
                                    ModulePackager.setProperty(moduleDir, nextConfig, "name", module.getName());
                                }
                            }
                        }
                        catch (IOException e) {
                            String message2 = MessageFormat.format(messageBundle.getResourceString("DATABASE_EXPORT_ERROR"), e.getMessage(), module.getName());
                            log.log(Level.SEVERE, message2, e);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (jarOutputStream != null) {
                        jarOutputStream.close();
                    }
                    if (!module.getName().equals(moduleName)) {
                        ModulePackager.setProperty(moduleDir, "default.config", "name", module.getName());
                        File defaultRepository = new File(moduleDir, "default.repository");
                        if (defaultRepository.exists()) {
                            ModulePackager.setProperty(moduleDir, "default.repository", "name", module.getName());
                        }
                        if (nextConfig != null) {
                            ModulePackager.setProperty(moduleDir, nextConfig, "name", module.getName());
                        }
                    }
                }
                catch (IOException e) {
                    message = MessageFormat.format(messageBundle.getResourceString("DATABASE_EXPORT_ERROR"), e.getMessage(), module.getName());
                    log.log(Level.SEVERE, message, e);
                }
            }
        }
    }

    public static void setProperty(File moduleDir, String filename, String key, String value) throws IOException {
        File file = new File(moduleDir, filename);
        ExProperties properties = new ExProperties(file);
        properties.setProperty(key, value);
        ExProperties.store((Properties)properties, (File)file);
    }

    public static void importModule(JDialog parentWindow, JarFile moduleFile, Repository repository, CreateDataCollectionController controller) throws Exception {
        FunctionJobControl jobControl = null;
        if (controller != null) {
            jobControl = controller.getJobControl();
        }
        ModulePackager.importModule(parentWindow, moduleFile, repository, controller, jobControl);
    }

    public static void importModule(JDialog parentWindow, JarFile moduleFile, Repository repository, CreateDataCollectionController controller, FunctionJobControl jobControl) throws Exception {
        String importingModuleFromMessage = MessageFormat.format(messageBundle.getResourceString("IMPORTING_DATABASE_FROM"), moduleFile.getName());
        log.info(importingModuleFromMessage);
        if (jobControl != null) {
            jobControl.functionStarted();
        }
        try {
            File moduleInfoFile;
            Serializable file;
            String moduleName = ModulePackager.getModuleAttribute(moduleFile, MF_DATABASE_NAME);
            File moduleDir = ModulePackager.getModuleDir(DataElementPath.create((String)ModulePackager.getModuleAttribute(moduleFile, MF_DATABASE_PARENT)), moduleName);
            if (repository.contains(moduleName)) {
                String message = MessageFormat.format(messageBundle.getResourceString("MESSAGE_DATABASE_EXIST"), moduleName);
                log.info(message);
                if (controller == null) {
                    throw new IOException(message + " Controller is null.");
                }
                int response = controller.fileAlreadyExists(moduleDir);
                if (response == 0) {
                    message = messageBundle.getResourceString("DATABASE_IMPORT_CANCELED");
                    log.info(message);
                    if (jobControl != null) {
                        jobControl.functionFinished(message);
                    }
                    return;
                }
                if (response != 3 && response != 2) {
                    throw new IllegalArgumentException("Old files can not be replaced by new in module " + moduleName);
                }
                CollectionFactoryUtils.getDatabases().remove(moduleName);
                log.info(messageBundle.getResourceString("OLD_DATABASE_VERSION_REMOVED"));
            }
            if (!moduleDir.exists()) {
                moduleDir.mkdir();
            }
            Enumeration<JarEntry> entries = moduleFile.entries();
            while (entries.hasMoreElements()) {
                String dirName;
                File dir;
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.isDirectory() || (dir = new File(moduleDir, dirName = jarEntry.getName())).exists() || dirName.equalsIgnoreCase(MANIFEST_DIR)) continue;
                String message = MessageFormat.format(messageBundle.getResourceString("CREATING_ITEM"), dir.getName());
                log.info(message);
                dir.mkdirs();
            }
            int count = 0;
            StringBuilder classpath = new StringBuilder();
            entries = moduleFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (!jarEntry.isDirectory() && !entryName.equalsIgnoreCase(MANIFEST_FILE)) {
                    String message = MessageFormat.format(messageBundle.getResourceString("EXTRACTING_ITEM"), entryName);
                    log.info(message);
                    file = ModulePackager.extractFile(moduleDir, entryName, moduleFile, jarEntry);
                    if (((File)file).getName().endsWith(".jar")) {
                        if (classpath.length() > 0) {
                            classpath.append(File.pathSeparator);
                        }
                        classpath.append(((File)file).getPath());
                    }
                }
                ++count;
                if (jobControl == null) continue;
                jobControl.setPreparedness(100 * count / moduleFile.size());
            }
            Manifest manifest = moduleFile.getManifest();
            if (manifest != null && !(moduleInfoFile = new File(moduleDir, INFO_FILENAME)).exists()) {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(moduleInfoFile));
                file = null;
                try {
                    manifest.write(out);
                }
                catch (Throwable throwable) {
                    file = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (file != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)file).addSuppressed(throwable);
                            }
                        } else {
                            ((OutputStream)out).close();
                        }
                    }
                }
            }
            String moduleActivatorClassName = ModulePackager.getModuleAttribute(moduleFile, MF_DATABASE_ACTIVATOR_CLASS);
            ModuleActivator moduleActivator = null;
            int whenCreateDataCollection = 1;
            if (moduleActivatorClassName != null) {
                moduleActivator = (ModuleActivator)ClassLoading.loadSubClass((String)moduleActivatorClassName, ModuleActivator.class).newInstance();
                whenCreateDataCollection = moduleActivator.whenCreateDataCollection();
            }
            if (moduleActivator != null && whenCreateDataCollection == 2) {
                ModulePackager.activateModule(parentWindow, moduleActivator, repository, moduleFile, classpath.toString(), controller);
            }
            if (moduleActivator == null || whenCreateDataCollection != 3) {
                File defaultConfig = new File(moduleDir, "default.config");
                ExProperties properties = new ExProperties(defaultConfig);
                String nextConfig = properties.getProperty("nextConfig");
                if (nextConfig != null) {
                    String className = properties.getProperty("class");
                    if (ProtectedModule.class.getName().equals(className)) {
                        File nextConfigFile = new File(moduleDir, nextConfig);
                        properties = new ExProperties(nextConfigFile);
                        nextConfigFile.delete();
                    }
                }
                CollectionFactoryUtils.createSubDirCollection((Repository)repository, (String)moduleName, (Properties)properties);
            }
            if (moduleActivator != null && whenCreateDataCollection != 2) {
                ModulePackager.activateModule(parentWindow, moduleActivator, repository, moduleFile, classpath.toString(), controller);
            }
            String message = messageBundle.getResourceString("DATABASE_IMPORTED_SUCCESSFULLY");
            log.info(message);
            if (jobControl != null) {
                jobControl.functionFinished(message);
            }
        }
        catch (Exception t) {
            if (jobControl != null) {
                jobControl.functionTerminatedByError((Throwable)t);
            }
            throw t;
        }
    }

    private static void activateModule(JDialog parentWindow, ModuleActivator moduleActivator, Repository repository, JarFile moduleFile, String classpath, CreateDataCollectionController controller) throws Exception {
        module = moduleActivator.createModule(parentWindow, repository, moduleFile, classpath, log, controller);
    }

    public static File getModuleDir(DataElementPath modulePath) {
        File moduleDir = null;
        DataCollection module = modulePath.optDataCollection();
        if (module != null) {
            if (module instanceof Module) {
                moduleDir = ((Module)module).getPath();
            } else if (module instanceof LocalRepository) {
                moduleDir = ((LocalRepository)module).getRootDirectory();
            }
        } else {
            moduleDir = ModulePackager.getModuleDir(modulePath.getParentPath(), modulePath.getName());
        }
        return moduleDir;
    }

    public static File getModuleDir(DataElementPath parentPath, String moduleName) {
        LocalRepository parent = (LocalRepository)parentPath.optDataElement(LocalRepository.class);
        if (parent != null) {
            File root = parent.getRootDirectory();
            return new File(root, moduleName);
        }
        File rootModulesDir = ((LocalRepository)CollectionFactoryUtils.getDatabases()).getRootDirectory();
        if (!rootModulesDir.exists()) {
            rootModulesDir.mkdir();
        }
        return new File(rootModulesDir, moduleName);
    }

    public static Manifest getModuleManifest(DataElementPath modulePath) {
        Manifest manifest = null;
        File moduleDir = ModulePackager.getModuleDir(modulePath);
        File infoFile = new File(moduleDir, INFO_FILENAME);
        if (infoFile.exists() && infoFile.isFile()) {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(infoFile));){
                manifest = new Manifest(in);
            }
            catch (Throwable t) {
                String message = MessageFormat.format(messageBundle.getResourceString("CANNOT_GET_MANIFEST"), modulePath);
                log.log(Level.SEVERE, message, t);
            }
        }
        return manifest;
    }

    public static List<File> getFiles(File dir, Set<String> excludedNames) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (excludedNames != null && excludedNames.contains(file.getName())) continue;
                list.add(file);
                if (!file.isDirectory()) continue;
                list.addAll(ModulePackager.getFiles(file, excludedNames));
            }
        }
        return list;
    }

    public static void addToJar(JarOutputStream jarOutputStream, int excludedPrefixPathSize, File file) throws IOException {
        String fileName = file.getPath();
        if (file.isDirectory()) {
            fileName = fileName + "/";
        }
        String zipEnrtyName = fileName.substring(excludedPrefixPathSize);
        ZipEntry zipentry = new ZipEntry(zipEnrtyName);
        zipentry.setSize(file.length());
        zipentry.setTime(file.lastModified());
        jarOutputStream.putNextEntry(zipentry);
        if (file.isFile()) {
            int n;
            byte[] rgb = new byte[1000];
            CRC32 crc32 = new CRC32();
            try (FileInputStream fileinputstream = new FileInputStream(file);){
                while ((n = fileinputstream.read(rgb)) > -1) {
                    crc32.update(rgb, 0, n);
                }
            }
            zipentry.setCrc(crc32.getValue());
            fileinputstream = new FileInputStream(file);
            var10_9 = null;
            try {
                while ((n = fileinputstream.read(rgb)) > -1) {
                    jarOutputStream.write(rgb, 0, n);
                }
            }
            catch (Throwable throwable) {
                var10_9 = throwable;
                throw throwable;
            }
            finally {
                if (fileinputstream != null) {
                    if (var10_9 != null) {
                        try {
                            fileinputstream.close();
                        }
                        catch (Throwable throwable) {
                            var10_9.addSuppressed(throwable);
                        }
                    } else {
                        fileinputstream.close();
                    }
                }
            }
        }
        jarOutputStream.closeEntry();
    }

    public static File extractFile(File dstDir, String fileName, JarFile moduleFile, JarEntry jarEntry) throws IOException {
        fileName = fileName.replace('\\', '/');
        File file = new File(dstDir, fileName);
        ApplicationUtils.copyStream((OutputStream)new FileOutputStream(file), (InputStream)moduleFile.getInputStream(jarEntry));
        return file;
    }

    public static String getModuleAttribute(JarFile jarFile, String attribute) {
        String moduleAttribute = null;
        try {
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                moduleAttribute = attributes.getValue(attribute);
            }
        }
        catch (Throwable t) {
            String message = MessageFormat.format(messageBundle.getResourceString("CANNOT_GET_MANIFEST_ATTRIBUTE"), attribute);
            log.log(Level.SEVERE, message, t);
        }
        return moduleAttribute;
    }
}

