/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.SimpleTableElement;
import biouml.model.dynamics.State;
import biouml.model.dynamics.TableElement;
import biouml.model.dynamics.Transition;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.util.DiagramXmlSupport;
import biouml.standard.diagram.PathwaySimulationDiagramType;
import biouml.standard.type.BaseUnit;
import biouml.standard.type.Unit;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import one.util.streamex.StreamEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;

public class ModelXmlWriter
extends DiagramXmlSupport {
    protected Document doc;
    protected Map<String, String> newPaths = new HashMap<String, String>();

    public void setNewPaths(Map<String, String> newPaths) {
        this.newPaths = newPaths;
    }

    public Element createModel(Diagram diagram, Document document) {
        this.doc = document;
        this.diagram = diagram;
        Element element = null;
        Role role = null;
        if (diagram != null && (role = diagram.getRole()) == null && diagram.getType() instanceof PathwaySimulationDiagramType) {
            try {
                role = new EModel(diagram);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Cannot create new model", t);
            }
        }
        if (role instanceof EModel) {
            EModel model = (EModel)role;
            element = this.doc.createElement("executableModel");
            element.setAttribute("class", role.getClass().getName());
            for (Variable var : model.getParameters()) {
                if (var.getName().equals("time")) continue;
                element.appendChild(this.createParameter(var));
            }
            for (Variable var : model.getVariableRoles()) {
                element.appendChild(this.createVariable((VariableRole)var));
            }
            this.createEquationList(element, diagram);
            this.createFunctionList(element, diagram);
            this.createEventList(element, diagram);
            this.createStateList(element, diagram);
            this.createTransitionList(element, diagram);
            this.createTableList(element, diagram);
            this.createSimpleTableList(element, diagram);
            this.createUnitList(element, diagram);
            ModelXmlWriter.setComment(element, model.getComment());
            Variable timeVar = model.getVariable("time");
            if (!timeVar.getUnits().isEmpty()) {
                element.setAttribute("timeUnits", timeVar.getUnits());
            }
        }
        return element;
    }

    private Element createParameter(Variable parameter) {
        Element element = this.doc.createElement("parameter");
        element.setAttribute("name", ModelXmlWriter.validate(parameter.getName()));
        element.setAttribute("title", ModelXmlWriter.validate(parameter.getTitle()));
        element.setAttribute("value", Double.toString(parameter.getInitialValue()));
        if (parameter.isConstant()) {
            element.setAttribute("constant", Boolean.toString(parameter.isConstant()));
        }
        ModelXmlWriter.setOptionalAttribute(element, "units", parameter.getUnits());
        ModelXmlWriter.setComment(element, parameter.getComment());
        DynamicPropertySet dps = parameter.getAttributes();
        if (!dps.isEmpty()) {
            ModelXmlWriter.serializeDPS(this.doc, element, dps, null, false);
        }
        return element;
    }

    private Element createVariable(VariableRole variable) {
        Element element = this.doc.createElement("variable");
        this.writeDiagramElement(element, variable.getAssociatedElements());
        element.setAttribute("initialValue", Double.toString(variable.getInitialValue()));
        ModelXmlWriter.setOptionalAttribute(element, "units", variable.getUnits());
        if (variable.isBoundaryCondition()) {
            element.setAttribute("boundaryCondition", "true");
        }
        if (variable.isConstant()) {
            element.setAttribute("constant", "true");
        }
        ModelXmlWriter.setComment(element, variable.getComment());
        return element;
    }

    private void createFunctionList(Element node, Diagram diagram) {
        diagram.recursiveStream().map(de -> de.getRole()).select(Function.class).forEach(function -> node.appendChild(this.createFunction((Function)function)));
    }

    private void createEquationList(Element node, Diagram diagram) {
        diagram.recursiveStream().map(de -> de.getRole()).select(Equation.class).forEach(equation -> node.appendChild(this.createEquation((Equation)equation)));
    }

    private void createSimpleTableList(Element node, Diagram diagram) {
        diagram.recursiveStream().map(de -> de.getRole()).select(SimpleTableElement.class).forEach(table -> node.appendChild(this.createSimpleTableElement((SimpleTableElement)table)));
    }

    private void createTableList(Element node, Diagram diagram) {
        diagram.recursiveStream().map(de -> de.getRole()).select(TableElement.class).forEach(table -> node.appendChild(this.createTableElement((TableElement)table)));
    }

    private void createEventList(Element element, Diagram diagram) {
        diagram.recursiveStream().map(de -> de.getRole()).select(Event.class).forEach(event -> element.appendChild(this.createEvent((Event)event, diagram)));
    }

    private void createStateList(Element element, Diagram diagram) {
        diagram.recursiveStream().map(de -> de.getRole()).select(State.class).forEach(state -> element.appendChild(this.createState((State)state)));
    }

    private void createTransitionList(Element element, Diagram diagram) {
        diagram.recursiveStream().map(de -> de.getRole()).select(Transition.class).forEach(transition -> element.appendChild(this.createTransition((Transition)transition)));
    }

    private void createUnitList(Element element, Diagram diagram) {
        for (Unit unit : diagram.getRole(EModel.class).getUnits().values()) {
            element.appendChild(this.createUnit(unit));
        }
    }

    private Element createState(State state) {
        Assignment[] assign;
        Element element = this.doc.createElement("state");
        this.writeDiagramElement(element, state.getDiagramElement());
        if (state.isStart()) {
            element.setAttribute("start", Boolean.TRUE.toString());
        }
        Element entryElement = this.doc.createElement("entry");
        for (Assignment element2 : assign = state.getOnEntryAssignment()) {
            Element assignElement = this.doc.createElement("assignment");
            String variable = ModelXmlWriter.validate(element2.getVariable());
            assignElement.setAttribute("variable", variable);
            String math = ModelXmlWriter.validate(element2.getMath());
            assignElement.setAttribute("formula", math);
            entryElement.appendChild(assignElement);
        }
        element.appendChild(entryElement);
        Element exitElement = this.doc.createElement("exit");
        for (Assignment element2 : assign = state.getOnExitAssignment()) {
            Element assignElement = this.doc.createElement("assignment");
            String variable = ModelXmlWriter.validate(element2.getVariable());
            assignElement.setAttribute("variable", variable);
            String math = ModelXmlWriter.validate(element2.getMath());
            assignElement.setAttribute("formula", math);
            exitElement.appendChild(assignElement);
        }
        element.appendChild(exitElement);
        return element;
    }

    private Element createTransition(Transition transition) {
        Assignment[] assign;
        Element element = this.doc.createElement("transition");
        this.writeDiagramElement(element, transition.getDiagramElement());
        String when = transition.getWhen();
        String after = transition.getAfter();
        if (after != null && after.length() > 0) {
            Element afterElement = this.doc.createElement("after");
            afterElement.setAttribute("after", after);
            element.appendChild(afterElement);
        } else if (when != null && when.length() > 0) {
            Element whenElement = this.doc.createElement("when");
            whenElement.setAttribute("trigger", when);
            element.appendChild(whenElement);
        }
        for (Assignment element2 : assign = transition.getAssignments()) {
            Element assignElement = this.doc.createElement("assignment");
            assignElement.setAttribute("variable", element2.getVariable());
            assignElement.setAttribute("formula", element2.getMath());
            element.appendChild(assignElement);
        }
        return element;
    }

    private Element createFunction(Function function) {
        Element element = this.doc.createElement("function");
        this.writeDiagramElement(element, function.getDiagramElement());
        String formula = function.getFormula();
        if (formula == null || formula.isEmpty()) {
            formula = "";
            ModelXmlWriter.warn("WARN_EQUATION_FORMULA_ABSENTS", new String[]{this.diagram.getName(), function.getDiagramElement().getName()});
        }
        element.setAttribute("formula", formula);
        return element;
    }

    private Element createSimpleTableElement(SimpleTableElement table) {
        Element element = this.doc.createElement("table");
        String path = table.getTablePath().toString();
        if (this.newPaths.containsKey(path)) {
            path = this.newPaths.get(path);
        }
        this.writeDiagramElement(element, table.getDiagramElement());
        element.setAttribute("tablePath", path);
        Element argColumnElement = this.doc.createElement("argColumn");
        argColumnElement.setAttribute("variable", table.getArgColumn().getVariable());
        argColumnElement.setAttribute("column", table.getArgColumn().getColumn());
        for (int i = 0; i < table.getColumns().length; ++i) {
            Element varColumnElement = this.doc.createElement("varColumn");
            varColumnElement.setAttribute("variable", table.getColumns()[i].getVariable());
            varColumnElement.setAttribute("column", table.getColumns()[i].getColumn());
            element.appendChild(varColumnElement);
        }
        element.appendChild(argColumnElement);
        return element;
    }

    private Element createTableElement(TableElement table) {
        Element element = this.doc.createElement("tableElement");
        this.writeDiagramElement(element, table.getDiagramElement());
        if (table.getVariables() != null) {
            for (TableElement.Variable var : table.getVariables()) {
                Element varElement = this.doc.createElement("variable");
                varElement.setAttribute("column", var.getColumnName());
                varElement.setAttribute("name", var.getName());
                element.appendChild(varElement);
            }
        } else {
            ModelXmlWriter.warn("ERROR_TABLE_VARIABLE_ABSENTS", new String[]{this.diagram.getName(), table.getDiagramElement().getName()});
        }
        if (table.getTablePath() != null) {
            element.setAttribute("tableDataCollection", table.getTablePath().toString());
        }
        if (table.getFormula() != null && !table.getFormula().isEmpty()) {
            element.setAttribute("formula", table.getFormula());
        } else {
            ModelXmlWriter.warn("ERROR_TABLE_DATA_ABSENTS", new String[]{this.diagram.getName(), table.getDiagramElement().getName()});
        }
        if (table.isCycled()) {
            element.setAttribute("cycled", String.valueOf(table.isCycled()));
        }
        return element;
    }

    private Element createEquation(Equation equation) {
        String formula;
        Element element = this.doc.createElement("equation");
        this.writeDiagramElement(element, equation.getDiagramElement());
        if (equation.getVariable() != null) {
            element.setAttribute("variable", equation.getVariable());
        }
        if ((formula = equation.getFormula()) == null || formula.length() == 0) {
            formula = "";
            ModelXmlWriter.warn("WARN_EQUATION_FORMULA_ABSENTS", new String[]{this.diagram.getName(), equation.getDiagramElement().getName()});
        }
        element.setAttribute("formula", formula);
        if (!"rate".equals(equation.getType())) {
            element.setAttribute("type", equation.getType());
        }
        ModelXmlWriter.setOptionalAttribute(element, "units", equation.getUnits());
        ModelXmlWriter.setComment(element, equation.getComment());
        return element;
    }

    private Element createEvent(Event event, Diagram diagram) {
        Element element = this.doc.createElement("event");
        Assignment[] actions = event.getEventAssignment();
        this.writeDiagramElement(element, event.getDiagramElement());
        element.setAttribute("trigger", event.getTrigger());
        if (!event.isTriggerInitialValue()) {
            element.setAttribute("initialValue", String.valueOf(event.isTriggerInitialValue()));
        }
        if (!event.isTriggerPersistent()) {
            element.setAttribute("persistent", String.valueOf(event.isTriggerPersistent()));
        }
        if (!event.isUseValuesFromTriggerTime()) {
            element.setAttribute("useValeusFromTriggerTime", String.valueOf(event.isUseValuesFromTriggerTime()));
        }
        ModelXmlWriter.setOptionalAttribute(element, "delay", event.getDelay());
        ModelXmlWriter.setOptionalAttribute(element, "priority", event.getPriority());
        ModelXmlWriter.setComment(element, event.getComment());
        for (Assignment action : actions) {
            element.appendChild(this.createAssignment(action, diagram));
        }
        return element;
    }

    private Element createAssignment(Assignment action, Diagram diagram) {
        Element element = this.doc.createElement("assignment");
        element.setAttribute("variable", ModelXmlWriter.validate(action.getVariable()));
        element.setAttribute("formula", ModelXmlWriter.validate(action.getMath()));
        return element;
    }

    private Element createUnit(Unit unit) {
        Element element = this.doc.createElement("unitDefinition");
        String name = unit.getName();
        String title = unit.getTitle();
        BaseUnit[] baseUnits = unit.getBaseUnits();
        element.setAttribute("name", name);
        element.setAttribute("title", title);
        for (BaseUnit baseUnit : baseUnits) {
            Element baseElement = this.doc.createElement("baseUnit");
            baseElement.setAttribute("type", String.valueOf(baseUnit.getType()));
            baseElement.setAttribute("multiplier", String.valueOf(baseUnit.getMultiplier()));
            baseElement.setAttribute("scale", String.valueOf(baseUnit.getScale()));
            baseElement.setAttribute("exponent", String.valueOf(baseUnit.getExponent()));
            element.appendChild(baseElement);
        }
        return element;
    }

    protected void writeDiagramElement(Element element, DiagramElement de) {
        String name = CollectionFactory.getRelativeName((DataElement)de, (DataCollection)this.diagram);
        element.setAttribute("diagramElement", ModelXmlWriter.validate(name));
    }

    private void writeDiagramElement(Element element, DiagramElement[] des) {
        String diagramElement = StreamEx.of((Object[])des).map(de -> CollectionFactory.getRelativeName((DataElement)de, (DataCollection)this.diagram)).map(DiagramXmlSupport::validate).joining((CharSequence)";");
        element.setAttribute("diagramElement", diagramElement);
    }
}

