/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.SimpleTableElement;
import biouml.model.dynamics.State;
import biouml.model.dynamics.TableElement;
import biouml.model.dynamics.Transition;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.util.DiagramXmlReader;
import biouml.model.util.DiagramXmlSupport;
import biouml.standard.type.BaseUnit;
import biouml.standard.type.Reaction;
import biouml.standard.type.Unit;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.math.model.UndeclaredFunction;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.util.TextUtil;
import ru.biosoft.util.XmlUtil;

public class ModelXmlReader
extends DiagramXmlSupport {
    protected Map<String, String> newPaths = new HashMap<String, String>();

    public ModelXmlReader(Diagram diagram) {
        this.diagram = diagram;
    }

    public void setNewPaths(Map<String, String> newPaths) {
        this.newPaths = newPaths;
    }

    public EModel readModel(Element element) {
        EModel model = null;
        try {
            String className = element.getAttribute("class");
            if (className == null || className.indexOf("MatlabOdeModel") >= 0) {
                model = new EModel(this.diagram);
            } else {
                Class clazz = ClassLoading.loadSubClass((String)className, EModel.class);
                model = (EModel)clazz.getConstructor(DiagramElement.class).newInstance(new Object[]{this.diagram});
            }
            this.readParameters(element, model);
            this.readVariables(element, model);
            EModel.DiagramVariableResolver resolver = model.getVariableResolver(0);
            this.readFunctions(element, model, resolver);
            this.readEquations(element, model, resolver);
            this.readEvents(element);
            this.readTables(element);
            this.readSimpleTables(element);
            this.readStates(element);
            this.readTransitions(element);
            this.readUnits(element, model);
            if (element.hasAttribute("timeUnits")) {
                model.getVariable("time").setUnits(element.getAttribute("timeUnits"));
            }
            if (element.hasAttribute("comment")) {
                model.setComment(element.getAttribute("comment"));
            }
        }
        catch (Throwable t) {
            ModelXmlReader.error("ERROR_EXECUTABLE_MODEL", new String[]{this.diagram.getName(), t.getMessage()}, t);
        }
        if (model != null) {
            model.setPropagationEnabled(true);
        }
        return model;
    }

    protected void readParameters(Element modelElement, EModel model) {
        NodeList list = modelElement.getElementsByTagName("parameter");
        for (Element element : XmlUtil.elements((NodeList)list)) {
            String name = element.getAttribute("name");
            try {
                Variable parameter = this.readParameter(element, name, model);
                model.put(parameter);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_CONSTANT_PROCESSING", new String[]{this.diagram.getName(), name, t.getMessage()});
            }
        }
    }

    protected Variable readParameter(Element element, String name, EModel model) {
        Variable parameter = new Variable(name, model, null);
        String title = element.getAttribute("title");
        if (!title.isEmpty()) {
            parameter.setTitle(title);
        }
        String value = element.getAttribute("value");
        try {
            if (value.isEmpty()) {
                ModelXmlReader.warn("WARN_PARAMETER_VALUE_ABSENTS", new String[]{this.diagram.getName(), name});
            } else {
                parameter.setInitialValue(Double.parseDouble(value));
            }
        }
        catch (Throwable t) {
            ModelXmlReader.error("ERROR_PARAMETER_VALUE", new String[]{this.diagram.getName(), name, value, t.getMessage()});
        }
        if (element.hasAttribute("units")) {
            parameter.setUnits(element.getAttribute("units"));
        }
        if (element.hasAttribute("constant")) {
            parameter.setConstant(Boolean.parseBoolean(element.getAttribute("constant")));
        }
        if (element.hasAttribute("comment")) {
            parameter.setComment(element.getAttribute("comment"));
        }
        if (element.hasChildNodes()) {
            DynamicPropertySet dps = DiagramXmlReader.readDPS(element, null);
            for (DynamicProperty dp : dps) {
                parameter.getAttributes().add(dp);
            }
        }
        return parameter;
    }

    protected void readVariables(Element modelElement, EModel model) {
        NodeList list = modelElement.getElementsByTagName("variable");
        for (Element element : XmlUtil.elements((NodeList)list)) {
            String diagramElement = null;
            try {
                diagramElement = element.getAttribute("diagramElement");
                VariableRole var = this.readVariable(element, diagramElement);
                if (var == null) continue;
                model.put(var);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_VARIABLE_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()}, t);
            }
        }
    }

    protected VariableRole readVariable(Element element, String diagramElement) {
        String[] diagramElements = TextUtil.split((String)diagramElement, (char)';');
        DiagramElement de = this.getDiagramElement(diagramElements[0]);
        if (de == null) {
            return null;
        }
        VariableRole variable = new VariableRole(de, 0.0);
        de.setRole(variable);
        for (int i = 1; i < diagramElements.length; ++i) {
            DiagramElement associatedDE = this.getDiagramElement(diagramElements[i]);
            if (associatedDE == null) continue;
            variable.addAssociatedElement(associatedDE);
            associatedDE.setRole(variable);
        }
        String initialValue = element.getAttribute("initialValue");
        try {
            if (initialValue.isEmpty()) {
                ModelXmlReader.warn("WARN_VARIABLE_VALUE_ABSENTS", new String[]{this.diagram.getName(), diagramElement});
            } else {
                variable.setInitialValue(Double.parseDouble(initialValue));
            }
        }
        catch (Throwable t) {
            ModelXmlReader.error("ERROR_VARIABLE_VALUE", new String[]{this.diagram.getName(), diagramElement, initialValue, t.getMessage()});
        }
        if (element.hasAttribute("units")) {
            variable.setUnits(element.getAttribute("units"));
        }
        if (element.hasAttribute("boundaryCondition") && "true".equals(element.getAttribute("boundaryCondition"))) {
            variable.setBoundaryCondition(true);
        }
        if (element.hasAttribute("constant") && "true".equals(element.getAttribute("constant"))) {
            variable.setConstant(true);
        }
        if (element.hasAttribute("comment")) {
            variable.setComment(element.getAttribute("comment"));
        }
        return variable;
    }

    protected void readFunctions(Element modelElement, EModel model, EModel.DiagramVariableResolver resolver) {
        NodeList list = modelElement.getElementsByTagName("function");
        for (Element child : XmlUtil.elements((NodeList)list)) {
            String formula = child.getAttribute("formula");
            if (formula.isEmpty()) continue;
            try {
                String name = formula.substring(formula.indexOf(32) + 1, formula.indexOf(40));
                if (model.getFunction(name) != null) continue;
                model.declareFunction((ru.biosoft.math.model.Function)new UndeclaredFunction(name, 7));
            }
            catch (Throwable t) {}
        }
        for (Element child : XmlUtil.elements((NodeList)list)) {
            String diagramElement = null;
            try {
                diagramElement = child.getAttribute("diagramElement");
                this.readFunction(child, diagramElement, model, resolver);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_EQUATION_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()});
            }
        }
    }

    protected void readEquations(Element modelElement, EModel model, EModel.DiagramVariableResolver resolver) {
        NodeList list = modelElement.getElementsByTagName("equation");
        for (Element child : XmlUtil.elements((NodeList)list)) {
            String diagramElement = null;
            try {
                diagramElement = child.getAttribute("diagramElement");
                this.readEquation(child, diagramElement, model, resolver);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_EQUATION_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()});
            }
        }
    }

    protected void readSimpleTables(Element modelElement) {
        NodeList list = modelElement.getElementsByTagName("table");
        for (Element child : XmlUtil.elements((NodeList)list)) {
            String diagramElement = null;
            try {
                diagramElement = child.getAttribute("diagramElement");
                this.readSimpleTable(child, diagramElement);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_TABLE_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()});
            }
        }
    }

    protected void readTables(Element modelElement) {
        NodeList list = modelElement.getElementsByTagName("tableElement");
        for (Element child : XmlUtil.elements((NodeList)list)) {
            String diagramElement = null;
            try {
                diagramElement = child.getAttribute("diagramElement");
                this.readTable(child, diagramElement);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_TABLE_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()});
            }
        }
    }

    protected void readSimpleTable(Element element, String diagramElement) {
        Node de;
        try {
            de = (Node)CollectionFactory.getDataElement((String)diagramElement, (DataCollection)this.diagram, Node.class);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
            return;
        }
        SimpleTableElement table = new SimpleTableElement(de);
        String path = element.getAttribute("tablePath");
        if (this.newPaths != null && this.newPaths.containsKey(path)) {
            path = this.newPaths.get(path);
        }
        table.setTablePath(DataElementPath.create((String)path));
        Element argElement = XmlUtil.getChildElement((Element)element, (String)"argColumn");
        table.getArgColumn().setColumn(argElement.getAttribute("column"));
        table.getArgColumn().setVariable(argElement.getAttribute("variable"));
        ArrayList<SimpleTableElement.VarColumn> columns = new ArrayList<SimpleTableElement.VarColumn>();
        for (Element child : XmlUtil.elements((Element)element, (String)"varColumn")) {
            SimpleTableElement.VarColumn column = new SimpleTableElement.VarColumn();
            column.setColumn(child.getAttribute("column"));
            column.setVariable(child.getAttribute("variable"));
            columns.add(column);
        }
        table.setColumns((SimpleTableElement.VarColumn[])StreamEx.of(columns).toArray(SimpleTableElement.VarColumn[]::new));
        de.setRole(table);
    }

    protected void readTable(Element element, String diagramElement) {
        Node de;
        try {
            de = (Node)CollectionFactory.getDataElement((String)diagramElement, (DataCollection)this.diagram, Node.class);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
            return;
        }
        TableElement tableElement = new TableElement(de);
        String path = ModelXmlReader.getRequiredAttribute(element, "tableDataCollection", this.diagram.getName());
        DataElementPath tablePath = DataElementPath.create((String)path);
        DataElement tdc = null;
        try {
            tdc = tablePath.getDataElement();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)ex));
        }
        if (tdc != null && tdc instanceof TableDataCollection) {
            tableElement.setTablePath(tablePath);
            String formula = element.getAttribute("formula");
            tableElement.setFormula(formula);
            NodeList list = element.getChildNodes();
            for (Element child : XmlUtil.elements((NodeList)list)) {
                if (!"variable".equals(child.getNodeName())) continue;
                String name = ModelXmlReader.getRequiredAttribute(child, "name", this.diagram.getName());
                String columnName = ModelXmlReader.getRequiredAttribute(child, "column", this.diagram.getName());
                for (TableElement.Variable var : tableElement.getVariables()) {
                    if (!var.getColumnName().equals(columnName)) continue;
                    var.setName(name);
                }
            }
        }
        if ("true".equals(element.getAttribute("cycled"))) {
            tableElement.setCycled(true);
        }
        de.setRole(tableElement);
    }

    protected void readEvents(Element modelElement) {
        NodeList list = modelElement.getElementsByTagName("event");
        for (Element child : XmlUtil.elements((NodeList)list)) {
            String diagramElement = null;
            try {
                diagramElement = child.getAttribute("diagramElement");
                this.readEvent(child, diagramElement);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_EVENT_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()});
            }
        }
    }

    protected void readEvent(Element element, String diagramElement) {
        String priority;
        String useValuesFromTriggerTime;
        String triggerInitialValue;
        Node de;
        try {
            de = (Node)CollectionFactory.getDataElement((String)diagramElement, (DataCollection)this.diagram, Node.class);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
            return;
        }
        String trigger = ModelXmlReader.getRequiredAttribute(element, "trigger", this.diagram.getName());
        if (trigger == null) {
            return;
        }
        String delay = element.getAttribute("delay");
        ModelXmlReader.readComment(de, element);
        NodeList list = element.getElementsByTagName("assignment");
        ArrayList<Assignment> assign = new ArrayList<Assignment>();
        for (Element child : XmlUtil.elements((NodeList)list)) {
            try {
                assign.add(this.readAssignment(child));
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_ASSIGNMENT_PROCESSING", new String[]{this.diagram.getName(), de.getName(), t.getMessage()});
            }
        }
        Event event = new Event(de, trigger, delay, assign.toArray(new Assignment[assign.size()]));
        String triggerPersistent = element.getAttribute("persistent");
        if (!triggerPersistent.isEmpty()) {
            event.setTriggerPersistent(Boolean.parseBoolean(triggerPersistent));
        }
        if (!(triggerInitialValue = element.getAttribute("initialValue")).isEmpty()) {
            event.setTriggerInitialValue(Boolean.parseBoolean(triggerInitialValue));
        }
        if (!(useValuesFromTriggerTime = element.getAttribute("useValeusFromTriggerTime")).isEmpty()) {
            event.setUseValuesFromTriggerTime(Boolean.parseBoolean(useValuesFromTriggerTime));
        }
        if (!(priority = element.getAttribute("priority")).isEmpty()) {
            event.setPriority(priority);
        }
        de.setRole(event);
    }

    protected void readStates(Element element) {
        NodeList list = element.getElementsByTagName("state");
        for (Element child : XmlUtil.elements((NodeList)list)) {
            String diagramElement = null;
            try {
                diagramElement = child.getAttribute("diagramElement");
                this.readState(child, diagramElement);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_STATE_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()});
            }
        }
    }

    protected void readState(Element element, String diagramElement) {
        NodeList onEventList;
        NodeList exitList;
        DiagramElement de;
        try {
            de = (DiagramElement)CollectionFactory.getDataElement((String)diagramElement, (DataCollection)this.diagram, DiagramElement.class);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
            return;
        }
        State state = new State(de);
        String isStart = element.getAttribute("start");
        state.setStart(Boolean.parseBoolean(isStart));
        NodeList entryList = element.getElementsByTagName("entry");
        if (entryList.getLength() > 0) {
            Element entryElement = (Element)entryList.item(0);
            NodeList assignList = entryElement.getElementsByTagName("assignment");
            for (Object child : XmlUtil.elements((NodeList)assignList)) {
                try {
                    Assignment assign = this.readAssignment((Element)child);
                    state.addOnEntryAssignment(assign, false);
                }
                catch (Throwable t) {
                    ModelXmlReader.error("ERROR_STATE_ENTRY_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()}, t);
                }
            }
        }
        if ((exitList = element.getElementsByTagName("exit")).getLength() > 0) {
            Element exitElement = (Element)exitList.item(0);
            NodeList assignList = exitElement.getElementsByTagName("assignment");
            for (Element child : XmlUtil.elements((NodeList)assignList)) {
                try {
                    Assignment assign = this.readAssignment(child);
                    state.addOnExitAssignment(assign, false);
                }
                catch (Throwable t) {
                    ModelXmlReader.error("ERROR_STATE_EXIT_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()}, t);
                }
            }
        }
        if ((onEventList = element.getElementsByTagName("on_event")).getLength() > 0) {
            Element onEventElement = (Element)onEventList.item(0);
            NodeList assignList = onEventElement.getElementsByTagName("assignment");
            for (Element element2 : XmlUtil.elements((NodeList)assignList)) {
            }
        }
        de.setRole(state);
    }

    protected void readTransitions(Element element) {
        NodeList list = element.getElementsByTagName("transition");
        for (Element child : XmlUtil.elements((NodeList)list)) {
            String diagramElement = null;
            try {
                diagramElement = child.getAttribute("diagramElement");
                this.readTransition(child, diagramElement);
            }
            catch (Throwable t) {
                ModelXmlReader.error("ERROR_TRANSITION_PROCESSING", new String[]{this.diagram.getName(), diagramElement, t.getMessage()});
            }
        }
    }

    protected void readTransition(Element element, String diagramElement) {
        DiagramElement de;
        try {
            de = (DiagramElement)CollectionFactory.getDataElement((String)diagramElement, (DataCollection)this.diagram, DiagramElement.class);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
            return;
        }
        Element whenElement = XmlUtil.findElementByTagName((Element)element, (String)"when");
        Element afterElement = XmlUtil.findElementByTagName((Element)element, (String)"after");
        if (whenElement != null && afterElement != null) {
            ModelXmlReader.error("ERROR_HAS_WHEN_HAS_AFTER", new String[]{this.diagram.getName(), diagramElement});
            return;
        }
        Transition transition = new Transition(de);
        if (whenElement != null) {
            String whenTrigger = whenElement.getAttribute("trigger");
            transition.setWhen(whenTrigger);
        }
        if (afterElement != null) {
            String afterTrigger = afterElement.getAttribute("after");
            transition.setAfter(afterTrigger);
        }
        de.setRole(transition);
    }

    protected Function readFunction(Element element, String diagramElement, EModel model, EModel.DiagramVariableResolver resolver) {
        DiagramElement de;
        try {
            de = (DiagramElement)CollectionFactory.getDataElement((String)diagramElement, (DataCollection)this.diagram, DiagramElement.class);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
            return null;
        }
        Function function = new Function(de);
        de.setRole(function);
        String formula = element.getAttribute("formula");
        if (formula.isEmpty()) {
            ModelXmlReader.warn("WARN_EQUATION_FORMULA_ABSENTS", new String[]{this.diagram.getName(), diagramElement});
        } else {
            function.setFormula(formula);
            model.readMath(function.getFormula(), (Role)function, (VariableResolver)resolver);
        }
        return function;
    }

    protected Equation readEquation(Element element, String diagramElement, EModel model, EModel.DiagramVariableResolver resolver) {
        DiagramElement de;
        try {
            de = (DiagramElement)CollectionFactory.getDataElement((String)diagramElement, (DataCollection)this.diagram, DiagramElement.class);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
            return null;
        }
        String variableName = element.getAttribute("variable");
        Variable variable = model.getVariable(variableName);
        if (variable != null) {
            variableName = variable.getName();
        }
        Reaction reaction = null;
        if (de instanceof Edge) {
            Edge edge = (Edge)de;
            boolean resolved = edge.nodes().map(DiagramElement::getRole).select(VariableRole.class).map(VariableRole::getName).has((Object)variableName);
            reaction = edge.nodes().map(DiagramElement::getKernel).select(Reaction.class).findFirst().orElse(null);
            if (!resolved) {
                Node bad;
                VariableRole var;
                ModelXmlReader.warn("WARN_EQUATION_VARIABLE_UNRESOLVED", new String[]{this.diagram.getName(), diagramElement, variableName});
                if (edge.nodes().map(DiagramElement::getRole).has(null) && (var = new VariableRole(bad = edge.getInput().getRole() == null ? edge.getInput() : edge.getOutput(), 0.0)).getName().equals(variableName)) {
                    bad.setRole(var);
                    model.put(var);
                    resolver.addVariable(var);
                    ModelXmlReader.warn("WARN_MISSED_VARIABLE_DECLARATION", new String[]{this.diagram.getName(), bad.getName(), variableName});
                }
            }
        } else if (de.getKernel() instanceof Reaction) {
            reaction = (Reaction)de.getKernel();
            model.put(new Variable(variableName, model, null));
        }
        String type = "rate";
        if (element.hasAttribute("type")) {
            type = element.getAttribute("type");
        }
        Equation equation = new Equation(de, type, variableName);
        de.setRole(equation);
        String formula = element.getAttribute("formula");
        if (formula.isEmpty()) {
            ModelXmlReader.warn("WARN_EQUATION_FORMULA_ABSENTS", new String[]{this.diagram.getName(), diagramElement});
        } else if (!equation.hasDelegate()) {
            equation.setFormula(formula);
            model.readMath(equation.getFormula(), (Role)equation, (VariableResolver)resolver);
        }
        if (element.hasAttribute("units")) {
            equation.setUnits(element.getAttribute("units"));
        }
        if (element.hasAttribute("comment")) {
            equation.setComment(element.getAttribute("comment"));
        }
        if (reaction != null) {
            equation.setFast(reaction.isFast());
        }
        return equation;
    }

    @Nonnull
    protected Assignment readAssignment(Element element) {
        String variableName = element.getAttribute("variable");
        String formula = element.getAttribute("formula");
        return new Assignment(variableName, formula);
    }

    protected void readUnits(Element element, EModel model) {
        NodeList list = element.getElementsByTagName("unitDefinition");
        for (Element child : XmlUtil.elements((NodeList)list)) {
            try {
                String name = child.getAttribute("name");
                String title = child.getAttribute("title");
                Unit unit = new Unit(null, name);
                unit.setTitle(title);
                ArrayList<BaseUnit> baseUnits = new ArrayList<BaseUnit>();
                NodeList baseUnitList = child.getElementsByTagName("baseUnit");
                for (Element baseUnitElement : XmlUtil.elements((NodeList)baseUnitList)) {
                    BaseUnit baseUnit = new BaseUnit();
                    baseUnit.setType(baseUnitElement.getAttribute("type"));
                    baseUnit.setMultiplier(Double.parseDouble(baseUnitElement.getAttribute("multiplier")));
                    baseUnit.setExponent(Integer.parseInt(baseUnitElement.getAttribute("exponent")));
                    baseUnit.setScale(Integer.parseInt(baseUnitElement.getAttribute("scale")));
                    baseUnits.add(baseUnit);
                }
                unit.setBaseUnits(baseUnits.toArray(new BaseUnit[baseUnits.size()]));
                model.addUnit(unit);
            }
            catch (Throwable throwable) {}
        }
    }
}

