/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Diagram;
import biouml.model.DiagramFilter;
import biouml.model.DiagramViewBuilder;
import com.developmentontheedge.application.ApplicationUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.View;

public class ImageGenerator {
    protected static final Logger log = Logger.getLogger(ImageGenerator.class.getName());

    public static BufferedImage generateDiagramImage(Diagram diagram) {
        return ImageGenerator.generateDiagramImage(diagram, 1.0, false);
    }

    public static BufferedImage generateDiagramImage(Diagram diagram, double scale, boolean antiAliasing) {
        Graphics2D graphics = ApplicationUtils.getGraphics();
        View view = ImageGenerator.generateDiagramView(diagram, graphics);
        BufferedImage image = ImageGenerator.generateImage(view, scale, antiAliasing);
        return image;
    }

    public static View generateDiagramView(Diagram diagram, Graphics graphics) {
        View view = diagram.getView();
        if (view == null) {
            DiagramFilter[] filterList;
            DiagramViewBuilder builder = diagram.getType().getDiagramViewBuilder();
            view = builder.createDiagramView(diagram, graphics);
            for (DiagramFilter filter : filterList = diagram.getFilterList()) {
                if (filter == null || !filter.isEnabled()) continue;
                filter.apply(diagram);
            }
        }
        view.setLocation(10, 10);
        return view;
    }

    public static BufferedImage generateImage(View view, double scale, boolean antiAliasing) {
        return ImageGenerator.generateImage(view, scale, antiAliasing, false);
    }

    public static BufferedImage generateImage(View view, double scale, boolean antiAliasing, boolean isTransparent) {
        Rectangle r = view.getBounds();
        int width = (int)Math.ceil((double)(r.width + 2 * r.x) * scale);
        int height = (int)Math.ceil((double)(r.height + 2 * r.y) * scale);
        BufferedImage image = new BufferedImage(width, height, isTransparent ? 2 : 1);
        Graphics2D graphics = image.createGraphics();
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        if (antiAliasing) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (isTransparent) {
            graphics.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        } else {
            graphics.setColor(Color.white);
        }
        graphics.fill(new Rectangle(0, 0, width, height));
        graphics.setTransform(at);
        view.paint(graphics);
        return image;
    }

    public static void encodeImage(BufferedImage image, String format, OutputStream out) throws Exception {
        ImageGenerator.encodeImage(image, format, null, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeImage(BufferedImage image, String format, IIOMetadata metadata, OutputStream out) throws Exception {
        block19: {
            try {
                if (metadata != null) {
                    ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
                    ImageWriteParam writeParam = writer.getDefaultWriteParam();
                    try (ImageOutputStream stream = ImageIO.createImageOutputStream(out);){
                        writer.setOutput(stream);
                        writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                        break block19;
                    }
                }
                ImageIO.write((RenderedImage)image, format, out);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error during image encoding", t);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static String generateImageMap(View view, ReferenceGenerator generator) {
        return ImageGenerator.generateImageMap(view, generator, 0.0f);
    }

    public static String generateImageMap(View view, ReferenceGenerator generator, float zoomFactor) {
        view.setLocation(10, 10);
        StringBuffer result = new StringBuffer();
        ImageGenerator.generateImageMap(view, generator, result, zoomFactor);
        return result.toString();
    }

    protected static void generateImageMap(View view, ReferenceGenerator generator, StringBuffer result, float zoomFactor) {
        String ref;
        if (view instanceof CompositeView) {
            CompositeView composite = (CompositeView)view;
            for (int i = composite.size() - 1; i >= 0; --i) {
                ImageGenerator.generateImageMap(composite.elementAt(i), generator, result, zoomFactor);
            }
        }
        if (view.isActive() && (ref = generator.getReference(view.getModel())) != null) {
            Rectangle bounds = view.getBounds();
            bounds.x -= 3;
            bounds.y -= 3;
            bounds.width += 6;
            bounds.height += 6;
            if (zoomFactor != 0.0f) {
                bounds.x = (int)((float)bounds.x * zoomFactor);
                bounds.y = (int)((float)bounds.y * zoomFactor);
                bounds.width = (int)((float)bounds.width * zoomFactor);
                bounds.height = (int)((float)bounds.height * zoomFactor);
            }
            result.append("<area shape=\"rect\"");
            result.append(" coords=\"" + bounds.x + "," + bounds.y + "," + (bounds.x + bounds.width) + "," + (bounds.y + bounds.height) + "\" ");
            result.append("href=\"");
            result.append(ref);
            result.append("\" target=\"");
            result.append(generator.getTarget(view.getModel()));
            result.append("\"");
            String title = generator.getTitle(view.getModel());
            if (title != null) {
                result.append(" title=\"");
                result.append(title);
                result.append("\"");
            }
            result.append("/>\n");
        }
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static interface ReferenceGenerator {
        public String getReference(Object var1);

        public String getTarget(Object var1);

        public String getTitle(Object var1);
    }
}

