/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.GlobalViewOptions;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.VariableRole;
import biouml.standard.type.Reaction;
import biouml.workbench.diagram.DiagramDocument;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.editors.TextButtonEditor;
import java.awt.Component;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import ru.biosoft.graphics.editor.ViewPaneAdapter;
import ru.biosoft.graphics.editor.ViewPaneEvent;
import ru.biosoft.graphics.editor.ViewPaneListener;
import ru.biosoft.gui.Document;
import ru.biosoft.math.Expression;
import ru.biosoft.math.ExpressionEditorDialog;
import ru.biosoft.math.ExpressionEditorPane;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.model.VariableResolver;
import ru.biosoft.util.IconUtils;

public class FormulaEditor
extends TextButtonEditor {
    protected DiagramDocument diagramDocument;
    protected JLabel titledTextField = new JLabel();
    protected EModel emodel = null;

    public FormulaEditor() {
        this.editor.remove(this.textField);
        this.editor.add((Component)this.titledTextField, "Center");
        URL url = FormulaEditor.class.getResource("resources/edit.gif");
        this.getButton().setText("");
        this.getButton().setIcon(IconUtils.getImageIcon((URL)url));
    }

    protected void buttonPressed() {
        Expression expression;
        final ExpressionEditorDialog dialog = new ExpressionEditorDialog(new String[]{"Text"}, false);
        if (!(this.getBean() instanceof ExpressionOwner)) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Bean is not compatible with expression editor", "Editor unavailable", 0);
            return;
        }
        if (this.getEModel() == null) {
            JOptionPane.showMessageDialog((Component)Application.getApplicationFrame(), "Diagram model is not defined", "Editor unavailable", 0);
            return;
        }
        ViewPaneAdapter adapter = new ViewPaneAdapter(){

            public void mousePressed(ViewPaneEvent e) {
                Object model = e.getViewSource().getModel();
                if (model instanceof Role) {
                    model = ((Role)model).getDiagramElement();
                }
                if (model instanceof Node) {
                    Node node = (Node)((Object)model);
                    if (node.getKernel() instanceof Reaction) {
                        return;
                    }
                    Role role = node.getRole();
                    if (role instanceof VariableRole) {
                        String varName = FormulaEditor.this.emodel.getQualifiedName(((VariableRole)role).getName(), node, GlobalViewOptions.getVarNameMode());
                        dialog.addVariableToFormula(varName);
                    }
                }
            }
        };
        try {
            this.emodel.getParser().setDeclareUndefinedVariables(false);
            AstStart astStart = this.emodel.readMath((String)this.getValue(), this.getRole(), GlobalViewOptions.getVarNameMode());
            expression = new Expression(null, ExpressionEditorPane.linearFormatter.format(astStart)[1]);
            expression.setParserContext((ParserContext)this.emodel);
            expression.setAstStart(astStart);
            this.emodel.getParser().setDeclareUndefinedVariables(true);
        }
        catch (Exception ex) {
            expression = new Expression(null, "");
        }
        dialog.setVariableResolver((VariableResolver)this.emodel.getVariableResolver(0));
        dialog.setExpression(expression);
        dialog.getOkButton().addActionListener(e -> {
            String text = new LinearFormatter().format(dialog.getExpression().getAstStart())[1];
            this.setValue(text);
            this.diagramDocument.getViewPane().removeViewPaneListener((ViewPaneListener)adapter);
        });
        this.diagramDocument.getViewPane().addViewPaneListener((ViewPaneListener)adapter);
        dialog.doModal();
    }

    public void setValue(Object value) {
        super.setValue(value);
        String titledValue = value.toString();
        this.titledTextField.setText(titledValue);
    }

    protected Role getRole() {
        return this.getBean() instanceof ExpressionOwner ? ((ExpressionOwner)this.getBean()).getRole() : null;
    }

    protected EModel getEModel() {
        if (this.emodel == null) {
            Role diagramRole;
            Document document = Document.getCurrentDocument();
            if (document instanceof DiagramDocument) {
                this.diagramDocument = (DiagramDocument)document;
            }
            if (this.diagramDocument != null && (diagramRole = this.diagramDocument.getDiagram().getRole()) instanceof EModel) {
                this.emodel = (EModel)diagramRole;
            }
        }
        return this.emodel;
    }
}

