/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementStyle;
import biouml.model.DiagramFilter;
import biouml.model.DiagramType;
import biouml.model.Edge;
import biouml.model.EquivalentNodeGroup;
import biouml.model.ModelDefinition;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.MultipleConnection;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.model.util.DiagramWriter;
import biouml.model.util.DiagramXmlSupport;
import biouml.model.util.ModelXmlWriter;
import biouml.model.util.XmlSerializationUtils;
import biouml.model.xml.XmlDiagramType;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.state.State;
import biouml.standard.state.StateXmlSerializer;
import biouml.standard.type.Base;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.ImageDescriptor;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import com.developmentontheedge.beans.Option;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.exception.Assert;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.Path;
import ru.biosoft.util.ColorUtils;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.TextUtil;

public class DiagramXmlWriter
extends DiagramXmlSupport
implements DiagramWriter {
    protected static final Logger log = Logger.getLogger(DiagramXmlWriter.class.getName());
    public static final String VERSION = "0.7.7";
    public static final String APPVERSION = "0.7.7";
    protected Document doc;
    protected OutputStream stream;
    private Map<String, String> replacements = new HashMap<String, String>();

    public DiagramXmlWriter() {
    }

    public static void writeDiagram(Diagram diagram, OutputStream stream) throws Exception {
        DiagramType type = diagram.getType();
        DiagramXmlWriter writer = type.getDiagramWriter();
        writer.stream = stream;
        writer.write(diagram);
    }

    @Override
    public void writeNode(Element parent, Node node) {
        Element element = node instanceof Compartment ? this.createCompartmentNode("compartment", (Compartment)node) : this.createNode(node);
        if (element != null) {
            parent.appendChild(element);
        }
    }

    @Override
    public void writeEdge(Element parent, Edge edge) {
        Element element;
        Compartment compartment = this.getDiagram();
        if (edge.getOrigin() instanceof Compartment && !(edge.getOrigin() instanceof Diagram)) {
            compartment = (Compartment)edge.getOrigin();
        }
        if ((element = this.createEdge(edge, compartment)) != null) {
            parent.appendChild(element);
        }
    }

    public static void writeCompartmentInfo(Element element, Compartment compartment, Document doc) {
        Element imageEl;
        DiagramXmlWriter.setTitle(element, compartment);
        DiagramXmlWriter.setLocation(element, compartment);
        Dimension size = compartment.getShapeSize();
        if (size == null) {
            size = new Dimension(10, 10);
        }
        element.setAttribute("width", Integer.toString((int)size.getWidth()));
        element.setAttribute("height", Integer.toString((int)size.getHeight()));
        element.setAttribute("shape", Integer.toString(compartment.getShapeType()));
        element.setAttribute("isTitleHidden", String.valueOf(!compartment.isShowTitle()));
        if (compartment.isUseCustomImage() && (imageEl = DiagramXmlWriter.createImage(compartment.getImage(), doc)) != null) {
            element.appendChild(imageEl);
        }
        DiagramXmlWriter.writeStyle(element, compartment);
        if (!compartment.isVisible()) {
            element.setAttribute("isHidden", "true");
        }
    }

    public static void writeNodeInfo(Element element, Node node, Document doc) {
        DynamicPropertySet properties;
        String comment;
        ImageDescriptor imageDesc;
        Element imageEl;
        DiagramXmlWriter.setTitle(element, node);
        DiagramXmlWriter.setLocation(element, node);
        Dimension size = node.getShapeSize();
        if (size != null) {
            element.setAttribute("width", Integer.toString((int)size.getWidth()));
            element.setAttribute("height", Integer.toString((int)size.getHeight()));
        }
        if (!node.isVisible()) {
            element.setAttribute("isHidden", "true");
        }
        element.setAttribute("isTitleHidden", String.valueOf(!node.isShowTitle()));
        if (node.getKernel() instanceof Stub.Note && !((Stub.Note)node.getKernel()).isBackgroundVisible()) {
            element.setAttribute("background_visible", "false");
        }
        if ((imageEl = DiagramXmlWriter.createImage(imageDesc = node.getImage(), doc)) != null) {
            element.appendChild(imageEl);
        }
        DiagramXmlWriter.writeStyle(element, node);
        if (node.isFixed()) {
            element.setAttribute("fixed", String.valueOf(node.isFixed()));
        }
        if ((comment = node.getComment()) != null && !comment.isEmpty()) {
            element.setAttribute("comment", comment);
        }
        if ((properties = Diagram.getDiagram(node).getType().getProperties()) != null) {
            DiagramXmlWriter.serializeDPS(doc, element, node.getAttributes(), properties);
        }
    }

    public static boolean isEdgeInfoInformative(Edge edge) {
        Path path = edge.getPath();
        if (path != null && path.npoints > 1) {
            return true;
        }
        Point inPort = edge.getInPort();
        if (inPort != null && inPort.getX() != 0.0 && inPort.getY() != 0.0) {
            return true;
        }
        Point outPort = edge.getOutPort();
        if (outPort != null && outPort.getX() != 0.0 && outPort.getY() != 0.0) {
            return true;
        }
        if (edge.getKernel() == null) {
            return true;
        }
        if (edge.getTitle() == null && edge.getKernel().getTitle() == null) {
            return false;
        }
        return edge.getTitle() == null && edge.getKernel().getTitle() != null || !edge.getTitle().equals(edge.getKernel().getTitle());
    }

    public static void writeEdgeInfo(Element element, Edge edge, Document doc) {
        DiagramType diagramType;
        DynamicPropertySet properties;
        String comment;
        Point outPort;
        Point inPort;
        Path path;
        if (DiagramXmlWriter.isEdgeInfoInformative(edge) && (path = edge.getPath()) != null && path.npoints > 2) {
            Element pathElem = doc.createElement("path");
            for (int i = 0; i < path.npoints; ++i) {
                Element segment = doc.createElement("segment");
                segment.setAttribute("x0", String.valueOf(path.xpoints[i]));
                segment.setAttribute("y0", String.valueOf(path.ypoints[i]));
                if (i == 0) {
                    segment.setAttribute("segmentType", "moveTo");
                } else if (path.pointTypes[i] == 1) {
                    segment.setAttribute("segmentType", "quadric");
                } else if (path.pointTypes[i] == 2) {
                    segment.setAttribute("segmentType", "cubic");
                } else {
                    segment.setAttribute("segmentType", "lineTo");
                }
                pathElem.appendChild(segment);
            }
            element.appendChild(pathElem);
        }
        if (edge != null && edge.getName() != null && !edge.getName().isEmpty()) {
            element.setAttribute("edgeID", edge.getName());
        }
        DiagramXmlWriter.setTitle(element, edge);
        DiagramXmlWriter.writeStyle(element, edge);
        if (edge.isFixed()) {
            element.setAttribute("fixed", String.valueOf(edge.isFixed()));
        }
        if (edge.isFixedInOut()) {
            element.setAttribute("fixedInOut", String.valueOf(edge.isFixedInOut()));
        }
        if ((inPort = edge.getInPort()) != null && inPort.getX() != 0.0 && inPort.getY() != 0.0) {
            element.setAttribute("inPort", XmlSerializationUtils.getPointString(inPort));
        }
        if ((outPort = edge.getOutPort()) != null && outPort.getX() != 0.0 && outPort.getY() != 0.0) {
            element.setAttribute("outPort", XmlSerializationUtils.getPointString(outPort));
        }
        if ((comment = edge.getComment()) != null && !comment.isEmpty()) {
            element.setAttribute("comment", comment);
        }
        if ((properties = (diagramType = Diagram.getDiagram(edge).getType()).getProperties()) != null) {
            DiagramXmlWriter.serializeDPS(doc, element, edge.getAttributes(), properties);
        }
    }

    public static void writeEdgeRole(Element element, Edge edge, Document doc) {
        Role role = edge.getRole();
        if (role instanceof Connection) {
            DiagramXmlWriter.writeConnection(doc, edge, (Connection)role, element);
        }
    }

    public static void writeConnection(Document doc, Edge edge, Connection connection, Element parentElement) {
        Element connectionElement = doc.createElement("connection");
        connectionElement.setAttribute("type", edge.getRole(Role.class).getClass().getName());
        Element inPort = doc.createElement("connectionInput");
        inPort.setAttribute("id", connection.getInputPort().getVariableName());
        inPort.setAttribute("title", connection.getInputPort().getVariableTitle());
        connectionElement.appendChild(inPort);
        Element outPort = doc.createElement("connectionOutput");
        outPort.setAttribute("id", connection.getOutputPort().getVariableName());
        outPort.setAttribute("title", connection.getOutputPort().getVariableTitle());
        connectionElement.appendChild(outPort);
        if (connection instanceof DirectedConnection) {
            DiagramXmlWriter.setOptionalAttribute(connectionElement, "formula", ((DirectedConnection)connection).getFunction());
        } else if (connection instanceof UndirectedConnection) {
            String mainVariable = ((UndirectedConnection)connection).getMainVariableType().toString();
            connectionElement.setAttribute("mainVariable", mainVariable);
        }
        if (connection instanceof MultipleConnection) {
            Connection[] connectionList = ((MultipleConnection)connection).getConnections();
            Element connectionListElement = doc.createElement("listOfConnections");
            for (Connection con : connectionList) {
                DiagramXmlWriter.writeConnection(doc, (Edge)con.getParent(), con, connectionListElement);
            }
            connectionElement.appendChild(connectionListElement);
        }
        parentElement.appendChild(connectionElement);
    }

    protected static void setTitle(Element element, DiagramElement diagramElement) {
        if (diagramElement == null || diagramElement.getTitle() == null) {
            return;
        }
        element.setAttribute("title", DiagramXmlWriter.validate(diagramElement.getTitle()));
    }

    protected static void setComment(Element element, DiagramElement diagramElement) {
        if (diagramElement != null) {
            DiagramXmlWriter.setComment(element, diagramElement.getComment());
        }
    }

    protected static void setLocation(Element element, Node node) {
        if (node != null) {
            Point location = node.getLocation();
            element.setAttribute("x", Integer.toString(location.x));
            element.setAttribute("y", Integer.toString(location.y));
        }
    }

    protected static Element createImage(ImageDescriptor imageDesc, Document doc) {
        Element element = null;
        if (imageDesc != null) {
            String imageSource;
            if (imageDesc.getPath() != null) {
                element = doc.createElement("image");
                element.setAttribute("path", imageDesc.getPath().toString());
            }
            if ((imageSource = imageDesc.getSource()) != null) {
                element = doc.createElement("image");
                element.setAttribute("src", imageSource);
                Dimension size = imageDesc.getSize();
                element.setAttribute("width", Integer.toString((int)size.getWidth()));
                element.setAttribute("height", Integer.toString((int)size.getHeight()));
            }
        }
        return element;
    }

    public DiagramXmlWriter(OutputStream stream) {
        this.stream = stream;
    }

    public DiagramXmlWriter(Document doc, Diagram diagram) {
        this.doc = doc;
        this.diagram = diagram;
    }

    public void write(@Nonnull Diagram sourceDiagram) throws Exception {
        this.write(sourceDiagram, TransformerFactory.newInstance().newTransformer());
    }

    public void write(@Nonnull Diagram sourceDiagram, Transformer transformer) throws Exception {
        Assert.notNull((String)"sourceDiagram", (Object)((Object)sourceDiagram));
        this.diagram = sourceDiagram;
        boolean notificationEnabled = false;
        if (this.diagram.isNotificationEnabled()) {
            notificationEnabled = true;
            this.diagram.setNotificationEnabled(false);
        }
        this.buildDocument();
        if (notificationEnabled) {
            this.diagram.setNotificationEnabled(true);
        }
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(this.stream);
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(source, result);
    }

    protected Document buildDocument() throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.newDocument();
        ModelXmlWriter modelWriter = new ModelXmlWriter();
        modelWriter.setNewPaths(this.replacements);
        this.doc.appendChild(this.createDml(this.createDiagram(), modelWriter.createModel(this.diagram, this.doc), this.createStates()));
        return this.doc;
    }

    protected Element createDml(Element diag, Element model, Element states) {
        Element element = this.doc.createElement("dml");
        element.setAttribute("version", "0.7.7");
        element.setAttribute("appVersion", "0.7.7");
        element.appendChild(diag);
        if (model != null) {
            element.appendChild(model);
        }
        if (states != null) {
            element.appendChild(states);
        }
        return element;
    }

    protected Element createDiagram() {
        Element labelLayouterInfo;
        Element layouterInfo;
        Element plots;
        Element simulationOptions;
        Assert.notNull((String)"diagram", (Object)((Object)this.diagram));
        Element element = this.doc.createElement("diagram");
        element.setAttribute("diagramType", this.diagram.getType().getClass().getName());
        element.setAttribute("title", this.diagram.getTitle());
        if (this.diagram.getType() instanceof XmlDiagramType) {
            element.setAttribute("notation", DataElementPath.create((DataElement)((XmlDiagramType)this.diagram.getType())).toString());
        }
        element.appendChild(this.createDiagramInfo(this.diagram));
        Element viewOptions = DiagramXmlWriter.createDiagramViewOptions(this.doc, this.diagram, "viewOptions");
        if (viewOptions != null) {
            element.appendChild(viewOptions);
        }
        if ((simulationOptions = DiagramXmlWriter.writeSimulationOptions(this.doc, "simulationOptions", this.diagram)) != null) {
            element.appendChild(simulationOptions);
        }
        if ((plots = DiagramXmlWriter.writePlotsInfo(this.doc, "plots", this.diagram, this.replacements)) != null) {
            element.appendChild(plots);
        }
        if ((layouterInfo = DiagramXmlWriter.createLayouterInfo(this.doc, this.diagram.getPathLayouter(), "layouterInfo")) != null) {
            element.appendChild(layouterInfo);
        }
        if ((labelLayouterInfo = DiagramXmlWriter.createLayouterInfo(this.doc, this.diagram.getLabelLayouter(), "labelLayouterInfo")) != null) {
            element.appendChild(labelLayouterInfo);
        }
        element.appendChild(this.createNodes(this.diagram));
        element.appendChild(this.createEdges(this.diagram));
        element.appendChild(this.createFilters(this.diagram));
        return element;
    }

    public void createAttributes(Base base, Element element) {
        DynamicPropertySet dps = base.getAttributes();
        if (dps != null && dps.size() > 0) {
            Element dpsElement = this.doc.createElement("attributes");
            DiagramXmlWriter.serializeDPS(this.doc, dpsElement, dps, null);
            element.appendChild(dpsElement);
        }
    }

    protected Element createDiagramInfo(Diagram diagram) {
        DynamicPropertySet properties;
        Element element = this.doc.createElement("diagramInfo");
        Base kernel = diagram.getKernel();
        if (kernel instanceof DiagramInfo) {
            String[] lr;
            DiagramXmlWriter.setOptionalAttribute(element, "title", kernel.getTitle());
            DiagramXmlWriter.setComment(element, ((DiagramInfo)kernel).getComment());
            String value = ((DiagramInfo)kernel).getDescription();
            if (value != null) {
                element.appendChild(this.doc.createCDATASection(DiagramXmlWriter.validate(value)));
            }
            this.writeCreationInfo((DiagramInfo)kernel, element);
            this.createAttributes(kernel, element);
            DatabaseReference[] dr = ((DiagramInfo)kernel).getDatabaseReferences();
            if (dr != null) {
                for (DatabaseReference element2 : dr) {
                    Element itemElement = this.doc.createElement("databaseReference");
                    itemElement.setAttribute("value", element2.getAsText());
                    element.appendChild(itemElement);
                }
            }
            if ((lr = ((DiagramInfo)kernel).getLiteratureReferences()) != null) {
                for (String element2 : lr) {
                    Element itemElement = this.doc.createElement("literatureReference");
                    itemElement.setAttribute("value", element2);
                    element.appendChild(itemElement);
                }
            }
        }
        if ((properties = diagram.getType().getProperties()) != null) {
            DiagramXmlWriter.serializeDPS(this.doc, element, diagram.getAttributes(), properties);
        }
        return element;
    }

    protected void writeCreationInfo(DiagramInfo info, Element element) {
        Element authorsElement = this.doc.createElement("authors");
        DiagramInfo.AuthorInfo[] authors = info.getAuthors();
        for (int i = 0; i < authors.length; ++i) {
            Element author = this.doc.createElement("author");
            author.setAttribute("familyName", authors[i].getFamilyName());
            author.setAttribute("givenName", authors[i].getGivenName());
            author.setAttribute("email", authors[i].getEmail());
            author.setAttribute("organisation", authors[i].getOrgName());
            authorsElement.appendChild(author);
        }
        if (authorsElement.hasChildNodes()) {
            element.appendChild(authorsElement);
        }
        Element historyElement = this.doc.createElement("history");
        String created = info.getCreated();
        if (created != null && !created.isEmpty()) {
            Element createdElement = this.doc.createElement("created");
            createdElement.setAttribute("date", info.getCreated());
            historyElement.appendChild(createdElement);
        }
        String[] modified = info.getModified();
        for (int i = 0; i < modified.length; ++i) {
            Element modifiedElement = this.doc.createElement("modified");
            modifiedElement.setAttribute("date", modified[i]);
            historyElement.appendChild(modifiedElement);
        }
        if (historyElement.hasChildNodes()) {
            element.appendChild(historyElement);
        }
    }

    public static Element createDiagramViewOptions(Document doc, Diagram diagram, String elementName) {
        return DiagramXmlWriter.createDiagramViewOptions(doc, diagram, elementName, false);
    }

    public static Element createDiagramViewOptions(Document doc, Diagram diagram, String elementName, boolean writeIfDefault) {
        Element element = doc.createElement(elementName);
        DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
        DPSUtils.writeBeanToDPS((Object)diagram.getViewOptions(), (DynamicPropertySet)dps, (String)"");
        if (!dps.isEmpty()) {
            DynamicPropertySetAsMap defaults = new DynamicPropertySetAsMap();
            DPSUtils.writeBeanToDPS((Object)diagram.getType().getDiagramViewBuilder().createDefaultDiagramViewOptions(), (DynamicPropertySet)defaults, (String)"");
            DiagramXmlWriter.serializeDPS(doc, element, (DynamicPropertySet)dps, (DynamicPropertySet)defaults, writeIfDefault);
        }
        return element;
    }

    public static Element createLayouterInfo(Document doc, Layouter layouter, String elementName) {
        if (layouter != null) {
            Element element = doc.createElement(elementName);
            element.setAttribute("type", layouter.getClass().getName());
            DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
            DPSUtils.writeBeanToDPS((Object)layouter, (DynamicPropertySet)dps, (String)"");
            DiagramXmlWriter.serializeDPS(doc, element, (DynamicPropertySet)dps, (DynamicPropertySet)new DynamicPropertySetAsMap(), false);
            return element;
        }
        return null;
    }

    private Element createCompartmentInfo(Compartment compartment) {
        Element element = this.doc.createElement("compartmentInfo");
        this.setKernelRef(element, compartment);
        DiagramXmlWriter.writeCompartmentInfo(element, compartment, this.doc);
        DiagramXmlWriter.setComment(element, compartment);
        return element;
    }

    private Element createNodes(Compartment compartment) {
        Element element = this.doc.createElement("nodes");
        HashSet<SubDiagram> subDiagrams = new HashSet<SubDiagram>();
        Iterator<DiagramElement> iterator = compartment.iterator();
        while (iterator.hasNext()) {
            DiagramElement de = iterator.next();
            Element child = null;
            if (de instanceof SubDiagram) {
                subDiagrams.add((SubDiagram)de);
            } else if (de instanceof ModelDefinition) {
                child = this.createModelDefinitionNode((ModelDefinition)de);
            } else if (de instanceof EquivalentNodeGroup) {
                child = this.createCompartmentNode("equivalentNodeGroup", (EquivalentNodeGroup)de);
            } else if (de instanceof Compartment) {
                child = this.createCompartmentNode("compartment", (Compartment)de);
            } else if (de instanceof Node) {
                child = this.createNode((Node)de);
            }
            if (child == null) continue;
            element.appendChild(child);
        }
        for (SubDiagram sd : subDiagrams) {
            element.appendChild(this.createSubDiagramNode(sd));
        }
        return element;
    }

    private Element createEdges(Compartment compartment) {
        Element element = this.doc.createElement("edges");
        compartment.stream().select(Edge.class).forEach(e -> element.appendChild(this.createEdge((Edge)((Object)e), compartment)));
        return element;
    }

    public Element createCompartmentNode(String compartmentName, Compartment compartment) {
        Element element = this.doc.createElement(compartmentName);
        if (compartmentName.equals("equivalentNodeGroup")) {
            element.setAttribute("representative", "unknown222");
        }
        element.appendChild(this.createCompartmentInfo(compartment));
        element.appendChild(this.createNodes(compartment));
        element.appendChild(this.createEdges(compartment));
        DiagramType diagramType = Diagram.getDiagram(compartment).getType();
        DynamicPropertySet properties = diagramType.getProperties();
        if (properties != null) {
            DiagramXmlWriter.serializeDPS(this.doc, element, compartment.getAttributes(), properties);
        }
        return element;
    }

    public void setReplacements(Map<String, String> replacements) {
        this.replacements = replacements;
    }

    private Element createSubDiagramNode(SubDiagram subDiagram) {
        Element element = this.createCompartmentNode("subdiagram", subDiagram);
        element.setAttribute("id", subDiagram.getName());
        Diagram innerDiagram = subDiagram.getDiagram();
        if (ModelDefinition.isDefindInModelDefinition(innerDiagram)) {
            element.setAttribute("modelDefinition", ModelDefinition.getModelDefinition(innerDiagram).getName());
        } else {
            String path = subDiagram.getDiagramPath();
            if (this.replacements != null && this.replacements.containsKey(path)) {
                path = this.replacements.get(path);
            }
            element.setAttribute("diagram", path);
        }
        element.setAttribute("diagramState", subDiagram.getStateName());
        try {
            State state = innerDiagram.getState("SubdiagramState");
            if (state != null) {
                element.appendChild(StateXmlSerializer.getStateXmlElement(state, this.doc, new DiagramXmlWriter(this.doc, innerDiagram)));
            }
        }
        catch (Throwable t) {
            DiagramXmlWriter.error("ERROR_SUBDIAGRAM_STATES_WRITING", new String[]{this.diagram.getName(), subDiagram.getName(), t.getMessage()});
        }
        return element;
    }

    private Element createModelDefinitionNode(ModelDefinition modelDefinition) {
        Element element = this.createCompartmentNode("modelDefinition", modelDefinition);
        element.setAttribute("id", modelDefinition.getName());
        try {
            Diagram innerDiagram = modelDefinition.getDiagram();
            DiagramXmlWriter writer = new DiagramXmlWriter(this.doc, innerDiagram);
            boolean notificationEnabled = innerDiagram.isNotificationEnabled();
            innerDiagram.setNotificationEnabled(false);
            State currentState = innerDiagram.getCurrentState();
            if (currentState != null) {
                innerDiagram.restore();
            }
            element.appendChild(writer.createDml(writer.createDiagram(), new ModelXmlWriter().createModel(this.diagram, this.doc), writer.createStates()));
            if (currentState != null) {
                innerDiagram.setStateEditingMode(currentState);
            }
            innerDiagram.setNotificationEnabled(notificationEnabled);
        }
        catch (Throwable t) {
            DiagramXmlWriter.error("ERROR_MODEL_DEFINITION_WRITING", new String[]{this.diagram.getName(), modelDefinition.getName(), t.getMessage()});
        }
        return element;
    }

    public Element createNode(Node node) {
        Element element = this.doc.createElement("node");
        this.setKernelRef(element, node);
        DiagramXmlWriter.writeNodeInfo(element, node, this.doc);
        DiagramXmlWriter.setComment(element, node);
        return element;
    }

    public Element createEdge(Edge edge, @Nonnull Compartment root) {
        Element element = this.doc.createElement("edge");
        this.setKernelRef(element, edge);
        String inRefStr = CollectionFactory.getRelativeName((DataElement)edge.getInput(), (DataCollection)root);
        String outRefStr = CollectionFactory.getRelativeName((DataElement)edge.getOutput(), (DataCollection)root);
        element.setAttribute("in", inRefStr);
        element.setAttribute("out", outRefStr);
        DiagramXmlWriter.writeEdgeInfo(element, edge, this.doc);
        DiagramXmlWriter.writeEdgeRole(element, edge, this.doc);
        DiagramXmlWriter.setComment(element, edge);
        return element;
    }

    protected Element createFilters(Diagram diagram) {
        return DiagramXmlWriter.createFilters(this.doc, diagram);
    }

    public static Element createFilters(Document doc, Diagram diagram) {
        DiagramFilter[] filters = diagram.getFilterList();
        Element element = doc.createElement("filters");
        element.setAttribute("type", filters.getClass().getName());
        element.setAttribute("elementType", DiagramFilter.class.getName());
        DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
        for (DiagramFilter filter : filters) {
            Object properties;
            Element item = doc.createElement("item");
            item.setAttribute("type", filter.getClass().getName());
            if (filter.getName() != null) {
                DiagramXmlWriter.serializeDynamicProperty(doc, item, new DynamicProperty("name", String.class, (Object)filter.getName()), (DynamicPropertySet)dps);
            }
            if (filter.isEnabled()) {
                DiagramXmlWriter.serializeDynamicProperty(doc, item, new DynamicProperty("enabled", Boolean.TYPE, (Object)true), (DynamicPropertySet)dps);
                element.setAttribute("active", filter.getName());
            }
            if ((properties = filter.getProperties()) != null) {
                Element property = doc.createElement("property");
                property.setAttribute("name", "properties");
                property.setAttribute("type", properties.getClass().getName());
                DPSUtils.writeBeanToDPS((Object)properties, (DynamicPropertySet)dps, (String)"");
                DiagramXmlWriter.serializeDPS(doc, property, (DynamicPropertySet)dps, (DynamicPropertySet)new DynamicPropertySetAsMap());
                item.appendChild(property);
            } else {
                DPSUtils.writeBeanToDPS((Object)filter, (DynamicPropertySet)dps, (String)"");
                DiagramXmlWriter.serializeDPS(doc, item, (DynamicPropertySet)dps, (DynamicPropertySet)new DynamicPropertySetAsMap());
            }
            element.appendChild(item);
        }
        return element;
    }

    protected Element createStates() {
        Element[] states = StateXmlSerializer.getXmlElements(this.diagram, this.doc, this);
        if (states == null) {
            return null;
        }
        Element element = this.doc.createElement("states");
        for (Element state : states) {
            element.appendChild(state);
        }
        return element;
    }

    private void setKernelRef(Element element, DiagramElement diagramElement) {
        Base kernel = diagramElement.getKernel();
        if (kernel != null && kernel.getOrigin() != null && !(kernel instanceof Stub)) {
            String ref = DataElementPath.create((DataElement)kernel).toString();
            if (!TextUtil.isFullPath((String)ref) || !kernel.getOrigin().contains(kernel.getName())) {
                ref = "stub/" + ref;
            }
            if (ref != null && ref.length() > 0) {
                element.setAttribute("kernel", ref);
                element.setAttribute("id", diagramElement.getName());
                if (ref.startsWith("stub")) {
                    element.setAttribute("kernel_type", kernel.getType());
                }
                return;
            }
        }
        DataElementPath kernelPath = DiagramUtility.toRepositoryPath(diagramElement.getCompleteNameInDiagram());
        if (kernel != null && !kernel.getName().equals(diagramElement.getName())) {
            kernelPath = kernelPath.getSiblingPath(kernel.getName());
            element.setAttribute("id", diagramElement.getName());
        }
        element.setAttribute("kernel", "stub/" + kernelPath);
        element.setAttribute("kernel_type", kernel != null ? kernel.getType() : "unknown");
        if (kernel instanceof Reaction && kernel.getOrigin() == null) {
            Element reaction = this.doc.createElement("reaction");
            Reaction reactionKernel = (Reaction)kernel;
            if (reactionKernel.getKineticLaw() != null && reactionKernel.getKineticLaw().getFormula() != null) {
                reaction.setAttribute("formula", reactionKernel.getKineticLaw().getFormula());
            }
            Iterator<SpecieReference> iterator = reactionKernel.iterator();
            while (iterator.hasNext()) {
                SpecieReference sr = iterator.next();
                Element srElement = this.doc.createElement("specieReference");
                srElement.setAttribute("name", sr.getName());
                String role = sr.getRole();
                srElement.setAttribute("role", role);
                if (role != null && role.equals("modifier")) {
                    srElement.setAttribute("modifierAction", sr.getModifierAction());
                }
                srElement.setAttribute("specie", sr.getSpecie());
                srElement.setAttribute("stoichiometry", sr.getStoichiometry());
                srElement.setAttribute("participation", sr.getParticipation());
                DiagramXmlWriter.setComment(srElement, sr.getComment());
                reaction.appendChild(srElement);
            }
            element.appendChild(reaction);
            return;
        }
        if (kernel != null && kernel.getOrigin() == null) {
            this.createAttributes(kernel, element);
        }
    }

    public static Element serializeDiagram(Document doc, Diagram diagram) {
        return new DiagramXmlWriter(doc, diagram).createDiagram();
    }

    public static void writeStyle(Element element, DiagramElement de) {
        String predefinedStyle = de.getPredefinedStyle();
        if (predefinedStyle.equals("Default")) {
            return;
        }
        if (predefinedStyle.equals("Not selected")) {
            DiagramElementStyle style = de.getCustomStyle();
            element.setAttribute("pen", XmlSerializationUtils.getPenString(style.getPen()));
            element.setAttribute("color", ColorUtils.paintToString((Paint)style.getBrush().getPaint()));
            element.setAttribute("font", XmlSerializationUtils.getFontString(style.getFont()));
        } else {
            element.setAttribute("style", predefinedStyle);
        }
    }

    public static Element writeSimulationOptions(Document doc, String elementName, Diagram diagram) {
        DynamicProperty dp = diagram.getAttributes().getProperty("simulationOptions");
        if (dp == null || dp.getValue() == null) {
            return null;
        }
        Object value = dp.getValue();
        Element element = doc.createElement(elementName);
        element.setAttribute("type", value.getClass().getName());
        DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
        DPSUtils.writeBeanToDPS((Object)value, (DynamicPropertySet)dps, (String)"");
        if (dps.isEmpty()) {
            return null;
        }
        DiagramXmlWriter.serializeDPS(doc, element, (DynamicPropertySet)dps, null, false);
        return element;
    }

    public static Element writePlotsInfo(Document doc, String elementName, Diagram diagram, Map<String, String> newPaths) {
        DynamicProperty dp = diagram.getAttributes().getProperty("Plots");
        if (dp == null || dp.getValue() == null) {
            return null;
        }
        Object value = dp.getValue();
        PlotsInfo info = (PlotsInfo)((Object)value);
        Element element = doc.createElement(elementName);
        for (PlotInfo plotInfo : info.getPlots()) {
            Element plotElement = doc.createElement("plot");
            plotElement.setAttribute("active", String.valueOf(plotInfo.isActive()));
            plotElement.setAttribute("title", plotInfo.getTitle());
            plotElement.setAttribute("autoColorNumber", String.valueOf(plotInfo.getAutoColorNumber()));
            plotElement.setAttribute("xAxisType", plotInfo.getXAxisType());
            if (plotInfo.getXFrom() != plotInfo.getXTo()) {
                plotElement.setAttribute("xFrom", String.valueOf(plotInfo.getXFrom()));
                plotElement.setAttribute("xTo", String.valueOf(plotInfo.getXTo()));
            }
            plotElement.setAttribute("xAutoRange", String.valueOf(plotInfo.isXAutoRange()));
            plotElement.setAttribute("yAxisType", plotInfo.getYAxisType());
            if (plotInfo.getXFrom() != plotInfo.getXTo()) {
                plotElement.setAttribute("yFrom", String.valueOf(plotInfo.getYFrom()));
                plotElement.setAttribute("yTo", String.valueOf(plotInfo.getYTo()));
            }
            plotElement.setAttribute("yAutoRange", String.valueOf(plotInfo.isYAutoRange()));
            Element xElement = doc.createElement("xVariable");
            xElement.setAttribute("name", plotInfo.getXVariable().getName());
            xElement.setAttribute("title", plotInfo.getXVariable().getTitle());
            xElement.setAttribute("path", plotInfo.getXVariable().getPath());
            plotElement.appendChild(xElement);
            for (Curve curve : plotInfo.getYVariables()) {
                Element curveElement = doc.createElement("yVariable");
                curveElement.setAttribute("name", curve.getName());
                curveElement.setAttribute("title", curve.getTitle());
                curveElement.setAttribute("path", curve.getPath());
                curveElement.setAttribute("pen", XmlSerializationUtils.getPenString(curve.getPen()));
                curveElement.setAttribute("type", curve.getType());
                plotElement.appendChild(curveElement);
            }
            if (plotInfo.getExperiments() != null) {
                for (Option option : plotInfo.getExperiments()) {
                    Element experimentElement = doc.createElement("experiment");
                    String path = option.getPath().toString();
                    if (newPaths != null && newPaths.containsKey(path)) {
                        path = newPaths.get(path);
                    }
                    experimentElement.setAttribute("path", path);
                    experimentElement.setAttribute("nameX", option.getNameX());
                    experimentElement.setAttribute("nameY", option.getNameY());
                    experimentElement.setAttribute("title", option.getTitle());
                    experimentElement.setAttribute("pen", XmlSerializationUtils.getPenString(option.getPen()));
                    plotElement.appendChild(experimentElement);
                }
            }
            element.appendChild(plotElement);
        }
        return element.hasChildNodes() ? element : null;
    }
}

