/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.model.util.DiagramXmlReader;
import biouml.model.util.DiagramXmlWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import ru.biosoft.access.AbstractFileTransformer;
import ru.biosoft.access.FileDataElement;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.generic.PriorityTransformer;

public class DiagramXmlTransformer
extends AbstractFileTransformer<Diagram>
implements PriorityTransformer {
    public Class<Diagram> getOutputType() {
        return Diagram.class;
    }

    public Diagram load(File input, String name, DataCollection<Diagram> origin) throws Exception {
        Module module = Module.optModule(origin);
        try (FileInputStream fis = new FileInputStream(input);){
            Diagram diagram = DiagramXmlReader.readDiagram(name, fis, null, this.getTransformedCollection(), module);
            return diagram;
        }
    }

    public void save(File output, Diagram diagram) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(output);){
            DiagramXmlWriter.writeDiagram(diagram, fos);
        }
    }

    public int getInputPriority(Class<? extends DataElement> inputClass, DataElement output) {
        if (FileDataElement.class.isAssignableFrom(inputClass) && output instanceof Diagram) {
            return 10;
        }
        return 0;
    }

    public int getOutputPriority(String name) {
        return name.endsWith(".dml") ? 2 : 0;
    }
}

