/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.SubDiagram;
import biouml.model.util.DiagramXmlConstants;
import biouml.model.util.MessageBundle;
import biouml.model.util.VariableName;
import biouml.model.util.XmlSerializationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.exception.LoggedClassNotFoundException;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.font.ColorFont;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.TextUtil;
import ru.biosoft.util.XmlUtil;

public class DiagramXmlSupport
extends DiagramXmlConstants {
    protected static final Logger log = Logger.getLogger(DiagramXmlSupport.class.getName());
    protected static final MessageBundle resources = (MessageBundle)ResourceBundle.getBundle(MessageBundle.class.getName());
    protected Diagram diagram = null;
    private static Map<String, Class<?>> typeNameToType = new HashMap();

    protected static void error(String messageBundleKey, String[] params) {
        String message = resources.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        log.log(Level.SEVERE, message);
    }

    protected static void error(String messageBundleKey, String[] params, Throwable t) {
        String message = resources.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        log.log(Level.SEVERE, message);
        ExceptionRegistry.log((Throwable)t);
    }

    protected static void warn(String messageBundleKey, String[] params) {
        String message = resources.getResourceString(messageBundleKey);
        message = MessageFormat.format(message, params);
        log.warning(message);
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    protected DiagramElement getDiagramElement(String diagramElement) {
        try {
            return (DiagramElement)CollectionFactory.getDataElement((String)diagramElement, (DataCollection)this.diagram, DiagramElement.class);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, ExceptionRegistry.log((Throwable)t));
            return null;
        }
    }

    public static Element getElement(Element element, String childName) {
        String elementName = element.getAttribute("name");
        if (elementName.isEmpty()) {
            elementName = element.getTagName();
        }
        try {
            NodeList list = element.getChildNodes();
            Element result = null;
            for (Element node : XmlUtil.elements((NodeList)list)) {
                if (!node.getNodeName().equals(childName)) continue;
                if (result == null) {
                    result = node;
                    continue;
                }
                DiagramXmlSupport.warn("WARN_MULTIPLE_DECLARATION", new String[]{result.getTagName(), elementName, childName});
            }
            return result;
        }
        catch (Throwable t) {
            DiagramXmlSupport.error("ERROR_ELEMENT_PROCESSING", new String[]{elementName, elementName, childName, t.getMessage()});
            return null;
        }
    }

    protected static Class<?> getPropertyType(String type) {
        Class<?> clazz = typeNameToType.get(type);
        if (clazz != null) {
            return clazz;
        }
        try {
            return ClassLoading.loadClass((String)type);
        }
        catch (LoggedClassNotFoundException e) {
            e.log();
            return null;
        }
    }

    protected static String getPropertyType(Class<?> _class) {
        return StreamEx.ofKeys(typeNameToType, _class::equals).findAny().orElse(_class.getName());
    }

    protected static String getRequiredAttribute(Element element, String attrName, String diagramName) {
        if (!element.hasAttribute(attrName)) {
            DiagramXmlSupport.error("ERROR_REQUIRED_ATTRIBUTE_MISSING", new String[]{diagramName, attrName, element.getTagName()});
            return null;
        }
        return element.getAttribute(attrName);
    }

    protected static void readComment(DiagramElement diagramElement, Element element) {
        if (element.hasAttribute("comment")) {
            diagramElement.setComment(element.getAttribute("comment"));
        }
    }

    public static boolean isEligibleToTextUtil(Class propertyType) {
        return propertyType.isPrimitive() || XmlSerializationUtils.isPrimitiveWrapperElement(propertyType) || String.class.equals((Object)propertyType) || DataElementPath.class.equals((Object)propertyType) || Color.class.equals((Object)propertyType) || Class.class.equals((Object)propertyType) || propertyType.isEnum();
    }

    protected static void setComment(Element element, String comment) {
        DiagramXmlSupport.setOptionalAttribute(element, "comment", comment);
    }

    protected static void setOptionalAttribute(Element element, String name, String value) {
        if (value != null && !value.isEmpty()) {
            element.setAttribute(name, DiagramXmlSupport.validate(value));
        }
    }

    protected static String validate(String str) {
        return str;
    }

    public static void serializeDPS(Document doc, Element root, DynamicPropertySet dps, DynamicPropertySet registry, boolean writeIfdeafault) {
        for (DynamicProperty dp : dps) {
            DiagramXmlSupport.serializeDynamicProperty(doc, root, dp, registry, writeIfdeafault);
        }
    }

    public static void serializeDPS(Document doc, Element root, DynamicPropertySet dps, DynamicPropertySet registry) {
        DiagramXmlSupport.serializeDPS(doc, root, dps, registry, true);
    }

    public static void serializeDynamicProperty(Document doc, Element root, DynamicProperty dp, DynamicPropertySet registry) {
        DiagramXmlSupport.serializeDynamicProperty(doc, root, dp, registry, true);
    }

    public static void serializeDynamicProperty(Document doc, Element root, DynamicProperty dp, DynamicPropertySet registry, boolean writeIfDefault) {
        Element element;
        DynamicProperty templateProperty;
        if (DPSUtils.isTransient((DynamicProperty)dp)) {
            return;
        }
        String name = dp.getName();
        DynamicProperty dynamicProperty = templateProperty = registry != null ? registry.getProperty(name) : null;
        if (templateProperty != null) {
            if (!writeIfDefault && templateProperty.getValue() != null && templateProperty.getValue().equals(dp.getValue())) {
                return;
            }
            element = doc.createElement("propertyRef");
        } else {
            Object tagValues;
            element = doc.createElement("property");
            element.setAttribute("short-description", dp.getShortDescription());
            if (registry == null && (tagValues = dp.getDescriptor().getValue("TAGS")) != null) {
                Element tagsElement = doc.createElement("tags");
                for (String tagValue : (String[])tagValues) {
                    Element tag = doc.createElement("tag");
                    tag.setAttribute("name", tagValue);
                    tag.setAttribute("value", tagValue);
                    tagsElement.appendChild(tag);
                }
                element.appendChild(tagsElement);
            }
        }
        element.setAttribute("name", name);
        Object value = dp.getValue();
        Class<?> propertyType = dp.getType();
        if (value != null && !propertyType.equals(value.getClass())) {
            propertyType = value.getClass();
        }
        if (DiagramXmlSupport.isEligibleToTextUtil(propertyType)) {
            if (templateProperty == null) {
                element.setAttribute("type", DiagramXmlSupport.getPropertyType(propertyType));
            }
            if (value != null) {
                element.setAttribute("value", TextUtil.toString((Object)value));
            }
        } else if (Pen.class.equals((Object)propertyType)) {
            XmlSerializationUtils.serializePen(element, (Pen)value, templateProperty != null);
        } else if (Brush.class.equals(propertyType)) {
            XmlSerializationUtils.serializeBrush(element, (Brush)value, templateProperty != null);
        } else if (Dimension.class.equals(propertyType)) {
            XmlSerializationUtils.serializeDimension(element, (Dimension)value, templateProperty != null);
        } else if (Point.class.equals(propertyType)) {
            XmlSerializationUtils.serializePoint(element, (Point)value, templateProperty != null);
        } else if (ColorFont.class.equals(propertyType)) {
            XmlSerializationUtils.serializeFont(element, (ColorFont)value, templateProperty != null);
        } else if (propertyType.isArray()) {
            element.setAttribute("type", DiagramXmlSupport.getPropertyType(Array.class));
            String type = DiagramXmlSupport.getPropertyType(propertyType.getComponentType());
            if (propertyType.getComponentType().getName().equals(DynamicProperty.class.getName()) || propertyType.getComponentType().getName().equals(DynamicPropertySet.class.getName())) {
                type = DiagramXmlSupport.getPropertyType(Composite.class);
            }
            element.setAttribute("elementType", type);
            if (value instanceof DynamicProperty[]) {
                for (DynamicProperty property : (DynamicProperty[])value) {
                    DiagramXmlSupport.serializeDynamicProperty(doc, element, property, registry, writeIfDefault);
                }
            } else if (value instanceof DynamicPropertySet[]) {
                for (DynamicPropertySet dps : (DynamicPropertySet[])value) {
                    DiagramXmlSupport.serializeDynamicProperty(doc, element, new DynamicProperty(" ", DynamicPropertySet.class, (Object)dps), registry, writeIfDefault);
                }
            } else if (value != null) {
                for (int j = 0; j < java.lang.reflect.Array.getLength(value); ++j) {
                    Element itemElement = doc.createElement("item");
                    Object arrayElement = java.lang.reflect.Array.get(value, j);
                    Class<?> propertyClass = arrayElement.getClass();
                    if (String.class.equals(propertyClass) || propertyClass.isPrimitive() || XmlSerializationUtils.isPrimitiveWrapperElement(propertyClass)) {
                        itemElement.appendChild(doc.createTextNode(arrayElement.toString()));
                    } else if (DiagramXmlSupport.isEligibleToTextUtil(propertyClass)) {
                        itemElement.appendChild(doc.createTextNode(TextUtil.toString((Object)arrayElement)));
                    } else {
                        DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
                        DPSUtils.writeBeanToDPS((Object)arrayElement, (DynamicPropertySet)dps, (String)"");
                        DiagramXmlSupport.serializeDPS(doc, itemElement, (DynamicPropertySet)dps, (DynamicPropertySet)new DynamicPropertySetAsMap());
                    }
                    element.appendChild(itemElement);
                }
            }
        } else if (SubDiagram.PortOrientation.class.equals(propertyType)) {
            DiagramXmlSupport.serializePortOrientation(element, (SubDiagram.PortOrientation)((Object)value), templateProperty != null);
        } else {
            DynamicProperty property;
            if (templateProperty == null) {
                element.setAttribute("type", "composite");
            }
            DynamicPropertySetAsMap dps = new DynamicPropertySetAsMap();
            DynamicPropertySetAsMap nestedRegistry = new DynamicPropertySetAsMap();
            DynamicProperty dynamicProperty2 = property = registry == null ? null : registry.getProperty(name);
            if (value instanceof DynamicPropertySet) {
                dps = (DynamicPropertySet)value;
                nestedRegistry = property != null ? (DynamicPropertySet)property.getValue() : null;
            } else if (value != null) {
                DPSUtils.writeBeanToDPS((Object)value, (DynamicPropertySet)dps, (String)"");
                element.setAttribute("type", DiagramXmlSupport.getPropertyType(value.getClass()));
                if (property != null) {
                    DPSUtils.writeBeanToDPS((Object)property.getValue(), (DynamicPropertySet)nestedRegistry, (String)"");
                }
            }
            DiagramXmlSupport.serializeDPS(doc, element, (DynamicPropertySet)dps, (DynamicPropertySet)nestedRegistry, writeIfDefault);
        }
        if (dp.isHidden()) {
            element.setAttribute("isHidden", "true");
        }
        if (dp.isReadOnly()) {
            element.setAttribute("isReadOnly", "true");
        }
        root.appendChild(element);
    }

    private static void serializePortOrientation(Element element, SubDiagram.PortOrientation port, boolean isRef) {
        if (!isRef) {
            element.setAttribute("type", "portOrientation");
        }
        if (port != null) {
            element.setAttribute("value", port.toString());
        }
    }

    static {
        typeNameToType.put("String", String.class);
        typeNameToType.put("int", Integer.class);
        typeNameToType.put("boolean", Boolean.class);
        typeNameToType.put("double", Double.class);
        typeNameToType.put("pen", Pen.class);
        typeNameToType.put("brush", Brush.class);
        typeNameToType.put("dimension", Dimension.class);
        typeNameToType.put("font", ColorFont.class);
        typeNameToType.put("composite", Composite.class);
        typeNameToType.put("array", Array.class);
        typeNameToType.put("dataElementPath", DataElementPath.class);
        typeNameToType.put("color", Color.class);
        typeNameToType.put("Class", Class.class);
        typeNameToType.put("portOrientation", SubDiagram.PortOrientation.class);
        typeNameToType.put("variable", VariableName.class);
    }

    protected static class Array {
        protected Array() {
        }
    }

    protected static class Composite {
        protected Composite() {
        }
    }
}

