/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramContainer;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementStyleDeclaration;
import biouml.model.DiagramFilter;
import biouml.model.DiagramType;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.EquivalentNodeGroup;
import biouml.model.ModelDefinition;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.MultipleConnection;
import biouml.model.dynamics.MultipleDirectedConnection;
import biouml.model.dynamics.MultipleUndirectedConnection;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.Experiment;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotVariable;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.model.util.DiagramReader;
import biouml.model.util.DiagramXmlSupport;
import biouml.model.util.ModelXmlReader;
import biouml.model.util.XmlSerializationUtils;
import biouml.model.xml.XmlDiagramType;
import biouml.standard.state.State;
import biouml.standard.state.StateXmlSerializer;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.ImageDescriptor;
import biouml.standard.type.Reaction;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.Option;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import one.util.streamex.StreamEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementDescriptor;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.security.CodePrivilege;
import ru.biosoft.access.security.CodePrivilegeType;
import ru.biosoft.exception.LoggedClassNotFoundException;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.editor.GridOptions;
import ru.biosoft.graphics.font.ColorFont;
import ru.biosoft.util.ColorUtils;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.TextUtil;
import ru.biosoft.util.XmlStream;
import ru.biosoft.util.XmlUtil;

@CodePrivilege(value={CodePrivilegeType.REFLECTION})
public class DiagramXmlReader
extends DiagramXmlSupport
implements DiagramReader {
    protected static final Logger log = Logger.getLogger(DiagramXmlReader.class.getName());
    private Module module = null;
    protected Map<String, String> newPaths = new HashMap<String, String>();
    protected InputStream stream;
    protected DiagramInfo diagramInfo;
    protected String name;
    protected boolean getKernels = true;
    protected DiagramType defaultDiagramType = new XmlDiagramType();
    String version = "0.7.7";
    HashMap<Element, Compartment> wrongEdges = new HashMap();
    private final List<String> kernelNames = new ArrayList<String>();

    public void setNewPaths(Map<String, String> newPaths) {
        this.newPaths = newPaths;
    }

    public static Layouter readLayouterInfo(Element element) {
        if (element == null) {
            return null;
        }
        Layouter layouter = (Layouter)DiagramXmlReader.readElement(element, Layouter.class);
        return layouter == null ? (Layouter)XmlSerializationUtils.deserialize(DiagramXmlReader.getElement(element, "o")) : layouter;
    }

    public static void readFilters(Element element, Diagram diagram) {
        if (element == null) {
            return;
        }
        String selectedFilter = element.getAttribute("active");
        DiagramFilter[] filters = new DiagramFilter[0];
        if (filters.getClass().getName().equals(element.getAttribute("type"))) {
            filters = (DiagramFilter[])((StreamEx)XmlStream.elements((Element)element, (String)"item").map(item -> {
                DiagramFilter filter = (DiagramFilter)DiagramXmlReader.readElement(item, DiagramFilter.class);
                if (filter != null) {
                    filter.setLoading(false);
                }
                return filter;
            }).nonNull()).toArray(DiagramFilter[]::new);
        } else {
            Object filtersObj = XmlSerializationUtils.deserialize(DiagramXmlReader.getElement(element, "a"));
            if (filtersObj != null) {
                filters = (DiagramFilter[])filtersObj;
            }
        }
        for (DiagramFilter f : filters) {
            DiagramXmlReader.initFilter(f, diagram, selectedFilter);
        }
        diagram.setFilterList(filters);
    }

    private static void initFilter(DiagramFilter filter, Diagram diagram, String selectedFilter) {
        filter.setDiagram(diagram);
        if (selectedFilter.equals(filter.getName())) {
            diagram.setDiagramFilter(filter);
        }
    }

    private static Object readElement(Element element, Class<?> expectedType) {
        Class clazz;
        if (element == null) {
            return null;
        }
        String type = element.getAttribute("type");
        try {
            clazz = Class.forName(type);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            try {
                clazz = ClassLoading.loadClass((String)type);
            }
            catch (LoggedClassNotFoundException e1) {
                log.warning(e1.getMessage());
                return null;
            }
        }
        if (!expectedType.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            Object result = clazz.newInstance();
            DynamicPropertySetAsMap defaults = new DynamicPropertySetAsMap();
            DPSUtils.writeBeanToDPS(result, (DynamicPropertySet)defaults, (String)"");
            DynamicPropertySet dps = DiagramXmlReader.readDPS(element, (DynamicPropertySet)defaults);
            DPSUtils.readBeanFromDPS(result, (DynamicPropertySet)dps, (String)"");
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void readViewOptions(Element element, Diagram diagram) {
        String stepSize;
        String cellSize;
        String gridStyle;
        GridOptions gridOptions = new GridOptions();
        gridOptions.setUseDefault(false);
        String showGrid = element.getAttribute("showGrid");
        if (!showGrid.isEmpty()) {
            gridOptions.setShowGrid(Boolean.parseBoolean(showGrid));
        }
        if (!(gridStyle = element.getAttribute("gridStyle")).isEmpty()) {
            gridOptions.setGridStyle(gridOptions.getStyleFromString(gridStyle));
        }
        if (!(cellSize = element.getAttribute("gridCellSize")).isEmpty()) {
            gridOptions.setCellSize(Integer.parseInt(cellSize));
        }
        if (!(stepSize = element.getAttribute("gridStepSize")).isEmpty()) {
            gridOptions.setStepSize(Integer.parseInt(stepSize));
        }
        diagram.getViewOptions().setGridOptions(gridOptions);
        DynamicPropertySetAsMap defaults = new DynamicPropertySetAsMap();
        DPSUtils.writeBeanToDPS((Object)diagram.getType().getDiagramViewBuilder().createDefaultDiagramViewOptions(), (DynamicPropertySet)defaults, (String)"");
        DynamicPropertySet dps = DiagramXmlReader.readDPS(element, (DynamicPropertySet)defaults);
        DPSUtils.readBeanFromDPS((Object)diagram.getViewOptions(), (DynamicPropertySet)dps, (String)"");
    }

    public static void readSimulationOptions(Element element, Diagram diagram) {
        try {
            String className = element.getAttribute("type");
            if (!className.isEmpty()) {
                Class clazz = ClassLoading.loadClass((String)className);
                Object object = clazz.newInstance();
                DynamicPropertySet dps = DiagramXmlReader.readDPS(element, null);
                DPSUtils.readBeanFromDPS(object, (DynamicPropertySet)dps, (String)"");
                diagram.getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)"simulationOptions", object.getClass(), object));
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error reading simulation engine", ex);
        }
    }

    public static void readPlotsInfo(Element element, Diagram diagram, Map<String, String> newPaths) {
        try {
            if (!(diagram.getRole() instanceof EModel)) {
                return;
            }
            EModel emodel = diagram.getRole(EModel.class);
            PlotsInfo plotsInfo = new PlotsInfo(emodel);
            ArrayList<PlotInfo> plotInfos = new ArrayList<PlotInfo>();
            for (Element plotElement : XmlUtil.elements((Element)element, (String)"plot")) {
                Object cElement2;
                String yType;
                PlotInfo plotInfo = new PlotInfo();
                plotInfo.setEModel(emodel);
                plotInfo.setActive(Boolean.parseBoolean(plotElement.getAttribute("active")));
                plotInfo.setTitle(plotElement.getAttribute("title"));
                String xType = plotElement.getAttribute("xAxisType");
                if (!xType.isEmpty()) {
                    plotInfo.setXAxisType(xType);
                }
                String from = plotElement.getAttribute("xFrom");
                String to = plotElement.getAttribute("xTo");
                plotInfo.setXFrom(from.isEmpty() ? 0.0 : Double.parseDouble(from));
                plotInfo.setXTo(to.isEmpty() ? 0.0 : Double.parseDouble(to));
                if (!plotElement.getAttribute("xAutoRange").isEmpty()) {
                    plotInfo.setXAutoRange(Boolean.parseBoolean(plotElement.getAttribute("xAutoRange")));
                }
                if (!(yType = plotElement.getAttribute("yAxisType")).isEmpty()) {
                    plotInfo.setYAxisType(yType);
                }
                from = plotElement.getAttribute("yFrom");
                to = plotElement.getAttribute("yTo");
                plotInfo.setYFrom(from.isEmpty() ? 0.0 : Double.parseDouble(from));
                plotInfo.setYTo(to.isEmpty() ? 0.0 : Double.parseDouble(to));
                if (!plotElement.getAttribute("yAutoRange").isEmpty()) {
                    plotInfo.setYAutoRange(Boolean.parseBoolean(plotElement.getAttribute("yAutoRange")));
                }
                plotInfos.add(plotInfo);
                Element xElement = XmlUtil.findElementByTagName((Element)plotElement, (String)"xVariable");
                plotInfo.setXVariable(new PlotVariable(xElement.getAttribute("path"), xElement.getAttribute("name"), xElement.getAttribute("title"), emodel));
                ArrayList<Curve> curves = new ArrayList<Curve>();
                for (Object cElement2 : XmlUtil.elements((Element)plotElement, (String)"yVariable")) {
                    Curve curve = new Curve(cElement2.getAttribute("path"), cElement2.getAttribute("name"), cElement2.getAttribute("title"), emodel);
                    curve.setPen(XmlSerializationUtils.readPen(cElement2.getAttribute("pen")));
                    curve.setType(cElement2.getAttribute("type"));
                    curves.add(curve);
                }
                ArrayList<Experiment> experiments = new ArrayList<Experiment>();
                cElement2 = XmlUtil.elements((Element)plotElement, (String)"experiment").iterator();
                while (cElement2.hasNext()) {
                    Element cElement3 = (Element)cElement2.next();
                    String path = cElement3.getAttribute("path");
                    if (newPaths != null && newPaths.containsKey(path)) {
                        path = newPaths.get(path);
                    }
                    experiments.add(new Experiment(DataElementPath.create((String)path), cElement3.getAttribute("nameX"), cElement3.getAttribute("nameY"), cElement3.getAttribute("title"), XmlSerializationUtils.readPen(cElement3.getAttribute("pen"))));
                }
                if (!experiments.isEmpty()) {
                    plotInfo.setExperiments((Experiment[])StreamEx.of(experiments).toArray(Experiment[]::new));
                }
                String autoColorNumberStr = plotElement.getAttribute("autoColorNumber");
                try {
                    int autoColorNumber = autoColorNumberStr.isEmpty() ? curves.size() : Integer.parseInt(autoColorNumberStr);
                    plotInfo.setAutoColorNumber(autoColorNumber);
                }
                catch (NumberFormatException e) {
                    log.log(Level.WARNING, "Invalid 'autoColorNumber' attribute value in plots infos: " + autoColorNumberStr);
                }
                plotInfo.setYVariables((Curve[])curves.stream().toArray(Curve[]::new));
            }
            plotsInfo.setPlots((PlotInfo[])StreamEx.of(plotInfos).toArray(PlotInfo[]::new));
            diagram.getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)"Plots", PlotsInfo.class, (Object)((Object)plotsInfo)));
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error reading plot infos", ex);
        }
    }

    public static void readCompartmentInfo(Element element, Compartment compartment, String diagramName) {
        boolean notificationEnabled = compartment.isNotificationEnabled();
        if (notificationEnabled) {
            compartment.setNotificationEnabled(false);
        }
        DiagramXmlReader.getTitle(element, compartment);
        compartment.setLocation(DiagramXmlReader.readLocation(element, compartment.getName(), diagramName));
        compartment.setShapeSize(DiagramXmlReader.readDimension(element, diagramName, compartment.getName()));
        compartment.setVisible(!Boolean.parseBoolean(element.getAttribute("isHidden")));
        if (element.hasAttribute("isTitleHidden")) {
            compartment.setShowTitle(!Boolean.parseBoolean(element.getAttribute("isTitleHidden")));
        }
        DiagramXmlReader.readStyle(element, compartment);
        XmlStream.elements((Element)element, (String)"image").findFirst().ifPresent(img -> {
            ImageDescriptor imageDesc = DiagramXmlReader.readImage(img, diagramName, compartment.getName());
            if (imageDesc != null) {
                compartment.setUseCustomImage(true);
                compartment.setImage(imageDesc);
            }
        });
        if (element.hasAttribute("shape")) {
            compartment.setShapeType(Integer.parseInt(element.getAttribute("shape")));
        }
        if (notificationEnabled) {
            compartment.setNotificationEnabled(true);
        }
    }

    public static void readNodeInfo(Element element, Node node, String diagramName) {
        node.setNotificationEnabled(false);
        if (element.hasAttribute("title")) {
            node.setTitle(element.getAttribute("title"));
        }
        if (element.hasAttribute("comment")) {
            node.setComment(element.getAttribute("comment"));
        }
        node.setLocation(DiagramXmlReader.readLocation(element, node.getName(), diagramName));
        node.setShapeSize(DiagramXmlReader.readDimension(element, diagramName, node.getName()));
        node.setVisible(!Boolean.parseBoolean(element.getAttribute("isHidden")));
        if (element.hasAttribute("isTitleHidden")) {
            node.setShowTitle(!Boolean.parseBoolean(element.getAttribute("isTitleHidden")));
        } else if (node.getKernel().getType().equals("math-equation") || node.getKernel().getType().equals("math-function")) {
            node.setShowTitle(false);
        }
        DiagramXmlReader.readStyle(element, node);
        if (element.hasAttribute("fixed")) {
            node.setFixed(true);
        }
        DiagramXmlReader.processHighlightAttr(element, node);
        if (node.getKernel() instanceof Stub.Note) {
            if ("false".equals(element.getAttribute("background_visible"))) {
                ((Stub.Note)node.getKernel()).setBackgroundVisible(false);
            }
            if (element.hasAttribute("background_color")) {
                node.setPredefinedStyle("Not selected");
                node.getCustomStyle().setBrush(new Brush(DiagramXmlReader.stringToColor(element.getAttribute("background_color"), diagramName, node.getName())));
            }
        }
        XmlStream.elements((Element)element, (String)"image").findFirst().ifPresent(img -> {
            ImageDescriptor imageDesc = DiagramXmlReader.readImage(img, diagramName, node.getName());
            if (imageDesc != null) {
                node.setUseCustomImage(true);
                node.setImage(imageDesc);
            }
        });
        node.setNotificationEnabled(true);
        DiagramType diagramType = Diagram.getDiagram(node).getType();
        DynamicPropertySet properties = diagramType.getProperties();
        if (properties != null) {
            DiagramXmlReader.fillProperties(element, node.getAttributes(), properties);
            if (diagramType instanceof XmlDiagramType) {
                ((XmlDiagramType)diagramType).fillPropertyEditorParameters(node.getAttributes());
            }
        }
    }

    private static void processHighlightAttr(Element element, Node node) {
        for (Element child : XmlUtil.elements((Element)element)) {
            String name = child.getAttribute("name");
            if (!name.equals("highlight")) continue;
            String highlight = child.getAttribute("value");
            element.removeChild(child);
            if (highlight.equals("none")) break;
            DiagramViewOptions opts = Diagram.getDiagram(node).getViewOptions();
            if (opts.getStyle(highlight) == null) {
                String highlightColor = highlight.equals("highlight3") ? "#FFCEFF" : (highlight.equals("highlight2") ? "#FFCECE" : "#CCF");
                DiagramElementStyleDeclaration newStyle = new DiagramElementStyleDeclaration(highlight);
                newStyle.getStyle().setBrush(new Brush((Paint)ColorUtils.parseColor((String)highlightColor)));
                opts.addStyleIfAbsent(newStyle);
            }
            node.setPredefinedStyle(highlight);
            return;
        }
    }

    public static String readEdgeID(Element element) {
        return element.hasAttribute("edgeID") ? element.getAttribute("edgeID") : "";
    }

    public static void readEdgeInfo(Element element, Edge edge, String diagramName) {
        edge.setNotificationEnabled(false);
        NodeList pathNodes = element.getElementsByTagName("path");
        if (pathNodes.getLength() > 0) {
            NodeList segments = ((Element)pathNodes.item(0)).getElementsByTagName("segment");
            Path path = new Path();
            for (Element segment : XmlUtil.elements((NodeList)segments)) {
                String strType = segment.getAttribute("segmentType");
                int type = 0;
                if (strType.equals("lineTo")) {
                    type = 0;
                } else if (strType.equals("quadric")) {
                    type = 1;
                } else if (strType.equals("cubic")) {
                    type = 2;
                }
                int x = Integer.parseInt(segment.getAttribute("x0"));
                int y = Integer.parseInt(segment.getAttribute("y0"));
                path.addPoint(x, y, type);
            }
            edge.setPath(path);
        } else {
            if (element.hasAttribute("inPort")) {
                edge.setInPort(XmlSerializationUtils.readPoint(element.getAttribute("inPort")));
            }
            if (element.hasAttribute("outPort")) {
                edge.setOutPort(XmlSerializationUtils.readPoint(element.getAttribute("outPort")));
            }
        }
        if (element.hasAttribute("title")) {
            edge.setTitle(element.getAttribute("title"));
        }
        if (element.hasAttribute("comment")) {
            edge.setComment(element.getAttribute("comment"));
        }
        if (element.hasAttribute("fixed")) {
            edge.setFixed(true);
        }
        if (element.hasAttribute("fixedInOut")) {
            edge.setFixedInOut(true);
        }
        DiagramXmlReader.readStyle(element, edge);
        edge.setNotificationEnabled(true);
        DiagramType diagramType = Diagram.getDiagram(edge).getType();
        DynamicPropertySet properties = diagramType.getProperties();
        if (properties != null) {
            DiagramXmlReader.fillProperties(element, edge.getAttributes(), properties);
            if (diagramType instanceof XmlDiagramType) {
                Object role;
                ((XmlDiagramType)diagramType).fillPropertyEditorParameters(edge.getAttributes());
                if (edge.getKernel() instanceof SpecieReference && (role = edge.getAttributes().getValue("kernelRole")) != null) {
                    ((SpecieReference)edge.getKernel()).setRole(role.toString());
                }
            }
        }
    }

    protected static void getTitle(Element element, DiagramElement de) {
        if (element.hasAttribute("title")) {
            de.setTitle(element.getAttribute("title"));
        }
    }

    protected static Point readLocation(Element element, String nodeName, String diagramName) {
        String x = DiagramXmlReader.getRequiredAttribute(element, "x", diagramName);
        String y = DiagramXmlReader.getRequiredAttribute(element, "y", diagramName);
        if (x == null || y == null) {
            return new Point(0, 0);
        }
        try {
            return new Point((int)Double.parseDouble(x), (int)Double.parseDouble(y));
        }
        catch (Throwable t) {
            DiagramXmlReader.error("ERROR_LOCATION_PARSING", new String[]{diagramName, nodeName, x, y, t.getMessage()});
            return new Point(0, 0);
        }
    }

    @Nonnull
    protected static Dimension readDimension(Element element, String diagramName, String elementName) {
        Dimension dim = new Dimension(50, 50);
        String width = element.getAttribute("width");
        String height = element.getAttribute("height");
        if (!width.isEmpty() && !height.isEmpty()) {
            try {
                dim = new Dimension((int)Double.parseDouble(width), (int)Double.parseDouble(height));
            }
            catch (Throwable t) {
                DiagramXmlReader.error("ERROR_SIZE_PARSING", new String[]{diagramName, elementName, width, height, t.getMessage()});
            }
        }
        return dim;
    }

    public static Paint stringToColor(String colorStr, String diagramName, String name) {
        if (!colorStr.contains(",") || colorStr.contains("rgb")) {
            return ColorUtils.parsePaint((String)colorStr);
        }
        Color color = Color.gray;
        try {
            int b;
            int g;
            int r;
            int alpha;
            String[] vals = TextUtil.split((String)colorStr, (char)',');
            if (vals.length <= 4) {
                alpha = 255;
                r = Integer.parseInt(vals[0].trim());
                g = Integer.parseInt(vals[1].trim());
                b = Integer.parseInt(vals[2].trim());
                if (vals.length > 3) {
                    alpha = Integer.parseInt(vals[3].trim());
                }
            } else {
                int i = 3;
                int alpha2 = 255;
                if (vals.length > 7) {
                    alpha2 = Integer.parseInt(vals[7].trim());
                }
                int n = ++i;
                int r2 = Integer.parseInt(vals[n].trim());
                int n2 = ++i;
                int g2 = Integer.parseInt(vals[n2].trim());
                int n3 = ++i;
                ++i;
                int b2 = Integer.parseInt(vals[n3].trim());
                Color color2 = new Color(r2, g2, b2, alpha2);
                return new GradientPaint(0.0f, 0.0f, color, 100.0f, 100.0f, color2);
            }
            color = new Color(r, g, b, alpha);
        }
        catch (Throwable t) {
            DiagramXmlReader.error("ERROR_COLOR_PARSING", new String[]{diagramName, name, colorStr, t.getMessage()});
        }
        return color;
    }

    protected static ImageDescriptor readImage(Element element, String diagramName, String nodeName) {
        String path = element.getAttribute("path");
        if (path != null) {
            return new ImageDescriptor(DataElementPath.create((String)path));
        }
        String src = DiagramXmlReader.getRequiredAttribute(element, "src", diagramName);
        if (src == null) {
            return null;
        }
        try {
            return new ImageDescriptor(src, DiagramXmlReader.readDimension(element, diagramName, nodeName));
        }
        catch (Throwable t) {
            DiagramXmlReader.warn("ERROR_IMAGE_PROCESSING", new String[]{diagramName, nodeName, src, t.getMessage()});
            return null;
        }
    }

    public void readEdgeRole(Element element, Edge edge, String diagramName) {
        Element outPort;
        Element inPort;
        Connection role;
        Element connectionElement = DiagramXmlReader.getElement(element, "connection");
        if (connectionElement == null) {
            return;
        }
        String type = DiagramXmlReader.getRequiredAttribute(connectionElement, "type", diagramName);
        if (type == null) {
            return;
        }
        try {
            Class connectionClass = ClassLoading.loadSubClass((String)type, null, Connection.class);
            role = (Connection)connectionClass.getConstructor(Edge.class).newInstance(new Object[]{edge});
        }
        catch (Throwable t) {
            DiagramXmlReader.error("ERROR_READ_CONNECTION", new String[]{diagramName, edge.getName(), t.getMessage()});
            return;
        }
        if (!element.hasAttribute("title")) {
            edge.setTitle("");
        }
        if ((inPort = DiagramXmlReader.getElement(connectionElement, "connectionInput")) != null) {
            role.setInputPort(new Connection.Port(inPort.getAttribute("id"), inPort.getAttribute("title")));
        }
        if ((outPort = DiagramXmlReader.getElement(connectionElement, "connectionOutput")) != null) {
            role.setOutputPort(new Connection.Port(outPort.getAttribute("id"), outPort.getAttribute("title")));
        }
        if (role instanceof DirectedConnection) {
            String function = connectionElement.getAttribute("formula");
            if (!function.isEmpty()) {
                ((DirectedConnection)role).setFunction(function);
            }
        } else if (role instanceof UndirectedConnection) {
            String mainVariable = connectionElement.getAttribute("mainVariable");
            if (!mainVariable.isEmpty()) {
                ((UndirectedConnection)role).setMainVariableType(UndirectedConnection.MainVariableType.valueOf(mainVariable));
            }
        } else if (role instanceof MultipleConnection) {
            Element connectionListElement = DiagramXmlReader.getElement(connectionElement, "listOfConnections");
            NodeList list = connectionListElement.getChildNodes();
            for (Element connectionListItemElement : XmlUtil.elements((NodeList)list)) {
                Connection c;
                if (!connectionListItemElement.getNodeName().equals("connection")) continue;
                Element innerInPort = DiagramXmlReader.getElement(connectionListItemElement, "connectionInput");
                Element innerOutPort = DiagramXmlReader.getElement(connectionListItemElement, "connectionOutput");
                if (role instanceof MultipleDirectedConnection) {
                    c = new DirectedConnection(edge);
                    c.setInputPort(new Connection.Port(innerInPort.getAttribute("id"), innerInPort.getAttribute("title")));
                    c.setOutputPort(new Connection.Port(innerOutPort.getAttribute("id"), innerOutPort.getAttribute("title")));
                    ((DirectedConnection)c).setFunction(connectionListItemElement.getAttribute("formula"));
                    ((MultipleConnection)role).addConnection(c);
                    continue;
                }
                if (!(role instanceof MultipleUndirectedConnection)) continue;
                c = new UndirectedConnection(edge);
                ((UndirectedConnection)c).setInputPort(new Connection.Port(innerInPort.getAttribute("id"), innerInPort.getAttribute("title")));
                ((UndirectedConnection)c).setOutputPort(new Connection.Port(innerOutPort.getAttribute("id"), innerOutPort.getAttribute("title")));
                String initialValue = connectionListItemElement.getAttribute("initialValue");
                if (!initialValue.isEmpty()) {
                    ((UndirectedConnection)c).setInitialValue(Double.parseDouble(initialValue));
                }
                ((MultipleConnection)role).addConnection(c);
            }
        }
        edge.setRole(role);
    }

    public DiagramXmlReader(String name, InputStream stream, DiagramInfo diagramInfo) {
        this.name = name;
        this.stream = stream;
        this.diagramInfo = diagramInfo;
    }

    public void setDefaultDiagramType(DiagramType defaultDiagramType) {
        this.defaultDiagramType = defaultDiagramType;
    }

    public DiagramXmlReader(String name) {
        this.name = name;
    }

    public DiagramXmlReader() {
    }

    public Diagram read(DataCollection origin, Module module) throws Exception {
        Document document = DiagramXmlReader.createDocument(this.name, this.stream, this.diagramInfo);
        this.module = module;
        Element root = document.getDocumentElement();
        Element diagramElement = DiagramXmlReader.getElement(root, "diagram");
        if (diagramElement == null) {
            throw new Exception("Diagram element not found while reading diagram " + this.name);
        }
        DiagramType type = DiagramXmlReader.readDiagramType(diagramElement, origin, new XmlDiagramType());
        return this.read(origin, type, document);
    }

    public static Diagram readDiagram(String name, InputStream stream, DiagramInfo diagramInfo, DataCollection origin, Module module) throws Exception {
        return DiagramXmlReader.readDiagram(name, stream, diagramInfo, origin, module, null, null);
    }

    public static Diagram readDiagram(String name, InputStream stream, DiagramInfo diagramInfo, DataCollection origin, Module module, List<String> requestedKernels, Map<String, String> newPaths) throws Exception {
        Document document = DiagramXmlReader.createDocument(name, stream, diagramInfo);
        Element root = document.getDocumentElement();
        Element diagramElement = DiagramXmlReader.getElement(root, "diagram");
        if (diagramElement == null) {
            throw new Exception("Diagram element not found while reading diagram " + name);
        }
        DiagramType type = DiagramXmlReader.readDiagramType(diagramElement, origin, new XmlDiagramType());
        DiagramXmlReader reader = type.getDiagramReader();
        reader.setNewPaths(newPaths);
        reader.name = name;
        reader.module = module;
        reader.diagramInfo = diagramInfo;
        reader.getKernels = requestedKernels == null;
        Diagram diagram = reader.read(origin, type, document);
        DiagramXmlReader.getTitle(diagramElement, diagram);
        if (requestedKernels != null) {
            requestedKernels.addAll(reader.getRequestedKernelsNameList());
        }
        return diagram;
    }

    private Diagram read(DataCollection origin, DiagramType diagramType, Document doc) throws Exception {
        return this.read(origin, diagramType, doc.getDocumentElement());
    }

    private Diagram read(DataCollection origin, DiagramType diagramType, Element root) throws Exception {
        Element statesElement;
        Element diagramElement;
        if (root.hasAttribute("version")) {
            this.version = root.getAttribute("version");
        }
        if ((diagramElement = DiagramXmlReader.getElement(root, "diagram")) == null) {
            DiagramXmlReader.error("ERROR_DIAGRAM_ELEMENT_ABSENTS", new String[]{this.name});
            return null;
        }
        this.diagram = this.readDiagram(diagramElement, diagramType, origin);
        this.readRole(root, this.diagram);
        Element plotElement = DiagramXmlReader.getElement(diagramElement, "plots");
        if (plotElement != null) {
            DiagramXmlReader.readPlotsInfo(plotElement, this.diagram, this.newPaths);
        }
        if ((statesElement = DiagramXmlReader.getElement(root, "states")) == null) {
            statesElement = DiagramXmlReader.getElement(root, "experiments");
        }
        if (statesElement != null) {
            this.readStates(statesElement, this.diagram);
        }
        this.diagram.setNotificationEnabled(true);
        return this.diagram;
    }

    protected void readRole(Element root, Diagram diagram) {
        Element modelElement = DiagramXmlReader.getElement(root, "executableModel");
        if (modelElement != null) {
            ModelXmlReader reader = new ModelXmlReader(diagram);
            reader.setNewPaths(this.newPaths);
            diagram.setRole(reader.readModel(modelElement));
        }
    }

    private Diagram readDiagram(Element diagramElement, DiagramType diagramType, DataCollection origin) throws Exception {
        Element nodesElement;
        Layouter layouter;
        Element labelLayouterInfoElement;
        Layouter layouter2;
        Element layouterInfoElement;
        Element diagramInfoElement;
        this.diagram = null;
        if (this.diagramInfo == null) {
            this.diagramInfo = new DiagramInfo(this.name);
            diagramInfoElement = DiagramXmlReader.getElement(diagramElement, "diagramInfo");
            if (diagramInfoElement != null) {
                Element attrElement;
                if (diagramInfoElement.hasAttribute("value")) {
                    this.diagramInfo.setDescription(diagramInfoElement.getAttribute("value"));
                } else {
                    XmlStream.nodes((Element)diagramInfoElement).findFirst(child -> child.getNodeType() == 4).ifPresent(child -> this.diagramInfo.setDescription(child.getNodeValue()));
                }
                if (diagramInfoElement.hasAttribute("title")) {
                    this.diagramInfo.setTitle(diagramInfoElement.getAttribute("title"));
                }
                if (diagramInfoElement.hasAttribute("comment")) {
                    this.diagramInfo.setComment(diagramInfoElement.getAttribute("comment"));
                }
                if ((attrElement = DiagramXmlReader.getElement(diagramInfoElement, "attributes")) != null) {
                    DiagramXmlReader.fillProperties(attrElement, this.diagramInfo.getAttributes(), null);
                }
                ArrayList<DatabaseReference> dbRefs = new ArrayList<DatabaseReference>();
                for (Object dbRef : XmlUtil.elements((Element)diagramInfoElement, (String)"databaseReference")) {
                    dbRefs.add(new DatabaseReference(dbRef.getAttribute("value")));
                }
                if (!dbRefs.isEmpty()) {
                    this.diagramInfo.setDatabaseReferences(dbRefs.toArray(new DatabaseReference[dbRefs.size()]));
                }
                ArrayList<String> litRefs = new ArrayList<String>();
                for (Element litRef : XmlUtil.elements((Element)diagramInfoElement, (String)"literatureReference")) {
                    litRefs.add(litRef.getAttribute("value"));
                }
                if (!litRefs.isEmpty()) {
                    this.diagramInfo.setLiteratureReferences(litRefs.toArray(new String[litRefs.size()]));
                }
                this.readCreationInfo(this.diagramInfo, diagramInfoElement);
            }
        }
        try {
            DynamicPropertySet properties;
            if (diagramType == null) {
                diagramType = DiagramXmlReader.readDiagramType(diagramElement, origin, this.defaultDiagramType);
            }
            this.diagram = diagramType.createDiagram(origin, this.name, this.diagramInfo);
            diagramInfoElement = DiagramXmlReader.getElement(diagramElement, "diagramInfo");
            if (diagramInfoElement != null && (properties = diagramType.getProperties()) != null) {
                DiagramXmlReader.fillProperties(diagramInfoElement, this.diagram.getAttributes(), properties);
            }
        }
        catch (Throwable t) {
            DiagramXmlReader.error("ERROR_DIAGRAM_TYPE", new String[]{this.name, diagramElement.getAttribute("diagramType"), t.getMessage()});
        }
        this.diagram.setNotificationEnabled(false);
        Element viewOptionsElement = DiagramXmlReader.getElement(diagramElement, "viewOptions");
        if (viewOptionsElement != null) {
            DiagramXmlReader.readViewOptions(viewOptionsElement, this.diagram);
        }
        if ((layouterInfoElement = DiagramXmlReader.getElement(diagramElement, "layouterInfo")) != null && (layouter2 = DiagramXmlReader.readLayouterInfo(layouterInfoElement)) != null) {
            this.diagram.setPathLayouter(layouter2);
        }
        if ((labelLayouterInfoElement = DiagramXmlReader.getElement(diagramElement, "labelLayouterInfo")) != null && (layouter = DiagramXmlReader.readLayouterInfo(labelLayouterInfoElement)) != null) {
            this.diagram.setLabelLayouter(layouter);
        }
        if ((nodesElement = DiagramXmlReader.getElement(diagramElement, "nodes")) == null) {
            DiagramXmlReader.error("ERROR_NODES_ABSENT", new String[]{this.diagram.getName(), this.diagram.getName()});
        } else {
            this.readNodes(nodesElement, this.diagram);
        }
        this.diagram.setNotificationEnabled(false);
        Element edgesElement = DiagramXmlReader.getElement(diagramElement, "edges");
        if (edgesElement == null) {
            DiagramXmlReader.error("ERROR_EDGES_ABSENT", new String[]{this.diagram.getName(), this.diagram.getName()});
        } else {
            this.readEdges(edgesElement, this.diagram);
        }
        this.readAndApplyWrongEdges();
        this.diagram.setNotificationEnabled(true);
        Element filtersElement = DiagramXmlReader.getElement(diagramElement, "filters");
        if (filtersElement != null) {
            DiagramXmlReader.readFilters(filtersElement, this.diagram);
        }
        this.diagram.setNotificationEnabled(false);
        Element simulationElement = DiagramXmlReader.getElement(diagramElement, "simulationOptions");
        if (simulationElement != null) {
            DiagramXmlReader.readSimulationOptions(simulationElement, this.diagram);
        }
        this.diagram.setNodeViewBuilders();
        return this.diagram;
    }

    protected void readCreationInfo(DiagramInfo info, Element element) {
        ArrayList<DiagramInfo.AuthorInfo> authors = new ArrayList<DiagramInfo.AuthorInfo>();
        Element authorsElement = DiagramXmlReader.getElement(element, "authors");
        if (authorsElement != null) {
            for (Element authorElement : XmlUtil.elements((Element)authorsElement)) {
                DiagramInfo.AuthorInfo authorInfo = new DiagramInfo.AuthorInfo();
                authorInfo.setFamilyName(authorElement.getAttribute("familyName"));
                authorInfo.setGivenName(authorElement.getAttribute("givenName"));
                authorInfo.setEmail(authorElement.getAttribute("email"));
                authorInfo.setOrgName(authorElement.getAttribute("organisation"));
                authors.add(authorInfo);
            }
        }
        info.setAuthors(authors.toArray(new DiagramInfo.AuthorInfo[authors.size()]));
        Element historyElement = DiagramXmlReader.getElement(element, "history");
        if (historyElement != null) {
            Element createdElement = DiagramXmlReader.getElement(historyElement, "created");
            if (createdElement != null) {
                info.setCreated(createdElement.getAttribute("date"));
            }
            ArrayList<String> modified = new ArrayList<String>();
            for (Element modifiedElement : XmlUtil.elements((Element)historyElement, (String)"modified")) {
                modified.add(modifiedElement.getAttribute("date"));
            }
            info.setModified(modified.toArray(new String[modified.size()]));
        }
    }

    public static DiagramType readDiagramType(Element diagramElement, DataCollection origin, DiagramType defaultDiagramType) throws Exception {
        String pluginForClass;
        String type = diagramElement.getAttribute("diagramType");
        if (type.trim().length() == 0) {
            type = diagramElement.getAttribute("diagram_type");
        }
        if (type.equals("biouml.standard.diagram.OntologyDiagramType")) {
            type = "biouml.standard.diagram.SemanticNetworkDiagramType";
        }
        if (type.equals("biouml.standard.diagram.pathway.PathwayDiagramType")) {
            type = "biouml.standard.diagram.PathwayDiagramType";
        }
        if (type.equals("biouml.standard.diagram.pathway.PathwaySimulationDiagramType")) {
            type = "biouml.standard.diagram.PathwaySimulationDiagramType";
        }
        if (type.equals(XmlDiagramType.class.getName())) {
            DataElement xdt;
            String notation = diagramElement.getAttribute("notation");
            if (notation.startsWith("data/graphic notations/")) {
                notation = notation.replaceFirst("data/graphic notations", "databases/Utils/Diagrams/graphic notations");
            }
            return (xdt = CollectionFactory.getDataElement((String)notation)) != null ? ((XmlDiagramType)xdt).clone() : defaultDiagramType;
        }
        String pluginNames = null;
        if (origin != null) {
            pluginNames = origin.getInfo().getProperties().getProperty("plugins");
        }
        return (DiagramType)ClassLoading.loadSubClass((String)type, (String)((pluginForClass = ClassLoading.getPluginForClass((String)type)) == null ? pluginNames : pluginForClass), DiagramType.class).newInstance();
    }

    public Compartment createCompartment(Element element, String id, Base kernel, Compartment origin) {
        if (element.getNodeName().equals("equivalentNodeGroup")) {
            return new EquivalentNodeGroup((DataCollection)origin, id);
        }
        return new Compartment(origin, id, kernel);
    }

    public Node createNode(Element element, String id, Base kernel, Compartment origin) {
        return new Node(origin, id, kernel);
    }

    public Compartment readCompartment(Element compartmentElement, Compartment origin) {
        Compartment compartment;
        DiagramType diagramType;
        DynamicPropertySet properties;
        Element compartmentInfoElement = DiagramXmlReader.getElement(compartmentElement, "compartmentInfo");
        if (compartmentInfoElement == null) {
            DiagramXmlReader.error("ERROR_COMPARTMENT_INFO_ABSENTS", new String[]{this.diagram.getName(), "parent=" + origin.getName()});
            return null;
        }
        Base kernel = this.getKernel(compartmentInfoElement, origin);
        String id = kernel.getName();
        if (compartmentElement.hasAttribute("id")) {
            id = compartmentElement.getAttribute("id");
        }
        if (compartmentInfoElement.hasAttribute("id")) {
            id = compartmentInfoElement.getAttribute("id");
        }
        if ((properties = (diagramType = Diagram.getDiagram(compartment = this.createCompartment(compartmentElement, id, kernel, origin)).getType()).getProperties()) != null) {
            DiagramXmlReader.fillProperties(compartmentElement, compartment.getAttributes(), properties);
            if (diagramType instanceof XmlDiagramType) {
                ((XmlDiagramType)diagramType).fillPropertyEditorParameters(compartment.getAttributes());
            }
        }
        compartment = (Compartment)this.validate(origin, compartment);
        compartment.setNotificationEnabled(false);
        DiagramXmlReader.readCompartmentInfo(compartmentInfoElement, compartment, this.diagram.getName());
        DiagramXmlReader.readComment(compartment, compartmentInfoElement);
        Element nodesElement = DiagramXmlReader.getElement(compartmentElement, "nodes");
        if (nodesElement == null) {
            DiagramXmlReader.error("ERROR_NODES_ABSENT", new String[]{this.diagram.getName(), compartment.getName()});
        } else {
            this.readNodes(nodesElement, compartment);
        }
        Element edgesElement = DiagramXmlReader.getElement(compartmentElement, "edges");
        if (edgesElement == null) {
            DiagramXmlReader.error("ERROR_EDGES_ABSENT", new String[]{this.diagram.getName(), compartment.getName()});
        } else {
            this.readEdges(edgesElement, compartment);
        }
        compartment.setNotificationEnabled(true);
        return compartment;
    }

    @Override
    public void readNodes(Element nodesElement, Compartment compartment) {
        NodeList list = nodesElement.getChildNodes();
        for (Element element : XmlUtil.elements((NodeList)list)) {
            try {
                boolean notificationEnabled = compartment.isNotificationEnabled();
                compartment.setNotificationEnabled(false);
                Node node = null;
                String nodeName = element.getNodeName();
                if (nodeName.equals("compartment")) {
                    node = this.readCompartment(element, compartment);
                } else if (nodeName.equals("equivalentNodeGroup")) {
                    node = this.readCompartment(element, compartment);
                } else if (nodeName.equals("node")) {
                    node = this.readNode(element, compartment);
                } else if (nodeName.equals("subdiagram")) {
                    node = this.readSubDiagram(element, compartment);
                } else if (nodeName.equals("modelDefinition")) {
                    node = this.readModelDefinition(element, compartment);
                }
                compartment.setNotificationEnabled(notificationEnabled);
                if (node == null) continue;
                compartment.put(node);
            }
            catch (Throwable t) {
                DiagramXmlReader.error("ERROR_READ_NODES", new String[]{this.diagram.getName(), compartment.getName(), t.getMessage()}, t);
            }
        }
    }

    private Node readModelDefinition(Element element, Compartment compartment) {
        try {
            String id = element.getAttribute("id");
            DiagramXmlReader reader = new DiagramXmlReader(id);
            Diagram innerDiagram = reader.read(null, null, DiagramXmlReader.getElement(element, "dml"));
            ModelDefinition modelDefinition = new ModelDefinition(compartment, innerDiagram, id);
            DiagramType diagramType = this.readInfo(element, modelDefinition);
            return (Compartment)diagramType.getSemanticController().validate(compartment, modelDefinition);
        }
        catch (Throwable t) {
            DiagramXmlReader.error("ERROR_READ_MODEL_DEFINITION", new String[]{this.diagram.getName(), compartment.getName(), t.getMessage()}, t);
            return null;
        }
    }

    private DiagramType readInfo(Element element, DiagramContainer compartment) {
        Element compartmentInfoElement = DiagramXmlReader.getElement(element, "compartmentInfo");
        if (compartmentInfoElement == null) {
            compartment.setLocation(DiagramXmlReader.readLocation(element, compartment.getName(), this.diagram.getName()));
            compartment.setShapeSize(DiagramXmlReader.readDimension(element, this.diagram.getName(), compartment.getName()));
        } else {
            DiagramXmlReader.readCompartmentInfo(compartmentInfoElement, compartment, this.diagram.getName());
            DiagramXmlReader.readComment(compartment, compartmentInfoElement);
        }
        DiagramType diagramType = Diagram.getDiagram(compartment).getType();
        DynamicPropertySet properties = diagramType.getProperties();
        if (properties != null) {
            DiagramXmlReader.fillProperties(element, compartment.getAttributes(), properties);
            if (diagramType instanceof XmlDiagramType) {
                ((XmlDiagramType)diagramType).fillPropertyEditorParameters(compartment.getAttributes());
            }
        }
        return diagramType;
    }

    protected Compartment readSubDiagram(Element subdiagramElement, Compartment compartment) {
        try {
            Element nodesElement;
            Diagram associatedDiagram;
            String name = subdiagramElement.getAttribute("id");
            String stateName = subdiagramElement.getAttribute("diagramState");
            String modelDefName = subdiagramElement.getAttribute("modelDefinition");
            if (modelDefName.isEmpty()) {
                String diagramPath = subdiagramElement.getAttribute("diagram");
                if (this.newPaths != null && this.newPaths.containsKey(diagramPath)) {
                    diagramPath = this.newPaths.get(diagramPath);
                }
                DataElementPath elementPath = DataElementPath.create((String)diagramPath);
                associatedDiagram = (Diagram)elementPath.getDataElement(Diagram.class);
            } else {
                Node node = Diagram.getDiagram(compartment).findNode(modelDefName);
                if (node instanceof ModelDefinition) {
                    associatedDiagram = ((ModelDefinition)node).getDiagram();
                } else {
                    return null;
                }
            }
            SubDiagram subDiagram = new SubDiagram(compartment, associatedDiagram, name);
            DiagramXmlReader.readSubDiagramState(DiagramXmlReader.getElement(subdiagramElement, "state"), subDiagram);
            State state = subDiagram.getDiagram().getState(stateName);
            if (state != null) {
                subDiagram.setStateName(state.getName());
            }
            if ((nodesElement = DiagramXmlReader.getElement(subdiagramElement, "nodes")) != null) {
                this.readNodes(nodesElement, subDiagram);
            }
            DiagramType diagramType = this.readInfo(subdiagramElement, subDiagram);
            this.readPortInfos(subDiagram, subdiagramElement);
            subDiagram.updatePorts();
            return (Compartment)diagramType.getSemanticController().validate(compartment, subDiagram);
        }
        catch (Throwable t) {
            DiagramXmlReader.error("ERROR_READ_SUBDIAGRAM", new String[]{this.diagram.getName(), compartment.getName(), t.getMessage()}, t);
            return null;
        }
    }

    private void readPortInfos(SubDiagram subDiagram, Element subdiagramElement) throws Exception {
        NodeList list = subdiagramElement.getChildNodes();
        Diagram associatedDiagram = subDiagram.getDiagram();
        for (Element element : XmlUtil.elements((NodeList)list)) {
            DiagramElement node;
            String nodeName;
            if (!element.getNodeName().equals("port") || (nodeName = element.getAttribute("node")).isEmpty() || !((node = associatedDiagram.get(nodeName)) instanceof Node)) continue;
            Point location = DiagramXmlReader.readLocation(element, nodeName, this.diagram.getName());
            location.translate(subDiagram.getLocation().x, subDiagram.getLocation().y);
            Node portNode = SubDiagram.createPort((Node)node, subDiagram, location);
            String orientation = element.getAttribute("orientation");
            if (orientation.isEmpty()) continue;
            portNode.getAttributes().add(DPSUtils.createHiddenReadOnly((String)"orientation", SubDiagram.PortOrientation.class, (Object)((Object)SubDiagram.PortOrientation.getOrientation(orientation))));
        }
    }

    public Node readNode(Element element, Compartment compartment) {
        Base kernel = this.getKernel(element, compartment);
        String id = kernel.getName();
        if (element.hasAttribute("id")) {
            id = element.getAttribute("id");
        }
        Node node = this.createNode(element, id, kernel, compartment);
        if (kernel instanceof Reaction) {
            ((Reaction)kernel).setParent((Option)node);
        }
        DiagramXmlReader.readComment(node, element);
        DiagramXmlReader.readNodeInfo(element, node, this.diagram.getName());
        return (Node)this.validate(compartment, node);
    }

    @Override
    public void readEdges(Element edgesElement, Compartment compartment) {
        NodeList list = edgesElement.getChildNodes();
        for (Element element : XmlUtil.elements((NodeList)list)) {
            try {
                if (!element.getNodeName().equals("edge")) continue;
                boolean notificationEnabled = compartment.isNotificationEnabled();
                compartment.setNotificationEnabled(false);
                Edge edge = this.readEdge(element, compartment);
                compartment.setNotificationEnabled(notificationEnabled);
                if (edge == null) continue;
                compartment.put(edge);
            }
            catch (Throwable t) {
                DiagramXmlReader.error("ERROR_READ_EDGES", new String[]{this.diagram.getName(), compartment.getName(), t.getMessage()}, t);
            }
        }
    }

    public Edge readEdge(Element edgeElement, Compartment compartment) {
        Edge edge;
        String outRef = edgeElement.getAttribute("out");
        Node outNode = DiagramXmlReader.findNestedNode(compartment, outRef);
        if (outNode == null) {
            this.wrongEdges.put(edgeElement, compartment);
            return null;
        }
        String inRef = edgeElement.getAttribute("in");
        Node inNode = DiagramXmlReader.findNestedNode(compartment, inRef);
        if (inNode == null) {
            this.wrongEdges.put(edgeElement, compartment);
            return null;
        }
        Base kernel = outNode.getKernel() instanceof Reaction ? this.getKernel(edgeElement, outNode.getCompartment()) : (inNode.getKernel() instanceof Reaction ? this.getKernel(edgeElement, inNode.getCompartment()) : this.getKernel(edgeElement, compartment));
        if (edgeElement.hasAttribute("id")) {
            String id = edgeElement.getAttribute("id");
            edge = new Edge(compartment, id, kernel, inNode, outNode);
        } else {
            String id = Edge.getUniqEdgeName(compartment, kernel, inNode, outNode);
            if (this.version.equals("0.7.0") || this.version.equals("0.7.1") || this.version.equals("0.7.2") || this.version.equals("0.7.3") || this.version.equals("0.7.4") || this.version.equals("0.7.5") || this.version.equals("0.7.6")) {
                id = Edge.getUniqEdgeName(compartment, kernel, null, null);
            }
            edge = new Edge(compartment, id, kernel, inNode, outNode);
        }
        DiagramXmlReader.readComment(edge, edgeElement);
        DiagramXmlReader.readEdgeInfo(edgeElement, edge, this.diagram.getName());
        this.readEdgeRole(edgeElement, edge, this.diagram.getName());
        return (Edge)this.validate(compartment, edge);
    }

    private void readAndApplyWrongEdges() {
        if (this.wrongEdges.size() > 0) {
            log.log(Level.SEVERE, "Diagram contains some wrong edges - if it is possible, please resave this diagram.");
        }
        for (Map.Entry<Element, Compartment> entry : this.wrongEdges.entrySet()) {
            Element edgeElement = entry.getKey();
            Compartment compartment = entry.getValue();
            try {
                String kernelRef = edgeElement.getAttribute("kernel");
                Base kernel = this.getKernel(edgeElement, compartment);
                String inRef = edgeElement.getAttribute("in");
                Node inNode = DiagramXmlReader.findNestedNode(compartment, inRef);
                if (inNode == null && inRef.equals(compartment.getName())) {
                    inNode = compartment;
                }
                if (inNode == null && inRef.contentEquals(this.diagram.getName())) {
                    inRef = inRef.substring(inRef.indexOf(this.diagram.getName()) + this.diagram.getName().length() + 1, inRef.length());
                }
                if ((inNode = DiagramXmlReader.findNestedNode(this.diagram, inRef)) == null) {
                    DiagramXmlReader.error("ERROR_NODE_NOT_FOUND", new String[]{this.diagram.getName(), kernelRef, inRef});
                    continue;
                }
                String outRef = edgeElement.getAttribute("out");
                Node outNode = DiagramXmlReader.findNestedNode(compartment, outRef);
                if (outNode == null && outRef.equals(compartment.getName())) {
                    outNode = compartment;
                }
                if (outNode == null && outRef.contains(this.diagram.getName())) {
                    outRef = outRef.substring(outRef.indexOf(this.diagram.getName()) + this.diagram.getName().length() + 1, outRef.length());
                    outNode = DiagramXmlReader.findNestedNode(this.diagram, outRef);
                }
                if (outNode == null) {
                    DiagramXmlReader.error("ERROR_NODE_NOT_FOUND", new String[]{this.diagram.getName(), kernelRef, outRef});
                    continue;
                }
                Edge edge = new Edge(kernel, inNode, outNode);
                DiagramXmlReader.readComment(edge, edgeElement);
                DiagramXmlReader.readEdgeInfo(edgeElement, edge, this.diagram.getName());
                edge.save();
            }
            catch (Throwable t) {
                DiagramXmlReader.error("ERROR_READ_EDGES", new String[]{this.diagram.getName(), compartment.getName(), t.getMessage()}, t);
            }
        }
    }

    private DiagramElement validate(Compartment compartment, DiagramElement de) {
        try {
            return this.diagram.getType().getSemanticController().validate(compartment, de);
        }
        catch (Exception e) {
            log.warning("Can not validate element: " + de.getName());
            return de;
        }
    }

    private static Node findNestedNode(Compartment compartment, String name) {
        Node node = null;
        try {
            Object de = CollectionFactory.getDataElement((String)name, (DataCollection)compartment);
            if (de instanceof Node) {
                return (Node)((Object)de);
            }
            Compartment nestedCompartment = null;
            int oldPos = 0;
            int pos = 0;
            while (nestedCompartment == null) {
                pos = name.indexOf(".", oldPos);
                if (pos <= oldPos) {
                    de = compartment.get(name);
                    break;
                }
                String s1 = name.substring(oldPos, pos);
                if (compartment.getName().equals(s1)) {
                    return DiagramXmlReader.findNestedNode(compartment, name.substring(pos + 1));
                }
                String str = name.substring(0, pos);
                nestedCompartment = (Compartment)compartment.get(str);
                oldPos = pos + 1;
            }
            if (de instanceof Node) {
                node = (Node)((Object)de);
            }
            if (nestedCompartment != null) {
                return DiagramXmlReader.findNestedNode(nestedCompartment, name.substring(pos + 1));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error during node search: ", t);
        }
        return node;
    }

    public void readStates(Element element, Diagram diagram) {
        if (element == null) {
            return;
        }
        NodeList list = element.getChildNodes();
        for (Element child : XmlUtil.elements((NodeList)list)) {
            diagram.addState(StateXmlSerializer.readXmlElement(child, diagram, this));
        }
    }

    @Nonnull
    public List<String> getRequestedKernelsNameList() {
        return this.getKernels ? new ArrayList() : this.kernelNames;
    }

    protected Base getKernel(Element element, Compartment compartment) {
        String name = element.getAttribute("kernel");
        Base kernel = null;
        DataElementPath kernelRef = DataElementPath.create((String)name);
        try {
            if (kernelRef.isDescendantOf(this.diagram.getCompletePath())) {
                throw new KernelNotFoundException(name);
            }
            if (name.startsWith("stub")) {
                Element attrElement;
                String simpleName = kernelRef.getName();
                String type = element.getAttribute("kernel_type");
                if (type.isEmpty()) {
                    type = "unknown";
                }
                if (type.equals("compartment")) {
                    kernel = new biouml.standard.type.Compartment(null, simpleName);
                } else if (type.equals("note")) {
                    kernel = new Stub.Note(null, simpleName);
                } else if (type.equals("output connection port")) {
                    kernel = new Stub.OutputConnectionPort(null, simpleName);
                } else if (type.equals("input connection port")) {
                    kernel = new Stub.InputConnectionPort(null, simpleName);
                } else if (type.equals("contact connection port")) {
                    kernel = new Stub.ContactConnectionPort(null, simpleName);
                } else if (type.equals("connection bus")) {
                    kernel = new Stub.Bus(null, simpleName);
                } else if (type.equals("note-edge")) {
                    kernel = new Stub.NoteLink(null, simpleName);
                } else if (type.equals("adapter")) {
                    kernel = new Stub.AveragerElement(null, simpleName);
                } else if (type.equals("switch")) {
                    kernel = new Stub.SwitchElement(null, simpleName);
                } else if (type.equals("constant")) {
                    kernel = new Stub.Constant(null, simpleName);
                } else if (type.equals("dependency")) {
                    kernel = new Stub.Dependency(null, simpleName);
                } else if (type.equals("directed-edge")) {
                    kernel = new Stub.DirectedConnection(null, simpleName);
                } else if (type.equals("undirected-edge")) {
                    kernel = new Stub.UndirectedConnection(null, simpleName);
                } else if (type.equals("relation-semantic")) {
                    kernel = new SemanticRelation(null, simpleName);
                } else if (type.equals("plot")) {
                    kernel = new Stub.PlotElement(null, simpleName);
                } else if (type.equals("relation-chemical")) {
                    DataElement de;
                    DataElementPath refName = DataElementPath.create((String)name.substring("stub".length() + 1));
                    if (refName.getParentPath().isDescendantOf(this.diagram.getCompletePath())) {
                        throw new KernelNotFoundException(name);
                    }
                    DataCollection origin = refName.optParentCollection();
                    if (origin == null && (de = CollectionFactory.getDataElement((String)refName.getParentPath().getName(), (DataCollection)compartment)) instanceof Node && ((Node)de).getKernel() instanceof DataCollection) {
                        origin = (DataCollection)((Node)de).getKernel();
                        kernel = (Base)origin.get(refName.getName());
                    }
                    if (kernel == null) {
                        kernel = new SpecieReference((DataCollection<?>)origin, refName.getName());
                    }
                } else {
                    kernel = type.equals("reaction") ? this.getReactionKernel(element, simpleName) : new Stub(null, simpleName, type);
                }
                String title = element.getAttribute("title");
                if (!title.isEmpty() && kernel instanceof BaseSupport) {
                    ((BaseSupport)kernel).setTitle(title);
                }
                if ((attrElement = DiagramXmlReader.getElement(element, "attributes")) != null) {
                    DiagramXmlReader.fillProperties(attrElement, kernel.getAttributes(), null);
                }
            } else if (this.getKernels) {
                boolean isDiagramName;
                DataElementPath path;
                DataElementPath dataElementPath = path = TextUtil.isFullPath((String)name) || this.module == null ? kernelRef : this.module.getCompletePath().getRelativePath("./" + name);
                if (path.getParentPath().isDescendantOf(this.diagram.getCompletePath())) {
                    throw new KernelNotFoundException(name);
                }
                DataCollection origin = path.getParentCollection();
                DataElementDescriptor descriptor = origin.getDescriptor(path.getName());
                boolean bl = isDiagramName = descriptor != null && Diagram.class.isAssignableFrom(descriptor.getType());
                if (!isDiagramName) {
                    if (this.module != null) {
                        DataElement tmpKernel = this.module.getKernel(name);
                        if (tmpKernel instanceof Base) {
                            kernel = (Base)tmpKernel;
                        }
                    } else {
                        kernel = (Base)CollectionFactory.getDataElement((String)name);
                    }
                    if (kernel == null) {
                        throw new KernelNotFoundException(name);
                    }
                }
            } else {
                String[] components = kernelRef.getPathComponents();
                if (components.length > 0) {
                    DataElementPath tempName = DataElementPath.create((String)components[0]);
                    for (int i = 1; i < components.length; ++i) {
                        DataElement de;
                        String nextName = components[i];
                        DataElementPath path = tempName.getChildPath(new String[]{nextName});
                        if (path.equals((Object)kernelRef)) {
                            this.kernelNames.add(name);
                            kernel = new Stub(null, nextName);
                            break;
                        }
                        if (this.module != null) {
                            de = this.module.getKernel(path.toString());
                        } else {
                            if (path.isDescendantOf(this.diagram.getCompletePath())) {
                                throw new KernelNotFoundException(name);
                            }
                            de = path.optDataElement();
                        }
                        if (de != null && this.module != null && this.module.getType().isCategorySupported()) {
                            String reaction = this.module.getType().getCategory(Reaction.class);
                            if (("Data/" + DataElementPath.escapeName((String)de.getName())).equals(reaction)) {
                                if (i >= components.length - 1) break;
                                String reactionName = components[++i];
                                path = tempName.getChildPath(new String[]{de.getName(), reactionName});
                                kernel = new Stub(null, reactionName);
                                this.kernelNames.add(path.toString());
                                break;
                            }
                        }
                        if (de == null) {
                            this.kernelNames.add(tempName.toString());
                            break;
                        }
                        tempName = path;
                    }
                    if (kernel == null) {
                        String stubName = name;
                        if (tempName.isAncestorOf(kernelRef)) {
                            stubName = kernelRef.getPathDifference(tempName);
                        }
                        kernel = new Stub(null, stubName);
                    }
                }
                if (kernel == null) {
                    throw new KernelNotFoundException(name);
                }
            }
        }
        catch (KernelNotFoundException e) {
            kernel = new Stub(null, kernelRef.getName());
            DiagramXmlReader.error("ERROR_KERNEL_PROCESSING", new String[]{this.diagram.getCompletePath().toString(), name, e.getMessage()});
        }
        catch (Throwable t) {
            kernel = new Stub(null, kernelRef.getName());
            DiagramXmlReader.error("ERROR_KERNEL_PROCESSING", new String[]{this.diagram.getCompletePath().toString(), name, t.getMessage()}, t);
        }
        return kernel;
    }

    public Base getReactionKernel(Element element, String simpleName) {
        NodeList list;
        Element reactionElement = DiagramXmlReader.getElement(element, "reaction");
        if (reactionElement == null) {
            return new Stub(null, simpleName, "reaction");
        }
        Reaction reaction = new Reaction(null, simpleName);
        if (reactionElement.hasAttribute("formula")) {
            reaction.getKineticLaw().setFormula(reactionElement.getAttribute("formula"));
        }
        if ((list = element.getElementsByTagName("specieReference")) != null) {
            for (Element srElement : XmlUtil.elements((NodeList)list)) {
                try {
                    SpecieReference sr = new SpecieReference(reaction, srElement.getAttribute("name"));
                    String role = srElement.getAttribute("role");
                    if (!role.isEmpty()) {
                        sr.setRole(role);
                        if (role.equals("modifier")) {
                            sr.setModifierAction(srElement.getAttribute("modifierAction"));
                        }
                    }
                    sr.setSpecie(srElement.getAttribute("specie"));
                    sr.setStoichiometry(srElement.getAttribute("stoichiometry"));
                    sr.setParticipation(srElement.getAttribute("participation"));
                    sr.setComment(srElement.getAttribute("comment"));
                    reaction.put(sr);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Cannot read SpecieReference", e);
                }
            }
        }
        return reaction;
    }

    public static void fillProperties(Element element, DynamicPropertySet dps, DynamicPropertySet registry) {
        NodeList nodeList = element.getChildNodes();
        for (Element e : XmlUtil.elements((NodeList)nodeList)) {
            if (!"property".equals(e.getTagName()) && !"propertyRef".equals(e.getTagName())) continue;
            try {
                DynamicProperty property = DiagramXmlReader.getProperty(registry, e);
                if (property == null) continue;
                dps.add(property);
            }
            catch (Throwable t) {
                DiagramXmlReader.error("ERROR_PARSING_PROPERTY", new String[]{e.getTagName()}, t);
            }
        }
    }

    private static DynamicProperty getProperty(DynamicPropertySet registry, Element e) throws Exception {
        if ("propertyRef".equals(e.getTagName())) {
            DynamicProperty property;
            String name = e.getAttribute("name");
            String value = e.getAttribute("value");
            DynamicProperty dynamicProperty = property = registry != null ? registry.getProperty(name) : null;
            if (property == null) {
                DiagramXmlReader.error("UNDEFINED_PROPERTY_REF", new String[]{name, value});
                return null;
            }
            if (DynamicPropertySet.class.isAssignableFrom(property.getType())) {
                DynamicPropertySet v = DiagramXmlReader.readDPS(e, DiagramXmlReader.getNestedRegistry(name, registry));
                return new DynamicProperty(property.getDescriptor(), property.getType(), (Object)v);
            }
            if (property.getType() != null && property.getType().isArray()) {
                Class<?> componentType = property.getType().getComponentType();
                return new DynamicProperty(property.getDescriptor(), property.getType(), DiagramXmlReader.readPropertyArray(e, name, componentType, registry));
            }
            return new DynamicProperty(property.getDescriptor(), property.getType(), DiagramXmlReader.getPropertyValue(e, name, property.getType(), value, registry));
        }
        if ("property".equals(e.getTagName())) {
            String name = e.getAttribute("name");
            String value = e.getAttribute("value");
            String type = e.getAttribute("type");
            String shortDescr = e.getAttribute("short-description");
            Class<Object> propertyType = DiagramXmlReader.getPropertyType(type);
            if (DiagramXmlSupport.Composite.class.equals(propertyType)) {
                DynamicPropertySet v = DiagramXmlReader.readDPS(e, DiagramXmlReader.getNestedRegistry(name, registry));
                return new DynamicProperty(name, name, DynamicPropertySet.class, (Object)v);
            }
            if (DiagramXmlSupport.Array.class.equals(propertyType)) {
                String elementType = e.getAttribute("elementType");
                if ((elementType == null || "".equals(elementType)) && DiagramXmlReader.getClosestSiblingElementList(e, "item").size() > 0) {
                    DiagramXmlReader.error("ERROR_ARRAY_NO_ELEMENT_TYPE", new String[]{name, type});
                    propertyType = DiagramXmlSupport.Composite.class;
                } else {
                    propertyType = DiagramXmlReader.getPropertyType(elementType);
                }
                if (propertyType != null) {
                    return new DynamicProperty(name, name, Array.newInstance(propertyType, 0).getClass(), DiagramXmlReader.readPropertyArray(e, name, propertyType, registry));
                }
                DiagramXmlReader.error("ERROR_COULD_NOT_RESOLVE_TYPE", new String[]{name, type});
            }
            if (propertyType == null) {
                DiagramXmlReader.error("ERROR_COULD_NOT_RESOLVE_TYPE", new String[]{name, type});
            } else {
                DynamicProperty dp = new DynamicProperty(name, name, propertyType, DiagramXmlReader.getPropertyValue(e, name, propertyType, value, registry));
                dp.setShortDescription(shortDescr);
                DiagramXmlReader.readPropertyAttributes(e, dp);
                String[] tagsArray = (String[])XmlStream.elements((Element)e, (String)"tags").flatMap(tags -> XmlStream.elements((Element)tags, (String)"tag")).map(tag -> tag.getAttribute("value")).toArray(String[]::new);
                if (tagsArray.length > 0) {
                    dp.getDescriptor().setValue("TAGS", tagsArray);
                }
                return dp;
            }
        }
        return null;
    }

    private static void readPropertyAttributes(Element e, DynamicProperty dp) {
        String isHidden;
        String isReadOnly = e.getAttribute("isReadOnly");
        if (isReadOnly != null && !isReadOnly.isEmpty()) {
            dp.setReadOnly(Boolean.parseBoolean(isReadOnly));
        }
        if ((isHidden = e.getAttribute("isHidden")) != null && !isHidden.isEmpty()) {
            dp.setHidden(Boolean.parseBoolean(isHidden));
        }
    }

    private static Object readPropertyArray(Element element, String name, Class<?> type, DynamicPropertySet registry) throws Exception {
        if (String.class.equals(type) || type.isPrimitive() || XmlSerializationUtils.isPrimitiveWrapperElement(type) || !DiagramXmlSupport.Composite.class.isAssignableFrom(type) && !DynamicPropertySet.class.isAssignableFrom(type)) {
            List<Element> items = DiagramXmlReader.getClosestSiblingElementList(element, "item");
            int j = 0;
            Object[] array = (Object[])Array.newInstance(type, items.size());
            if (String.class.equals(type)) {
                for (Element e : items) {
                    array[j++] = e.getFirstChild().getNodeValue();
                }
            } else if (type.isPrimitive() || XmlSerializationUtils.isPrimitiveWrapperElement(type)) {
                for (Element e : items) {
                    array[j++] = XmlSerializationUtils.getPrimitiveValue(type, e.getFirstChild().getNodeValue());
                }
            } else if (!DynamicPropertySet.class.isAssignableFrom(type)) {
                if (DiagramXmlReader.isEligibleToTextUtil(type)) {
                    for (Element e : items) {
                        array[j++] = TextUtil.fromString(type, (String)e.getFirstChild().getNodeValue());
                    }
                } else {
                    for (Element e : items) {
                        Object arrayElement = type.newInstance();
                        DynamicPropertySetAsMap defaults = new DynamicPropertySetAsMap();
                        DPSUtils.writeBeanToDPS(arrayElement, (DynamicPropertySet)defaults, (String)"");
                        DynamicPropertySet dps = DiagramXmlReader.readDPS(e, (DynamicPropertySet)defaults);
                        DPSUtils.readBeanFromDPS(arrayElement, (DynamicPropertySet)dps, (String)"");
                        array[j++] = arrayElement;
                    }
                }
            }
            return array;
        }
        if (registry == null) {
            ArrayList<DynamicProperty> list = new ArrayList<DynamicProperty>();
            List<Element> properties = DiagramXmlReader.getClosestSiblingElementList(element);
            for (Element p : properties) {
                if (!"property".equals(p.getTagName()) && !"propertyRef".equals(p.getTagName())) continue;
                list.add(DiagramXmlReader.getProperty(null, p));
            }
            return list.toArray(new DynamicProperty[list.size()]);
        }
        ArrayList<DynamicPropertySet> list = new ArrayList<DynamicPropertySet>();
        List<Element> properties = DiagramXmlReader.getClosestSiblingElementList(element);
        for (Element p : properties) {
            if (!"property".equals(p.getTagName()) && !"propertyRef".equals(p.getTagName())) continue;
            list.add(DiagramXmlReader.readDPS(p, DiagramXmlReader.getNestedRegistry(name, registry)));
        }
        return list.toArray(new DynamicPropertySet[list.size()]);
    }

    public static DynamicPropertySet readDPS(Element element, DynamicPropertySet registry) {
        DynamicPropertySetSupport dps = new DynamicPropertySetSupport();
        DiagramXmlReader.fillProperties(element, (DynamicPropertySet)dps, registry);
        return dps;
    }

    private static List<Element> getClosestSiblingElementList(Element e) {
        return DiagramXmlReader.getClosestSiblingElementList(e, null);
    }

    private static List<Element> getClosestSiblingElementList(Element e, String tagName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodeList = e.getChildNodes();
        for (Element elem : XmlUtil.elements((NodeList)nodeList)) {
            if (tagName != null && !tagName.equals(elem.getTagName())) continue;
            elements.add(elem);
        }
        return elements;
    }

    private static DynamicPropertySet getNestedRegistry(String name, DynamicPropertySet registry) {
        DynamicPropertySetAsMap dps;
        if (registry == null) {
            return null;
        }
        DynamicProperty property = registry.getProperty(name);
        if (property == null) {
            return null;
        }
        if (!(property.getValue() instanceof DynamicPropertySet)) {
            dps = new DynamicPropertySetAsMap();
            DPSUtils.writeBeanToDPS((Object)property.getValue(), (DynamicPropertySet)dps, (String)"");
        } else {
            dps = (DynamicPropertySet)property.getValue();
        }
        return dps;
    }

    private static Object getPropertyValue(Element element, String name, Class<?> type, String value, DynamicPropertySet registry) {
        List<Element> properties = DiagramXmlReader.getClosestSiblingElementList(element, "property");
        List<Element> propertyRefs = DiagramXmlReader.getClosestSiblingElementList(element, "propertyRef");
        if (properties.size() > 0 || propertyRefs.size() > 0) {
            DynamicPropertySet dps = DiagramXmlReader.readDPS(element, DiagramXmlReader.getNestedRegistry(name, registry));
            if (type != null) {
                Object result = TextUtil.fromString(type, (String)value);
                if (result == null) {
                    try {
                        result = type.newInstance();
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error while reading diagram: unable to create object of type " + type.getName());
                        return null;
                    }
                }
                DPSUtils.readBeanFromDPS((Object)result, (DynamicPropertySet)dps, (String)"");
                return result;
            }
            return dps;
        }
        if (String.class.equals(type)) {
            return value;
        }
        if (Pen.class.equals(type)) {
            return XmlSerializationUtils.readPen(value);
        }
        if (Brush.class.equals(type)) {
            return XmlSerializationUtils.readBrush(value);
        }
        if (Dimension.class.equals(type)) {
            return XmlSerializationUtils.readDimension(value);
        }
        if (Point.class.equals(type)) {
            return XmlSerializationUtils.readPoint(value);
        }
        if (ColorFont.class.equals(type)) {
            return XmlSerializationUtils.readFont(value);
        }
        if (SubDiagram.PortOrientation.class.equals(type)) {
            return SubDiagram.PortOrientation.getOrientation(value);
        }
        Object result = TextUtil.fromString(type, (String)value);
        if (result != null) {
            return result;
        }
        result = XmlSerializationUtils.getPrimitiveValue(type, value);
        try {
            if (result == null && registry.getValue(name) != null && value.isEmpty()) {
                return type.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Diagram parseDiagram(String name, Element diagramElement, DataCollection<?> origin, DiagramType diagramType) {
        try {
            DiagramXmlReader dxr = new DiagramXmlReader(name, null, null);
            dxr.setDefaultDiagramType(diagramType);
            return dxr.readDiagram(diagramElement, null, origin);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setDiagram(Diagram d) {
        this.diagram = d;
    }

    public static void readSubDiagramState(Element stateElement, SubDiagram subDiagram) {
        if (stateElement == null) {
            return;
        }
        Diagram innerDiagram = subDiagram.getDiagram();
        DiagramXmlReader reader = new DiagramXmlReader(innerDiagram.getName());
        reader.setDiagram(innerDiagram);
        State oldState = innerDiagram.getState("SubdiagramState");
        if (oldState != null) {
            innerDiagram.removeState(oldState);
        }
        innerDiagram.addState(StateXmlSerializer.readXmlElement(stateElement, innerDiagram, reader));
    }

    public static void readStyle(Element element, DiagramElement de) {
        boolean customStyle;
        String style = element.getAttribute("style");
        if (!style.isEmpty()) {
            de.setPredefinedStyle(style);
            return;
        }
        boolean bl = customStyle = element.hasAttribute("pen") || element.hasAttribute("color") || element.hasAttribute("font");
        if (!customStyle) {
            return;
        }
        de.setPredefinedStyle("Not selected");
        Pen pen = XmlSerializationUtils.readPen(element.getAttribute("pen"));
        de.getCustomStyle().setPen(pen);
        Brush brush = new Brush(DiagramXmlReader.stringToColor(element.getAttribute("color"), Diagram.getDiagram(de).getName(), de.getName()));
        de.getCustomStyle().setBrush(brush);
        ColorFont font = XmlSerializationUtils.readFont(element.getAttribute("font"));
        if (font != null) {
            de.getCustomStyle().setFont(font);
        }
    }

    public static Document createDocument(String name, InputStream stream, DiagramInfo diagramInfo) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        String xml = ApplicationUtils.readAsString((InputStream)stream);
        xml = DiagramXmlReader.normalizeXml(xml);
        stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        try {
            return builder.parse(stream);
        }
        catch (SAXException e) {
            log.log(Level.SEVERE, "Parse diagram \"" + name + "\" error: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            int finish;
            log.log(Level.SEVERE, "Read diagram \"" + name + "\" error: " + e.getMessage());
            int start = xml.indexOf("<![CDATA[");
            if (start >= 0 && (finish = xml.indexOf("]]>")) > start + 9) {
                xml = xml.substring(0, start + 9) + "Invalid diagram" + xml.substring(finish, xml.length());
            }
            stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            try {
                return builder.parse(stream);
            }
            catch (IOException | SAXException e2) {
                return null;
            }
        }
    }

    private static String normalizeXml(String xmlStr) {
        char[] xml = xmlStr.toCharArray();
        block3: for (int i = 0; i < xml.length; ++i) {
            switch (xml[i]) {
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u000b': 
                case '\f': 
                case '\u000f': 
                case '\u0012': 
                case '\u0014': 
                case '\u0016': 
                case '\u001a': 
                case '\u001c': 
                case '\u001e': 
                case '\u0092': 
                case '\u00ff': {
                    xml[i] = 63;
                    continue block3;
                }
            }
        }
        return new String(xml);
    }

    private static class KernelNotFoundException
    extends Exception {
        public KernelNotFoundException(String kernelPath) {
            super("Kernel not found: " + kernelPath);
        }
    }
}

