/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramExporter;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.SpecieReference;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;

public class DiagramPairGraphExporter
extends DiagramExporter {
    @Override
    public boolean accept(Diagram diagram) {
        return diagram != null;
    }

    @Override
    public void doExport(@Nonnull Diagram diagram, @Nonnull File file) throws Exception {
        try (PrintWriter pw = new PrintWriter(file, "UTF-8");){
            this.processReactions(diagram, pw);
            this.processRelations(diagram, pw);
        }
    }

    protected void processReactions(Compartment compartment, PrintWriter pw) {
        for (Node de : compartment.recursiveStream().select(Node.class)) {
            if (!this.isReaction(de.getKernel())) continue;
            ArrayList<Node> reactants = new ArrayList<Node>();
            ArrayList<Node> products = new ArrayList<Node>();
            ArrayList<Node> modifiers = new ArrayList<Node>();
            for (Edge edge : de.getEdges()) {
                if (this.isReactant(edge.getKernel())) {
                    reactants.add(edge.getOtherEnd(de));
                    continue;
                }
                if (this.isProduct(edge.getKernel())) {
                    products.add(edge.getOtherEnd(de));
                    continue;
                }
                if (!this.isModifier(edge.getKernel())) continue;
                modifiers.add(edge.getOtherEnd(de));
            }
            pw.println("//" + this.getReactionComment(de.getName(), reactants, products, modifiers));
            for (Node node : reactants) {
                pw.println(node.getName() + "\t" + de.getName());
            }
            for (Node node : products) {
                pw.println(de.getName() + "\t" + node.getName());
            }
            for (Node node : modifiers) {
                pw.println(node.getName() + "\t" + de.getName());
            }
            pw.println();
        }
    }

    protected String getReactionComment(String name, List<Node> reactants, List<Node> products, List<Node> modifiers) {
        StringBuilder result = new StringBuilder();
        result.append(name);
        result.append(": ");
        result.append(StreamEx.of(reactants).map(DiagramElement::getTitle).joining((CharSequence)" + "));
        String modifiersString = StreamEx.of(modifiers).map(m -> " -" + m.getTitle()).joining();
        result.append(modifiersString.isEmpty() ? " " : modifiersString);
        result.append("-> ");
        result.append(StreamEx.of(products).map(DiagramElement::getTitle).joining((CharSequence)" + "));
        return result.toString();
    }

    protected void processRelations(Compartment compartment, PrintWriter pw) {
        ((StreamEx)compartment.recursiveStream().select(Edge.class).filter(edge -> this.isRelation(edge.getKernel()))).map(edge -> edge.getInput().getTitle() + "\t" + edge.getOutput().getTitle()).forEach(pw::println);
    }

    protected boolean isReaction(Base kernel) {
        return kernel != null && (kernel instanceof Reaction || kernel.getType().equals("reaction"));
    }

    protected boolean isRelation(Base kernel) {
        return kernel != null && (kernel instanceof SemanticRelation || kernel.getType().equals("relation"));
    }

    protected boolean isReactant(Base kernel) {
        return kernel != null && (kernel instanceof SpecieReference && ((SpecieReference)kernel).getRole().equals("reactant") || kernel.getType().equals("consumption"));
    }

    protected boolean isProduct(Base kernel) {
        return kernel != null && (kernel instanceof SpecieReference && ((SpecieReference)kernel).getRole().equals("product") || kernel.getType().equals("production"));
    }

    protected boolean isModifier(Base kernel) {
        return kernel != null && (kernel instanceof SpecieReference && ((SpecieReference)kernel).getRole().equals("modifier") || kernel.getType().equals("regulation"));
    }

    @Override
    public boolean init(String format, String suffix) {
        return true;
    }
}

