/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Diagram;
import biouml.model.DiagramImporter;
import biouml.model.Module;
import biouml.model.util.DiagramXmlReader;
import com.developmentontheedge.application.ApplicationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.FolderCollection;
import ru.biosoft.jobcontrol.FunctionJobControl;

public class DiagramDMLImporter
extends DiagramImporter {
    protected static final Logger log = Logger.getLogger(DiagramDMLImporter.class.getName());

    @Override
    public int accept(File file) {
        try {
            String header = ApplicationUtils.readAsString((File)file, (int)1000);
            int iXml = header.indexOf("<?xml");
            if (iXml == -1) {
                return 0;
            }
            if (!header.substring(iXml, iXml + 100 > header.length() ? header.length() : iXml + 100).matches("(\\s)*<\\?xml(\\s)*version(\\s)*=(.|\\s)*")) {
                return 0;
            }
            if (header.indexOf("<dml") == -1) {
                return 0;
            }
            return 20;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "accept error :", t);
            return 0;
        }
    }

    @Override
    public DataElement doImport(Module module, File file, String diagramName) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataElement doImport(@Nonnull DataCollection parent, @Nonnull File file, String diagramName, FunctionJobControl jobControl, Logger log) throws Exception {
        if (jobControl != null) {
            jobControl.functionStarted();
        }
        try {
            parent = DataCollectionUtils.fetchPrimaryCollection((DataCollection)parent, (int)4);
            DataCollection<Diagram> actualParent = null;
            Module module = Module.optModule((DataElement)parent);
            if (parent instanceof FolderCollection && parent.isAcceptable(Diagram.class)) {
                actualParent = parent;
            } else {
                DataCollection<Diagram> dataCollection = actualParent = module == null ? parent : module.getDiagrams();
                if (actualParent == null) {
                    actualParent = parent;
                }
            }
            if (diagramName == null || diagramName.trim().isEmpty()) {
                throw new IllegalArgumentException("Incorrect diagram name");
            }
            Diagram diagram = DiagramXmlReader.readDiagram(diagramName, new FileInputStream(file), null, actualParent, module, null, this.newPaths);
            CollectionFactoryUtils.save((DataElement)diagram);
            if (jobControl != null) {
                jobControl.functionFinished();
            }
            return diagram;
        }
        catch (Exception e) {
            if (jobControl != null) {
                jobControl.functionTerminatedByError((Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public int accept(DataCollection parent, File file) {
        if (DataCollectionUtils.isAcceptable((DataCollection)parent, Diagram.class)) {
            return file == null ? 20 : this.accept(file);
        }
        return super.accept(parent, file);
    }
}

