/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Diagram;
import biouml.model.DiagramTypeConverter;
import biouml.model.util.MessageBundle;
import biouml.workbench.diagram.DiagramTypeConverterRegistry;
import com.developmentontheedge.beans.BeanInfoEx;
import com.developmentontheedge.beans.PropertyDescriptorEx;
import java.beans.PropertyDescriptor;
import java.util.List;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.repository.DataElementPathEditor;
import ru.biosoft.access.subaction.BackgroundDynamicAction;
import ru.biosoft.jobcontrol.AbstractJobControl;
import ru.biosoft.jobcontrol.JobControl;
import ru.biosoft.jobcontrol.JobControlException;
import ru.biosoft.workbench.editors.GenericComboBoxEditor;

public class ConvertDiagramAction
extends BackgroundDynamicAction {
    public Object getProperties(Object model, List<DataElement> selectedItems) {
        return new ActionProperties(model);
    }

    public boolean isApplicable(Object model) {
        if (model instanceof Diagram) {
            DiagramTypeConverterRegistry.Conversion[] conversions = DiagramTypeConverterRegistry.getPossibleConversions(((Diagram)((Object)model)).getType().getClass().getName());
            return conversions != null && conversions.length > 0;
        }
        return false;
    }

    public JobControl getJobControl(final Object model, List<DataElement> selectedItems, final Object properties) throws Exception {
        return new AbstractJobControl(this.log){

            protected void doRun() throws JobControlException {
                ActionProperties actionProperties = (ActionProperties)properties;
                DiagramTypeConverterRegistry.Conversion conversion = actionProperties.getConversion();
                DataElementPath path = actionProperties.getOutputDiagramPath();
                try {
                    DiagramTypeConverter converter = conversion.getConverter().newInstance();
                    DataCollection origin = path.getParentCollection();
                    Diagram newDiagram = ((Diagram)((Object)model)).clone(origin, path.getName());
                    newDiagram = converter.convert(newDiagram, conversion.getDiagramType());
                    origin.put((DataElement)newDiagram);
                    this.setPreparedness(100);
                    this.resultsAreReady(new Object[]{newDiagram});
                }
                catch (Exception e) {
                    throw new JobControlException((Throwable)e);
                }
            }
        };
    }

    public static class ActionPropertiesBeanInfo
    extends BeanInfoEx {
        public ActionPropertiesBeanInfo() {
            super(ActionProperties.class, MessageBundle.class.getName());
            this.beanDescriptor.setDisplayName(this.getResourceString("CN_CLASS"));
            this.beanDescriptor.setShortDescription(this.getResourceString("CD_CLASS"));
        }

        public void initProperties() throws Exception {
            super.initProperties();
            this.add((PropertyDescriptor)DataElementPathEditor.registerOutput((String)"outputDiagramPath", (Class)this.beanClass, Diagram.class), this.getResourceString("PN_CONVERTED_DIAGRAM_NAME"), this.getResourceString("PD_CONVERTED_DIAGRAM_NAME"));
            PropertyDescriptorEx pde = new PropertyDescriptorEx("conversion", this.beanClass);
            pde.setSimple(true);
            pde.setPropertyEditorClass(ConversionSelector.class);
            this.add((PropertyDescriptor)pde, this.getResourceString("PN_CONVERTED_DIAGRAM_TYPE"), this.getResourceString("PD_CONVERTED_DIAGRAM_TYPE"));
        }
    }

    public static class ConversionSelector
    extends GenericComboBoxEditor {
        protected Object[] getAvailableValues() {
            return ((ActionProperties)this.getBean()).getConversions();
        }
    }

    public static class ActionProperties {
        private DataElementPath inputDiagramPath;
        private DataElementPath outputDiagramPath;
        private DiagramTypeConverterRegistry.Conversion conversion;
        private DiagramTypeConverterRegistry.Conversion[] conversions;

        public ActionProperties(Object model) {
            if (model instanceof Diagram) {
                DataElementPath modelPath = ((Diagram)((Object)model)).getCompletePath();
                this.setInputDiagramPath(modelPath);
                DiagramTypeConverterRegistry.Conversion[] availableConversions = DiagramTypeConverterRegistry.getPossibleConversions(((Diagram)((Object)model)).getType().getClass().getName());
                this.setConversions(availableConversions);
                if (availableConversions.length > 0) {
                    this.setConversion(availableConversions[0]);
                }
            }
        }

        public DataElementPath getInputDiagramPath() {
            return this.inputDiagramPath;
        }

        public void setInputDiagramPath(DataElementPath inputDiagramPath) {
            this.inputDiagramPath = inputDiagramPath;
        }

        public DiagramTypeConverterRegistry.Conversion getConversion() {
            return this.conversion;
        }

        public void setConversion(DiagramTypeConverterRegistry.Conversion conversion) {
            this.conversion = conversion;
        }

        public DataElementPath getOutputDiagramPath() {
            return this.outputDiagramPath;
        }

        public void setOutputDiagramPath(DataElementPath outputDiagramPath) {
            this.outputDiagramPath = outputDiagramPath;
        }

        public DiagramTypeConverterRegistry.Conversion[] getConversions() {
            return this.conversions;
        }

        public void setConversions(DiagramTypeConverterRegistry.Conversion[] conversions) {
            this.conversions = conversions;
        }
    }
}

