/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.standard.type.BaseSupport;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetSerializer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import ru.biosoft.exception.ExceptionRegistry;

public class BaseSupportWrapper {
    private Map<BaseSupport, Map<String, String>> object2DpsProperty2Serialized = new HashMap<BaseSupport, Map<String, String>>();
    private BaseSupport wrapped;

    public BaseSupportWrapper(BaseSupport baseSupportArg) {
        this.explore(baseSupportArg);
    }

    public BaseSupportWrapper() {
    }

    private void explore(BaseSupport obj) {
        if (obj == null || this.object2DpsProperty2Serialized.containsKey(obj)) {
            return;
        }
        if (this.wrapped == null) {
            this.wrapped = obj;
        }
        HashMap<String, String> dpsProperty2Serialized = new HashMap<String, String>();
        DynamicPropertySetSerializer dpsSerializer = new DynamicPropertySetSerializer();
        try {
            PropertyDescriptor[] props;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor pd : props = beanInfo.getPropertyDescriptors()) {
                try (ByteArrayOutputStream bas = new ByteArrayOutputStream();
                     BufferedOutputStream os = new BufferedOutputStream(bas);){
                    Method readMethod;
                    if (pd.getPropertyType().equals(DynamicPropertySet.class) && pd.getReadMethod() != null) {
                        readMethod = pd.getReadMethod();
                        DynamicPropertySet dps = (DynamicPropertySet)readMethod.invoke((Object)obj, new Object[0]);
                        dpsSerializer.save((OutputStream)os, dps);
                        String serialized = bas.toString();
                        dpsProperty2Serialized.put(pd.getName(), serialized);
                        continue;
                    }
                    if (pd.getPropertyType().isArray() && pd.getReadMethod() != null && pd.getWriteMethod() != null) {
                        Object arr;
                        if (BaseSupport.class.isAssignableFrom(pd.getPropertyType().getComponentType()) && (arr = (readMethod = pd.getReadMethod()).invoke((Object)obj, new Object[0])) != null) {
                            for (int i = 0; i < Array.getLength(arr); ++i) {
                                this.explore((BaseSupport)Array.get(arr, i));
                            }
                        }
                        continue;
                    }
                    if (!BaseSupport.class.isAssignableFrom(pd.getPropertyType()) || pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
                    readMethod = pd.getReadMethod();
                    this.explore((BaseSupport)readMethod.invoke((Object)obj, new Object[0]));
                }
                catch (IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    ExceptionRegistry.log((Throwable)e);
                }
            }
            this.object2DpsProperty2Serialized.put(obj, dpsProperty2Serialized);
        }
        catch (IntrospectionException e) {
            ExceptionRegistry.log((Throwable)e);
        }
    }

    public void restoreWrapped() {
        for (Map.Entry<BaseSupport, Map<String, String>> entry : this.object2DpsProperty2Serialized.entrySet()) {
            Map<String, String> dpsProperty2Serialized = entry.getValue();
            if (dpsProperty2Serialized.size() < 1) continue;
            DynamicPropertySetSerializer dpsSerializer = new DynamicPropertySetSerializer();
            try {
                PropertyDescriptor[] props;
                BeanInfo beanInfo = Introspector.getBeanInfo(entry.getKey().getClass());
                for (PropertyDescriptor pd : props = beanInfo.getPropertyDescriptors()) {
                    if (!pd.getPropertyType().equals(DynamicPropertySet.class) || pd.getReadMethod() == null) continue;
                    Method readMethod = pd.getReadMethod();
                    DynamicPropertySet dps = (DynamicPropertySet)readMethod.invoke((Object)entry.getKey(), new Object[0]);
                    String serialized = dpsProperty2Serialized.get(pd.getName());
                    if (serialized.length() <= 0) continue;
                    ByteArrayInputStream is = new ByteArrayInputStream(serialized.getBytes(StandardCharsets.UTF_8));
                    BufferedInputStream bis = new BufferedInputStream(is);
                    dpsSerializer.load(dps, (InputStream)bis);
                }
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                ExceptionRegistry.log((Throwable)e);
            }
        }
        this.object2DpsProperty2Serialized.clear();
    }

    public Map<BaseSupport, Map<String, String>> getObject2DpsProperty2Serialized() {
        return this.object2DpsProperty2Serialized;
    }

    public void setObject2DpsProperty2Serialized(Map<BaseSupport, Map<String, String>> object2DpsProperty2Serialized) {
        this.object2DpsProperty2Serialized = object2DpsProperty2Serialized;
    }

    public BaseSupport getWrapped() {
        return this.wrapped;
    }

    public void setWrapped(BaseSupport wrapped) {
        this.wrapped = wrapped;
    }
}

