/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.util;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramType;
import biouml.model.DiagramTypeConverter;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.util.ImageGenerator;
import biouml.model.xml.XmlDiagramSemanticController;
import biouml.model.xml.XmlDiagramType;
import biouml.model.xml.XmlDiagramTypeConstants;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Reaction;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import biouml.workbench.diagram.DiagramEditorHelper;
import biouml.workbench.diagram.DiagramTypeConverterRegistry;
import biouml.workbench.diagram.ViewEditorPaneStub;
import biouml.workbench.graph.DiagramToGraphTransformer;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.biohub.Element;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graph.FastGridLayouter;
import ru.biosoft.graph.Graph;
import ru.biosoft.graph.Layouter;
import ru.biosoft.graph.PathwayLayouter;
import ru.biosoft.util.Clazz;

public class AddElementsUtils {
    protected static final Logger log = Logger.getLogger(AddElementsUtils.class.getName());
    public static final String INVISIBLE_ELEMENT_PROPERTY = "invisible";

    public static void addElements(Compartment compartment, Element[] elements, Point location) throws Exception {
        AddElementsUtils.addElements(compartment, elements, location, true, true);
    }

    public static void addElements(Compartment compartment, Element[] elements, Point location, boolean correctRelations, boolean addMissed) throws Exception {
        Diagram diagram = Diagram.getDiagram(compartment);
        List<DiagramElement> previouslyFixed = AddElementsUtils.fixCurrentNodes(diagram, true);
        DiagramTypeConverter[] converters = AddElementsUtils.getAvailableConverters(diagram);
        AddElementsUtils.addNodesToCompartment(elements, compartment, converters, location);
        AddElementsUtils.addEdgesToCompartment(elements, compartment, correctRelations, converters);
        if (addMissed) {
            AddElementsUtils.extendReactionNodes(elements, compartment, converters);
            AddElementsUtils.addMissedEdges(AddElementsUtils.getNewlyCreatedNodes(elements, compartment), compartment, converters);
        }
        if (location == null) {
            AddElementsUtils.layoutDiagram(diagram, AddElementsUtils.getLayouter(compartment));
        }
        AddElementsUtils.fixCurrentNodes(diagram, false, previouslyFixed);
    }

    public static DiagramTypeConverter[] getAvailableConverters(Diagram diagram) {
        Object[] conversions = DiagramTypeConverterRegistry.getDiagramElementConverter(diagram);
        return (DiagramTypeConverter[])StreamEx.of((Object[])conversions).map(DiagramTypeConverterRegistry.Conversion::getConverter).map(arg_0 -> ((Clazz)Clazz.of(DiagramTypeConverter.class)).create(arg_0)).toArray(DiagramTypeConverter[]::new);
    }

    public static List<DiagramElement> fixCurrentNodes(Compartment compartment, boolean fixed) {
        return AddElementsUtils.fixCurrentNodes(compartment, fixed, null);
    }

    public static List<DiagramElement> fixCurrentNodes(Compartment compartment, boolean fixed, List<DiagramElement> restoreList) {
        List previouslyFixed = ((StreamEx)compartment.recursiveStream().filter(de -> de.isFixed() == fixed)).toList();
        compartment.recursiveStream().forEach(node -> node.setFixed(fixed));
        if (restoreList != null) {
            restoreList.stream().forEach(de -> de.setFixed(!fixed));
        }
        return previouslyFixed;
    }

    public static void addNodesToCompartment(Element[] elements, Compartment compartment, DiagramTypeConverter[] converters, Point location) throws Exception {
        for (Element element : elements) {
            AddElementsUtils.addNode(compartment, AddElementsUtils.getKernel(element), converters, AddElementsUtils.isElementVisible(element), location);
        }
    }

    private static boolean isElementVisible(Element element) {
        return !(element.getValue(INVISIBLE_ELEMENT_PROPERTY) instanceof Boolean) || (Boolean)element.getValue(INVISIBLE_ELEMENT_PROPERTY) == false;
    }

    public static DataElement getKernel(Element element) {
        DataElement kernel = AddElementsUtils.getKernel(element.getElementPath());
        if (kernel instanceof Base) {
            AddElementsUtils.fillUserElementProperties((Base)kernel, element);
        }
        return kernel;
    }

    private static void fillUserElementProperties(Base kernel, Element element) {
        if (element.getValue("userTitle") != null && element.getValue("userTitle") instanceof String) {
            ((BaseSupport)kernel).setTitle((String)element.getValue("userTitle"));
        }
        for (String propertyName : new String[]{"userReactionReactants", "userReactionProducts"}) {
            if (element.getValue(propertyName) == null) continue;
            kernel.getAttributes().add(new DynamicProperty(propertyName, String.class, element.getValue(propertyName)));
        }
    }

    @CheckForNull
    public static DataElement optKernel(Element element) {
        try {
            return AddElementsUtils.getKernel(element);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static DataElement getKernel(DataElementPath path) {
        if (path.isDescendantOf(DatabaseReference.STUB_PATH.getChildPath(new String[]{"reaction"}))) {
            return new Reaction(null, path.getName());
        }
        DataElement de = path.optDataElement();
        if (de == null) {
            String originalName;
            DataElementPath originalPath;
            DataElement originalDe;
            if (path.getName().contains("_") && (originalDe = (originalPath = path.getSiblingPath(originalName = path.getName().substring(0, path.getName().lastIndexOf("_")))).optDataElement()) != null && originalDe instanceof Reaction) {
                Reaction originalReaction = (Reaction)originalDe;
                Reaction result = new Reaction((DataCollection<?>)originalReaction.getOrigin(), path.getName());
                result.getAttributes().add(new DynamicProperty("Original reaction", String.class, (Object)originalPath.toString()));
                return result;
            }
            return null;
        }
        if (de instanceof DiagramElement) {
            Base kernel = ((DiagramElement)de).getKernel();
            return kernel;
        }
        return de;
    }

    public static DiagramElement[] addNode(Compartment cmp, @Nonnull DataElement kernel, DiagramTypeConverter[] converters, boolean visible, Point location) throws Exception {
        DiagramElement[] nodes = null;
        boolean hasConverter = false;
        if (converters != null && kernel instanceof Base) {
            Node testNode = new Node(cmp, (Base)kernel);
            DiagramTypeConverter[] available = (DiagramTypeConverter[])((StreamEx)StreamEx.of((Object[])converters).filter(c -> c.canConvert(testNode))).toArray(DiagramTypeConverter[]::new);
            if (available.length > 0) {
                hasConverter = true;
                nodes = AddElementsUtils.createDiagramElements(cmp, (Base)kernel, available);
                if (nodes == null) {
                    throw new Exception("Can not add element " + kernel.getName() + " with available converters");
                }
                Base kernelToFind = nodes[0].getKernel();
                DiagramElement existingDE = AddElementsUtils.findNodeWithKernel(cmp, kernelToFind);
                if (existingDE != null) {
                    return new DiagramElement[]{existingDE};
                }
                AddElementsUtils.addDiagramElements(cmp, nodes, visible, location);
                return nodes;
            }
        }
        if (!hasConverter) {
            Diagram diagram = Diagram.getDiagram(cmp);
            DiagramEditorHelper helper = new DiagramEditorHelper(diagram);
            SemanticController semanticController = diagram.getType().getSemanticController();
            ViewEditorPaneStub viewEditor = new ViewEditorPaneStub(helper, diagram);
            DiagramElementGroup elements = semanticController.addInstanceFromElement(cmp, kernel, location != null ? location : cmp.getLocation(), viewEditor);
            return elements.getElements().toArray(new DiagramElement[elements.size()]);
        }
        return null;
    }

    public static void addDiagramElements(Compartment cmp, DiagramElement[] nodes, boolean visible, Point location) {
        Diagram diagram = Diagram.getDiagram(cmp);
        DiagramEditorHelper helper = new DiagramEditorHelper(diagram);
        ViewEditorPaneStub viewEditor = new ViewEditorPaneStub(helper, diagram);
        if (location == null) {
            location = cmp.getLocation();
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        for (DiagramElement de : nodes) {
            viewEditor.add((Object)de, location);
            if (visible || !(de instanceof Node)) continue;
            ((Node)de).setVisible(false);
        }
    }

    public static DiagramElement[] createDiagramElements(Compartment cmp, Base base, DiagramTypeConverter[] converters) throws Exception {
        Diagram diagram = Diagram.getDiagram(cmp);
        DiagramElement[] nodes = null;
        if (converters != null && (nodes = AddElementsUtils.convertDiagramElement(new Node(cmp, base), diagram, converters)) == null) {
            nodes = new DiagramElement[]{diagram.getType() instanceof XmlDiagramType ? AddElementsUtils.getXmlDiagramNode(base, cmp, diagram) : new Node(cmp, base)};
        }
        return nodes;
    }

    public static void addEdgesToCompartment(Element[] elements, Compartment compartment, boolean correctRelations, DiagramTypeConverter[] converters) {
        for (Element element : elements) {
            AddElementsUtils.addSingleEdgeToCompartment(compartment, element, correctRelations, converters);
        }
    }

    protected static void addSingleEdgeToCompartment(Compartment compartment, Element element, boolean correctDirection, DiagramTypeConverter[] converters) {
        if (element.getLinkedFromPath() != null && !element.getLinkedFromPath().isEmpty()) {
            Base toBase = (Base)AddElementsUtils.getKernel(element);
            Base fromBase = (Base)AddElementsUtils.getKernel(DataElementPath.create((String)element.getLinkedFromPath()));
            if (fromBase != null) {
                if (correctDirection && element.getLinkedDirection() == 0) {
                    Base tmp = toBase;
                    toBase = fromBase;
                    fromBase = tmp;
                }
                try {
                    DiagramElement de;
                    Node toNode = compartment.findNode(toBase.getName());
                    Node fromNode = compartment.findNode(fromBase.getName());
                    if (toNode == null) {
                        de = AddElementsUtils.findNodeWithKernel(compartment, toBase);
                        toNode = de != null && de instanceof Node ? (Node)de : Diagram.getDiagram(compartment).findNode(toBase.getName());
                    }
                    if (fromNode == null) {
                        de = AddElementsUtils.findNodeWithKernel(compartment, fromBase);
                        fromNode = de != null && de instanceof Node ? (Node)de : Diagram.getDiagram(compartment).findNode(fromBase.getName());
                    }
                    if (toNode != null && fromNode != null) {
                        AddElementsUtils.addEdge(fromNode, toNode, element.getRelationType(), compartment, converters);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Can not add edge to diagram", e);
                }
            }
        }
    }

    public static void addEdge(@Nonnull Node fromNode, @Nonnull Node toNode, String edgeType, Compartment compartment, DiagramTypeConverter[] converters) throws Exception {
        DiagramElement[] des = AddElementsUtils.createEdge(fromNode, toNode, edgeType, compartment, converters);
        if (des == null) {
            return;
        }
        Compartment origin = Node.findCommonOrigin(toNode, fromNode);
        for (DiagramElement de : des) {
            origin.put(de);
        }
    }

    public static DiagramElement[] createEdge(@Nonnull Node fromNode, @Nonnull Node toNode, String edgeType, Compartment compartment, DiagramTypeConverter[] converters) throws Exception {
        Diagram diagram = Diagram.getDiagram(compartment);
        SemanticController sc = diagram.getType().getSemanticController();
        Compartment origin = Node.findCommonOrigin(toNode, fromNode);
        Base edgeKernel = null;
        Edge edge = null;
        Node specieNode = toNode;
        Reaction reaction = AddElementsUtils.getReactionByNode(fromNode);
        if (reaction == null) {
            reaction = AddElementsUtils.getReactionByNode(toNode);
            specieNode = fromNode;
        }
        Base kernel = specieNode.getKernel();
        DataElementPath modulePath = Module.optModulePath(kernel);
        if (reaction != null) {
            String speciePath = modulePath != null ? kernel.getCompletePath().getPathDifference(modulePath) : kernel.getName();
            String searchType = edgeType;
            List species = (List)((StreamEx)reaction.stream().filter(sp -> sp.getSpecie().equals(speciePath) && sp.getRole().equals(searchType))).collect(Collectors.toList());
            if (species.size() > 0) {
                edgeKernel = (Base)species.get(0);
            }
            if (edgeKernel != null) {
                edge = sc.findEdge(fromNode, toNode, edgeKernel);
                if (edge != null) {
                    return null;
                }
                edge = sc.findEdge(toNode, fromNode, edgeKernel);
                if (edge != null) {
                    return null;
                }
                edge = new Edge(origin, edgeKernel, fromNode, toNode);
            }
        }
        if (edge == null) {
            edge = sc.createEdge(fromNode, toNode, edgeType, origin);
        }
        if (edge == null) {
            return null;
        }
        DiagramElement[] converted = AddElementsUtils.convertDiagramElement(edge, diagram, converters);
        if (converted != null) {
            return converted;
        }
        return new DiagramElement[]{edge};
    }

    public static boolean edgeExists(Node from, Node to, Base kernel) {
        Edge[] edges;
        for (Edge e : edges = from.getEdges()) {
            if (!e.getInput().getName().equals(from.getName()) || !e.getOutput().getName().equals(to.getName()) || e.getKernel() == null || !(e.getKernel() instanceof SpecieReference) || !(kernel instanceof SpecieReference) || e.getKernel().getOrigin() == null || kernel.getOrigin() == null || !e.getKernel().getOrigin().getCompletePath().equals((Object)kernel.getOrigin().getCompletePath())) continue;
            return true;
        }
        return false;
    }

    protected static void extendReactionNodes(Element[] elements, Compartment compartment, DiagramTypeConverter[] converters) {
        for (Element element : elements) {
            try {
                Base base = (Base)AddElementsUtils.getKernel(element);
                if (!(base instanceof Reaction)) continue;
                Module module = Module.getModule(base);
                Node reactionNode = compartment.findNode(base.getName());
                if (reactionNode == null) continue;
                Reaction reaction = (Reaction)base;
                for (SpecieReference sr : reaction.getSpecieReferences()) {
                    String specieName = sr.getSpecie();
                    Base specieBase = (Base)module.getKernel(specieName);
                    if (specieBase == null) continue;
                    boolean needEdge = true;
                    Node specieNode = null;
                    DiagramElement[] added = AddElementsUtils.addNode(compartment, specieBase, converters, true, reactionNode.getLocation());
                    if (added != null && added.length > 0 && added[0] instanceof Node) {
                        specieNode = (Node)added[0];
                    }
                    if (specieNode != null) {
                        Edge[] edges;
                        for (Edge e : edges = reactionNode.getEdges()) {
                            Node in = e.getInput();
                            Node out = e.getOutput();
                            if ((!in.getName().equals(reaction.getName()) || !out.getName().equals(specieBase.getName())) && (!out.getName().equals(reaction.getName()) || !in.getName().equals(specieBase.getName()))) continue;
                            needEdge = false;
                            break;
                        }
                    }
                    if (!needEdge) continue;
                    if (sr.getRole().equals("product")) {
                        AddElementsUtils.addEdge(reactionNode, specieNode, sr.getRole(), compartment, converters);
                        continue;
                    }
                    AddElementsUtils.addEdge(specieNode, reactionNode, sr.getRole(), compartment, converters);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not add reaction components to diagram", e);
            }
        }
    }

    private static DiagramElement findNodeWithKernel(Compartment compartment, Base kernel) {
        if (Util.hasNodeWithKernel(compartment, kernel)) {
            return compartment.get(kernel.getName());
        }
        Diagram diagram = Diagram.getDiagram(compartment);
        if (Util.hasNodeWithKernel(diagram, kernel)) {
            return diagram.get(kernel.getName());
        }
        Compartment cmpWithNode = ((StreamEx)diagram.recursiveStream().filter(node -> node.getKernel() != null && node instanceof Compartment && node.getKernel().getType().equals("compartment"))).findAny(cmp -> Util.hasNodeWithKernel((Compartment)((Object)cmp), kernel)).orElse(null);
        if (cmpWithNode != null) {
            return cmpWithNode.get(kernel.getName());
        }
        return null;
    }

    private static List<Node> getNewlyCreatedNodes(Element[] elements, Compartment compartment) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Element element : elements) {
            Node node;
            DataElement de = AddElementsUtils.getKernel(element);
            if (de instanceof Reaction || (node = compartment.findNode(de.getName())) == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static void addMissedEdges(Element[] elements, Compartment compartment, DiagramTypeConverter[] converters) {
        AddElementsUtils.addMissedEdges(AddElementsUtils.getNewlyCreatedNodes(elements, compartment), compartment, converters);
    }

    protected static void addMissedEdges(List<Node> nodes, Compartment compartment, DiagramTypeConverter[] converters) {
        List reactionNodes = ((StreamEx)compartment.stream(Node.class).filter(node -> node.getKernel() != null && node.getKernel() instanceof Reaction)).toList();
        for (Node node2 : nodes) {
            block3: for (Node reactionNode : reactionNodes) {
                DataElement reactionDe;
                Reaction reaction = (Reaction)reactionNode.getKernel();
                Object reactionNameObj = reactionNode.getAttributes().getValue("completeName");
                if (reactionNameObj != null && (reactionDe = DataElementPath.create((String)reactionNameObj.toString()).optDataElement()) != null && reactionDe instanceof Reaction) {
                    reaction = (Reaction)reactionDe;
                }
                for (SpecieReference sr : reaction.getSpecieReferences()) {
                    Edge[] edges;
                    String specieName = sr.getSpecieName();
                    if (!specieName.equals(node2.getName())) continue;
                    boolean needEdge = true;
                    for (Edge e : edges = reactionNode.getEdges()) {
                        Node in = e.getInput();
                        Node out = e.getOutput();
                        if ((!in.getName().equals(reactionNode.getName()) || !out.getName().equals(specieName)) && (!out.getName().equals(reactionNode.getName()) || !in.getName().equals(specieName))) continue;
                        needEdge = false;
                        break;
                    }
                    if (!needEdge) continue block3;
                    try {
                        if (sr.getRole().equals("product")) {
                            AddElementsUtils.addEdge(reactionNode, node2, sr.getRole(), compartment, converters);
                            continue block3;
                        }
                        AddElementsUtils.addEdge(node2, reactionNode, sr.getRole(), compartment, converters);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Can not add edge to diagram", e);
                    }
                    continue block3;
                }
            }
        }
    }

    private static DiagramElement[] convertDiagramElement(DiagramElement de, Diagram diagram, DiagramTypeConverter[] converters) throws Exception {
        if (converters != null) {
            for (DiagramTypeConverter converter : converters) {
                XmlDiagramType xmlDiagramType;
                DiagramElement[] nodes = converter.convertDiagramElement(de, diagram);
                if (nodes == null) continue;
                if (diagram.getType() instanceof XmlDiagramType && (xmlDiagramType = (XmlDiagramType)diagram.getType()).getSemanticController() instanceof XmlDiagramSemanticController) {
                    XmlDiagramSemanticController sc = (XmlDiagramSemanticController)xmlDiagramType.getSemanticController();
                    for (int j = 0; j < nodes.length; ++j) {
                        nodes[j] = sc.getPrototype().validate(diagram, nodes[j]);
                    }
                }
                return nodes;
            }
        }
        return null;
    }

    private static Node getXmlDiagramNode(@Nonnull Base base, Compartment origin, Diagram diagram) throws Exception {
        Node node;
        boolean isCompartment;
        XmlDiagramType xmlDiagramType = (XmlDiagramType)diagram.getType();
        String typeStr = xmlDiagramType.getKernelTypeName(base.getClass());
        if (typeStr == null) {
            typeStr = xmlDiagramType.getDefaultTypeName();
        }
        if (typeStr == null) {
            typeStr = "";
        }
        if (isCompartment = xmlDiagramType.checkCompartment(typeStr)) {
            node = new Compartment(origin, base);
            node.setShapeSize(new Dimension(0, 0));
        } else {
            node = new Node(origin, base);
        }
        SemanticController sc = xmlDiagramType.getSemanticController();
        if (sc instanceof XmlDiagramSemanticController) {
            DynamicPropertySet attributes = ((XmlDiagramSemanticController)sc).createAttributes(typeStr);
            for (DynamicProperty attribute : attributes) {
                node.getAttributes().add(attribute);
            }
            node = (Node)((XmlDiagramSemanticController)sc).getPrototype().validate(origin, node);
        }
        if (typeStr.length() > 0) {
            DynamicProperty dp = new DynamicProperty(XmlDiagramTypeConstants.XML_TYPE_PD, String.class, (Object)typeStr);
            node.getAttributes().add(dp);
        }
        return node;
    }

    private static void layoutDiagram(Diagram diagram, Layouter layouter) {
        ImageGenerator.generateDiagramView(diagram, ApplicationUtils.getGraphics());
        PathwayLayouter pathwayLayouter = new PathwayLayouter(layouter);
        Graph graph = DiagramToGraphTransformer.generateGraph((Compartment)diagram, null);
        pathwayLayouter.doLayout(graph, null);
        DiagramToGraphTransformer.applyLayout((Graph)graph, (Diagram)diagram);
    }

    private static Layouter getLayouter(Compartment compartment) {
        FastGridLayouter layouter = new FastGridLayouter();
        if (compartment.isFixed()) {
            layouter.setGridX(40);
            layouter.setGridY(30);
        } else {
            layouter.setGridX(60);
            layouter.setGridY(40);
        }
        layouter.setIterations(2);
        layouter.setThreadCount(1);
        layouter.setCool(0.7);
        return layouter;
    }

    private static Reaction getReactionByNode(Node node) {
        Base kernel = node.getKernel();
        if (kernel != null) {
            DataElement reactionDe;
            Object reactionNameObj;
            if (kernel instanceof Reaction) {
                return (Reaction)kernel;
            }
            if (kernel instanceof Stub && kernel.getType().equals("reaction") && (reactionNameObj = node.getAttributes().getValue("completeName")) != null && (reactionDe = CollectionFactory.getDataElement((String)reactionNameObj.toString())) instanceof Reaction) {
                return (Reaction)reactionDe;
            }
        }
        return null;
    }

    public static void addDiagram(Compartment compartment, Diagram sourceDiagram, Point addPoint) throws Exception {
        Diagram diagram = Diagram.getDiagram(compartment);
        DiagramType targetType = diagram.getType();
        DiagramType sourceType = sourceDiagram.getType();
        if (!targetType.getClass().isInstance(sourceType) && !sourceType.getClass().isInstance(targetType)) {
            log.log(Level.WARNING, "Source diagram type " + sourceType.getTitle() + " is not compartible with target diagram type " + targetType.getTitle());
            DiagramEditorHelper helper = new DiagramEditorHelper(diagram);
            SemanticController semanticController = diagram.getType().getSemanticController();
            ViewEditorPaneStub viewEditor = new ViewEditorPaneStub(helper, diagram);
            semanticController.addInstanceFromElement(compartment, (DataElement)sourceDiagram, addPoint != null ? addPoint : compartment.getLocation(), viewEditor);
        } else {
            AddElementsUtils.copyDiagramByElements(compartment, sourceDiagram);
        }
    }

    private static void copyDiagramByElements(Compartment compartment, Diagram sourceDiagram) throws Exception {
        DiagramElement de;
        Diagram diagram = Diagram.getDiagram(compartment);
        SemanticController sc = diagram.getType().getSemanticController();
        ImageGenerator.generateDiagramView(diagram, ApplicationUtils.getGraphics());
        Rectangle rect = diagram.getView().getBounds();
        List<DiagramElement> previouslyFixed = AddElementsUtils.fixCurrentNodes(diagram, true);
        DiagramTypeConverter[] converters = AddElementsUtils.getAvailableConverters(diagram);
        int shiftX = rect.x + rect.width + 10;
        int shiftY = rect.y + rect.height + 10;
        if (shiftX > shiftY) {
            shiftX = 0;
        } else {
            shiftY = 0;
        }
        ArrayList<Node> newNodes = new ArrayList<Node>();
        Iterator<DiagramElement> iterator = sourceDiagram.iterator();
        while (iterator.hasNext()) {
            Base kernel;
            de = iterator.next();
            if (!(de instanceof Node) || compartment.findNode(de.getName()) != null || (kernel = de.getKernel()) instanceof Reaction) continue;
            AddElementsUtils.addNode(compartment, de.getKernel(), converters, ((Node)de).isVisible(), null);
            Node newNode = compartment.findNode(de.getName());
            Point location = ((Node)de).getLocation();
            Dimension offset = new Dimension(location.x + shiftX, location.y + shiftY);
            try {
                sc.move(newNode, compartment, offset, null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not move element", e);
            }
            newNode.setFixed(true);
            newNodes.add(newNode);
        }
        iterator = sourceDiagram.iterator();
        while (iterator.hasNext()) {
            de = iterator.next();
            if (!(de instanceof Node) || !(de.getKernel() instanceof Reaction) || compartment.findNode(de.getName()) != null) continue;
            AddElementsUtils.addNode(compartment, de.getKernel(), converters, ((Node)de).isVisible(), null);
            Node newNode = compartment.findNode(de.getName());
            Point location = ((Node)de).getLocation();
            Dimension offset = new Dimension(location.x + shiftX, location.y + shiftY);
            try {
                sc.move(newNode, compartment, offset, null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not move element", e);
            }
            newNode.setFixed(true);
            newNodes.add(newNode);
        }
        iterator = sourceDiagram.iterator();
        while (iterator.hasNext()) {
            de = iterator.next();
            if (!(de instanceof Edge)) continue;
            Edge edge = (Edge)de;
            Node newInput = compartment.findNode(edge.getInput().getName());
            Node newOutput = compartment.findNode(edge.getOutput().getName());
            if (newInput == null || newOutput == null) continue;
            try {
                String edgeType = edge.getKernel() instanceof SpecieReference ? ((SpecieReference)edge.getKernel()).getRole() : (edge.getKernel() instanceof SemanticRelation ? "semantic" : "noteLink");
                AddElementsUtils.addEdge(newInput, newOutput, edgeType, compartment, converters);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not add edge to diagram", e);
            }
        }
        AddElementsUtils.addMissedEdges(newNodes, compartment, converters);
        AddElementsUtils.layoutDiagram(diagram, AddElementsUtils.getLayouter(diagram));
        AddElementsUtils.fixCurrentNodes(diagram, false, previouslyFixed);
    }
}

