/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.javascript;

import biouml.model.javascript.BarChart;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import ru.biosoft.table.RowDataElement;
import ru.biosoft.table.TableDataCollection;

public class StatisticalBarChart
extends BarChart {
    public StatisticalBarChart() {
        this.dataset = new DefaultStatisticalCategoryDataset();
        this.renderer = new StatisticalBarRenderer();
        ((StatisticalBarRenderer)this.renderer).setErrorIndicatorPaint((Paint)Color.black);
        this.renderer.setItemMargin(0.0);
    }

    public void addBars(String legend, String tablePath, String mean, String sd) {
        TableDataCollection data = this.getData(tablePath);
        this.addBars(legend, data, mean, sd);
    }

    public void addBars(String legend, TableDataCollection data, String mean, String sd) {
        if (this.checkColumn(data, mean) && this.checkColumn(data, sd)) {
            for (RowDataElement row : data) {
                ((DefaultStatisticalCategoryDataset)this.dataset).add(((Double)row.getValue(mean)).doubleValue(), ((Double)row.getValue(sd)).doubleValue(), (Comparable)((Object)legend), (Comparable)((Object)row.getName()));
            }
        }
    }

    @Override
    public BufferedImage getImage(int width, int height) {
        JFreeChart chart = this.generateChart();
        ((CategoryPlot)chart.getPlot()).setRenderer((CategoryItemRenderer)this.renderer);
        return chart.createBufferedImage(width, height);
    }
}

