/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.javascript;

import biouml.model.Diagram;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.simulation.ArraySpan;
import biouml.plugins.simulation.Model;
import biouml.plugins.simulation.ResultWriter;
import biouml.plugins.simulation.SimulationEngine;
import biouml.plugins.simulation.SimulationEngineUtils;
import biouml.plugins.simulation.Simulator;
import biouml.plugins.simulation.SimulatorRegistry;
import biouml.plugins.simulation.Span;
import biouml.plugins.simulation.UniformSpan;
import biouml.plugins.simulation.java.JavaSimulationEngine;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.Util;
import biouml.standard.simulation.ResultListener;
import biouml.standard.simulation.SimulationResult;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.util.streamex.StreamEx;
import org.jfree.data.xy.XYSeries;
import ru.biosoft.access.CollectionFactoryUtils;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.script.ScriptEnvironment;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.plugins.javascript.Global;
import ru.biosoft.plugins.javascript.JSPlotGenerator;
import ru.biosoft.plugins.javascript.JavaScriptHostObjectBase;
import ru.biosoft.table.ColumnModel;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;
import ru.biosoft.util.BeanUtil;

public class JavaScriptSimulationEngine
extends JavaScriptHostObjectBase {
    protected static final Logger log = Logger.getLogger(JavaScriptSimulationEngine.class.getName());
    private SimulationEngine engine = new JavaSimulationEngine();
    private ResultWriter currentResults;
    private String message;

    public SimulationEngine getSimulationEngine() {
        return this.engine;
    }

    public String[] getSolvers() {
        return this.engine.getAvailableSolvers();
    }

    public String getSolver() {
        return this.engine.getSolverName();
    }

    public void setSolver(String name) {
        this.engine.setSolverName(name);
    }

    public String[] getOptions() {
        return this.getOptions(this.getSolver());
    }

    public String[] getOptions(String solver) {
        Simulator simulator;
        try {
            simulator = SimulatorRegistry.getSimulator((String)solver);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Solver with name " + solver + " was not found");
        }
        return (String[])BeanUtil.properties((Object)simulator.getOptions()).map(Property::getName).toArray(String[]::new);
    }

    public String getOption(String optionName) {
        return this.getProperty(optionName, this.engine.getSimulator()).getValue().toString();
    }

    public void setOption(String optionName, Object value) throws NoSuchMethodException {
        this.getProperty(optionName, this.engine.getSimulator()).setValue(value);
    }

    public String getOptionInfo(String optionName) {
        return this.getOptionInfo(optionName, this.getSolver());
    }

    public String getOptionInfo(String optionName, String solver) {
        Simulator simulator;
        try {
            simulator = SimulatorRegistry.getSimulator((String)solver);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Solver with name " + solver + " was not found");
        }
        return this.getProperty(optionName, simulator).getShortDescription();
    }

    private Property getProperty(String optionName, Simulator simulator) {
        ComponentModel model = ComponentFactory.getModel((Object)simulator.getOptions());
        Property prop = model.findProperty(optionName);
        if (prop == null) {
            throw new IllegalArgumentException("Option with name " + optionName + " was not found");
        }
        return prop;
    }

    public Span createSpan(double startTime, double endTime, double timeIncrement) {
        return timeIncrement != 0.0 ? new UniformSpan(startTime, endTime, timeIncrement) : new ArraySpan(startTime, endTime);
    }

    public void generateCode(Diagram diagram, boolean logging) {
        this.loadEngine(diagram);
        this.engine.setDiagram(diagram);
        this.engine.setLogLevel(Level.SEVERE);
        long time = System.nanoTime();
        try {
            if (logging) {
                System.out.println("Java code generation...");
            }
            ((JavaSimulationEngine)this.engine).generateModel(true);
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error during model compilation", t);
        }
    }

    public Model compileModel(Diagram diagram, boolean logging) {
        this.loadEngine(diagram);
        return this.compileModel(diagram, this.engine, logging);
    }

    public Model compileModel(Diagram diagram, SimulationEngine engine, boolean logging) {
        engine.setDiagram(diagram);
        engine.setLogLevel(Level.SEVERE);
        long time = System.nanoTime();
        try {
            if (logging) {
                System.out.println("Model generation...");
            }
            Model model = engine.createModel();
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            }
            return model;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error during model compilation", t);
            return null;
        }
    }

    public Model compileModel(Diagram diagram) {
        this.loadEngine(diagram);
        return this.compileModel(diagram, this.engine, true);
    }

    public SimulationResult simulateModel(Model model, Span span) {
        return this.simulateModel(model, span, true);
    }

    public SimulationResult simulateModel(Model model, Span span, boolean logging) {
        return this.simulateModel(model, span, logging, "Simulation_result");
    }

    public SimulationResult simulateModel(Model model, Span span, boolean logging, String resultName) {
        long time = System.nanoTime();
        this.engine.setSpan(span);
        this.engine.setLogLevel(Level.SEVERE);
        try {
            model.init();
            if (logging) {
                System.out.println("Simulation...");
            }
            this.message = this.engine.simulate(model, this.getResultListeners(this.engine));
            if (this.message != null) {
                if (logging) {
                    System.out.println("Done with errors:" + this.message);
                }
                return this.getSimulationResult(this.engine, resultName);
            }
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error during model simulation", t);
            return null;
        }
        return this.getSimulationResult(this.engine, resultName);
    }

    public SimulationEngine getEngine(Diagram diagram) {
        return DiagramUtility.getEngine(diagram);
    }

    public void loadEngine(Diagram diagram) {
        this.engine = DiagramUtility.getEngine(diagram);
    }

    public String getMessage() {
        return this.message;
    }

    public SimulationResult simulate(Diagram diagram, SimulationEngine engine, boolean logging) {
        if (!this.checkDiagram(diagram)) {
            return null;
        }
        engine.setDiagram(diagram);
        engine.setLogLevel(Level.SEVERE);
        long time = System.nanoTime();
        try {
            if (logging) {
                System.out.println("Model generation...");
            }
            Model model = engine.createModel();
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            }
            if (model == null) {
                log.log(Level.SEVERE, "Model was not generated!");
            }
            if (logging) {
                time = System.nanoTime();
                System.out.println("Simulation...");
            }
            this.message = engine.simulate(model, this.getResultListeners(engine));
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error during model simulation", t);
        }
        return this.getSimulationResult(engine, diagram);
    }

    public SimulationResult simulate(Diagram diagram, Span span, boolean logging) {
        if (!this.checkDiagram(diagram)) {
            return null;
        }
        this.loadEngine(diagram);
        this.engine.setDiagram(diagram);
        this.engine.setSpan(span);
        this.engine.setLogLevel(Level.SEVERE);
        long time = System.nanoTime();
        try {
            if (logging) {
                System.out.println("Code generation...");
            }
            File[] files = SimulationEngineUtils.generateCode((EModel)((EModel)diagram.getRole()), (SimulationEngine)this.engine);
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            }
            if (files == null) {
                log.log(Level.SEVERE, "Code was not generated!");
            }
            if (logging) {
                time = System.nanoTime();
                System.out.println("Code compilation...");
            }
            Model model = (Model)this.engine.compileModel(files, true, this.engine.getOutputDir())[0];
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            }
            if (model == null) {
                log.log(Level.SEVERE, "Model was not generated!");
            }
            if (logging) {
                time = System.nanoTime();
                System.out.println("Simulation...");
            }
            this.message = this.engine.simulate(model, this.getResultListeners(this.engine));
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds");
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error during model simulation", t);
        }
        return this.getSimulationResult(this.engine, diagram);
    }

    public SimulationResult simulate(Diagram diagram, Span span) {
        return this.simulate(diagram, span, true);
    }

    public SimulationResult simulate(Diagram diagram) {
        return this.simulate(diagram, (Span)new ArraySpan(0.0, 100.0, 1.0));
    }

    public ResultListener[] getResultListeners(SimulationEngine simulationEngine) throws Exception {
        SimulationResult res = new SimulationResult(null, "tmp");
        simulationEngine.initSimulationResult(res);
        this.currentResults = new ResultWriter(res);
        return new ResultListener[]{this.currentResults};
    }

    public SimulationResult getSimulationResult(SimulationEngine simulationEngine, String name) {
        SimulationResult simulationResult = null;
        try {
            simulationResult = new SimulationResult(null, name);
            SimulationResult tmpResult = this.currentResults.getResults();
            simulationResult.setTimes(tmpResult.getTimes());
            simulationResult.setValues(tmpResult.getValues());
            simulationEngine.initSimulationResult(simulationResult);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create simulation result.", e);
            return null;
        }
        return simulationResult;
    }

    public SimulationResult getSimulationResult(SimulationEngine simulationEngine, Diagram diagram) {
        SimulationResult simulationResult = null;
        try {
            simulationResult = new SimulationResult(null, diagram.getName() + "_result");
            SimulationResult tmpResult = this.currentResults.getResults();
            simulationResult.setTimes(tmpResult.getTimes());
            simulationResult.setValues(tmpResult.getValues());
            simulationEngine.initSimulationResult(simulationResult);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create simulation result.", e);
            return null;
        }
        return simulationResult;
    }

    public void saveResults(SimulationResult simulationResult, String dataElementPath, String description) {
        if (simulationResult == null) {
            log.log(Level.SEVERE, "Simulation result is null.");
            return;
        }
        if (dataElementPath == null) {
            log.log(Level.SEVERE, "Incorrect data element path.");
            return;
        }
        try {
            DataElementPath path = DataElementPath.create((String)dataElementPath);
            DataCollection origin = path.optParentCollection();
            if (origin != null) {
                SimulationResult simulationResultCopy = simulationResult.clone(origin, path.getName());
                simulationResultCopy.setDescription(description);
                origin.put((DataElement)simulationResultCopy);
            } else {
                log.log(Level.SEVERE, "Can not get data collection '" + dataElementPath + "' to save simulation result '" + simulationResult.getName() + "'.");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not save simulation result '" + simulationResult.getName() + "'.", e);
        }
    }

    public void saveResultsTable(SimulationResult simulationResult, String dataElementPath, String description) {
        if (simulationResult == null) {
            log.log(Level.SEVERE, "Simulation result is null.");
            return;
        }
        if (dataElementPath == null) {
            log.log(Level.SEVERE, "Incorrect data element path.");
            return;
        }
        try {
            DataElementPath path = DataElementPath.create((String)dataElementPath);
            TableDataCollection table = TableDataCollectionUtils.createTableDataCollection((DataElementPath)path);
            ColumnModel cm = table.getColumnModel();
            cm.addColumn("time", Double.class);
            Map<String, Integer> variableMap = simulationResult.getVariableMap();
            double[] times = simulationResult.getTimes();
            double[][] values = simulationResult.getValues();
            if (variableMap != null && times != null && values != null) {
                try {
                    ArrayList<Integer> indeces = new ArrayList<Integer>();
                    ArrayList<String> names = new ArrayList<String>();
                    for (Map.Entry<String, Integer> entry : variableMap.entrySet()) {
                        String name = entry.getKey();
                        if (name.equals("time") || name.endsWith("/time")) continue;
                        names.add(name);
                        indeces.add(entry.getValue());
                    }
                    for (int i = 0; i < names.size(); ++i) {
                        String columnName = (String)names.get(i);
                        if (columnName.contains("/")) {
                            columnName = columnName.replaceAll("/", ": ");
                        }
                        cm.addColumn(columnName, Double.class);
                    }
                    int timeSliceNumber = times.length;
                    int rowId = 1;
                    for (int i = 0; i < timeSliceNumber; ++i) {
                        Object[] vals = new Double[names.size() + 1];
                        vals[0] = times[i];
                        for (int j = 0; j < names.size(); ++j) {
                            vals[j + 1] = values[i][(Integer)indeces.get(j)];
                        }
                        TableDataCollectionUtils.addRow((TableDataCollection)table, (String)("row_" + Integer.toString(rowId)), (Object[])vals, (boolean)true);
                        ++rowId;
                    }
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "An error occured when saving simulation result table " + path.getName() + " query: " + ex);
                }
            }
            table.finalizeAddition();
            CollectionFactoryUtils.save((DataElement)table);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not save simulation result table '" + simulationResult.getName() + "'.", e);
        }
    }

    public void saveResults(SimulationResult simulationResult, String dataElementPath) {
        this.saveResults(simulationResult, dataElementPath, null);
    }

    public BufferedImage doPlotResults(SimulationResult simulationResult, String[] variables, String[] lineSpec, boolean show) {
        if (simulationResult == null) {
            log.log(Level.SEVERE, "Can not plot. Simulation result is null.");
            return null;
        }
        if (variables == null || variables.length == 0) {
            log.info("Array of variables to plot is empty.");
            return null;
        }
        try {
            ScriptEnvironment environment;
            Diagram diagram;
            EModel emodel = null;
            if (simulationResult.getDiagramPath() != null && (diagram = (Diagram)simulationResult.getDiagramPath().optDataElement(Diagram.class)) != null && diagram.getRole() instanceof EModel) {
                emodel = (EModel)diagram.getRole();
            }
            String[] titles = new String[variables.length];
            for (int i = 0; i < titles.length; ++i) {
                titles[i] = variables[i];
                if (emodel == null || !(emodel.getVariable(titles[i]) instanceof VariableRole)) continue;
                VariableRole var = (VariableRole)emodel.getVariable(titles[i]);
                titles[i] = var.getDiagramElement().getTitle();
            }
            Map<String, Integer> variablesMap = simulationResult.getVariableMap();
            double[] times = simulationResult.getTimes();
            double[][] values = simulationResult.getValues();
            ArrayList<XYSeries> series = new ArrayList<XYSeries>();
            for (int i = 0; i < variables.length; ++i) {
                int ind = variablesMap.get(variables[i]);
                double[] variableValues = StreamEx.of((Object[])values).mapToDouble(val -> val[ind]).toArray();
                series.add(JSPlotGenerator.createLineSeries((String)titles[i], (double[])times, (double[])variableValues));
            }
            BufferedImage plotImage = JSPlotGenerator.generatePlot((String)"Time", (String)"Quantity or concentration", series, null);
            if (show && (environment = Global.getEnvironment()) != null) {
                environment.showGraphics(plotImage);
            }
            return plotImage;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured when creating plot for simulation result " + simulationResult.getName() + " : " + ExceptionRegistry.log((Throwable)ex));
            return null;
        }
    }

    public BufferedImage doPlotResults2(SimulationResult simulationResult, String[] variables, TableDataCollection tdc, String timeColumn, String[] columns) {
        if (simulationResult == null) {
            log.log(Level.SEVERE, "Can not plot. Simulation result is null.");
            return null;
        }
        if (variables == null || variables.length == 0) {
            log.info("Array of variables to plot is empty.");
            return null;
        }
        try {
            boolean usePaths = false;
            HashSet<String> titlesSet = new HashSet<String>();
            for (int i = 0; i < variables.length; ++i) {
                String title;
                String string = title = variables[i].contains("/") ? variables[i].substring(variables[i].lastIndexOf("/") + 1) : variables[i];
                if (titlesSet.contains(title)) {
                    usePaths = true;
                    break;
                }
                titlesSet.add(title);
            }
            String[] titles = new String[variables.length];
            for (int i = 0; i < titles.length; ++i) {
                titles[i] = usePaths ? variables[i] : (variables[i].contains("/") ? variables[i].substring(variables[i].lastIndexOf("/") + 1) : variables[i]);
                titlesSet.add(titles[i]);
            }
            Map<String, Integer> variablesMap = simulationResult.getVariablePathMap();
            double[] times = simulationResult.getTimes();
            double[][] values = simulationResult.getValues();
            ArrayList<String> seriesTypes = new ArrayList<String>();
            ArrayList<XYSeries> series = new ArrayList<XYSeries>();
            for (int i = 0; i < variables.length; ++i) {
                int ind = variablesMap.get(variables[i]);
                double[] variableValues = StreamEx.of((Object[])values).mapToDouble(val -> val[ind]).toArray();
                series.add(JSPlotGenerator.createLineSeries((String)titles[i], (double[])times, (double[])variableValues));
                seriesTypes.add("line");
            }
            if (tdc != null) {
                double[] timeValues = TableDataCollectionUtils.getColumn((TableDataCollection)tdc, (String)timeColumn);
                for (int i = 0; i < columns.length; ++i) {
                    double[] columnValues = TableDataCollectionUtils.getColumn((TableDataCollection)tdc, (String)columns[i]);
                    series.add(JSPlotGenerator.createLineSeries((String)columns[i], (double[])timeValues, (double[])columnValues));
                    seriesTypes.add("experiment");
                }
            }
            BufferedImage plotImage = JSPlotGenerator.generatePlot((String)"Time", (String)"Quantity or concentration", series, seriesTypes);
            return plotImage;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error occured when creating plot for simulation result " + simulationResult.getName() + " : " + ExceptionRegistry.log((Throwable)ex));
            return null;
        }
    }

    public BufferedImage createPlot(SimulationResult simulationResult, String[] variables) {
        return this.doPlotResults(simulationResult, variables, null, false);
    }

    public BufferedImage createPlot2(SimulationResult simulationResult, String[] variables, TableDataCollection table, String[] columns) {
        return this.doPlotResults2(simulationResult, variables, table, "time", columns);
    }

    public BufferedImage createPlot2(SimulationResult simulationResult, String[] variables) {
        return this.doPlotResults2(simulationResult, variables, null, null, null);
    }

    public void plotResults(SimulationResult simulationResult, String[] variables, String[] lineSpec) {
        this.doPlotResults(simulationResult, variables, lineSpec, true);
    }

    public void plotResults(SimulationResult simulationResult, String[] variables) {
        this.plotResults(simulationResult, variables, null);
    }

    private boolean checkDiagram(Diagram diagram) {
        if (diagram == null) {
            log.log(Level.SEVERE, "The diagram is null.");
            return false;
        }
        if (!(diagram.getRole() instanceof EModel)) {
            log.log(Level.SEVERE, "Invalid executable model of the diagram " + diagram.getName());
            return false;
        }
        return true;
    }

    public void writeResult(SimulationResult result, String path, String delimiter) {
        this.writeResult(result, path, delimiter, true);
    }

    public void writeResult(SimulationResult result, String path, String delimiter, boolean logging) {
        if (logging) {
            System.out.println("Start to write");
        }
        long time = System.nanoTime();
        File resultFile = new File(path);
        double[] times = result.getTimes();
        try (PrintWriter pw = new PrintWriter(resultFile, "UTF-8");){
            StringBuilder firstLine = new StringBuilder();
            firstLine.append("time");
            for (String var : result.getVariableMap().keySet()) {
                firstLine.append(delimiter);
                firstLine.append(var);
            }
            pw.println(firstLine.toString());
            for (int i = 0; i < times.length; ++i) {
                double[] values = result.getValues()[i];
                StringBuilder line = new StringBuilder();
                line.append(times[i]);
                for (double value : values) {
                    line.append(delimiter);
                    line.append(value);
                }
                pw.println(line.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (logging) {
                System.out.println("Done. Elapsed time: " + (double)(System.nanoTime() - time) / 1.0E9);
            }
        }
    }

    public static void simulateAndApply(Diagram diagram, double endTime, double step) throws Exception {
        SimulationEngine engine = DiagramUtility.getEngine(diagram);
        engine.setDiagram(diagram);
        engine.setCompletionTime(endTime);
        SimulationResult result = new SimulationResult(null, "");
        engine.setTimeIncrement(step);
        engine.simulate(result);
        Map<String, Integer> mapping = result.getVariablePathMap();
        double[] values = result.getValue(result.getCount() - 1);
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        for (Map.Entry<String, Integer> e : mapping.entrySet()) {
            if (e.getKey().contains("time")) continue;
            String path = e.getKey();
            if (path.contains("/")) {
                String varName = path.substring(path.lastIndexOf("/") + 1);
                SubDiagram subDiagram = Util.getSubDiagram(diagram, path);
                Diagram innerDiagram = (Diagram)DataElementPath.create((String)subDiagram.getDiagramPath()).getDataElement();
                Variable var = innerDiagram.getRole(EModel.class).getVariable(varName);
                int index = e.getValue();
                double value = values[index];
                var.setInitialValue(value);
                diagrams.add(innerDiagram);
                continue;
            }
            Variable var = diagram.getRole(EModel.class).getVariable(path);
            if (var == null) {
                System.out.println((Object)var);
                continue;
            }
            var.setInitialValue(values[e.getValue()]);
        }
        for (Diagram d : diagrams) {
            d.save();
        }
        diagram.save();
    }
}

