/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.javascript;

import biouml.standard.simulation.SimulationResult;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Year;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.script.ScriptEnvironment;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.StrokeTextEditor;
import ru.biosoft.plugins.javascript.Global;
import ru.biosoft.plugins.javascript.JavaScriptHostObjectBase;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;

public class JavaScriptPlot
extends JavaScriptHostObjectBase {
    protected static final Logger log = Logger.getLogger(JavaScriptPlot.class.getName());
    protected static final Shape circle = new Ellipse2D.Float(0.0f, 0.0f, 3.0f, 3.0f);
    public static String AXIS_STANDARD = "Standard";
    public static String AXIS_DATE = "Date";
    private Plot instance = new Plot("");

    public Plot createPlot() {
        return this.createPlot("");
    }

    public Plot createPlot(String title) {
        this.instance = new Plot(title);
        return this.instance;
    }

    public Plot createPlot(String title, String xTitle, String yTitle) {
        this.instance = new Plot(title);
        this.instance.xTitle = xTitle;
        this.instance.yTitle = yTitle;
        return this.instance;
    }

    public Plot createPlot(Object obj) {
        Object expObj;
        Object curvesObj;
        Object backgroundObj;
        Object yTitleObj;
        if (!(obj instanceof NativeObject)) {
            log.info("ERROR");
        }
        NativeObject njo = (NativeObject)obj;
        String title = "";
        Object titleObj = njo.get("title", this.scope);
        if (titleObj instanceof String) {
            title = (String)titleObj;
        }
        this.createPlot(title);
        Object xTitleObj = njo.get("xTitle", this.scope);
        if (xTitleObj instanceof String) {
            this.instance.setXTitle((String)xTitleObj);
        }
        if ((yTitleObj = njo.get("yTitle", this.scope)) instanceof String) {
            this.instance.setYTitle((String)yTitleObj);
        }
        if ((backgroundObj = njo.get("backgound", this.scope)) instanceof String) {
            this.instance.setBackgroundColor((String)backgroundObj);
        }
        if ((curvesObj = njo.get("curves", this.scope)) instanceof NativeArray) {
            NativeArray ar = (NativeArray)curvesObj;
            for (int i = 0; i < ar.size(); ++i) {
                this.instance.addCurve(ar.get(i));
            }
        }
        if ((expObj = njo.get("experiments", this.scope)) instanceof NativeArray) {
            NativeArray ar = (NativeArray)expObj;
            for (int i = 0; i < ar.size(); ++i) {
                this.instance.addExperiment(ar.get(i));
            }
        }
        return this.instance;
    }

    public Plot showPlot(Object obj) {
        Plot result = this.createPlot(obj);
        ScriptEnvironment environment = Global.getEnvironment();
        if (environment != null) {
            environment.showGraphics(this.getImage());
        }
        return result;
    }

    public void showPlot() {
        ScriptEnvironment environment = Global.getEnvironment();
        if (environment != null) {
            environment.showGraphics(this.getImage());
        }
    }

    public void setBackgroundColor(String color) {
        this.instance.setBackgroundColor(color);
    }

    public Pen createPen(String color) {
        return new Pen(1.0f, JavaScriptPlot.getColor(color, Color.black));
    }

    public Pen createPen(float width, String color) {
        return new Pen(width, JavaScriptPlot.getColor(color, Color.black));
    }

    public Pen createPen(float width, String color, String stroke) {
        BasicStroke basicStroke = Pen.createBasicStroke((float[])StrokeTextEditor.getArrayByPattern((String)stroke));
        Pen pen = new Pen(basicStroke, JavaScriptPlot.getColor(color, Color.black));
        pen.setWidth((double)width);
        return pen;
    }

    public void addCurve(String title, double[] yVals, double[] xVals) {
        this.instance.addCurve(title, yVals, xVals);
    }

    public void addCurve(String title, double[] yVals, double[] xVals, Pen pen) {
        this.instance.addCurve(title, yVals, xVals, pen);
    }

    public void addCurve(String title, SimulationResult res, String yPath, String xPath) {
        this.instance.addCurve(title, res, yPath, xPath);
    }

    public void addCurve(String title, SimulationResult res, String yPath, String xPath, Pen pen) {
        this.instance.addCurve(title, res, yPath, xPath, pen);
    }

    public void addCurve(String title, Object obj) {
        this.instance.addCurve(title, obj);
    }

    public void addCurve(Object obj) {
        this.instance.addCurve(obj);
    }

    public void addExperiment(Object obj) {
        this.instance.addExperiment(obj);
    }

    public void addExperiment(String title, double[] yVals, double[] xVals) {
        this.instance.addExperiment(title, yVals, xVals);
    }

    public void addExperiment(String title, double[] yVals, double[] xVals, Pen pen) {
        this.instance.addExperiment(title, yVals, xVals, pen);
    }

    public void addExperiment(String title, TableDataCollection tdc, String yColumn, String xColumn) {
        this.instance.addExperiment(title, tdc, yColumn, xColumn);
    }

    public void addExperiment(String title, TableDataCollection tdc, String yColumn, String xColumn, Pen pen) {
        this.instance.addExperiment(title, tdc, yColumn, xColumn, pen);
    }

    public BufferedImage getImage() {
        return this.instance.getImage();
    }

    public BufferedImage getImage(int width, int height) {
        return this.instance.getImage(width, height);
    }

    public void setXTitle(String xTitle) {
        this.instance.setXTitle(xTitle);
    }

    public void setYTitle(String yTitle) {
        this.instance.setYTitle(yTitle);
    }

    public void setXFrom(double xFrom) {
        this.instance.setXFrom(xFrom);
    }

    public void setXTo(double xTo) {
        this.instance.setXTo(xTo);
    }

    public void setYFrom(double yFrom) {
        this.instance.setYFrom(yFrom);
    }

    public void setYTo(double yTo) {
        this.instance.setYTo(yTo);
    }

    public static Color getColor(String str, Color defaultColor) {
        switch (str) {
            case "red": {
                return Color.red;
            }
            case "blue": {
                return Color.blue;
            }
            case "green": {
                return Color.green;
            }
            case "black": {
                return Color.black;
            }
            case "cyan": {
                return Color.cyan;
            }
            case "darkGray": {
                return Color.darkGray;
            }
            case "magenta": {
                return Color.magenta;
            }
            case "orange": {
                return Color.orange;
            }
            case "pink": {
                return Color.pink;
            }
            case "gray": {
                return Color.gray;
            }
        }
        return defaultColor;
    }

    public static class Variable {
        private String title;
        private double[] yData;
        private double[] xData;
        private VarType type;
        private Pen pen;

        public Variable(String title, double[] data, VarType type, Pen pen) {
            this.title = title;
            this.yData = data;
            this.type = type;
            this.pen = pen;
        }

        public Variable(String title, double[] data, double[] xData, VarType type, Pen pen) {
            this.title = title;
            this.yData = data;
            this.xData = xData;
            this.type = type;
            this.pen = pen;
        }
    }

    public static enum VarType {
        EXPERIMENT,
        SIMULATION;

    }

    public class Plot {
        private String title = "";
        private String xTitle = "Time";
        private String yTitle = "Quantity or concentration";
        private Color background = Color.white;
        private List<Variable> yVariables = new ArrayList<Variable>();
        private double xFrom = Double.NaN;
        private double xTo = Double.NaN;
        private double yFrom = Double.NaN;
        private double yTo = Double.NaN;
        private String xType = AXIS_STANDARD;
        private String dateFormat = "MMMM";
        private int startingYear = 2020;
        private int labelFontSize = 18;
        private int tickFontSize = 16;
        private boolean verticalTicks = false;

        public Plot(String title) {
            this.title = title;
        }

        public void setBackgroundColor(String color) {
            this.background = JavaScriptPlot.getColor(color, Color.white);
        }

        public void setYTitle(String yTitle) {
            this.yTitle = yTitle;
        }

        public void setXTitle(String xTitle) {
            this.xTitle = xTitle;
        }

        public void setXType(String xType) {
            this.xType = xType;
        }

        public void setDateFormat(String format) {
            this.dateFormat = format;
        }

        public void setStartingYear(int year) {
            this.startingYear = year;
        }

        public void setLabelFontSize(int size) {
            this.labelFontSize = size;
        }

        public void setTickFontSize(int size) {
            this.tickFontSize = size;
        }

        public void setVerticalTick(boolean verticalTicks) {
            this.verticalTicks = verticalTicks;
        }

        public void addCurve(String title, double[] vals, double[] xVals) {
            this.addCurve(title, vals, xVals, null);
        }

        public void addCurve(String title, double[] vals, double[] xVals, Pen pen) {
            this.yVariables.add(new Variable(title, vals, xVals, VarType.SIMULATION, pen));
        }

        public void addCurve(String title, SimulationResult res, String yPath, String xPath) {
            this.addCurve(title, res.getValues(yPath), res.getValues(xPath));
        }

        public void addCurve(String title, SimulationResult res, String yPath, String xPath, Pen pen) {
            this.addCurve(title, res.getValues(yPath), res.getValues(xPath), pen);
        }

        public void addExperiment(String title, double[] yVals, double[] xVals) {
            this.addExperiment(title, yVals, xVals, null);
        }

        public void addExperiment(String title, double[] yVals, double[] xVals, Pen pen) {
            this.yVariables.add(new Variable(title, yVals, xVals, VarType.EXPERIMENT, pen));
        }

        public void addExperiment(String title, TableDataCollection tdc, String column, String xColumn) {
            this.addExperiment(title, tdc, column, xColumn, null);
        }

        public void addExperiment(String title, TableDataCollection tdc, String yColumn, String xColumn, Pen pen) {
            this.addExperiment(title, TableDataCollectionUtils.getColumn((TableDataCollection)tdc, (String)yColumn), TableDataCollectionUtils.getColumn((TableDataCollection)tdc, (String)xColumn), pen);
        }

        public BufferedImage getImage() {
            return this.getImage(550, 350);
        }

        public void setXFrom(double xFrom) {
            this.xFrom = xFrom;
        }

        public void setXTo(double xTo) {
            this.xTo = xTo;
        }

        public void setYFrom(double yFrom) {
            this.yFrom = yFrom;
        }

        public void setYTo(double yTo) {
            this.yTo = yTo;
        }

        private void addXYSeries(XYSeriesCollection dataset, String name, double[] xData, double[] yData) {
            XYSeries series = new XYSeries((Comparable)((Object)name), false, true);
            for (int j = 0; j < Math.min(yData.length, xData.length); ++j) {
                series.add(xData[j], yData[j]);
            }
            dataset.addSeries(series);
        }

        private void addTimeSeries(TimeSeriesCollection dataset, String name, double[] xData, double[] yData) {
            TimeSeries series = new TimeSeries((Comparable)((Object)name));
            for (int j = 0; j < Math.min(yData.length, xData.length); ++j) {
                int xVal;
                int year = this.startingYear;
                int length = Year.of(year).length();
                for (xVal = (int)xData[j]; xVal > length; xVal -= length) {
                    length = Year.of(++year).length();
                }
                if (xVal == 0) {
                    xVal = Year.of(--year).length();
                }
                LocalDate dayExp = Year.of(year).atDay(xVal);
                Day day = new Day(dayExp.getDayOfMonth(), dayExp.getMonthValue(), dayExp.getYear());
                series.add((RegularTimePeriod)day, yData[j]);
            }
            dataset.addSeries(series);
        }

        private AbstractXYDataset fillDataSet(XYLineAndShapeRenderer renderer) {
            boolean dateType = this.xType.equals(AXIS_DATE);
            TimeSeriesCollection dataset = dateType ? new TimeSeriesCollection() : new XYSeriesCollection();
            int counter = 0;
            for (Variable var : this.yVariables) {
                if (!dateType) {
                    this.addXYSeries((XYSeriesCollection)dataset, var.title, var.xData, var.yData);
                } else {
                    this.addTimeSeries(dataset, var.title, var.xData, var.yData);
                }
                if (var.type.equals((Object)VarType.EXPERIMENT)) {
                    renderer.setSeriesLinesVisible(counter, false);
                    renderer.setSeriesShape(counter, circle);
                    if (var.pen != null) {
                        renderer.setSeriesFillPaint(counter, (Paint)var.pen.getColor());
                        renderer.setSeriesPaint(counter, (Paint)var.pen.getColor());
                    }
                } else {
                    renderer.setSeriesShapesVisible(counter, false);
                    if (var.pen != null) {
                        renderer.setSeriesPaint(counter, (Paint)var.pen.getColor());
                        renderer.setSeriesStroke(counter, (Stroke)var.pen.getStroke());
                    }
                }
                ++counter;
            }
            return dataset;
        }

        public BufferedImage getImage(int width, int height) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setDrawSeriesLineAsPath(true);
            AbstractXYDataset xyDataset = this.fillDataSet(renderer);
            JFreeChart chart = ChartFactory.createXYLineChart((String)this.title, (String)this.xTitle, (String)this.yTitle, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)this.background);
            if (!Double.isNaN(this.xTo)) {
                chart.getXYPlot().getDomainAxis().setUpperBound(this.xTo);
            }
            if (!Double.isNaN(this.xFrom)) {
                chart.getXYPlot().getDomainAxis().setLowerBound(this.xFrom);
            }
            if (!Double.isNaN(this.yTo)) {
                chart.getXYPlot().getRangeAxis().setUpperBound(this.yTo);
            }
            if (!Double.isNaN(this.yFrom)) {
                chart.getXYPlot().getRangeAxis().setLowerBound(this.yFrom);
            }
            chart.getXYPlot().setBackgroundPaint((Paint)this.background);
            chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
            if (this.xType.equals(AXIS_DATE)) {
                DateAxis dateAxis = new DateAxis();
                dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(this.dateFormat));
                chart.getXYPlot().setDomainAxis((ValueAxis)dateAxis);
            }
            chart.getXYPlot().getDomainAxis().setTickMarkPaint((Paint)Color.black);
            chart.getXYPlot().getRangeAxis().setTickMarkPaint((Paint)Color.black);
            chart.getXYPlot().getDomainAxis().setVerticalTickLabels(this.verticalTicks);
            chart.getXYPlot().getDomainAxis().setLabelFont(new Font("Arial", 1, this.labelFontSize));
            chart.getXYPlot().getDomainAxis().setTickLabelFont(new Font("Arial", 0, this.tickFontSize));
            chart.getXYPlot().getRangeAxis().setLabelFont(new Font("Arial", 1, this.labelFontSize));
            chart.getXYPlot().getRangeAxis().setTickLabelFont(new Font("Arial", 0, this.tickFontSize));
            return chart.createBufferedImage(width, height);
        }

        public void addCurve(Object obj) {
            if (!(obj instanceof NativeObject)) {
                log.info("ERROR");
            }
            NativeObject njo = (NativeObject)obj;
            String title = njo.get("title", JavaScriptPlot.this.scope).toString();
            this.addCurve(title, obj);
        }

        public void addCurve(String title, Object obj) {
            if (!(obj instanceof NativeObject)) {
                log.info("ERROR");
            }
            NativeObject njo = (NativeObject)obj;
            Object penObj = njo.get("pen", JavaScriptPlot.this.scope);
            Pen pen = null;
            if (penObj instanceof NativeJavaObject) {
                pen = (Pen)((NativeJavaObject)penObj).unwrap();
            }
            Object yValObj = njo.get("yValues", JavaScriptPlot.this.scope);
            Object xValObj = njo.get("xValues", JavaScriptPlot.this.scope);
            if ((yValObj instanceof NativeArray || yValObj instanceof NativeJavaArray) && (xValObj instanceof NativeArray || xValObj instanceof NativeJavaArray)) {
                double[] yValues = Global.getDoubleArrayFromObject((Scriptable)JavaScriptPlot.this.scope, (Object)yValObj);
                double[] xValues = Global.getDoubleArrayFromObject((Scriptable)JavaScriptPlot.this.scope, (Object)xValObj);
                this.addCurve(title, yValues, xValues, pen);
                return;
            }
            Object sourceObj = njo.get("source", JavaScriptPlot.this.scope);
            if (sourceObj instanceof NativeJavaObject) {
                SimulationResult result = (SimulationResult)((NativeJavaObject)sourceObj).unwrap();
                Object yVarObj = njo.get("yVariable", JavaScriptPlot.this.scope);
                Object xVarObj = njo.get("xVariable", JavaScriptPlot.this.scope);
                this.addCurve(title, result, yVarObj.toString(), xVarObj.toString(), pen);
                return;
            }
        }

        public void addExperiment(Object obj) {
            if (!(obj instanceof NativeObject)) {
                log.info("ERROR");
            }
            NativeObject njo = (NativeObject)obj;
            String title = njo.get("title", JavaScriptPlot.this.scope).toString();
            Object penObj = njo.get("pen", JavaScriptPlot.this.scope);
            Pen pen = null;
            if (penObj instanceof NativeJavaObject) {
                pen = (Pen)((NativeJavaObject)penObj).unwrap();
            }
            Object yValObj = njo.get("yValues", JavaScriptPlot.this.scope);
            Object xValObj = njo.get("xValues", JavaScriptPlot.this.scope);
            if (yValObj instanceof NativeArray && xValObj instanceof NativeArray) {
                double[] yValues = Global.getDoubleArrayFromObject((Scriptable)JavaScriptPlot.this.scope, (Object)yValObj);
                double[] xValues = Global.getDoubleArrayFromObject((Scriptable)JavaScriptPlot.this.scope, (Object)xValObj);
                this.addExperiment(title, yValues, xValues, pen);
                return;
            }
            Object sourceObj = njo.get("source", JavaScriptPlot.this.scope);
            if (sourceObj instanceof NativeJavaObject) {
                Object javaObject = ((NativeJavaObject)sourceObj).unwrap();
                TableDataCollection tdc = null;
                if (javaObject instanceof TableDataCollection) {
                    tdc = (TableDataCollection)javaObject;
                } else if (javaObject instanceof String) {
                    tdc = (TableDataCollection)DataElementPath.create((String)javaObject.toString()).getDataElement(TableDataCollection.class);
                }
                Object yVarObj = njo.get("yColumn", JavaScriptPlot.this.scope);
                Object xVarObj = njo.get("xColumn", JavaScriptPlot.this.scope);
                this.addExperiment(title, tdc, yVarObj.toString(), xVarObj.toString(), pen);
            }
        }
    }
}

