/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.javascript;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.standard.diagram.BusProperties;
import biouml.standard.diagram.CompositeDiagramType;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.SplitDiagramAction;
import biouml.standard.diagram.SubDiagramProperties;
import biouml.standard.diagram.Util;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.mozilla.javascript.NativeObject;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.exception.LoggedClassNotFoundException;
import ru.biosoft.plugins.javascript.JavaScriptHostObjectBase;
import ru.biosoft.table.RowDataElement;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;

public class JavaScriptModel
extends JavaScriptHostObjectBase {
    protected static final Logger log = Logger.getLogger(JavaScriptModel.class.getName());

    public Diagram createCompositeDiagram(DataCollection origin, String name) throws Exception {
        Diagram result = new CompositeDiagramType().createDiagram(origin, name, new DiagramInfo(name));
        result.save();
        return result;
    }

    public double getInitialValue(Diagram diagram, String variableName) {
        return this.getVariable(diagram, variableName).getInitialValue();
    }

    public void setInitialValue(Diagram diagram, String variableName, double value) {
        this.getVariable(diagram, variableName).setInitialValue(value);
    }

    public double[] getInitialValues(Diagram diagram, String[] variableNames) {
        StreamEx varStream = variableNames == null ? StreamEx.of((Stream)diagram.getRole(EModel.class).getVariables().stream()) : StreamEx.of((Object[])variableNames).map(name -> this.getVariable(diagram, (String)name));
        return varStream.mapToDouble(Variable::getInitialValue).toArray();
    }

    public void setInitialValues(Diagram diagram, String[] variableNames, double[] values) {
        if (values == null) {
            throw new IllegalArgumentException("Values array is null.");
        }
        if (variableNames == null) {
            Variable[] variables = this.getVariables(diagram);
            if (values.length != variables.length) {
                throw new IllegalArgumentException("Values array length must be equal to the number of diagram variables.");
            }
            for (int i = 0; i < variables.length; ++i) {
                variables[i].setInitialValue(values[i]);
            }
            return;
        }
        if (variableNames.length != values.length) {
            throw new IllegalArgumentException("Lengths of variableNames and values arrays must be the same.");
        }
        for (int i = 0; i < variableNames.length; ++i) {
            this.getVariable(diagram, variableNames[i]).setInitialValue(values[i]);
        }
    }

    public boolean getBoundaryCondition(Diagram diagram, String variableName) {
        Variable var = this.getVariable(diagram, variableName);
        if (var instanceof VariableRole) {
            return ((VariableRole)var).isBoundaryCondition();
        }
        return false;
    }

    public void setBoundaryCondition(Diagram diagram, String variableName, boolean value) {
        Variable var = this.getVariable(diagram, variableName);
        if (var instanceof VariableRole) {
            ((VariableRole)var).setBoundaryCondition(value);
        } else {
            log.log(Level.SEVERE, "Parameter " + variableName + " can not be set to boundary condition");
        }
    }

    public String[] getBoundaryConditions(Diagram diagram) {
        return (String[])diagram.getRole(EModel.class).getVariableRoles().stream().filter(VariableRole::isBoundaryCondition).map(VariableRole::getName).toArray(String[]::new);
    }

    public void setBoundaryConditions(Diagram diagram, String[] variables) {
        EModel role = diagram.getRole(EModel.class);
        for (String variableName : variables) {
            Variable var = role.getVariable(variableName);
            if (var == null) {
                log.log(Level.SEVERE, "Variable " + variableName + " was not found in diagram " + diagram.getName());
                continue;
            }
            if (!(var instanceof VariableRole)) {
                log.log(Level.SEVERE, "Parameter " + variableName + " can not be set to boundary condition");
                continue;
            }
            ((VariableRole)var).setBoundaryCondition(true);
        }
    }

    public boolean isConstant(Diagram diagram, String variableName) {
        return this.getVariable(diagram, variableName).isConstant();
    }

    public void setConstant(Diagram diagram, String variableName, boolean value) {
        this.getVariable(diagram, variableName).setConstant(value);
    }

    public String[] getConstants(Diagram diagram) {
        return (String[])diagram.getRole(EModel.class).getVariables().stream().filter(Variable::isConstant).map(Variable::getName).toArray(String[]::new);
    }

    public void setConstants(Diagram diagram, String[] variables) {
        EModel role = diagram.getRole(EModel.class);
        for (String variableName : variables) {
            Variable var = role.getVariable(variableName);
            if (var == null) {
                log.log(Level.SEVERE, "Variable " + variableName + " was not found in diagram " + diagram.getName());
                continue;
            }
            var.setConstant(true);
        }
    }

    public void clearAllBoundaryConditions(Diagram diagram) {
        diagram.getRole(EModel.class).getVariableRoles().stream().forEach(var -> var.setBoundaryCondition(false));
    }

    public void clearAllConstants(Diagram diagram) {
        diagram.getRole(EModel.class).getVariables().stream().forEach(var -> var.setConstant(false));
    }

    public Role getMath(Diagram diagram, String mathName) throws Exception {
        try {
            Role role = diagram.findNode(mathName).getRole();
            if (role instanceof Equation || role instanceof Function || role instanceof Event || role instanceof Assignment) {
                return role;
            }
        }
        catch (Exception ex) {
            throw new Exception("Can not get math with name " + mathName, ex);
        }
        throw new Exception("Can not get math with name " + mathName);
    }

    public String[] getVariableNames(Diagram diagram) {
        DataCollection<Variable> dc = diagram.getRole(EModel.class).getVariables();
        return (String[])dc.names().toArray(String[]::new);
    }

    public Variable getVariable(Diagram diagram, String variableName) {
        Variable var = Util.getVariable(diagram, variableName);
        if (var == null) {
            throw new IllegalArgumentException("Variable " + variableName + " not found");
        }
        return var;
    }

    public Variable[] getVariables(Diagram diagram) {
        return (Variable[])diagram.getRole(EModel.class).getVariables().stream().toArray(Variable[]::new);
    }

    public Variable[] getVariableRoles(Diagram diagram) {
        return (Variable[])diagram.getRole(EModel.class).getVariableRoles().stream().toArray(Variable[]::new);
    }

    public Diagram clone(Diagram diagram, String name) throws Exception {
        return diagram.clone(diagram.getOrigin(), name);
    }

    private static Map<String, Object> convertNativeObject(NativeObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object id : object.getIds()) {
            map.put(id.toString(), object.getAssociatedValue(id));
        }
        return map;
    }

    private Object convertType(String type) {
        if (type.endsWith(".class")) {
            try {
                return ClassLoading.loadClass((String)type.substring(0, type.length() - ".class".length()));
            }
            catch (LoggedClassNotFoundException e) {
                e.log();
                return null;
            }
        }
        return type;
    }

    protected Diagram getDiagram(DiagramElement de) {
        Diagram diagram = Diagram.getDiagram(de);
        while (diagram.getOrigin() instanceof DiagramElement) {
            DiagramElement origin = (DiagramElement)diagram.getOrigin();
            diagram = Diagram.getDiagram(origin);
        }
        return diagram;
    }

    protected DiagramElement add(@Nonnull Compartment compartment, Point pt, Object type, Map<String, Object> properties) {
        DiagramElement de = this.createElement(compartment, pt, type, properties);
        if (this.putElement(compartment, de)) {
            return de;
        }
        return null;
    }

    protected DiagramElement createElement(@Nonnull Compartment compartment, Point pt, Object type, Map<String, Object> properties) {
        DefaultSemanticController semanticController = (DefaultSemanticController)this.getDiagram(compartment).getType().getSemanticController();
        Object elementProperties = semanticController.getPropertiesByType(compartment, type, pt);
        if (elementProperties != null) {
            if (properties != null && !properties.isEmpty()) {
                ComponentModel model = ComponentFactory.getModel((Object)elementProperties);
                for (Map.Entry entry : EntryStream.of(properties).mapKeys(arg_0 -> ((ComponentModel)model).findProperty(arg_0)).nonNullKeys()) {
                    try {
                        ((Property)entry.getKey()).setValue(entry.getValue());
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Cannot set property " + ((Property)entry.getKey()).getName(), e);
                    }
                }
            }
            return semanticController.createInstance(compartment, type, pt, elementProperties).getElement();
        }
        return semanticController.createInstance(compartment, type, pt, (Object)null).getElement();
    }

    protected boolean putElement(Compartment compartment, DiagramElement de) {
        if (de == null) {
            log.log(Level.SEVERE, "putElement: No diagram element is provided");
            return false;
        }
        DefaultSemanticController semanticController = (DefaultSemanticController)this.getDiagram(compartment).getType().getSemanticController();
        if (semanticController.canAccept(compartment, de)) {
            try {
                compartment.put(de);
                return true;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "The equation adding error", t);
            }
        } else {
            log.info("Can not accept equation '" + de.getName() + "' to diagram '" + compartment.getName() + "'");
        }
        return false;
    }

    public void add(Compartment compartment, int x, int y, String type, NativeObject properties) {
        if (compartment == null) {
            throw new IllegalArgumentException("compartment is null");
        }
        this.add(compartment, new Point(x, y), this.convertType(type), JavaScriptModel.convertNativeObject(properties));
    }

    public void add(Compartment compartment, String type, NativeObject properties) {
        this.add(compartment, 0, 0, type, properties);
    }

    public void addEquation(Diagram diagram, String type, String variable, String formula) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("formula", formula);
        properties.put("variable", variable);
        properties.put("type", type);
        this.add(diagram, new Point(0, 0), Equation.class, properties);
    }

    public void addSubDiagram(Diagram diagram, String subDiagramPath, String name) {
        SubDiagramProperties properties = new SubDiagramProperties(diagram);
        properties.setDiagramPath(DataElementPath.create((String)subDiagramPath));
        properties.setName(name);
        DiagramElementGroup deg = diagram.getType().getSemanticController().createInstance((Compartment)diagram, SubDiagram.class, new Point(), properties);
        deg.putToCompartment();
    }

    public void addPublicPort(Diagram diagram, String variable, String type) {
        if (diagram.getRole(EModel.class).getVariable(variable) == null) {
            throw new IllegalArgumentException("Diagram " + diagram.getName() + " has no variable " + variable);
        }
        PortProperties properties = new PortProperties(diagram, type);
        if (properties.alreadyHasPort(variable, type, "public")) {
            return;
        }
        properties.setVarName(variable);
        properties.setAccessType("public");
        diagram.getType().getSemanticController().createInstance((Compartment)diagram, Stub.ConnectionPort.class, new Point(), properties);
    }

    public void addPrivatePort(Diagram diagram, String subDiagraName, String variable) {
        SubDiagram subDiagram = Util.getSubDiagram(diagram, subDiagraName);
        if (subDiagram == null) {
            throw new IllegalArgumentException("Diagram " + diagram.getName() + " has no subdiagram " + subDiagraName);
        }
        Node subDiagramPort = ((StreamEx)subDiagram.stream().select(Node.class).filter(n -> Util.isPort(n))).findAny(n -> variable.equals(Util.getPortVariable(n))).orElse(null);
        if (subDiagramPort == null) {
            throw new IllegalArgumentException("SubDiagram " + subDiagraName + " has no port for variable " + variable);
        }
        String type = Util.getPortType(subDiagramPort);
        String oppositeType = type == "input" ? "output" : (type == "output" ? "input" : "contact");
        EModel emodel = diagram.getRole(EModel.class);
        if (!emodel.containsVariable(variable)) {
            double initialValue = subDiagram.getDiagram().getRole(EModel.class).getVariable(variable).getInitialValue();
            emodel.declareVariable(variable, initialValue);
        }
        Point location = subDiagramPort.getLocation();
        location.x += subDiagram.getShapeSize().width + 100;
        PortProperties properties = new PortProperties(diagram, oppositeType);
        properties.setVarName(variable);
        properties.setAccessType("private");
        DiagramElementGroup deg = diagram.getType().getSemanticController().createInstance((Compartment)diagram, Stub.ConnectionPort.class, location, properties);
        Node port = deg.nodesStream().findAny(n -> Util.isPort(n)).orElse(null);
        Util.setPortOrientation(port, SubDiagram.PortOrientation.LEFT);
        if (port == null) {
            return;
        }
        String name = DefaultSemanticController.generateUniqueName(diagram, "Connection");
        Edge edge = type == "input" ? new Edge(new Stub.DirectedConnection(null, name), port, subDiagramPort) : (type == "output" ? new Edge(new Stub.DirectedConnection(null, name), subDiagramPort, port) : new Edge(new Stub.UndirectedConnection(null, name), subDiagramPort, port));
        Connection role = type == "contact" ? new UndirectedConnection(edge) : new DirectedConnection(edge);
        role.setInputPort(new Connection.Port(variable, variable));
        role.setOutputPort(new Connection.Port(variable, variable));
        edge.setRole(role);
        diagram.put(edge);
    }

    public Event addEvent(Diagram diagram) {
        return this.add(diagram, new Point(0, 0), Event.class, null).getRole(Event.class);
    }

    public void addEvent(Diagram diagram, String trigger, double delay, Assignment[] actions) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("trigger", trigger);
        properties.put("delay", Double.toString(delay));
        properties.put("eventAssignment", actions);
        this.add(diagram, new Point(0, 0), Event.class, properties);
    }

    public Assignment createAssignment(Diagram diagram, String variable, String math) {
        if (diagram.getRole(EModel.class).getVariable(variable) == null) {
            throw new IllegalArgumentException("Diagram " + diagram.getName() + " has no variable " + variable);
        }
        return new Assignment(variable, math);
    }

    public SpecieReference createSpecieReference(Diagram diagram, String variable, String role, double stoichiometry) {
        try {
            Node node = diagram.findNode(variable);
            if (node == null) {
                log.log(Level.SEVERE, "Diagram '" + diagram.getName() + "' has no variable '" + variable + "'.");
                return null;
            }
            if (!(role.equals("product") || role.equals("reactant") || role.equals("modifier"))) {
                log.log(Level.SEVERE, "Unknown role of the specie. Possible values are: reactant', 'product', 'modifier'.");
                return null;
            }
            SpecieReference specieReference = new SpecieReference(null, variable, role);
            specieReference.setStoichiometry(Double.toString(stoichiometry));
            specieReference.setSpecie(variable);
            return specieReference;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create specie reference.", e);
            return null;
        }
    }

    public Diagram split(Diagram diagram, String[] names, String path, String name) {
        SplitDiagramAction action = new SplitDiagramAction();
        ArrayList<DiagramElement> found = new ArrayList<DiagramElement>();
        ArrayList<String> notFound = new ArrayList<String>();
        for (String n : names) {
            DiagramElement de = diagram.findDiagramElement(n);
            if (de == null) {
                notFound.add(n);
                continue;
            }
            found.add(de);
        }
        if (found.isEmpty()) {
            log.log(Level.SEVERE, "No elements found in the diagram");
        } else if (!notFound.isEmpty()) {
            log.log(Level.SEVERE, "Elements not found in diagram: " + StreamEx.of(notFound).joining((CharSequence)","));
        }
        SplitDiagramAction.SplitDiagramActionParameters parameters = new SplitDiagramAction.SplitDiagramActionParameters();
        parameters.setAutoIncludeReactions(true);
        parameters.setAddModule(false);
        DataElementPath.create((String)path);
        DataElementPath resultPath = DataElementPath.create((String)path, (String[])new String[]{name});
        parameters.setResultPath(resultPath);
        return action.doSplit(diagram, found, parameters);
    }

    public SpecieReference createSpecieReference(Diagram diagram, String variable, String role) {
        return this.createSpecieReference(diagram, variable, role, 1.0);
    }

    public void addReaction(Diagram diagram, String formula, boolean fast, SpecieReference[] specieReferences) {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            KineticLaw kineticLaw = new KineticLaw();
            kineticLaw.setFormula(formula);
            properties.put("kineticLaw", (Object)kineticLaw);
            properties.put("fast", fast);
            properties.put("specieReferences", specieReferences);
            this.add(diagram, new Point(0, 0), Reaction.class, properties);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not add the reaction.", e);
        }
    }

    public void addReaction(Diagram diagram, String formula, SpecieReference[] specieReferences) {
        this.addReaction(diagram, formula, false, specieReferences);
    }

    public void addSpecies(Diagram diagram, String dataElementPath, double initialValue) {
        try {
            DataElementPath path;
            DataCollection origin;
            Object type;
            DiagramElement node;
            if (diagram == null) {
                throw new IllegalArgumentException("Diagram is null.");
            }
            if (dataElementPath == null) {
                log.log(Level.SEVERE, "Incorrect data element path.");
            }
            if ((node = this.createElement(diagram, new Point(0, 0), type = (origin = (path = DataElementPath.create((String)dataElementPath)).optParentCollection()) != null ? origin.getDataElementType() : "entity", null)) != null) {
                String name = path.getName();
                DiagramElement newNode = node.clone((Compartment)node.getOrigin(), name);
                newNode.setTitle(newNode.getName());
                if (this.putElement(diagram, newNode)) {
                    this.setInitialValue(diagram, name, initialValue);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not add specie.", e);
        }
    }

    public static void addBuses(Diagram diagram) throws Exception {
        for (SubDiagram subDiagram : Util.getSubDiagrams(diagram)) {
            EModel emodel = diagram.getRole(EModel.class);
            for (Node port : subDiagram.getNodes()) {
                Connection role;
                Edge e;
                Point p;
                if (port.getEdges().length != 0) continue;
                String variableName = Util.getPortVariable(port);
                if (variableName.contains(".")) {
                    variableName = variableName.substring(variableName.lastIndexOf(".") + 1);
                }
                if (variableName.startsWith("$")) {
                    variableName = variableName.substring(1);
                }
                BusProperties properties = new BusProperties(emodel);
                properties.setName(variableName);
                switch (Util.getPortOrientation(port)) {
                    case LEFT: {
                        p = new Point(subDiagram.getLocation().x - 100, port.getLocation().y);
                        break;
                    }
                    case RIGHT: {
                        p = new Point(subDiagram.getLocation().x + subDiagram.getShapeSize().width + 50, port.getLocation().y);
                        break;
                    }
                    case BOTTOM: {
                        p = new Point(port.getLocation().x, subDiagram.getLocation().y + subDiagram.getShapeSize().height + 50);
                        break;
                    }
                    case TOP: {
                        p = new Point(port.getLocation().x, subDiagram.getLocation().y - 100);
                        break;
                    }
                    default: {
                        p = new Point();
                    }
                }
                String type = Util.getPortType(port);
                Node bus = (Node)properties.createElements(diagram, p, null).getElement();
                bus.setLocation(p);
                diagram.put(bus);
                if (type.equals("contact")) {
                    e = new Edge(new Stub.UndirectedConnection(diagram, DefaultSemanticController.generateUniqueNodeName(diagram, "connection")), port, bus);
                    role = new UndirectedConnection(e);
                } else if (type.equals("input")) {
                    e = new Edge(new Stub.DirectedConnection(diagram, DefaultSemanticController.generateUniqueNodeName(diagram, "connection")), bus, port);
                    role = new DirectedConnection(e);
                } else {
                    e = new Edge(new Stub.DirectedConnection(diagram, DefaultSemanticController.generateUniqueNodeName(diagram, "connection")), port, bus);
                    role = new DirectedConnection(e);
                }
                role.setInputPort(new Connection.Port(variableName));
                role.setOutputPort(new Connection.Port(variableName));
                diagram.put(e);
            }
        }
    }

    public static void generateEvents(TableDataCollection collection, String timeColumn, Diagram diagram) {
        SemanticController controller = diagram.getType().getSemanticController();
        String[] names = TableDataCollectionUtils.getColumnNames((TableDataCollection)collection);
        int timeIndex = TableDataCollectionUtils.getColumnIndexes((TableDataCollection)collection, (String[])new String[]{timeColumn})[0];
        HashMap<String, Double> assignments = new HashMap<String, Double>();
        for (RowDataElement row : collection) {
            assignments.clear();
            Object[] values = row.getValues();
            double time = 0.0;
            for (int i = 0; i < row.size(); ++i) {
                Double value = (Double)values[i];
                if (value.isNaN()) continue;
                if (i == timeIndex) {
                    time = value;
                    continue;
                }
                assignments.put(names[i], value);
            }
            JavaScriptModel.addEvent(diagram, controller, time, assignments);
        }
    }

    private static void addEvent(Diagram diagram, SemanticController controller, double time, Map<String, Double> assignments) {
        Assignment[] assignmentArray = new Assignment[assignments.size()];
        int index = 0;
        for (Map.Entry<String, Double> assignment : assignments.entrySet()) {
            double value = assignment.getValue();
            String key = assignment.getKey();
            assignmentArray[index] = new Assignment(key, String.valueOf(value));
            ++index;
        }
        Event event = new Event(null, "time >= " + time, null, assignmentArray);
        DiagramElementGroup group = controller.createInstance((Compartment)diagram, Event.class, new Point(), event);
        group.nodesStream().forEach(node -> diagram.put((DiagramElement)((Object)node)));
    }

    public void setInitialValues(Diagram diagram, TableDataCollection table, String rowID) {
        DiagramUtility.setInitialValues(diagram, table, rowID);
    }

    public SubDiagram[] getSubDiagrams(Diagram diagram) {
        return (SubDiagram[])diagram.recursiveStream().select(SubDiagram.class).toArray(SubDiagram[]::new);
    }

    public Reaction[] getReactions(Diagram diagram) {
        return (Reaction[])diagram.recursiveStream().map(de -> de.getKernel()).select(Reaction.class).toArray(Reaction[]::new);
    }

    public Equation[] getODE(Diagram diagram) {
        return (Equation[])diagram.getRole(EModel.class).getODE().toArray(Equation[]::new);
    }

    public Equation[] getAlgebraic(Diagram diagram) {
        return (Equation[])diagram.getRole(EModel.class).getAlgebraic().toArray(Equation[]::new);
    }

    public Event[] getEvents(Diagram diagram) {
        return diagram.getRole(EModel.class).getEvents();
    }

    public Reaction[] getFastReactions(Diagram diagram) {
        return (Reaction[])((StreamEx)diagram.recursiveStream().map(de -> de.getKernel()).select(Reaction.class).filter(r -> r.isFast())).toArray(Reaction[]::new);
    }
}

