/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.javascript;

import biouml.model.javascript.BarChart;
import biouml.model.javascript.StatisticalBarChart;
import java.awt.Font;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.mozilla.javascript.NativeObject;
import ru.biosoft.plugins.javascript.JavaScriptHostObjectBase;

public class JavaScriptBarChart
extends JavaScriptHostObjectBase {
    protected static final Logger log = Logger.getLogger(JavaScriptBarChart.class.getName());

    public StatisticalBarChart createStatisticalBarChart(Object settings) {
        StatisticalBarChart bc = new StatisticalBarChart();
        this.applySettings(bc, settings);
        return bc;
    }

    public void applySettings(BarChart bc, Object settings) {
        Object lableFontObj;
        Object lablePositionObj;
        Object yToObj;
        Object yFromObj;
        Object yTitleObj;
        Object xTitleObj;
        if (!(settings instanceof NativeObject)) {
            log.log(Level.SEVERE, "Incorrect array of the bar chart settings.");
            return;
        }
        NativeObject njo = (NativeObject)settings;
        Object titleObj = njo.get("title", this.scope);
        if (titleObj instanceof String) {
            bc.setTitle((String)titleObj);
        }
        if ((xTitleObj = njo.get("xTitle", this.scope)) instanceof String) {
            bc.setXTitle((String)xTitleObj);
        }
        if ((yTitleObj = njo.get("yTitle", this.scope)) instanceof String) {
            bc.setYTitle((String)yTitleObj);
        }
        if ((yFromObj = njo.get("yFrom", this.scope)) instanceof Double) {
            bc.setYFrom((Double)yFromObj);
        }
        if ((yToObj = njo.get("yTo", this.scope)) instanceof Double) {
            bc.setYTo((Double)yToObj);
        }
        if ((lablePositionObj = njo.get((Object)"lablePosition")) instanceof CategoryLabelPositions) {
            bc.setLablePosition((CategoryLabelPositions)lablePositionObj);
        }
        if ((lableFontObj = njo.get((Object)"lableFont")) instanceof Font) {
            bc.setLableFont((Font)lableFontObj);
        }
    }
}

