/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics.util;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.PlotInfo;
import biouml.model.dynamics.plot.PlotsInfo;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.type.Base;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import biouml.standard.type.Unit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.exception.InternalException;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Function;
import ru.biosoft.math.model.LinearFormatter;
import ru.biosoft.math.model.Utils;

public class EModelHelper {
    static Logger log = Logger.getLogger(EModelHelper.class.getName());
    private final EModel model;

    public EModelHelper(EModel model) {
        this.model = model;
    }

    public static List<String> getUsedVariables(AstStart start) {
        return Utils.getVariables((ru.biosoft.math.model.Node)start);
    }

    public List<Equation> reorderAssignmentRules() throws InternalException {
        Map varASTMap = this.model.getDiagramElement().recursiveStream().map(DiagramElement::getRole).select(Equation.class).mapToEntry(equation -> new EquationASTPair((Equation)equation, equation.getMath())).filterValues(pair -> pair.ast != null).mapKeys(Equation::getVariable).toMap((p1, p2) -> {
            throw new InternalException("Duplicate assignment rules for variable " + p1.equation.getVariable());
        });
        return EModelHelper.reorderEquations(varASTMap);
    }

    public void substituteAssignmentRules(Map<String, ru.biosoft.math.model.Node> macroMap, AstStart start) throws Exception {
        this.substituteSubtree(macroMap, (ru.biosoft.math.model.Node)start);
    }

    protected void substituteSubtree(Map<String, ru.biosoft.math.model.Node> map, ru.biosoft.math.model.Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof AstVarNode) {
            ru.biosoft.math.model.Node substNode = map.get(((AstVarNode)node).getName());
            if (substNode != null && substNode.jjtGetNumChildren() > 0) {
                ru.biosoft.math.model.Node parent = node.jjtGetParent();
                parent.jjtReplaceChild(node, substNode.jjtGetChild(0));
                this.substituteSubtree(map, substNode.jjtGetChild(0));
            }
        } else {
            Utils.children((ru.biosoft.math.model.Node)node).forEach(child -> this.substituteSubtree(map, (ru.biosoft.math.model.Node)child));
        }
    }

    protected static List<Equation> reorderEquations(Map<String, EquationASTPair> map) {
        Set<Map.Entry<String, EquationASTPair>> entrySet;
        boolean cycleFound = false;
        ArrayList<Equation> reorderedEquationList = new ArrayList<Equation>();
        while (!cycleFound && !(entrySet = map.entrySet()).isEmpty()) {
            boolean independentEquationFound = false;
            for (Map.Entry<String, EquationASTPair> entry : entrySet) {
                if (EModelHelper.dependsFromOthers((ru.biosoft.math.model.Node)entry.getValue().ast, map)) continue;
                independentEquationFound = true;
                reorderedEquationList.add(entry.getValue().equation);
                map.remove(entry.getKey());
                break;
            }
            cycleFound = !independentEquationFound;
        }
        if (cycleFound) {
            log.log(Level.SEVERE, "Cyclic dependences between assignment rules found.");
            return null;
        }
        return reorderedEquationList;
    }

    public Variable[] getInvolvedVariables(String equationType) {
        return (Variable[])((StreamEx)((StreamEx)((StreamEx)this.model.getEquations().filter(equation -> equationType == null || equationType.equals(equation.getType()))).flatMap(equation -> Utils.variables((ru.biosoft.math.model.Node)equation.getMath()).append((Object)equation.getVariable())).distinct()).nonNull()).map(name -> new Variable((String)name, this.model, this.model.getVariables())).toArray(Variable[]::new);
    }

    public void renameUnit(String oldName, String newName) {
        if (this.model.getUnits().containsKey(newName)) {
            return;
        }
        if (this.model.getUnits().containsKey(oldName)) {
            Unit oldUnit = this.model.getUnits().get(oldName);
            this.model.addUnit(oldUnit.clone(null, newName));
            this.model.removeUnit(oldName);
        } else {
            this.model.addUnit(new Unit(null, newName));
        }
        for (Variable var : this.model.getVariables()) {
            if (!var.getUnits().equals(oldName)) continue;
            var.setUnits(newName);
        }
    }

    public StreamEx<ExpressionOwner> getExpressionOwners() {
        return this.model.getDiagramElement().recursiveStream().map(de -> de.getRole()).select(ExpressionOwner.class);
    }

    public void replaceFunction(String oldName, String newName) {
        Function replacement = this.model.getFunction(newName);
        for (ExpressionOwner owner : this.getExpressionOwners()) {
            List<AstStart> astStart = this.model.readMath(owner.getExpressions(), (Role)((Object)owner));
            for (AstStart start : astStart) {
                this.renameFunctionInAST((ru.biosoft.math.model.Node)start, oldName, replacement);
            }
            List formatted = new LinearFormatter().format(astStart);
            owner.setExpressions(formatted.toArray(new String[formatted.size()]));
        }
    }

    public void renameVariableRole(String oldName, String newName) throws Exception {
        Variable var = this.model.getVariable(oldName);
        if (!(var instanceof VariableRole)) {
            throw new IllegalArgumentException("Entity with name " + oldName + " was not found in model " + this.model.getParent().getName() + "!");
        }
        if (this.model.containsVariable(newName)) {
            throw new IllegalArgumentException("Variable with name " + newName + " already exists in model " + this.model.getParent().getName() + "!");
        }
        VariableRole varRole = (VariableRole)var;
        Node de = (Node)varRole.getDiagramElement();
        Base base = de.getKernel();
        Base newKernel = null;
        try {
            newKernel = base instanceof biouml.standard.type.Compartment ? new biouml.standard.type.Compartment(base.getOrigin(), newName) : (Base)base.getClass().getConstructor(DataCollection.class, String.class, String.class).newInstance(base.getOrigin(), newName, base.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Node newNode = de.clone(de.getCompartment(), newName, newKernel);
        newNode.setTitle(de.getTitle().equals(de.getName()) ? newName : de.getTitle());
        VariableRole newRole = de.getRole(VariableRole.class).clone(newNode, VariableRole.createName(newNode, false));
        newNode.setRole(newRole);
        String newVarName = newNode.getRole(VariableRole.class).getName();
        de.getCompartment().put(newNode);
        this.renameVariable(this.model.getDiagramElement(), oldName, newVarName);
        for (Edge e : de.getEdges()) {
            if (((Object)((Object)e.getInput())).equals((Object)de)) {
                e.setInput(newNode);
            } else {
                e.setOutput(newNode);
            }
            newNode.addEdge(e);
            if (!(e.getKernel() instanceof SpecieReference)) continue;
            ((SpecieReference)e.getKernel()).setSpecie(newNode.getCompleteNameInDiagram());
            Equation eq = (Equation)e.getRole();
            this.renameVariable(eq, oldName, newVarName);
        }
        de.getCompartment().remove(de.getName());
    }

    public void renameVariable(String oldName, String newName) {
        this.renameVariable(oldName, newName, false);
    }

    public void renameVariable(String oldName, String newName, boolean replaceByCoincide) {
        if (oldName.equals(newName)) {
            return;
        }
        try {
            Variable oldVar = this.model.getVariable(oldName);
            Variable coincideVariable = this.model.getVariable(newName);
            if (!replaceByCoincide && !(coincideVariable instanceof VariableRole)) {
                if (coincideVariable != null) {
                    coincideVariable.setParent(null);
                    this.model.getVariables().remove(newName);
                }
                Variable newVar = oldVar.clone(newName);
                this.model.put(newVar);
                newVar.setParent(this.model);
                newVar.setTitle(oldVar.getTitle().equals(oldVar.getName()) ? newName : oldVar.getTitle());
            }
            this.renameVariable(this.model.getDiagramElement(), oldName, newName);
            if (oldVar != null && !(oldVar instanceof VariableRole)) {
                oldVar.setParent(null);
                this.model.getVariables().remove(oldName);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Problems occured during variable " + oldName + " renaming to " + newName + " old variable was not deleted from the model because of " + ex);
        }
    }

    private void renameVariable(Compartment compartment, String oldName, String newName) {
        if (oldName.equals(newName)) {
            return;
        }
        Iterator<DiagramElement> iterator = compartment.iterator();
        while (iterator.hasNext()) {
            DiagramElement de = iterator.next();
            if (de instanceof Compartment) {
                this.renameVariable((Compartment)de, oldName, newName);
            }
            if (de.getKernel() != null) {
                this.renameVariable(de, de.getKernel(), oldName, newName);
            }
            if (de.getRole() == null) continue;
            this.renameVariable(de.getRole(), oldName, newName);
        }
        PlotsInfo plots = DiagramUtility.getPlotsInfo(Diagram.getDiagram(compartment));
        if (plots != null) {
            for (PlotInfo plot : plots.getActivePlots()) {
                for (Curve c : plot.getYVariables()) {
                    String name = c.getName();
                    if (!name.equals(oldName)) continue;
                    c.setName(newName);
                }
                if (!plot.getXVariable().getName().equals(oldName)) continue;
                plot.getXVariable().setName(newName);
            }
        }
    }

    private void renameVariable(DiagramElement de, Base kernel, String oldName, String newName) {
        String ownerNodeName;
        if (kernel instanceof Stub.ConnectionPort && (ownerNodeName = de.getAttributes().getValue("variableName").toString()).equals(oldName)) {
            de.getAttributes().setValue("variableName", (Object)newName);
        }
    }

    public void renameVariable(Role role, String oldName, String newName) {
        if (role instanceof ExpressionOwner) {
            ExpressionOwner expressionOwner = (ExpressionOwner)((Object)role);
            List<AstStart> astStart = this.model.readMath(expressionOwner.getExpressions(), role);
            for (AstStart start : astStart) {
                this.renameVariableInAST((ru.biosoft.math.model.Node)start, oldName, newName);
            }
            List formatted = new LinearFormatter().format(astStart);
            expressionOwner.setExpressions(formatted.toArray(new String[formatted.size()]));
        }
    }

    private void renameVariableInAST(ru.biosoft.math.model.Node node, String oldName, String newName) {
        if (node == null) {
            return;
        }
        Utils.deepChildren((ru.biosoft.math.model.Node)node).select(AstVarNode.class).findAny(var -> var.getName().equals(oldName)).ifPresent(var -> {
            var.setName(newName);
            var.setTitle(newName);
        });
    }

    private void renameFunctionInAST(ru.biosoft.math.model.Node node, String oldName, Function replacement) {
        if (node == null) {
            return;
        }
        ((StreamEx)Utils.deepChildren((ru.biosoft.math.model.Node)node).select(AstFunNode.class).filter(f -> f.getFunction().getName().equals(oldName))).forEach(f -> f.setFunction(replacement));
    }

    public Map<String, String> resolveVariables() {
        return this.model.getDiagramElement().recursiveStream().mapToEntry(DiagramElement::getRole, java.util.function.Function.identity()).flatMapKeys(this::variableNames).mapToValue((name, de) -> this.model.getQualifiedName((String)name, (DiagramElement)((Object)de))).toMap();
    }

    private Stream<String> variableNames(Role role) {
        if (role instanceof VariableRole) {
            return Stream.of(((VariableRole)role).getName());
        }
        if (role instanceof ExpressionOwner) {
            ExpressionOwner expressionOwner = (ExpressionOwner)((Object)role);
            return Stream.of(expressionOwner.getExpressions()).map(expression -> this.model.readMath((String)expression, role)).flatMap(Utils::variables);
        }
        return null;
    }

    protected static boolean dependsFromOthers(ru.biosoft.math.model.Node node, Map<String, EquationASTPair> map) {
        if (node == null) {
            return false;
        }
        return Utils.variables((ru.biosoft.math.model.Node)node).anyMatch(map::containsKey);
    }

    public static boolean variableIsUsed(String variable, ru.biosoft.math.model.Node node) {
        if (node == null) {
            return false;
        }
        return Utils.variables((ru.biosoft.math.model.Node)node).has((Object)variable);
    }

    public static String[] getParameters(EModel emodel) {
        return (String[])emodel.getVariables().names().sorted().toArray(String[]::new);
    }

    public static String generateUniqueVariableName(EModel emodel, String base) {
        String result = base;
        int counter = 1;
        while (emodel.containsVariable(result)) {
            result = base + counter++;
        }
        return result;
    }

    public static Map<String, List<Equation>> findDefiningEquations(EModel emodel) {
        HashMap<String, List<Equation>> varToEquations = new HashMap<String, List<Equation>>();
        for (Equation eq : emodel.getEquations()) {
            String varName;
            Variable variable;
            if ("algebraic".equals(eq.getType()) || "scalar_internal".equals(eq.getType()) || (variable = emodel.getVariable(varName = eq.getVariable())).isConstant() && !"initial assignment".equals(eq.getType()) || variable instanceof VariableRole && ((VariableRole)variable).isBoundaryCondition() && "rate".equals(eq.getType()) && eq.getParent() instanceof Edge) continue;
            varToEquations.computeIfAbsent(varName, k -> new ArrayList()).add(eq);
        }
        return varToEquations;
    }

    protected static class EquationASTPair {
        public Equation equation;
        public AstStart ast;

        EquationASTPair(Equation equation, AstStart ast) {
            this.equation = equation;
            this.ast = ast;
        }
    }
}

