/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics.plot;

import biouml.model.dynamics.EModel;
import biouml.model.dynamics.plot.PlotInfo;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyName;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jfree.chart.ChartColor;
import ru.biosoft.graphics.Pen;

@PropertyName(value="Simulation Plots")
public class PlotsInfo
extends Option {
    public static final Color[] POSSIBLE_COLORS = new Color[]{new Color(255, 85, 85), new Color(85, 85, 255), new Color(0, 255, 0), Color.pink, ChartColor.DARK_RED, ChartColor.DARK_BLUE, ChartColor.DARK_GREEN, ChartColor.DARK_MAGENTA, ChartColor.DARK_CYAN, Color.darkGray, ChartColor.VERY_DARK_RED, ChartColor.VERY_DARK_BLUE, ChartColor.VERY_DARK_GREEN, ChartColor.VERY_DARK_YELLOW, ChartColor.VERY_DARK_MAGENTA, ChartColor.VERY_DARK_CYAN};
    private PlotInfo[] plots;
    private EModel emodel;

    public PlotsInfo(EModel emodel, PlotInfo[] plots) {
        this.emodel = emodel;
        this.plots = plots;
    }

    public PlotsInfo(EModel emodel) {
        this(emodel, new PlotInfo[]{new PlotInfo(emodel)});
    }

    public PlotsInfo clone(EModel emodel) {
        return new PlotsInfo(emodel, (PlotInfo[])StreamEx.of((Object[])this.getPlots()).map(p -> p.clone(emodel)).toArray(PlotInfo[]::new));
    }

    public void setEModel(EModel emodel) {
        this.emodel = emodel;
        for (PlotInfo plotInfo : this.plots) {
            plotInfo.setEModel(emodel);
        }
    }

    @PropertyName(value="Plots")
    public PlotInfo[] getPlots() {
        return this.plots;
    }

    public void setPlots(PlotInfo[] plots) {
        PlotInfo[] oldValue = this.plots;
        this.plots = plots;
        for (PlotInfo plot : plots) {
            if (this.emodel.equals(plot.getEModel())) continue;
            plot.setEModel(this.emodel);
        }
        this.firePropertyChange("plots", oldValue, plots);
    }

    public PlotInfo[] getActivePlots() {
        return (PlotInfo[])((StreamEx)StreamEx.of((Object[])this.plots).filter(p -> p.isActive)).toArray(PlotInfo[]::new);
    }

    public static class AutoPenSelector {
        private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
        private static final Pen[] POSSIBLE_PENS;
        private static final int INNER_SIZE;
        private int index = 0;

        public int getNumber() {
            return this.index;
        }

        public void updateNumber(int newCount) {
            this.index = Math.abs(newCount % INNER_SIZE);
        }

        public Pen getNextPen() {
            if (this.index >= INNER_SIZE) {
                this.index %= INNER_SIZE;
            }
            return POSSIBLE_PENS[this.index++].clone();
        }

        static {
            String[] strokesStrs = Pen.getAvailableStrokes();
            BasicStroke[] strokes = strokesStrs == null || strokesStrs.length == 0 ? new BasicStroke[]{DEFAULT_STROKE} : (BasicStroke[])Stream.of(strokesStrs).map(s -> Pen.getStrokeByName((BasicStroke)DEFAULT_STROKE, (String)s)).toArray(BasicStroke[]::new);
            ArrayList<Pen> pens = new ArrayList<Pen>();
            for (BasicStroke stroke : strokes) {
                for (Color color : POSSIBLE_COLORS) {
                    pens.add(new Pen(stroke, color));
                }
            }
            POSSIBLE_PENS = pens.toArray(new Pen[0]);
            INNER_SIZE = pens.size();
        }
    }
}

