/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics.plot;

import biouml.model.Diagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.Util;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;

public class PlotVariable
extends Option
implements DataElement {
    static final String TIME_VARIABLE = "time";
    private String path;
    private String name;
    private String title;
    private EModel emodel;

    public PlotVariable(String path, String name, String title, EModel emodel) {
        this.setPath(path);
        this.setName(name);
        this.setTitle(title);
        this.setEModel(emodel);
    }

    public PlotVariable() {
        this("", TIME_VARIABLE, TIME_VARIABLE, null);
    }

    public EModel getEModel() {
        return this.emodel;
    }

    public void setEModel(EModel emodel) {
        this.emodel = emodel;
        if (!this.variables().toSet().contains(this.name)) {
            this.setName(TIME_VARIABLE);
        }
    }

    public String getCompleteName() {
        return this.getPath().isEmpty() ? this.getName() : this.getPath() + "/" + this.getName();
    }

    @PropertyName(value="Path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        String oldValue = this.path;
        this.path = path;
        this.firePropertyChange("path", oldValue, path);
        if (!Objects.equals(oldValue, path)) {
            this.setName(TIME_VARIABLE);
            this.setTitle(TIME_VARIABLE);
            this.firePropertyChange("*", "", "");
        }
    }

    @PropertyName(value="Value")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        if (this.emodel != null) {
            Diagram diagram = Util.getInnerDiagram(this.emodel.getParent(), this.path);
            if (diagram.getRole() instanceof EModel) {
                Variable var = diagram.getRole(EModel.class).getVariable(name);
                if (var == null) {
                    return;
                }
                this.name = name;
                this.setTitle(var.getTitle());
            }
        } else {
            this.name = name;
            this.setTitle(name);
        }
        this.firePropertyChange("name", oldValue, name);
    }

    public StreamEx<String> variables() {
        if (this.emodel == null) {
            return StreamEx.empty();
        }
        Diagram diagram = Util.getInnerDiagram(this.emodel.getParent(), this.path);
        if (!(diagram.getRole() instanceof EModel)) {
            return StreamEx.of((Object[])new String[]{""});
        }
        return StreamEx.of((Stream)diagram.getRole(EModel.class).getVariables().stream()).map(variable -> variable.getName());
    }

    public Stream<String> modules() {
        Diagram diagram = this.emodel.getParent();
        if (!DiagramUtility.isComposite(diagram)) {
            return StreamEx.of((Object[])new String[]{""});
        }
        return StreamEx.of(Util.getSubDiagrams(diagram)).map(s -> Util.getPath(s)).append((Object)"");
    }

    public boolean isPathReadOnly() {
        return !DiagramUtility.isComposite(this.getEModel().getParent());
    }

    @PropertyName(value="Title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    public PlotVariable clone(EModel emodel) {
        return new PlotVariable(this.path, this.name, this.title, emodel);
    }

    public boolean isPathHidden() {
        Diagram diagram = this.emodel.getParent();
        return !DiagramUtility.isComposite(diagram);
    }

    public DataCollection<?> getOrigin() {
        return null;
    }
}

