/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics.plot;

import biouml.model.dynamics.EModel;
import biouml.model.dynamics.plot.AxisInfo;
import biouml.model.dynamics.plot.Curve;
import biouml.model.dynamics.plot.Experiment;
import biouml.model.dynamics.plot.PlotVariable;
import biouml.model.dynamics.plot.PlotsInfo;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;
import ru.biosoft.graphics.font.ColorFont;

@PropertyName(value="Simulation Plot")
public class PlotInfo
extends Option {
    private EModel emodel;
    private PlotVariable xVariable;
    private Curve[] yVariables;
    private Experiment[] experiments;
    boolean isActive = true;
    private String title = "Plot";
    private AxisInfo xAxisInfo = new AxisInfo("Time");
    private AxisInfo yAxisInfo = new AxisInfo("Quantity or Concentration");
    private final PlotsInfo.AutoPenSelector penSelector = new PlotsInfo.AutoPenSelector();

    public PlotInfo(EModel emodel) {
        this(emodel, true);
    }

    public PlotInfo(EModel emodel, boolean createTemplateLine) {
        this.emodel = emodel;
        this.xVariable = new PlotVariable("", "time", "time", emodel);
        if (createTemplateLine) {
            this.yVariables = new Curve[1];
            this.yVariables[0] = new Curve("", "time", "time", emodel);
            this.yVariables[0].setPen(this.penSelector.getNextPen());
            this.yVariables[0].setParent(this);
        }
    }

    public PlotInfo() {
        this(null);
    }

    public void setEModel(EModel emodel) {
        this.emodel = emodel;
        this.xVariable.setEModel(emodel);
        for (Curve curve : this.yVariables) {
            curve.setEModel(emodel);
        }
    }

    public EModel getEModel() {
        return this.emodel;
    }

    @PropertyName(value="X variable")
    public PlotVariable getXVariable() {
        return this.xVariable;
    }

    public void setXVariable(PlotVariable xVariable) {
        this.xVariable = xVariable;
        xVariable.setEModel(this.emodel);
    }

    @PropertyName(value="Curves")
    public Curve[] getYVariables() {
        return this.yVariables;
    }

    public void setYVariables(Curve[] yVariables) {
        Curve[] oldValue = this.yVariables;
        this.yVariables = yVariables;
        for (int i = 0; i < yVariables.length; ++i) {
            Curve curve = yVariables[i];
            if (this.emodel != null && !this.emodel.equals(curve.getEModel())) {
                curve.setEModel(this.emodel);
            }
            if (curve.getPen() == null) {
                curve.setPen(this.penSelector.getNextPen());
            }
            curve.setParent(this);
        }
        this.firePropertyChange("yVariables", oldValue, yVariables);
    }

    @PropertyName(value="Experiments")
    public Experiment[] getExperiments() {
        return this.experiments;
    }

    public void setExperiments(Experiment[] experiments) {
        this.experiments = experiments;
        for (int i = 0; i < experiments.length; ++i) {
            Experiment experiment = experiments[i];
            if (experiment.getPen() == null) {
                experiment.setPen(this.penSelector.getNextPen());
            }
            experiment.setParent(this);
        }
    }

    @PropertyName(value="Active")
    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @PropertyName(value="X axis info")
    public AxisInfo getXAxisInfo() {
        return this.xAxisInfo;
    }

    public void setXAxisInfo(AxisInfo xAxisInfo) {
        AxisInfo oldValue = this.xAxisInfo;
        this.xAxisInfo = xAxisInfo;
        this.firePropertyChange("xAxisInfo", (Object)oldValue, (Object)xAxisInfo);
    }

    @PropertyName(value="Y axis info")
    public AxisInfo getYAxisInfo() {
        return this.yAxisInfo;
    }

    public void setYAxisInfo(AxisInfo yAxisInfo) {
        AxisInfo oldValue = this.yAxisInfo;
        this.yAxisInfo = yAxisInfo;
        this.firePropertyChange("yAxisInfo", (Object)oldValue, (Object)yAxisInfo);
    }

    @PropertyName(value="Title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @PropertyName(value="X axis title font")
    @PropertyDescription(value="Font for title of X axis of the plot.")
    public ColorFont getXTitleFont() {
        return this.xAxisInfo.getTitleFont();
    }

    public void setXTitleFont(ColorFont xTitleFont) {
        this.xAxisInfo.setTitleFont(xTitleFont);
    }

    @PropertyName(value="X axis type")
    @PropertyDescription(value="Type of X axis of the plot.")
    public String getXAxisType() {
        return this.xAxisInfo.getAxisType();
    }

    public boolean isXAxisTypeLogarithmic() {
        return this.xAxisInfo.isAxisTypeLogarithmic();
    }

    public void setXAxisType(String xAxisType) {
        this.xAxisInfo.setAxisType(xAxisType);
    }

    @PropertyName(value="Y axis type")
    @PropertyDescription(value="Type of Y axis of the plot.")
    public String getYAxisType() {
        return this.yAxisInfo.getAxisType();
    }

    public void setYAxisType(String yAxisType) {
        this.yAxisInfo.setAxisType(yAxisType);
    }

    public boolean isYAxisTypeLogarithmic() {
        return this.yAxisInfo.isAxisTypeLogarithmic();
    }

    @PropertyName(value="X axis auto range")
    @PropertyDescription(value="X axis auto range.")
    public boolean isXAutoRange() {
        return this.xAxisInfo.isAutoRange();
    }

    public void setXAutoRange(boolean xAutoRange) {
        this.xAxisInfo.setAutoRange(xAutoRange);
    }

    @PropertyName(value="   X: to ")
    @PropertyDescription(value="Largest value of X coordinate.")
    public double getXTo() {
        return this.xAxisInfo.getTo();
    }

    public void setXTo(double xTo) {
        this.xAxisInfo.setTo(xTo);
    }

    @PropertyName(value="   X: from")
    @PropertyDescription(value="Smallest value of X coordinate.")
    public double getXFrom() {
        return this.xAxisInfo.getFrom();
    }

    public void setXFrom(double xFrom) {
        this.xAxisInfo.setFrom(xFrom);
    }

    @PropertyName(value="X axis tick font")
    @PropertyDescription(value="X axis tick label font.")
    public ColorFont getXTickLabelFont() {
        return this.xAxisInfo.getTickLabelFont();
    }

    public void setXTickLabelFont(ColorFont xTickLabelFont) {
        this.xAxisInfo.setTickLabelFont(xTickLabelFont);
    }

    @PropertyName(value="Y axis title font")
    @PropertyDescription(value="Font for title of YX axis of the plot.")
    public ColorFont getYTitleFont() {
        return this.yAxisInfo.getTitleFont();
    }

    public void setYTitleFont(ColorFont yTitleFont) {
        this.yAxisInfo.setTitleFont(yTitleFont);
    }

    @PropertyName(value="Y axis auto range")
    @PropertyDescription(value="Y axis auto range.")
    public boolean isYAutoRange() {
        return this.yAxisInfo.isAutoRange();
    }

    public void setYAutoRange(boolean yAutoRange) {
        this.yAxisInfo.setAutoRange(yAutoRange);
    }

    @PropertyName(value="   Y: to ")
    @PropertyDescription(value="Largest value of Y coordinate.")
    public double getYTo() {
        return this.yAxisInfo.getTo();
    }

    public void setYTo(double yTo) {
        this.yAxisInfo.setTo(yTo);
    }

    @PropertyName(value="   Y: from ")
    @PropertyDescription(value="Smallest value of Y coordinate.")
    public double getYFrom() {
        return this.yAxisInfo.getFrom();
    }

    public void setYFrom(double yFrom) {
        this.yAxisInfo.setFrom(yFrom);
    }

    @PropertyName(value="Y axis tick font")
    @PropertyDescription(value="Y axis tick label font.")
    public ColorFont getYTickLabelFont() {
        return this.yAxisInfo.getTickLabelFont();
    }

    public void setYTickLabelFont(ColorFont yTickLabelFont) {
        this.yAxisInfo.setTickLabelFont(yTickLabelFont);
    }

    public PlotInfo clone(EModel emodel) {
        PlotInfo result = new PlotInfo(emodel);
        result.setTitle(this.getTitle());
        result.setActive(this.isActive());
        result.setAutoColorNumber(this.getAutoColorNumber());
        result.setXVariable(this.getXVariable().clone(emodel));
        result.setYVariables((Curve[])StreamEx.of((Object[])this.getYVariables()).map(y -> y.clone(emodel)).toArray(Curve[]::new));
        if (this.getExperiments() != null) {
            result.setExperiments((Experiment[])StreamEx.of((Object[])this.getExperiments()).map(y -> y.clone(emodel)).toArray(Experiment[]::new));
        }
        return result;
    }

    public int getAutoColorNumber() {
        return this.penSelector.getNumber();
    }

    public void setAutoColorNumber(int newNumber) {
        this.penSelector.updateNumber(newNumber);
    }

    @PropertyName(value="X axis title")
    public String getXTitle() {
        return this.xAxisInfo.getTitle();
    }

    public void setXTitle(String xTitle) {
        this.xAxisInfo.setTitle(xTitle);
    }

    @PropertyName(value="Y axis title")
    public String getYTitle() {
        return this.yAxisInfo.getTitle();
    }

    public void setYTitle(String yTitle) {
        this.yAxisInfo.setTitle(yTitle);
    }
}

