/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics.plot;

import biouml.model.dynamics.EModel;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graphics.Pen;
import ru.biosoft.table.TableDataCollection;

public class Experiment
extends Option
implements DataElement {
    private String nameY;
    private String title;
    private String nameX;
    private DataElementPath path;
    private List<String> columnNames = new ArrayList<String>();
    private Pen pen = null;

    public Experiment() {
    }

    public Experiment(DataElementPath path, String nameX, String nameY, String title, Pen pen) {
        this.setPath(path);
        this.setNameX(nameX);
        this.setNameY(nameY);
        this.setTitle(title);
        this.setPen(pen);
    }

    public DataElementPath getPath() {
        return this.path;
    }

    public void setPath(DataElementPath path) {
        this.path = path;
        TableDataCollection table = (TableDataCollection)path.getDataElement(TableDataCollection.class);
        this.columnNames = table.columns().map(c -> c.getName()).toList();
        if (!this.columnNames.isEmpty()) {
            if (!table.getColumnModel().hasColumn(this.getNameX())) {
                this.setNameX(this.columnNames.get(0));
            }
            if (!table.getColumnModel().hasColumn(this.getNameY())) {
                this.setNameY(this.columnNames.get(this.columnNames.size() > 1 ? 1 : 0));
            }
        }
    }

    @PropertyName(value="Name Y")
    public String getNameY() {
        return this.nameY;
    }

    public void setNameY(String nameY) {
        String oldValue = this.nameY;
        this.nameY = nameY;
        this.title = nameY;
        this.firePropertyChange("nameY", oldValue, nameY);
    }

    @PropertyName(value="Name X")
    public String getNameX() {
        return this.nameX;
    }

    public void setNameX(String nameX) {
        String oldValue = this.nameX;
        this.nameX = nameX;
        this.firePropertyChange("nameX", oldValue, nameX);
    }

    public StreamEx<String> columns() {
        return StreamEx.of(this.columnNames.stream());
    }

    @PropertyName(value="Title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    @PropertyName(value="Line spec")
    public Pen getPen() {
        return this.pen;
    }

    public void setPen(Pen pen) {
        this.pen = pen;
    }

    public Experiment clone(EModel emodel) {
        return new Experiment(this.path, this.nameX, this.nameY, this.title, this.pen);
    }

    public String getName() {
        return this.path + "_" + this.nameX + "_" + this.nameY;
    }

    public DataCollection<?> getOrigin() {
        return null;
    }
}

