/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics.plot;

import biouml.standard.simulation.plot.Plot;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import ru.biosoft.graphics.font.ColorFont;

public class AxisInfo
extends Option {
    private String title = "";
    private String axisType = Plot.AxisType.toString(Plot.AxisType.NUMBER);
    private double to;
    private double from;
    private boolean autoRange = true;
    private ColorFont tickLabelFont = new ColorFont("SansSerif", 0, 12);
    private ColorFont titleFont = new ColorFont("SansSerif", 0, 12);

    public AxisInfo(String title) {
        this.title = title;
    }

    @PropertyName(value="Axis title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    @PropertyName(value="Title font")
    @PropertyDescription(value="Font for title.")
    public ColorFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(ColorFont titleFont) {
        ColorFont oldValue = this.titleFont;
        this.titleFont = titleFont;
        this.firePropertyChange("titleFont", oldValue, titleFont);
    }

    @PropertyName(value="Axis type")
    @PropertyDescription(value="Type of axis.")
    public String getAxisType() {
        return this.axisType;
    }

    public boolean isAxisTypeLogarithmic() {
        return this.axisType.equals(Plot.AxisType.toString(Plot.AxisType.LOGARITHMIC));
    }

    public void setAxisType(String axisType) {
        this.axisType = axisType;
        if (this.isAxisTypeLogarithmic()) {
            this.setAutoRange(false);
        } else {
            this.firePropertyChange("*", null, null);
        }
    }

    @PropertyName(value="Axis auto range")
    @PropertyDescription(value="Axis auto range.")
    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean autoRange) {
        this.autoRange = autoRange;
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="To ")
    @PropertyDescription(value="Largest value of coordinate.")
    public double getTo() {
        return this.to;
    }

    public void setTo(double to) {
        double oldValue = this.to;
        this.to = to;
        this.firePropertyChange("to", oldValue, to);
    }

    @PropertyName(value="From")
    @PropertyDescription(value="Smallest value of coordinate.")
    public double getFrom() {
        return this.from;
    }

    public void setFrom(double from) {
        double oldValue = this.from;
        this.from = from;
        this.firePropertyChange("from", oldValue, from);
    }

    @PropertyName(value="Axis tick font")
    @PropertyDescription(value="Axis tick label font.")
    public ColorFont getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(ColorFont tickLabelFont) {
        ColorFont oldValue = this.tickLabelFont;
        this.tickLabelFont = tickLabelFont;
        this.firePropertyChange("tickLabelFont", oldValue, tickLabelFont);
    }
}

