/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.Variable;
import java.util.Iterator;
import java.util.Properties;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DerivedDataCollection;
import ru.biosoft.access.core.VectorDataCollection;

public class VariablesDataCollection
extends DerivedDataCollection<Variable, Variable> {
    public VariablesDataCollection(DataCollection<?> parent, Compartment compartment) throws Exception {
        super(parent, compartment.getName() + " variables", (DataCollection)new VectorDataCollection(compartment.getName() + " variables(vectorDC)", null, VariablesDataCollection.getDataElementProperties()), null);
        this.v_cache = null;
        this.fillCollection(compartment);
    }

    private static Properties getDataElementProperties() {
        Properties props = new Properties();
        props.setProperty("data-element-class", Variable.class.getName());
        props.setProperty("name", "Variables");
        return props;
    }

    protected Properties createCollectionProperties(Diagram diagram) {
        Properties props = new Properties();
        props.setProperty("name", diagram.getName());
        return props;
    }

    protected static Properties createProperties(Diagram diagram) {
        if (diagram == null) {
            throw new IllegalArgumentException("'diagram' parameter can't be null.");
        }
        Properties props = new Properties();
        props.setProperty("name", diagram.getName());
        return props;
    }

    private final void fillCollection(Compartment compartment) throws Exception {
        Iterator<DiagramElement> iterator = compartment.iterator();
        while (iterator.hasNext()) {
            DiagramElement element = iterator.next();
            if (element instanceof Compartment && !(element instanceof Diagram)) {
                Compartment subTree = (Compartment)element;
                this.fillCollection(subTree);
                continue;
            }
            Role role = element.getRole();
            if (!(role instanceof Variable)) continue;
            this.put((DataElement)((Variable)((Object)role)));
        }
    }
}

