/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableBeanInfo;
import biouml.model.dynamics.VariableRole;
import biouml.standard.type.Compartment;
import biouml.standard.type.Unit;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.PropertyDescriptorEx;
import com.developmentontheedge.beans.editors.TagEditorSupport;
import one.util.streamex.StreamEx;
import ru.biosoft.workbench.editors.GenericComboBoxEditor;

public class VariableRoleBeanInfo
extends VariableBeanInfo {
    public VariableRoleBeanInfo() {
        super(VariableRole.class);
    }

    @Override
    public void initProperties() throws Exception {
        this.addHidden("name");
        this.add("shortName");
        this.property(new PropertyDescriptorEx("compartment", this.beanClass, "getCompartment", null)).readOnly().add();
        this.add("title");
        this.addReadOnly("type");
        this.property("initialValue").numberFormat("none").add();
        this.property("initialQuantityType").editor(QuantityTypeEditor.class).hidden("isCompartment").add();
        this.property("quantityType").editor(QuantityTypeEditor.class).hidden("isCompartment").add();
        this.property("outputQuantityType").editor(QuantityTypeEditor.class).hidden("isCompartment").add();
        this.add("units", SubstanceUnitsEditor.class);
        this.property("boundaryCondition").hidden("isCompartment").add();
        this.add("constant");
        this.add("comment");
    }

    public static class SubstanceUnitsEditor
    extends GenericComboBoxEditor {
        public String[] getAvailableValues() {
            DiagramElement de;
            if (this.getBean() instanceof EModel) {
                return this.getEmodelUnits((EModel)this.getBean());
            }
            if (this.getBean() instanceof VariableRole && (de = ((VariableRole)this.getBean()).getDiagramElement()).getKernel() instanceof Compartment) {
                return (String[])Unit.getBaseVolumeUnits().stream().toArray(String[]::new);
            }
            if (this.getBean() instanceof Variable) {
                Diagram diagram;
                Option parent = ((Variable)((Object)this.getBean())).getParent();
                if (parent instanceof EModel) {
                    return this.getEmodelUnits((EModel)parent);
                }
                if (parent instanceof DiagramElement && (diagram = Diagram.getDiagram((DiagramElement)parent)).getRole() instanceof EModel) {
                    return this.getEmodelUnits(diagram.getRole(EModel.class));
                }
            }
            return new String[0];
        }

        protected String[] getEmodelUnits(EModel emodel) {
            return (String[])StreamEx.ofKeys(emodel.getUnits()).append((Object)"").append(Unit.getBaseUnitsList()).toArray(String[]::new);
        }
    }

    public static class QuantityTypeEditor
    extends TagEditorSupport {
        public QuantityTypeEditor() {
            super(new String[]{"amount", "concentration"}, 0);
        }
    }
}

