/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.GlobalViewOptions;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.util.EModelHelper;
import biouml.standard.type.Compartment;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;

@PropertyName(value="Variable")
@PropertyDescription(value="Variable with associated diagram element.")
public class VariableRole
extends Variable
implements Role {
    public static final String PREFIX = "$";
    public static final String SCOPE = ".";
    public static final Pattern IDENTIFIER = Pattern.compile("[_a-zA-Z][_0-9a-zA-Z]*([\\x2E][_a-zA-Z][_0-9a-zA-Z]*)*");
    public static final int AMOUNT_TYPE = 0;
    public static final int CONCENTRATION_TYPE = 1;
    public static final int UNDEFINED_TYPE = -1;
    private String shortName;
    private String compartment;
    protected int quantityType = 1;
    protected DiagramElement diagramElement;
    protected boolean boundaryCondition;
    private Variable conversionFactor = null;
    protected DiagramElement[] associatedElements;
    protected int outputQuantityType = 0;
    protected int initialQuantityType = 0;

    @Override
    @PropertyName(value="Name")
    @PropertyDescription(value="Variable name.")
    public String getName() {
        return super.getName();
    }

    public void setShortName(String name) {
        if (name.equals(this.shortName)) {
            return;
        }
        String oldName = this.name;
        try {
            Diagram diagram = Diagram.getDiagram(this.getDiagramElement());
            EModel emodel = diagram.getRole(EModel.class);
            EModelHelper helper = new EModelHelper(emodel);
            helper.renameVariableRole(oldName, name);
            ((EModel)this.getParent()).getVariableRoles().remove(oldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @PropertyName(value="Name")
    public String getShortName() {
        return this.shortName;
    }

    @PropertyName(value="Compartment")
    public String getCompartment() {
        return this.compartment;
    }

    public static String createName(DiagramElement de, boolean isBrief) {
        if (de == null) {
            throw new NullPointerException("Diagram element is not defined.");
        }
        String name = de.getName();
        if (!isBrief) {
            for (DiagramElement parent = (DiagramElement)de.getOrigin(); parent != null && !(parent instanceof Diagram); parent = (DiagramElement)parent.getOrigin()) {
                name = (parent.getRole() != null ? parent.getRole().getDiagramElement().getName() : parent.getName()) + SCOPE + name;
            }
        }
        if (!IDENTIFIER.matcher(name).matches()) {
            name = "\"" + name + "\"";
        }
        name = PREFIX + name;
        return name;
    }

    public VariableRole(DataCollection<?> origin, DiagramElement diagramElement, double initialValue) {
        super(VariableRole.createName(diagramElement, false), origin);
        this.initialValue = initialValue;
        this.diagramElement = diagramElement;
        this.setParent((Option)diagramElement);
        this.generatePath(this.name);
    }

    private void generatePath(String name) {
        name = name.replace(PREFIX, "");
        int index = name.lastIndexOf(SCOPE);
        this.shortName = name.substring(index + 1);
        if (this.shortName.endsWith("\"")) {
            this.shortName = "\"" + this.shortName;
        }
        if (index == -1) {
            this.compartment = "";
        } else {
            this.compartment = name.substring(0, index);
            if (this.compartment.startsWith("\"")) {
                this.compartment = this.compartment + "\"";
            }
        }
    }

    public VariableRole(DiagramElement diagramElement) {
        this(diagramElement, 0.0);
    }

    public VariableRole(DiagramElement diagramElement, double initialValue) {
        this((DataCollection)null, diagramElement, initialValue);
    }

    public VariableRole(String name, DataCollection<?> origin, double initialValue) {
        super(name, origin);
        this.initialValue = initialValue;
    }

    public VariableRole(String name, DiagramElement diagramElement) {
        super(name, null);
        this.diagramElement = diagramElement;
    }

    public VariableRole(String name, DataCollection<?> origin) {
        super(name, origin);
    }

    @Override
    public Role clone(DiagramElement de) {
        return this.clone(de, this.getName());
    }

    public VariableRole clone(DiagramElement de, String newName) {
        VariableRole var = (VariableRole)super.clone(newName);
        var.setParent((Option)de);
        var.generatePath(newName);
        var.diagramElement = de;
        var.associatedElements = new DiagramElement[]{var.diagramElement};
        return var;
    }

    @Override
    public VariableRole clone(String newName) {
        VariableRole clone = (VariableRole)super.clone(newName);
        clone.associatedElements = new DiagramElement[]{clone.diagramElement};
        this.generatePath(newName);
        return clone;
    }

    public String getTitledName() {
        Diagram diagram;
        String result = this.getName();
        if (this.diagramElement != null && (diagram = Diagram.optDiagram(this.diagramElement)) != null && diagram.getRole() instanceof EModel) {
            return diagram.getRole(EModel.class).getQualifiedName(result, this.diagramElement, GlobalViewOptions.getVarNameMode());
        }
        return result;
    }

    @Override
    public String toString() {
        String str = "VariableRole: " + this.name + "=" + this.initialValue + " " + this.units;
        if (this.boundaryCondition) {
            str = str + "(b)";
        }
        if (this.comment != null) {
            str = str + str + "; " + this.comment;
        }
        str = str + "; de=" + (Object)((Object)this.diagramElement);
        return str;
    }

    @Override
    public DiagramElement getDiagramElement() {
        return this.diagramElement;
    }

    @Override
    @PropertyName(value="Title")
    public String getTitle() {
        if (this.diagramElement == null) {
            return "";
        }
        return this.diagramElement.getTitle();
    }

    @Override
    public void setTitle(String title) {
        if (this.diagramElement != null) {
            this.diagramElement.setTitle(title);
        }
    }

    @Nonnull
    public DiagramElement[] getAssociatedElements() {
        if (this.associatedElements == null) {
            this.associatedElements = new DiagramElement[]{this.diagramElement};
        }
        return this.associatedElements;
    }

    public void addAssociatedElement(DiagramElement de) {
        DiagramElement[] old = this.getAssociatedElements();
        if (!StreamEx.of((Object[])old).has((Object)de)) {
            this.associatedElements = (DiagramElement[])StreamEx.of((Object[])old).append((Object)de).toArray(DiagramElement[]::new);
        }
    }

    public boolean removeAssociatedElement(DiagramElement de) {
        DiagramElement[] old = this.getAssociatedElements();
        if (old.length == 1 && old[0] == de) {
            return true;
        }
        this.associatedElements = (DiagramElement[])StreamEx.of((Object[])old).without((Object)de).toArray(DiagramElement[]::new);
        if (this.getDiagramElement() == de) {
            this.diagramElement = this.associatedElements[0];
        }
        return false;
    }

    @PropertyName(value="Boundary condition")
    @PropertyDescription(value="Boundary condition determines whether the variable value is fixed<br>or variable over the course of a simulation")
    public boolean isBoundaryCondition() {
        return this.boundaryCondition;
    }

    public void setBoundaryCondition(boolean boundaryCondition) {
        boolean oldValue = this.boundaryCondition;
        this.boundaryCondition = boundaryCondition;
        this.firePropertyChange("boundaryCondition", oldValue, boundaryCondition);
    }

    @PropertyName(value="Initial units type")
    @PropertyDescription(value="Initial quantity type.")
    public int getInitialQuantityType() {
        return this.initialQuantityType;
    }

    public void setInitialQuantityType(int quantityType) {
        int oldValue = this.initialQuantityType;
        this.initialQuantityType = quantityType;
        this.firePropertyChange("initialQuantityType", oldValue, quantityType);
    }

    @PropertyName(value="Output units type")
    @PropertyDescription(value="Units type in simulation result.")
    public int getOutputQuantityType() {
        return this.outputQuantityType;
    }

    public void setOutputQuantityType(int quantityType) {
        int oldValue = this.outputQuantityType;
        this.outputQuantityType = quantityType;
        this.firePropertyChange("outputQuantityType", oldValue, quantityType);
    }

    @PropertyName(value="Units type")
    @PropertyDescription(value="Units type.")
    public int getQuantityType() {
        return this.quantityType;
    }

    public void setQuantityType(int quantityType) {
        int oldValue = this.quantityType;
        this.quantityType = quantityType;
        this.firePropertyChange("quantityType", oldValue, quantityType);
    }

    public String getConversionFactor() {
        if (this.conversionFactor == null) {
            return null;
        }
        return this.conversionFactor.getName();
    }

    public void setConversionFactor(String variableName) {
        if (variableName == null) {
            this.conversionFactor = null;
            return;
        }
        Diagram diagram = Diagram.getDiagram(this.getDiagramElement());
        EModel role = diagram.getRole(EModel.class);
        Variable variable = role.getVariable(variableName);
        if (variable == null) {
            throw new IllegalArgumentException("Can not found parameter " + variableName + " in model");
        }
        if (variable instanceof VariableRole || !variable.isConstant()) {
            throw new IllegalArgumentException("Incorrect conversion factor, it should be model parameter with set constant = true");
        }
        this.conversionFactor = variable;
    }

    public boolean isCompartment() {
        return this.getDiagramElement() != null && this.getDiagramElement().getKernel() instanceof Compartment;
    }
}

