/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.dynamics.EModel;
import biouml.model.dynamics.util.EModelHelper;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import com.developmentontheedge.beans.DynamicPropertySetAsMap;
import com.developmentontheedge.beans.DynamicPropertySetSupport;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.beans.PropertyChangeEvent;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.MutableDataElementSupport;

@PropertyName(value="Parameter")
@PropertyDescription(value="Model parameter.")
public class Variable
extends MutableDataElementSupport {
    public static final String TYPE_CALCULATED = "Calculated";
    public static final String TYPE_ALGEBRAIC = "Algebraic";
    public static final String TYPE_PARAMETER = "Parameter";
    public static final String TYPE_DIFFERENTIAL = "Differential";
    public static final String TYPE_DISCRETE = "Discrete";
    public static final String TYPE_UNUSED = "Not used";
    public static final String TYPE_TIME = "Time";
    protected double initialValue;
    protected DynamicPropertySet attributes;
    protected String units = "";
    protected boolean showInPlot = false;
    protected boolean constant;
    protected String comment;
    private String title;
    private String type = "Not used";

    protected Variable(String name, DataCollection<?> origin) {
        super(origin, name);
    }

    public Variable(String name, EModel modelSupport, DataCollection<?> origin) {
        this(name, origin);
        this.setTitle(name);
        this.setParent(modelSupport, "vars/" + name);
    }

    @PropertyName(value="Name")
    @PropertyDescription(value="Parameter name.")
    public String getName() {
        return super.getName();
    }

    public void setName(String name) {
        if ("time".equals(this.name) || name.equals(this.name)) {
            return;
        }
        String oldName = this.name;
        if (this.getParent() instanceof EModel) {
            EModelHelper helper = new EModelHelper((EModel)this.getParent());
            helper.renameVariable(oldName, name);
            try {
                ((EModel)this.getParent()).getVariables().remove(oldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @PropertyName(value="Initial value")
    @PropertyDescription(value="Initial value of the variable.")
    public double getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(double initialValue) {
        if ("time".equals(this.name)) {
            return;
        }
        double oldValue = this.initialValue;
        this.initialValue = initialValue;
        this.firePropertyChange("initialValue", oldValue, initialValue);
    }

    @PropertyName(value="Units")
    @PropertyDescription(value="Units.")
    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        String oldValue = this.units;
        this.units = units;
        this.firePropertyChange("units", oldValue, units);
    }

    @PropertyName(value="Constant")
    @PropertyDescription(value="If true then variable value is fixed and can not ba changed by any equation or event.")
    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        if ("time".equals(this.name)) {
            return;
        }
        Boolean oldValue = this.constant;
        this.constant = constant;
        this.firePropertyChange("constant", oldValue, constant);
    }

    @PropertyName(value="Comment")
    @PropertyDescription(value="Comment.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    @PropertyName(value="Type")
    @PropertyDescription(value="Variable type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        String str = "Variable: " + this.name + "=" + this.initialValue + " " + this.units;
        if (this.comment != null) {
            str = str + "; " + this.comment;
        }
        return str;
    }

    public Object clone() {
        return this.clone(this.name);
    }

    public Variable clone(String newName) {
        Variable var = (Variable)this.internalClone(this.getOrigin(), newName);
        var.type = this.type;
        var.attributes = null;
        if (this.attributes != null) {
            for (DynamicProperty oldProp : this.attributes) {
                DynamicProperty prop = null;
                try {
                    prop = DynamicPropertySetSupport.cloneProperty((DynamicProperty)oldProp);
                }
                catch (Exception e) {
                    prop = oldProp;
                }
                var.getAttributes().add(prop);
            }
        }
        return var;
    }

    public DynamicPropertySet getAttributes() {
        if (this.attributes == null) {
            this.attributes = new DynamicPropertySetAsMap();
            this.attributes.addPropertyChangeListener(e -> this.firePropertyChange(new PropertyChangeEvent((Object)this, "attributes/" + e.getPropertyName(), e.getOldValue(), e.getNewValue())));
        }
        return this.attributes;
    }

    @PropertyName(value="Title")
    @PropertyDescription(value="Title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

