/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.standard.type.BaseUnit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.biosoft.math.unitparser.AstConstant;
import ru.biosoft.math.unitparser.AstFunNode;
import ru.biosoft.math.unitparser.AstStart;
import ru.biosoft.math.unitparser.AstType;
import ru.biosoft.math.unitparser.AstUnitNode;
import ru.biosoft.math.unitparser.Node;
import ru.biosoft.math.unitparser.UnitParser;

public class UnitCalculator {
    public static AstStart readMath(String math) throws Exception {
        UnitParser parser = new UnitParser();
        return parser.parse(math);
    }

    public static BaseUnit[] getBaseUnits(AstStart astStart) throws Exception {
        ArrayList<BaseUnit> buList = new ArrayList<BaseUnit>();
        UnitCalculator.getBaseUnits(astStart.jjtGetChild(0), 1, buList);
        return buList.toArray(new BaseUnit[0]);
    }

    private static void getBaseUnits(Node node, int power, List<BaseUnit> buList) throws Exception {
        if (node instanceof AstUnitNode) {
            Node type;
            double[] mulNScale = UnitCalculator.getMulScale(node.jjtGetChild(0), 1.0, 0, 1);
            if (!(node.jjtGetChild(0) instanceof AstConstant)) {
                UnitCalculator.postprocessMulScale(mulNScale);
            }
            if ((type = node.jjtGetChild(1)) instanceof AstType) {
                buList.add(new BaseUnit(((AstType)type).getValue(), mulNScale[0], (int)mulNScale[1], power));
            } else if (type instanceof AstFunNode) {
                LinkedHashMap<String, Integer> typeMap = UnitCalculator.getBasesNPowers(type, power);
                boolean separateFirstKey = mulNScale[0] != 1.0 || mulNScale[1] != 0.0;
                for (Map.Entry<String, Integer> entry : typeMap.entrySet()) {
                    if (separateFirstKey && entry.getValue() != 1) {
                        if (entry.getValue() > 0) {
                            buList.add(new BaseUnit(entry.getKey(), mulNScale[0], (int)mulNScale[1], 1));
                            buList.add(new BaseUnit(entry.getKey(), 1.0, 0, entry.getValue() - 1));
                        } else {
                            buList.add(new BaseUnit(entry.getKey(), mulNScale[0], (int)mulNScale[1], -1));
                            buList.add(new BaseUnit(entry.getKey(), 1.0, 0, entry.getValue() + 1));
                        }
                        separateFirstKey = false;
                        continue;
                    }
                    buList.add(new BaseUnit(entry.getKey(), 1.0, 0, entry.getValue()));
                }
            }
        } else if (node instanceof AstFunNode) {
            String operation;
            switch (operation = ((AstFunNode)node).getOperator()) {
                case "*": {
                    UnitCalculator.getBaseUnits(node.jjtGetChild(0), power, buList);
                    UnitCalculator.getBaseUnits(node.jjtGetChild(1), power, buList);
                    break;
                }
                case "/": {
                    UnitCalculator.getBaseUnits(node.jjtGetChild(0), power, buList);
                    UnitCalculator.getBaseUnits(node.jjtGetChild(1), -power, buList);
                    break;
                }
                case "^": {
                    Node powerNode = node.jjtGetChild(1);
                    UnitCalculator.getBaseUnits(node.jjtGetChild(0), power *= ((AstConstant)powerNode).getValue().intValue(), buList);
                }
            }
        }
    }

    private static LinkedHashMap<String, Integer> getBasesNPowers(Node node, int power) {
        LinkedHashMap<String, Integer> typeMap = new LinkedHashMap<String, Integer>();
        if (node instanceof AstType) {
            String key_name = ((AstType)node).getValue();
            typeMap.put(key_name, power);
        } else if (node instanceof AstFunNode) {
            String operation;
            switch (operation = ((AstFunNode)node).getOperator()) {
                case "*": {
                    typeMap.putAll(UnitCalculator.getBasesNPowers(node.jjtGetChild(0), power));
                    typeMap.putAll(UnitCalculator.getBasesNPowers(node.jjtGetChild(1), power));
                    break;
                }
                case "/": {
                    typeMap.putAll(UnitCalculator.getBasesNPowers(node.jjtGetChild(0), power));
                    typeMap.putAll(UnitCalculator.getBasesNPowers(node.jjtGetChild(1), -power));
                    break;
                }
                case "^": {
                    typeMap.putAll(UnitCalculator.getBasesNPowers(node.jjtGetChild(0), power * ((AstConstant)node.jjtGetChild(1)).getValue().intValue()));
                }
            }
        }
        return typeMap;
    }

    private static void postprocessMulScale(double[] mulNScale) {
        while (mulNScale[0] > 10.0) {
            mulNScale[0] = mulNScale[0] / 10.0;
            mulNScale[1] = mulNScale[1] + 1.0;
        }
        while (mulNScale[0] < 1.0) {
            mulNScale[0] = mulNScale[0] * 10.0;
            mulNScale[1] = mulNScale[1] - 1.0;
        }
        mulNScale[0] = (double)Math.round(mulNScale[0] * 1.0E10) / 1.0E10;
    }

    private static double[] getMulScale(Node node, double multiplier, int scale, int power) {
        double[] mulNScale = new double[]{multiplier, scale};
        if (node instanceof AstFunNode) {
            String operation;
            switch (operation = ((AstFunNode)node).getOperator()) {
                case "*": {
                    mulNScale = UnitCalculator.getMulScale(node.jjtGetChild(0), mulNScale[0], (int)mulNScale[1], power);
                    mulNScale = UnitCalculator.getMulScale(node.jjtGetChild(1), mulNScale[0], (int)mulNScale[1], power);
                    break;
                }
                case "/": {
                    mulNScale = UnitCalculator.getMulScale(node.jjtGetChild(0), mulNScale[0], (int)mulNScale[1], power);
                    mulNScale = UnitCalculator.getMulScale(node.jjtGetChild(1), mulNScale[0], (int)mulNScale[1], -power);
                    break;
                }
                case "^": {
                    mulNScale = UnitCalculator.getMulScale(node.jjtGetChild(0), mulNScale[0], (int)mulNScale[1], power *= ((AstConstant)node.jjtGetChild(1)).getValue().intValue());
                }
            }
        } else if (node instanceof AstConstant) {
            double value = ((AstConstant)node).getValue().doubleValue();
            if (value == 10.0) {
                mulNScale[1] = mulNScale[1] + 1.0;
            } else {
                mulNScale[0] = mulNScale[0] * Math.pow(value, power);
            }
        }
        return mulNScale;
    }
}

