/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Role;
import biouml.model.dynamics.Connection;
import biouml.standard.diagram.Util;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.HashMap;
import java.util.Map;
import one.util.streamex.StreamEx;

public class UndirectedConnection
extends Connection {
    public static final String NOT_SELECTED_STRING = "Not selected";
    private final Map<MainVariableType, String> varTypeDescription;
    private final boolean varIsEditable;
    private MainVariableType mainVariable = MainVariableType.NOT_SELECTED;
    private String conversionFactor = "";
    private double initialValue;

    public UndirectedConnection(Edge edge) {
        super(edge);
        this.varIsEditable = edge.nodes().noneMatch(Util::isPropagatedPort);
        this.varTypeDescription = new HashMap<MainVariableType, String>();
        this.varTypeDescription.put(MainVariableType.NOT_SELECTED, NOT_SELECTED_STRING);
    }

    @Override
    public void setInputPort(Connection.Port p) {
        super.setInputPort(p);
        Edge edge = (Edge)this.getDiagramElement();
        if (Util.isBus(edge.getInput())) {
            this.mainVariable = MainVariableType.INPUT;
        }
        String inputDescription = edge.getInput().getParent() instanceof Diagram ? this.getInputPort().getVariableName() : ((Compartment)edge.getInput().getParent()).getName() + "/" + this.getInputPort().getVariableName();
        this.varTypeDescription.put(MainVariableType.INPUT, inputDescription);
    }

    @Override
    public void setOutputPort(Connection.Port p) {
        super.setOutputPort(p);
        Edge edge = (Edge)this.getDiagramElement();
        if (Util.isBus(edge.getOutput())) {
            this.mainVariable = MainVariableType.OUTPUT;
        }
        String outputDescription = edge.getOutput().getParent() instanceof Diagram ? this.getOutputPort().getVariableName() : ((Compartment)edge.getOutput().getParent()).getName() + "/" + this.getOutputPort().getVariableName();
        this.varTypeDescription.put(MainVariableType.OUTPUT, outputDescription);
    }

    public void setMainVariableType(MainVariableType mainVariable) {
        MainVariableType oldValue = this.mainVariable;
        this.mainVariable = mainVariable;
        this.firePropertyChange("mainVariable", (Object)oldValue, (Object)mainVariable);
    }

    public MainVariableType getMainVariableType() {
        return this.mainVariable;
    }

    public String[] getAvailableNames() {
        try {
            if (!this.varIsEditable) {
                return new String[]{this.getVariableNamePath()};
            }
            return this.varTypeDescription.values().toArray(new String[this.varTypeDescription.size()]);
        }
        catch (Exception ex) {
            return new String[]{NOT_SELECTED_STRING};
        }
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(double initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public Role clone(DiagramElement de) {
        UndirectedConnection connection = new UndirectedConnection((Edge)de);
        this.doClone(connection);
        return connection;
    }

    public void doClone(UndirectedConnection connection) {
        super.doClone(connection);
        connection.initialValue = this.initialValue;
        connection.mainVariable = this.mainVariable;
        connection.conversionFactor = this.conversionFactor;
        connection.varTypeDescription.putAll(this.varTypeDescription);
    }

    @PropertyName(value="Main variable")
    @PropertyDescription(value="Main variable.")
    public String getVariableNamePath() {
        return this.varTypeDescription.get((Object)this.mainVariable);
    }

    public void setVariableNamePath(String variablePath) {
        for (MainVariableType mainVariableType : StreamEx.ofKeys(this.varTypeDescription, variablePath::equals)) {
            MainVariableType oldValue = this.mainVariable;
            this.mainVariable = mainVariableType;
            this.firePropertyChange("mainVariable", (Object)oldValue, (Object)mainVariableType);
        }
    }

    @PropertyName(value="Conversion factor")
    @PropertyDescription(value="Conversion factor.")
    public String getConversionFactor() {
        return this.conversionFactor;
    }

    public void setConversionFactor(String conversionFactor) {
        this.conversionFactor = conversionFactor;
    }

    public static enum MainVariableType {
        INPUT,
        OUTPUT,
        NOT_SELECTED;

    }
}

