/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.State;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;

@PropertyName(value="Transition")
@PropertyDescription(value="Transition from one state to another.")
public class Transition
extends EModelRoleSupport
implements ExpressionOwner {
    protected String when;
    protected String after;
    protected Assignment[] assignment = new Assignment[0];

    public Transition(DiagramElement de) {
        super(de);
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("Transition " + this.getDiagramElement().getName() + endl);
        if (this.when != null) {
            buf.append("  when:  " + this.when + endl);
        }
        if (this.after != null) {
            buf.append("  after: " + this.after + endl);
        }
        buf.append("  assignments: " + endl);
        for (Assignment element : this.assignment) {
            buf.append("    " + element.variable + " = " + element.math);
        }
        return buf.toString();
    }

    @Override
    public Role clone(DiagramElement de) {
        Transition transition = new Transition(de);
        transition.when = this.when;
        transition.after = this.after;
        transition.assignment = Assignment.clone(this.assignment, transition);
        transition.comment = this.comment;
        return transition;
    }

    @PropertyName(value="When")
    @PropertyDescription(value="Trigger for transition to be performed. <br> Alternative to After.")
    public String getWhen() {
        return this.when;
    }

    public void setWhen(String when) {
        String oldValue = this.when;
        this.when = when;
        this.firePropertyChange("when", oldValue, when);
        if (this.after != null) {
            oldValue = this.after;
            this.after = null;
            this.firePropertyChange("after", oldValue, this.after);
        }
    }

    @PropertyName(value="After")
    @PropertyDescription(value="Time after transition should be perfomed. <br> Alternative to When.")
    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        String oldValue = this.after;
        this.after = after;
        this.firePropertyChange("after", oldValue, after);
        if (this.when != null) {
            oldValue = this.when;
            this.when = null;
            this.firePropertyChange("when", oldValue, this.when);
        }
    }

    @PropertyName(value="Assignments")
    @PropertyDescription(value="Assignments while transition is performed.")
    public Assignment[] getAssignments() {
        return this.assignment;
    }

    public Assignment getAssignment(int i) {
        return this.assignment[i];
    }

    public void setAssignments(Assignment[] assignment) {
        Assignment[] oldValue = this.assignment;
        if (oldValue != null) {
            for (Assignment element : oldValue) {
                element.setParent(null);
            }
        }
        this.assignment = assignment;
        if (assignment == null) {
            assignment = new Assignment[]{};
        } else {
            for (Assignment element : assignment) {
                element.setParent(this);
            }
        }
        this.firePropertyChange("assignment", oldValue, assignment);
    }

    public void setAssignment(int i, Assignment assignment) {
        Assignment oldValue = this.assignment[i];
        oldValue.setParent(null);
        this.assignment[i] = assignment;
        assignment.setParent(this);
        this.firePropertyChange("assignment", oldValue, assignment);
    }

    public void addAssignment(Assignment ea, boolean fire) {
        Assignment[] oldValue = this.assignment;
        this.assignment = new Assignment[oldValue.length + 1];
        if (oldValue.length > 0) {
            System.arraycopy(oldValue, 0, this.assignment, 0, oldValue.length);
        }
        this.assignment[oldValue.length] = ea;
        ea.setParent(this);
        if (fire) {
            this.firePropertyChange("assignment", oldValue, this.assignment);
        }
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "when".equals(propertyName) || "after".equals(propertyName) || "assignment".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        return (String[])StreamEx.of((Object[])this.assignment).map(a -> a.variable + '=' + a.math).prepend((Object)(this.when == null ? this.after : this.when)).toArray(String[]::new);
    }

    @Override
    public void setExpressions(String[] exps) {
    }

    @Override
    public Role getRole() {
        return this;
    }

    public State getFrom() {
        Edge transitionEdge = (Edge)this.getDiagramElement();
        Role role = transitionEdge.getInput().getRole();
        return (State)role;
    }

    public State getTo() {
        Edge transitionEdge = (Edge)this.getDiagramElement();
        Role role = transitionEdge.getOutput().getRole();
        return (State)role;
    }
}

