/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.ExpressionOwner;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.util.bean.BeanInfoEx2;

@PropertyName(value="Table element")
@PropertyDescription(value="Element associated with table.")
public class TableElement
extends EModelRoleSupport
implements ExpressionOwner {
    private TableDataCollection table;
    private DataElementPath path;
    private Variable[] variables;
    private String formula;
    private boolean cycled = false;

    public TableElement(DiagramElement de) {
        super(de);
    }

    @PropertyName(value="Variables")
    @PropertyDescription(value="Variables associated with table columns.")
    public Variable[] getVariables() {
        return this.variables;
    }

    public void setVariables(Variable[] variable) {
        this.variables = variable;
    }

    public TableDataCollection getTable() {
        if (this.table == null && this.path != null) {
            this.table = (TableDataCollection)this.path.optDataElement(TableDataCollection.class);
        }
        return this.table;
    }

    public void setTable(TableDataCollection table) {
        TableDataCollection oldValue = this.table;
        this.table = table;
        this.path = table.getCompletePath();
        this.variables = (Variable[])table.columns().map(column -> new Variable("", column.getName(), this)).toArray(Variable[]::new);
        this.firePropertyChange("table", oldValue, table);
    }

    @PropertyName(value="Table path")
    @PropertyDescription(value="Path to associated table.")
    public DataElementPath getTablePath() {
        return this.path;
    }

    public void setTablePath(DataElementPath path) {
        if (path != null) {
            DataElement de = path.optDataElement();
            if (de instanceof TableDataCollection) {
                this.setTable((TableDataCollection)de);
            }
            this.path = path;
        }
    }

    @Override
    public Role clone(DiagramElement de) {
        TableElement te = new TableElement(de);
        if (this.table != null) {
            te.setTable(this.table);
            te.setVariables((Variable[])this.variables.clone());
            te.setFormula(this.formula);
            te.setCycled(this.cycled);
        }
        return te;
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "variables".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        return (String[])StreamEx.of((Object[])this.variables).map(Variable::getName).toArray(String[]::new);
    }

    @Override
    public void setExpressions(String[] exps) {
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i].setName(exps[i]);
        }
    }

    @Override
    public Role getRole() {
        return this;
    }

    @PropertyName(value="Formula")
    @PropertyDescription(value="Dependency between variables of type \"func ~ arg\".")
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        String oldValue = this.formula;
        this.formula = formula;
        this.firePropertyChange("formula", oldValue, formula);
    }

    @PropertyName(value="Cycled")
    @PropertyDescription(value="If true then table data considered as cycled i.e. after last argument point it will use value from first point and so on.")
    public boolean isCycled() {
        return this.cycled;
    }

    public void setCycled(boolean cycled) {
        boolean oldValue = this.cycled;
        this.cycled = cycled;
        this.firePropertyChange("cycled", oldValue, cycled);
    }

    public static class VariableBeanInfo
    extends BeanInfoEx2<Variable> {
        public VariableBeanInfo() {
            super(Variable.class);
        }

        public void initProperties() throws Exception {
            this.property("name").add();
            this.property("columnName").readOnly().add();
        }
    }

    @PropertyName(value="Variable")
    @PropertyDescription(value="Variable associated with table column.")
    public static class Variable
    extends Option
    implements ExpressionOwner {
        private String name;
        private String columnName;

        Variable(String name, String columnName, Option parent) {
            super(parent);
            this.name = name;
            this.columnName = columnName;
        }

        @PropertyName(value="Name")
        @PropertyDescription(value="Variable name.")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String oldValue = this.name;
            this.name = name;
            this.firePropertyChange("name", oldValue, name);
        }

        @PropertyName(value="Column name")
        @PropertyDescription(value="Name of the correspondent column in table.")
        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            String oldValue = this.columnName;
            this.columnName = columnName;
            this.firePropertyChange("columnName", oldValue, columnName);
        }

        @Override
        public boolean isExpression(String propertyName) {
            return "name".equals(propertyName);
        }

        @Override
        public String[] getExpressions() {
            return new String[]{this.name};
        }

        @Override
        public void setExpressions(String[] exps) {
            this.name = exps[0];
        }

        @Override
        public Role getRole() {
            return (Role)this.getParent();
        }
    }
}

