/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.ExpressionOwner;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;
import ru.biosoft.util.TextUtil;

@PropertyName(value="State")
@PropertyDescription(value="State. Model may transit between states during simulation.")
public class State
extends EModelRoleSupport
implements ExpressionOwner {
    protected boolean start;
    protected Assignment[] onEntryAssignment = new Assignment[0];
    protected Assignment[] onExitAssignment = new Assignment[0];

    public State(DiagramElement de) {
        super(de);
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("State " + this.getDiagramElement().getName() + endl);
        if (this.onEntryAssignment.length > 0) {
            buf.append("  on entry: " + endl);
            for (Assignment assignment : this.onEntryAssignment) {
                buf.append("    " + assignment.variable + " = " + assignment.math);
            }
        }
        if (this.onEntryAssignment.length > 0) {
            buf.append("  on exit: " + endl);
            for (Assignment assignment : this.onExitAssignment) {
                buf.append("    " + assignment.variable + " = " + assignment.math);
            }
        }
        return buf.toString();
    }

    @Override
    public Role clone(DiagramElement de) {
        State state = new State(de);
        state.onEntryAssignment = Assignment.clone(this.onEntryAssignment, state);
        state.onExitAssignment = Assignment.clone(this.onExitAssignment, state);
        state.comment = this.comment;
        state.start = this.start;
        return state;
    }

    @PropertyName(value="Is start")
    @PropertyDescription(value="Indicates if state is start.")
    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    @PropertyName(value="On entry")
    @PropertyDescription(value="On entry assignment.")
    public Assignment[] getOnEntryAssignment() {
        return this.onEntryAssignment;
    }

    public Assignment getOnEntryAssignment(int i) {
        return this.onEntryAssignment[i];
    }

    public void setOnEntryAssignment(Assignment[] onEntryAssignment) {
        Assignment[] oldValue = this.onEntryAssignment;
        if (oldValue != null) {
            for (Assignment assignment : oldValue) {
                assignment.setParent(null);
            }
        }
        this.onEntryAssignment = onEntryAssignment;
        if (onEntryAssignment == null) {
            onEntryAssignment = new Assignment[]{};
        } else {
            for (Assignment assignment : onEntryAssignment) {
                assignment.setParent(this);
            }
        }
        this.firePropertyChange("onEntryAssignment", oldValue, onEntryAssignment);
    }

    public void setOnEntryAssignment(int i, Assignment onEntryAssignment) {
        Assignment oldValue = this.onEntryAssignment[i];
        oldValue.setParent(null);
        this.onEntryAssignment[i] = onEntryAssignment;
        onEntryAssignment.setParent(this);
        this.firePropertyChange("onEntryAssignment", oldValue, onEntryAssignment);
    }

    public void addOnEntryAssignment(Assignment ea, boolean fireEvent) {
        Assignment[] oldValue = this.onEntryAssignment;
        this.onEntryAssignment = new Assignment[oldValue.length + 1];
        if (oldValue.length > 0) {
            System.arraycopy(oldValue, 0, this.onEntryAssignment, 0, oldValue.length);
        }
        this.onEntryAssignment[oldValue.length] = ea;
        ea.setParent(this);
        if (fireEvent) {
            this.firePropertyChange("onEntryAssignment", oldValue, this.onEntryAssignment);
        }
    }

    @PropertyName(value="On exit")
    @PropertyDescription(value="On exit assignment.")
    public Assignment[] getOnExitAssignment() {
        return this.onExitAssignment;
    }

    public Assignment getOnExitAssignment(int i) {
        return this.onExitAssignment[i];
    }

    public void setOnExitAssignment(Assignment[] onExitAssignment) {
        Assignment[] oldValue = this.onExitAssignment;
        if (oldValue != null) {
            for (Assignment assignment : oldValue) {
                assignment.setParent(null);
            }
        }
        this.onExitAssignment = onExitAssignment;
        if (onExitAssignment == null) {
            onExitAssignment = new Assignment[]{};
        } else {
            for (Assignment assignment : onExitAssignment) {
                assignment.setParent(this);
            }
        }
        this.firePropertyChange("onExitAssignment", oldValue, onExitAssignment);
    }

    public void setOnExitAssignment(int i, Assignment onExitAssignment) {
        Assignment oldValue = this.onExitAssignment[i];
        oldValue.setParent(null);
        this.onExitAssignment[i] = onExitAssignment;
        onExitAssignment.setParent(this);
        this.firePropertyChange("onExitAssignment", oldValue, onExitAssignment);
    }

    public void addOnExitAssignment(Assignment ea, boolean fireEvent) {
        Assignment[] oldValue = this.onExitAssignment;
        this.onExitAssignment = new Assignment[oldValue.length + 1];
        if (oldValue.length > 0) {
            System.arraycopy(oldValue, 0, this.onExitAssignment, 0, oldValue.length);
        }
        this.onExitAssignment[oldValue.length] = ea;
        ea.setParent(this);
        if (fireEvent) {
            this.firePropertyChange("onExitAssignment", oldValue, this.onExitAssignment);
        }
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "onEntryAssignment".equals(propertyName) || "onExitAssignment".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        return (String[])StreamEx.of((Object[])this.onEntryAssignment).append((Object[])this.onExitAssignment).map(assignment -> assignment.variable + '=' + assignment.math).toArray(String[]::new);
    }

    @Override
    public void setExpressions(String[] exps) {
        Assignment assignment;
        String[] maths;
        int i;
        int entryLen = this.onEntryAssignment.length;
        int exitLen = this.onExitAssignment.length;
        for (i = 0; i < entryLen; ++i) {
            maths = TextUtil.split((String)exps[i], (char)'=');
            assignment = this.onEntryAssignment[i];
            assignment.setVariable(maths[0]);
            assignment.setMath(maths[1]);
        }
        for (i = 0; i < exitLen; ++i) {
            maths = TextUtil.split((String)exps[i + entryLen], (char)'=');
            assignment = this.onExitAssignment[i];
            assignment.setVariable(maths[0]);
            assignment.setMath(maths[1]);
        }
    }

    @Override
    public Role getRole() {
        return this;
    }

    public String getName() {
        return this.getDiagramElement().getName();
    }
}

