/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.ExpressionOwner;
import com.developmentontheedge.beans.Option;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.table.TableDataCollection;
import ru.biosoft.table.TableDataCollectionUtils;
import ru.biosoft.util.bean.BeanInfoEx2;

@PropertyName(value="Table element")
@PropertyDescription(value="Element associated with table.")
public class SimpleTableElement
extends EModelRoleSupport
implements ExpressionOwner {
    public static String TYPE_PIECEWISE = "Piecewise";
    private TableDataCollection table;
    private DataElementPath path;
    private VarColumn argColumn = new VarColumn();
    private VarColumn[] columns = new VarColumn[1];
    private String[] availableColumns = new String[0];
    private String type = TYPE_PIECEWISE;
    private VarColumn prototype;

    public SimpleTableElement(DiagramElement de) {
        super(de);
        this.columns[0] = new VarColumn();
    }

    public String[] getAvailableColumns() {
        return this.availableColumns;
    }

    @PropertyName(value="Columns")
    @PropertyDescription(value="Table columns.")
    public VarColumn[] getColumns() {
        return this.columns;
    }

    public void setColumns(VarColumn[] argVariable) {
        this.columns = argVariable;
        for (VarColumn col : argVariable) {
            VarColumn.access$002(col, this.availableColumns);
        }
    }

    @PropertyName(value="Argument Column")
    @PropertyDescription(value="Column for table associated with argument variable.")
    public VarColumn getArgColumn() {
        return this.argColumn;
    }

    public void setArgColumn(VarColumn argColumn) {
        VarColumn oldValue = this.argColumn;
        this.argColumn = argColumn;
        this.firePropertyChange("argColumn", (Object)oldValue, (Object)argColumn);
    }

    public TableDataCollection getTable() {
        if (this.table == null && this.path != null) {
            this.table = (TableDataCollection)this.path.optDataElement(TableDataCollection.class);
        }
        return this.table;
    }

    public void setTable(TableDataCollection table) {
        TableDataCollection oldValue = this.table;
        this.table = table;
        this.path = table.getCompletePath();
        this.prototype = new VarColumn(table);
        this.availableColumns = TableDataCollectionUtils.getColumnNames((TableDataCollection)table);
        for (VarColumn col : this.getColumns()) {
            VarColumn.access$002(col, this.availableColumns);
        }
        VarColumn.access$002(this.argColumn, this.availableColumns);
        this.firePropertyChange("table", oldValue, table);
    }

    @PropertyName(value="Table path")
    @PropertyDescription(value="Path to associated table.")
    public DataElementPath getTablePath() {
        return this.path;
    }

    public void setTablePath(DataElementPath path) {
        if (path != null) {
            DataElement de = path.optDataElement();
            if (de instanceof TableDataCollection) {
                this.setTable((TableDataCollection)de);
            }
            this.path = path;
        }
    }

    @Override
    public Role clone(DiagramElement de) {
        SimpleTableElement te = new SimpleTableElement(de);
        if (this.table != null) {
            te.setTable(this.table);
            te.setColumns(this.columns);
            te.setArgColumn(this.argColumn);
        }
        return te;
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "variables".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        return (String[])StreamEx.of((Object[])this.columns).map(c -> c.getVariable()).toArray(String[]::new);
    }

    @Override
    public void setExpressions(String[] exps) {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].setVariable(exps[i]);
        }
    }

    @Override
    public Role getRole() {
        return this;
    }

    public static class VarColumnBeanInfo
    extends BeanInfoEx2<VarColumn> {
        public VarColumnBeanInfo() {
            super(VarColumn.class);
        }

        public void initProperties() throws Exception {
            this.add("variable");
            this.property("column").tags(bean -> bean.getAvailableColumns()).add();
        }
    }

    public static class VarColumn
    extends Option {
        private String variable = "";
        private String column = "";
        private TableDataCollection table;
        private String[] availableColumns = new String[0];

        public VarColumn() {
        }

        public VarColumn(TableDataCollection table) {
            this.table = table;
            this.availableColumns = TableDataCollectionUtils.getColumnNames((TableDataCollection)table);
        }

        public StreamEx<String> getAvailableColumns() {
            return StreamEx.of((Object[])this.availableColumns);
        }

        @PropertyName(value="Column")
        @PropertyDescription(value="Column for table associated with calculated variable.")
        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            String oldValue = this.column;
            this.column = column;
            this.firePropertyChange("column", oldValue, column);
        }

        @PropertyName(value="Variable")
        @PropertyDescription(value="Variable calculated by tabular data.")
        public String getVariable() {
            return this.variable;
        }

        public void setVariable(String variable) {
            this.variable = variable;
        }

        public VarColumn clone() {
            VarColumn result = new VarColumn(this.table);
            result.column = this.column;
            result.variable = this.variable;
            return result;
        }

        static /* synthetic */ String[] access$002(VarColumn x0, String[] x1) {
            x0.availableColumns = x1;
            return x1;
        }
    }
}

