/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.dynamics.Connection;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;

public abstract class MultipleConnection
extends Connection {
    private List<Connection> connections = new ArrayList<Connection>();

    protected MultipleConnection(Edge edge) {
        super(edge);
    }

    @PropertyName(value="Connections")
    @PropertyDescription(value="Inner connections.")
    public Connection[] getConnections() {
        return this.connections.toArray(new Connection[this.connections.size()]);
    }

    public void setConnections(Connection[] pc) {
        this.connections.clear();
        StreamEx.of((Object[])pc).forEach(c -> this.addConnection((Connection)c));
    }

    public void addConnection(Connection c) {
        this.connections.add(c);
    }

    protected void removeConnection(Connection c) {
        if (!this.connections.contains(c)) {
            throw new IllegalArgumentException("Directed connection was not found");
        }
        this.connections.remove(c);
    }

    protected void doClone(MultipleConnection connection, DiagramElement de) {
        super.doClone(connection);
        for (Connection c : this.connections) {
            connection.addConnection((Connection)c.clone(de));
        }
    }

    public static StreamEx<Connection> getBasicConnections(Connection connection) {
        if (connection instanceof MultipleConnection) {
            return StreamEx.of((Object[])((MultipleConnection)connection).getConnections());
        }
        return StreamEx.of((Object)connection);
    }
}

