/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import one.util.streamex.StreamEx;

public class MathOperations {
    private final HashMap<String, Method> operations = new HashMap();
    private final Set<String> comparisons = new TreeSet<String>();

    public MathOperations() {
        this.init();
    }

    public Method getMethod(String name) {
        return this.operations.get(name);
    }

    public boolean contains(String name) {
        return this.operations.containsKey(name);
    }

    public boolean isComparison(String name) {
        return this.comparisons.contains(name);
    }

    private void init() {
        this.initComparisonSet();
        this.initMathLibraryOperations();
        this.initSimpleOperations();
    }

    private void initComparisonSet() {
        this.comparisons.add("=");
        this.comparisons.add(">");
        this.comparisons.add("<");
    }

    private void initMathLibraryOperations() {
        Method[] methods;
        for (Method method : methods = Math.class.getMethods()) {
            if (!this.checkParameterTypes(method.getParameterTypes())) continue;
            String name = method.getName();
            if (name.equals("pow")) {
                name = "^";
            }
            this.operations.put(name, method);
        }
    }

    private boolean checkParameterTypes(Class<?>[] types) {
        return StreamEx.of((Object[])types).allMatch(Double.TYPE::equals);
    }

    private void initSimpleOperations() {
        try {
            Method method = MathOperations.class.getMethod("plus", Double.TYPE, Double.TYPE);
            this.operations.put("+", method);
            method = MathOperations.class.getMethod("minus", Double.TYPE, Double.TYPE);
            this.operations.put("-", method);
            method = MathOperations.class.getMethod("multiplication", Double.TYPE, Double.TYPE);
            this.operations.put("*", method);
            method = MathOperations.class.getMethod("division", Double.TYPE, Double.TYPE);
            this.operations.put("/", method);
            method = MathOperations.class.getMethod("unaryMinus", Double.TYPE);
            this.operations.put("u-", method);
            method = MathOperations.class.getMethod("equality", Double.TYPE, Double.TYPE);
            this.operations.put("=", method);
            method = MathOperations.class.getMethod("less", Double.TYPE, Double.TYPE);
            this.operations.put("<", method);
            method = MathOperations.class.getMethod("greater", Double.TYPE, Double.TYPE);
            this.operations.put(">", method);
            method = MathOperations.class.getMethod("delay", Double.TYPE, Double.TYPE);
            this.operations.put("delay", method);
            this.operations.put("log", MathOperations.class.getMethod("log", Double.TYPE, Double.TYPE));
            this.operations.put("ln", MathOperations.class.getMethod("ln", Double.TYPE));
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalArgumentException(exc);
        }
    }

    public static double plus(double arg1, double arg2) {
        return arg1 + arg2;
    }

    public static double minus(double arg1, double arg2) {
        return arg1 - arg2;
    }

    public static double multiplication(double arg1, double arg2) {
        return arg1 * arg2;
    }

    public static double division(double arg1, double arg2) {
        return arg1 / arg2;
    }

    public static double unaryMinus(double arg1) {
        return -arg1;
    }

    public static boolean equality(double arg1, double arg2) {
        return arg1 == arg2;
    }

    public static boolean less(double arg1, double arg2) {
        return arg1 < arg2;
    }

    public static boolean greater(double arg1, double arg2) {
        return arg1 > arg2;
    }

    public static double delay(double arg1, double arg2) {
        return arg1;
    }

    public static double log(double arg1, double arg2) {
        return MathOperations.ln(arg2) / MathOperations.ln(arg1);
    }

    public static double ln(double arg) {
        return Math.log(arg);
    }
}

