/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.MessageBundle;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.MathContext;
import biouml.model.dynamics.MathOperations;
import biouml.model.dynamics.Variable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstFunctionDeclaration;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.AstVarNode;
import ru.biosoft.math.model.Node;
import ru.biosoft.math.model.Utils;
import ru.biosoft.math.parser.Parser;

public class MathCalculator {
    protected static final Logger log = Logger.getLogger(MathCalculator.class.getName());
    protected static final MathOperations mathOperations = new MathOperations();
    private Map<String, AstStart> formulas;
    private List<AstFunctionDeclaration> functionDeclarations;
    private EModel emodel;
    private Map<String, AstStart> equations;

    public MathCalculator(EModel emodel) {
        this.emodel = emodel;
        this.formulas = new HashMap<String, AstStart>();
    }

    public MathCalculator() {
        this.formulas = new HashMap<String, AstStart>();
    }

    public double[] calculateMath(String formula, MathContext variableValues) {
        AstStart start = this.formulas.get(formula);
        if (start == null) {
            start = MathCalculator.readMath(formula);
            this.formulas.put(formula, start);
        }
        return this.calculateMath(start, variableValues);
    }

    public double[] calculateMath(AstStart start, MathContext variableValues) {
        return start == null ? null : Utils.children((Node)start).mapToDouble(child -> this.processNode((Node)child, variableValues)).toArray();
    }

    protected double processNode(Node node, MathContext variableValues) {
        if (node instanceof AstConstant) {
            return this.processConstant((AstConstant)node);
        }
        if (node instanceof AstVarNode) {
            return this.processVariable((AstVarNode)node, variableValues);
        }
        if (node instanceof AstFunNode) {
            return this.processFunction((AstFunNode)node, variableValues);
        }
        return 0.0;
    }

    protected double processConstant(AstConstant node) {
        Object value = node.getValue();
        return value instanceof Number ? ((Number)value).doubleValue() : 0.0;
    }

    protected double processVariable(AstVarNode node, MathContext variableValues) {
        String nodeName = node.getName().replace("\"", "");
        if (this.equations != null && this.equations.containsKey(nodeName)) {
            return this.calculateMath(this.equations.get(nodeName), variableValues)[0];
        }
        if (!variableValues.contains(nodeName)) {
            Variable var;
            if (this.emodel != null && (var = this.emodel.getVariable(nodeName)) != null) {
                return var.getInitialValue();
            }
            log.log(Level.SEVERE, "Unknown value for variable " + nodeName);
            return 0.0;
        }
        return variableValues.get(nodeName, 0.0);
    }

    protected double processFunction(AstFunNode node, MathContext variableValues) {
        String name = node.getFunction().getName();
        double[] args = new double[node.jjtGetNumChildren()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.processNode(node.jjtGetChild(i), variableValues);
        }
        try {
            Method method = mathOperations.getMethod(name);
            if (method != null) {
                return (Double)method.invoke(null, (Object[])ArrayUtils.toObject((double[])args));
            }
            if (this.functionDeclarations != null) {
                for (AstFunctionDeclaration declaration : this.functionDeclarations) {
                    if (!declaration.getName().equals(name) || declaration.getNumberOfParameters() != args.length) continue;
                    MathContext params = new MathContext(variableValues);
                    for (int i = 0; i < declaration.jjtGetNumChildren() - 1; ++i) {
                        Node functionParam = declaration.jjtGetChild(i);
                        if (!(functionParam instanceof AstVarNode)) continue;
                        params.put(((AstVarNode)functionParam).getName(), args[i]);
                    }
                    return this.processNode(declaration.jjtGetChild(declaration.jjtGetNumChildren() - 1), params);
                }
            }
            log.log(Level.SEVERE, "Unknown function: '" + name + "'.");
            return 0.0;
        }
        catch (IllegalAccessException | InvocationTargetException exc) {
            throw new AssertionError((Object)exc);
        }
    }

    public static AstStart readMath(String math) {
        AstStart start = null;
        if (math != null && math.length() > 0) {
            Parser parser = new Parser();
            try {
                int status = parser.parse(math);
                if (status > 0) {
                    MessageBundle.error(log, "ERROR_MATH_PARSING", new Object[]{math, Utils.formatErrors((ru.biosoft.math.model.Parser)parser)});
                }
                if (status < 4) {
                    start = parser.getStartNode();
                }
            }
            catch (Throwable t) {
                MessageBundle.error(log, "ERROR_MATH_PARSING", new Object[]{math, t.toString()});
            }
        }
        return start;
    }

    public void addFunctionDeclarations(Function[] functions) {
        if (functions != null && functions.length > 0) {
            if (this.functionDeclarations == null) {
                this.functionDeclarations = new ArrayList<AstFunctionDeclaration>();
            }
            for (Function function : functions) {
                AstStart math = MathCalculator.readMath(function.getFormula());
                if (!(math.jjtGetChild(0) instanceof AstFunctionDeclaration)) continue;
                this.functionDeclarations.add((AstFunctionDeclaration)math.jjtGetChild(0));
            }
        }
    }

    public void setEModel(EModel emodel) {
        this.emodel = emodel;
        if (this.functionDeclarations == null) {
            this.functionDeclarations = new ArrayList<AstFunctionDeclaration>();
        }
        for (Function function : emodel.getFunctions()) {
            AstStart math = emodel.readMath(function.getFormula(), (Role)function);
            if (!(math.jjtGetChild(0) instanceof AstFunctionDeclaration)) continue;
            this.functionDeclarations.add((AstFunctionDeclaration)math.jjtGetChild(0));
        }
    }

    public void addEquations(List<Equation> equations) throws Exception {
        if (equations != null && equations.size() > 0) {
            if (this.equations == null) {
                this.equations = new HashMap<String, AstStart>();
            }
            for (Equation equation : equations) {
                if (equation.getType().equals("scalar") || equation.getType().equals("initial assignment") || equation.getType().equals("scalar_internal")) {
                    AstStart math = MathCalculator.readMath(equation.getFormula());
                    if (math == null) continue;
                    this.equations.put(equation.getVariable(), math);
                    continue;
                }
                throw new Exception("Unsupported type of equation: " + equation.getType());
            }
        }
    }

    public void clearRepositories() {
        this.formulas = new HashMap<String, AstStart>();
        if (this.functionDeclarations != null) {
            this.functionDeclarations = new ArrayList<AstFunctionDeclaration>();
        }
        if (this.equations != null) {
            this.equations = new HashMap<String, AstStart>();
        }
    }
}

