/*
 * Decompiled with CFR 0.152.
 */
package biouml.model.dynamics;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.EModelRoleSupport;
import biouml.model.dynamics.ExpressionOwner;
import biouml.model.dynamics.util.EModelHelper;
import com.developmentontheedge.beans.annot.PropertyDescription;
import com.developmentontheedge.beans.annot.PropertyName;
import java.util.Set;
import one.util.streamex.StreamEx;
import ru.biosoft.math.model.Utils;

@PropertyName(value="Function")
@PropertyDescription(value="Mathematical function.")
public class Function
extends EModelRoleSupport
implements ExpressionOwner {
    private String formula;
    private String name;
    private String rhs = "0";
    private String[] arguments = new String[0];
    private static final String DEFAULT_FORMULA = "function math_function() = 0";

    public Function(DiagramElement diagramElement, String formula) {
        super(diagramElement);
        this.setFormula(formula);
    }

    public Function(DiagramElement diagramElement, String name, String[] arguments, String rightHandSide) {
        super(diagramElement);
        this.name = name;
        this.rhs = rightHandSide;
        this.arguments = arguments;
        this.generateFormula();
    }

    public Function(DiagramElement diagramElement) {
        this(diagramElement, diagramElement == null || diagramElement.getName() == null ? DEFAULT_FORMULA : "function " + diagramElement.getName().replaceAll("-", "_") + "() = 0");
    }

    private void generateFormula() {
        this.formula = "function " + this.name + "(" + StreamEx.of((Object[])this.arguments).joining((CharSequence)",") + ") = " + this.rhs;
    }

    @PropertyName(value="Name")
    @PropertyDescription(value="Function name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setName(name, true);
    }

    public void setName(String name, boolean updateModel) {
        String oldValue = this.name;
        if (name.equals(this.name) || !this.isValidName(name)) {
            return;
        }
        this.name = name;
        this.generateFormula();
        this.firePropertyChange(oldValue, null, null);
        if (updateModel) {
            this.updateModel(oldValue, name);
        }
    }

    private void updateModel(String oldValue, String newName) {
        if (oldValue == null || oldValue.equals(newName)) {
            return;
        }
        try {
            Diagram diagram = Diagram.getDiagram(this.getDiagramElement());
            EModel emodel = diagram.getRole(EModel.class);
            emodel.removeFunction(oldValue);
            emodel.readMath(this.getFormula(), (Role)this);
            new EModelHelper(emodel).replaceFunction(oldValue, newName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @PropertyName(value="Right Hand Side")
    @PropertyDescription(value="Right Hand Side.")
    public String getRightHandSide() {
        return this.rhs;
    }

    public void setRightHandSide(String rhs) {
        this.updateArgList(rhs);
        this.rhs = rhs;
        this.generateFormula();
        this.firePropertyChange("*", null, null);
    }

    @PropertyName(value="Formula")
    @PropertyDescription(value="Function formula.")
    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        String oldValue = this.formula;
        String name = null;
        String rhs = null;
        String argNames = null;
        try {
            name = formula.substring(9, formula.indexOf("(")).trim();
            rhs = formula.substring(formula.indexOf("=") + 1).trim();
            argNames = formula.substring(formula.indexOf("(") + 1, formula.indexOf(")"));
        }
        catch (Exception ex) {
            return;
        }
        String oldName = this.name;
        this.name = name;
        this.updateModel(oldName, name);
        this.rhs = rhs;
        this.formula = formula;
        this.arguments = argNames.isEmpty() ? new String[]{} : (String[])StreamEx.of((Object[])argNames.split(",")).map(s -> s.trim()).toArray(String[]::new);
        this.firePropertyChange("formula", oldValue, formula);
    }

    @Override
    public Role clone(DiagramElement de) {
        Function f = new Function(de, this.formula);
        f.comment = this.comment;
        return f;
    }

    @Override
    public boolean isExpression(String propertyName) {
        return "formula".equals(propertyName);
    }

    @Override
    public String[] getExpressions() {
        return new String[]{this.getFormula()};
    }

    @Override
    public void setExpressions(String[] exps) {
        this.setFormula(exps[0]);
    }

    @Override
    public Role getRole() {
        return this;
    }

    private void updateArgList(String source) {
        if (this.arguments.length == 0) {
            this.arguments = (String[])Utils.variables((String)source).toArray(String[]::new);
            return;
        }
        Set oldArguments = StreamEx.of((Object[])this.arguments).toSet();
        String[] addArguments = (String[])Utils.variables((String)source).filter(arg -> !oldArguments.contains(arg)).toArray(String[]::new);
        String[] newArguments = new String[this.arguments.length + addArguments.length];
        System.arraycopy(this.arguments, 0, newArguments, 0, this.arguments.length);
        System.arraycopy(addArguments, 0, newArguments, this.arguments.length, addArguments.length);
        this.arguments = newArguments;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "Function: " + this.getFormula();
    }

    private boolean isValidName(String var) {
        return var.matches("[a-zA-Z][_a-zA-Z0-9]*");
    }
}

